/*
 *   TrackerPacker_v1.c   1998 (c) Asle / ReDoX
 *
 * Converts TP1 packed MODs back to PTK MODs
 * thanks to Gryzor and his ProWizard tool ! ... without it, this prog
 * would not exist !!!
 *
*/

#ifdef DOS
#include "..\include\globals.h"
#include "..\include\extern.h"
#endif

#ifdef UNIX
#include "../include/globals.h"
#include "../include/extern.h"
#endif

void Depack_TP1 ( void )
{
  Uchar c1=0x00,c2=0x00,c3=0x00;
  Uchar poss[37][2];
  Uchar *Whatever;
  Uchar Note,Smp,Fx,FxVal;
  Uchar PatMax=0x00;
  Uchar PatPos;
  long Pats_Address[128];
  long i=0,j=0;
  long Pats_Address_tmp[128];
  long tmp_ptr;
  long Start_Pat_Address=999999l;
  long Whole_Sample_Size=0;
  long Sample_Data_Address;
  long Where=PW_Start_Address;
  FILE *out;

#ifdef DOS
  #include "..\include\ptktable.h"
#endif

#ifdef UNIX
  #include "../include/ptktable.h"
#endif

  if ( Save_Status == BAD )
    return;

  BZERO ( Pats_Address , 128*4 );
  BZERO ( Pats_Address_tmp , 128*4 );

  sprintf ( Depacked_OutName , "%ld.mod" , Cpt_Filename-1 );
  out = fopen ( Depacked_OutName , "w+b" );

  /* title */
  Whatever = (Uchar *) malloc (1024);
  BZERO ( Whatever , 1024 );
  fwrite ( &in_data[Where+8] , 20 , 1 , out );
  Where += 28;

  /* sample data address */
  Sample_Data_Address = (in_data[Where]*256*256*256)+
                        (in_data[Where+1]*256*256)+
                        (in_data[Where+2]*256)+
                         in_data[Where+3];
  Where += 4;
/*printf ( "sample data address : %ld\n" , Sample_Data_Address );*/

  for ( i=0 ; i<31 ; i++ )
  {
    /*sample name*/
    fwrite ( Whatever , 22 , 1 , out );

    /* size */
    Whole_Sample_Size += (((in_data[Where+2]*256)+in_data[Where+3])*2);
    fwrite ( &in_data[Where+2] , 2 , 1 , out );

    /* write finetune,vol */
    fwrite ( &in_data[Where] , 2 , 1 , out );

    /* loops */
    fwrite ( &in_data[Where+4] , 4 , 1 , out );

    Where += 8;
  }
  /*printf ( "Whole sample size : %ld\n" , Whole_Sample_Size );*/

  /* read size of pattern table */
  Where = PW_Start_Address + 281;
  PatPos = in_data[Where]+0x01;
  fwrite ( &PatPos , 1 , 1 , out );
  Where += 1;

  /* ntk byte */
  c1 = 0x7f;
  fwrite ( &c1 , 1 , 1 , out );

  for ( i=0 ; i<PatPos ; i++ )
  {
    Where += 2;
    Pats_Address[i] = (in_data[Where]*256)+in_data[Where+1];
    Where += 2;
    if ( Start_Pat_Address > Pats_Address[i] )
      Start_Pat_Address = Pats_Address[i];
/*fprintf ( info , "%3ld: %ld\n" , i,Pats_Address[i] );*/
  }

  /* ordering of patterns addresses */

  tmp_ptr = 0;
  BZERO ( Whatever , 1024 );
  for ( i=0 ; i<PatPos ; i++ )
  {
    if ( i==0 )
    {
      Whatever[0] = 0x00;
      Pats_Address_tmp[tmp_ptr] = Pats_Address[tmp_ptr];
      tmp_ptr++;
      continue;
    }

    for ( j=0 ; j<i ; j++ )
    {
      if ( Pats_Address[i] == Pats_Address[j] )
      {
        Whatever[i] = Whatever[j];
        break;
      }
    }
    if ( j == i )
    {
      Pats_Address_tmp[tmp_ptr] = Pats_Address[i];
      Whatever[i] = tmp_ptr++;
    }
  }

/*
  for ( i=0 ; i<PatPos ; i++ )
  {
    fprintf ( info , "%x, %ld\n" , Whatever[i],Pats_Address_tmp[i] );
  }
*/


  PatMax = tmp_ptr;
  /*printf ( "Highest pattern number : %d\n" , PatMax-1 );*/


  /* write pattern list */
  fwrite ( Whatever , 128 , 1 , out );


  /* ID string */
  Whatever[0] = 'M';
  Whatever[1] = '.';
  Whatever[2] = 'K';
  Whatever[3] = '.';
  fwrite ( Whatever , 4 , 1 , out );

  /*printf ( "address of the first pattern : %ld\n" , Start_Pat_Address );*/

  /* pattern datas */

  j=0;
  /*printf ( "converting pattern data " );*/
  for ( i=0 ; i<PatMax ; i++ )
  {
/*fprintf ( info , "\npattern %ld: (at: %ld)\n\n" , i,Pats_Address_tmp[i] );*/
    Where = PW_Start_Address + Pats_Address_tmp[i];
    BZERO ( Whatever , 1024 );
    for ( j=0 ; j<256 ; j++ )
    {
      c1 = in_data[Where++];
/*fprintf ( info , "%ld: %2x," , k , c1 );*/
      if ( c1 == 0xC0 )
      {
/*fprintf ( info , " <--- empty\n" );*/
        continue;
      }
      if ( (c1&0xC0) == 0x80 )
      {
        c2 = in_data[Where++];
/*fprintf ( info , "%2x ,\n" , c2 );*/
        Fx    = (c1>>2)&0x0f;
        FxVal = c2;
        Whatever[j*4+2]  = Fx;
        Whatever[j*4+3]  = FxVal;
        continue;
      }
      c2 = in_data[Where++];
      c3 = in_data[Where++];
/*fprintf ( info , "%2x, %2x\n" , c2 , c3 );*/

      Smp   = ((c2>>4)&0x0f) | ((c1<<4)&0x10);
      Note  = c1&0xFE;
      Fx    = c2&0x0F;
      FxVal = c3;

      Whatever[j*4] = Smp&0xf0;
      Whatever[j*4]   |= poss[(Note/2)][0];
      Whatever[j*4+1]  = poss[(Note/2)][1];
      Whatever[j*4+2]  = (Smp<<4)&0xf0;
      Whatever[j*4+2] |= Fx;
      Whatever[j*4+3]  = FxVal;
    }
    fwrite ( Whatever , 1024 , 1 , out );
    /*printf ( "." );*/
  }
  free ( Whatever );
  /*printf ( "\n" );*/

  /* Sample data */
  Where = PW_Start_Address + Sample_Data_Address;
  fwrite ( &in_data[Where] , Whole_Sample_Size , 1 , out );

  Crap ( " Tracker Packer 1 " , BAD , BAD , out );
  /*
  fseek ( out , 830 , SEEK_SET );
  fprintf ( out , "[Converted with    ]" );
  fseek ( out , 860 , SEEK_SET );
  fprintf ( out , "[TrackerPacker v1  ]" );
  fseek ( out , 890 , SEEK_SET );
  fprintf ( out , "[to Protracker     ]" );
  fseek ( out , 920 , SEEK_SET );
  fprintf ( out , "[by Asle /ReDoX    ]" );
  */
  fflush ( out );
  fclose ( out );

  printf ( "done\n" );
  return; /* useless ... but */
}
