/* Program 1.15 */
/* simple rectangle scaling animation */
/* hint: use the cursors left & right to change the scaling ratio of the funky rectangle, press 'q' to quit */
/* Used header files */

/* header files */
#include <stdio.h>
#include <ext.h>
#include <graphics.h>
#include <math.h> 

/* Declaration of brand new, user defined data type called VERTEX */
/* Our VERTEX is in 2d, so it can have 2 variables describing coordinates-x an y */

typedef struct
{
int x;
int y;
} VERTEX;


/* declaration of used functions */
void revamped_draw_rectangle(int x1,int y1,int x2,int y2,int colour);

/* implementation of user defined functions */

void revamped_draw_rectangle(int x1,int y1,int x2,int y2,int colour)
{
setcolor(colour);
moveto(x1,y1);		
lineto(x2,y1);
lineto(x2,y2);
lineto(x1,y2);
lineto(x1,y1);

}  	/* end of function(or procedure with parameter you naughty pascal $%&%*!) draw_rectangle */


/* Main function - our program starts here*/
int main(void)
{
/* initialization of variables */

int driver,mode,err=0;
int kod_znaku=0;
double scaling_ratio=1.0; 



/* To draw the rectangle we need only two vertexes */
VERTEX vertex_table[1]={0}; 
/* in C the counting begins from 0, so we have an array of two vertexes, 
0 and 1 */

driver = VDI;
mode = VDIMODE;
  
initgraph(&driver, &mode, "");		/* Damn, still no drivers for Atari! Why !? ;))))))*/
  err = graphresult();
  if(err) {
    puts(grapherrormsg(err));
    return(err);
   }
              
vertex_table[0].x=-40;
vertex_table[0].y=-40;
vertex_table[1].x=40;
vertex_table[1].y=40;

while(1==1)
 {

  revamped_draw_rectangle(getmaxx()/2+round(scaling_ratio*vertex_table[0].x),
						  getmaxy()/2+round(scaling_ratio*vertex_table[0].y),
						  getmaxx()/2+round(scaling_ratio*vertex_table[1].x),
						  getmaxy()/2+round(scaling_ratio*vertex_table[1].y),
						  RED);

  /* Now, we are checking if the key was pressed */
  /* if yes we are scaling our rectangle */
  if (kod_znaku=getch())
   {
    switch (kod_znaku) /* switch on :))) */
    {
    
     case 75:			/* left arrow pressed */
      {scaling_ratio=scaling_ratio-0.1;
	 cleardevice();
	 break;}
     
     case 77:			/* right arrow pressed */
      {scaling_ratio=scaling_ratio+0.1;
		cleardevice();
		break;}
     
     case 113:			/* if 'q' pressed quit proggy */
      {
       closegraph();
       printf("You have quitted the program. See ya!!");
       return(0);
       }

     } /* end of switch (switch it off ;)))) ) */

} /* end of if */



} /* end of while loop */

} /* our main program ends here */