******************************************************************
**                      D R A W   R A N G E S                   **
******************************************************************
** ESCAPE PAINT MODULE ** BY NORMAN FESKE (NO/ESCAPE)    07'96  **
******************************************************************


EVEN

lu EQU 0
ru EQU 4
lb EQU 8
rb EQU 12

range:
	;d0:	x1
	;d1:	y1
	;d2:	x2
	;d3:	y2
	;a0:	EP stucture

	;get screen adress
	movea.l (a0),a0

	lea lu_color(pc),a1

;read out the four source color at the four corners of the box
    move.l	d1,d5
    muls.l	#320,d5
    add.l	d0,d5
    move.w	(a0,d5.l*2),lu(a1)
    move.l  d3,d5
    muls.l	#320,d5
    add.l 	d0,d5
    move.w  (a0,d5.l*2),lb(a1)
    move.l	d1,d5
    muls.l	#320,d5
    add.l	d2,d5
    move.w	(a0,d5.l*2),ru(a1)
    move.l	d3,d5
    muls.l	#320,d5
    add.l	d2,d5
    move.w	(a0,d5.l*2),rb(a1)
	
	;calculate width and height
	sub.l	d0, d2
	addq.l	#1,d2
	;d2:	width
	sub.l	d1, d3
	addq.l	#1,d3
	;d3:	height
	
	move.w	lu(a1),d4
	move.w	ru(a1),d5
	move.w	lb(a1),d6
	move.w	rb(a1),d7

;move.l #%1111100000000000,d4
;move.l #%11111100000,d5
;move.l #%11111,d6
;move.l #0,d7

	bsr draw_range
	
rts

draw_range:
;d0: x
;d1: y
;d2: width
;d3: height
;d4: color of left upper corner
;d5: color of right upper corner
;d6: color of left bottom corner
;d7: color of right bottom corner
;a0: screen adress

                muls.l  #320,D1         ;calculate startadress
                add.l   D0,D1
                lea     0(A0,D1.l*2),A6 ;a6: destination adress

                movea.l D2,A4           ;a4: width
                movea.l D3,A5           ;a5: height

                lea     lu_color(pc),a1
                move.l  D4,lu(a1)
                move.l  D5,ru(a1)
                move.l  D6,lb(a1)
                move.l  D7,rb(a1)

                move.l  lu(a1),D0
                move.l  lb(a1),D1
                move.l  A5,D2
                lea     l_buf(pc),A0
                bsr     interpolate

                move.l  ru(a1),D0
                move.l  rb(a1),D1
                move.l  A5,D2
                lea     r_buf(pc),A0
                bsr     interpolate

                lea     l_buf(pc),A2
                lea     r_buf(pc),A3

                move.l  A5,D7
                subq.w  #1,D7
range_yloop:
                move.w  D7,-(SP)

                move.w  (A2)+,D0        ;start value
                move.w  (A3)+,D1        ;end value
                move.w  A4,D2           ;num of values = width of box
                movea.l A6,A0           ;dest. adress on screen
                bsr     interpolate
                lea     640(A6),A6
                move.w  (SP)+,D7
                dbra    D7,range_yloop

                rts

lu_color:       DS.L 1
ru_color:       DS.L 1
lb_color:       DS.L 1
rb_color:       DS.L 1

l_buf:          DS.L 240
r_buf:          DS.L 240


interpolate:
;d0: start value
;d1: end value
;d2: num of needed values = dx
;a0: destination buffer

                move.w  D0,D6
                move.w  D1,D7

;m for red
                andi.l  #%1111100000000000,D0 ;d0: red start value
                andi.l  #%1111100000000000,D1
                lsr.l   #5,D0
                lsr.l   #5,D1
                sub.l   D0,D1           ;d1: red dy
                swap    D1
                divs.l  D2,D1           ;d1: m_red = red dy / dx

;m for green
                move.w  D6,D3
                move.w  D7,D4
                andi.l  #%11111100000,D3 ;d3: green start value
                andi.l  #%11111100000,D4
                sub.l   D3,D4           ;d4: green dy
                swap    D4
                divs.l  D2,D4

;m for blue
                andi.l  #%11111,D6      ;d6: blue start value
                andi.l  #%11111,D7
                sub.l   D6,D7
                swap    D7
                divs.l  D2,D7

                subq.w  #1,D2
interpolation_loop:

;d0: red value
;d1: red increment
;d3: green value
;d4: green increment
;d6: blue value
;d7: blue increment

                move.w  D0,D5
                lsl.w   #5,D5
                andi.w  #%1111100000000000,D5
                move.w  D5,(A0)
                move.w  D3,D5
                andi.w  #%11111100000,D5
                add.w   D5,(A0)
                add.w   D6,(A0)+

                swap    D0              ;calculate new red value
                add.l   D1,D0
                swap    D0

                swap    D3              ;calculate new green value
                add.l   D4,D3
                swap    D3

                swap    D6              ;calculate new blue value
                add.l   D7,D6
                swap    D6


                dbra    D2,interpolation_loop
                rts


