/* Defines and structures for DigiTape Module */
/* last change 1.7.93 */

#define DTM_VERSION 'DTM1'

/*-------------------------------------------------------------------- 
Messages to the modules with: 

procedure( int module_action,		see following defines
					 Glob_globals *glob,	pointer to System-Globals
					 int x,
					 int y,
					 int param		MOD_INIT: TRUE=recording on
				 )

if the module doesn't want to process the message, it returns FALSE
----------------------------------------------------------------------*/

#define MOD_RSC_INIT   			1		/* comes during loadtime*/
#define MOD_INIT						2		/* during initialisation
                                   param: TRUE if Mastermodul is set to record */
#define MOD_DRAW						3		/* before drawing */

#define MOD_LOAD_DSP				4		/* load DSP programm
																	 x: DSP-input variable (mono)
																	 y: output variable (mono)
																	 param: address of buffer (Echo etc.)*/
#define MOD_CLR_MEMORY			5		/* clear DSP buffer */

#define MOD_LBUTTONDOWN			6		/* left mouse button down
																	 x, y: mouse position */
#define MOD_MOUSEMOVE				7		/* mouse dragged (button pressed)
																	 x, y: Mausposition */
#define MOD_LBUTTONUP				8		/* left button released */
#define MOD_OUT_VOLS				9		/* send slider (etc) settings to DSP */

#define MOD_SLIDER_MOVED 	 10		/* slider moved:
																	 x: slider id (-2: Vol, -1: Pan )
																	 y: position from 0 to 255 */
#define MOD_BUTTON_CHANGED 11		/* button toggled
																	 x: object index */
#define MOD_DEL_EFFECT		 12		/* nicht fr externe Module */

#define MOD_GET_VERSION		999		/* return version number*/


/* Bits fr 'type' in Module_info */
#define STEREO_IN  2
#define STEREO_OUT 1

/* Modulbeschreibung */
typedef struct
{
	int type;

	int x6, x8, x15, xbuff_size;          /* DSP memory need*/
	int y6, y8, y15, ybuff_size;

	char *mcomment;       /* descriptive text, displayed in the 'Auswahl'-menu */
} Module_info;

/* oject indexes in the resource */
typedef struct
{
	int tree_index;
	int titel_index;	/* module title */
	int solo_index;
	int eject_index;
	int mute_index;
	int vol_parent;  /* parent to the volume-slider handle */
	int vol_slider;	 /* slider. always vertical! */
	int pan_parent;  /* always horizontal */
	int pan_slider;
} Rsc_info;


typedef struct
{
	int bitplanes;
	int nr_effekte;

	long	Hz;         /* current frequency. */
	long	tape_Hz;
	long	reserve[4];	

	void	*track_info; /* pointer to array */
	void	*free[7];

	void (*_dtm_init)( Module_info *dtm_info,
										 void *rsc, Rsc_info *rsc_info);
	int		(*_dtm_init_poti)(void *vglob, int potinr, int type,
													int parent, int slider, int value);

	int		(*_mrsc_load)(void *rsc_hdr);
	long	*(*_log_tab_entry)( int wert );
	long	(*_get_rsc_pegel)( int f_size, int s_size, int s_posi,
													long max, int vertikal );
	void (*_set_line_volume)( int button, int vol, int line_nr );
	void (*_set_line_panorama)( int button, int pan, int line_nr );

	int  (*_DialogState)(HDIALOG hdialog, int item, int set, int mask);
	int  (*_DialogFlags)(HDIALOG hdialog, int item, int set, int mask);
	int  (*_DialogPrintf)(HDIALOG hdialog, int item, char *format, ...);

	void (*_draw_object)( OBJECT *obj, int item );
	int  (*_object_find)( OBJECT *baum, int beg_obj, int depth, int x, int y );

	void (*_dm_setvar)(int memtype, int var, long *value, int size);
	int  (*_dm_defvar)(int typ, int adrsize, int size);
	int  cdecl (*_dm_load)(void *modul, ...);
	void (*_dsp_setblock)( int memtyp, int adr, long value, int size);
} System_globals;

typedef struct
{
	int line_nr;  /* 0-7: Tracks, 8-15: effects */
	int slot_nr;
	OBJECT *object_ptr;
	HDIALOG hdialog;

	System_globals *sys;
	Module_info *mhinfo;

	int	track_nr;  /* for Track-Modules */
	int	track_nr2; /* 2. Kanal for Stereo */
	char leer[50];
} Modul_header;

/* Defines fr Poti.type */
#define H_POTI 0
#define V_POTI 1

typedef struct
{
	char type;
	char activ;
	int  parent_index;
	int  slider_index;
	unsigned char position;
	unsigned char obj_position;
} Poti;

/* max number of sliders */
#define POTI_ZAHL 12

typedef struct
{
	char l_butt; 		/* switches output*/
	char solo_butt; /* state of solo button */
	int  in_left;		/* input left DSP-Variable */
	int  in_right;  /* input right DSP-Variable */
	int  out_left;	/* output left DSP-Variable */
	int  out_right;	/* output right DSP-Variable */
	Poti vol_poti;
	Poti pan_poti;
	Poti potis[POTI_ZAHL];
} Modul_globals;
