; Echo (with multiple reflections)
;
; parameter:
; in braces:    X/Y for X/Y Memory
;               6/8 for Bitwidth of the address
;
; QUELLE: input value  (X-6)
; ZIEL:   output value (X-6)
;
; ESIZE:  size of buffer - 1           max. 16 Bit
; EZAHL:  number of reflections	     max. 12 Bit
; DELTAB: reflektor table            (Y-8)
; EPTR:   pointer to buffer input    (Y-6)
; FBACK:  feedback                   (Y-6)
;
; reflektor table (24 Bit DSP-Words):
;     time  (buffersize - delay)
;     volume (0 bis 2^23-1, Maximum: amplification factor 1)
;     ...
;     ...
;
; registers M1,M5  contain $FFFF 
;
; changed registers:
;   X0,X1,Y0,Y1
;   B
;   R1,R5
;   N1

echo
; init registers:
; 
      clr   B   #<DELTAB,R5     ; clear sum,
                                ; pointer to reflector table
      move  #>ESIZE,M1          ; buffersize
      move  Y:(R5)+,N1          ; 1. Delay-value from table
      move  Y:<EPTR,R1          ; pointer: next buffervalue

; loop: sum up reflektors
      do    #EZAHL,eloop        ; number of reflectors
      move  Y:(R5)+,X0          ; weight of reflectors
      move  X:(R1+N1),X1        ; next value from buffer
      mac   X0,X1,B  Y:(R5)+,N1 ; sum up, and load next delay
                                
eloop

; do feedback
      move  X:<QUELLE,X1        ; input
      move  Y:<FBACK,Y1         ; feedback
      move  B,Y0                ; sum of reflections

      mpy   Y0,Y1,B   B,X:<ZIEL ; weight sum,
                                ; parallel: Summe to output
      add   X1,B                ; input value plus feedback
      move  B,X:(R1)+           ; store in buffer
      move  R1,Y:<EPTR          ; save bufferpointer

      move  #$ffff,M1           ; set M1 back

      rts

      end
