*---------------------------------------------------------------*
*	Assember options					*
*---------------------------------------------------------------*

	OPT		O+,W-
	COMMENT		HEAD=7

;enable_hb
	
	ifd		enable_hb
	output		halfblit.prg
	elseif
	output		fullblit.prg
	endc
	
*---------------------------------------------------------------*
*	Equates							*
*---------------------------------------------------------------*

dc4			=	$80000000
ic4			=	$00008000

cookie_jar		=	$5a0

*---------------------------------------------------------------*

push	macro
	move.\0		\1,-(sp)
	endm
	
pop	macro
	move.\0		(sp)+,\1
	endm

pushall	macro
	movem.l		d0-d7/a0-a6,-(sp)
	endm
	
popall	macro
	movem.l		(sp)+,d0-d7/a0-a6
	endm

fcache	macro		* flush cache(s) [type]
	nop
	cpusha		\1
	nop
	endm

icache	macro		* invalidate cache(s) [type]
	nop
	cinva		\1
	nop
	endm

ecache	macro		* flush & edit cache(s) [type], [reg]
	fcache		\1
	movec		\2,cacr
	endm

*---------------------------------------------------------------*
*	Program start						*
*---------------------------------------------------------------*
start:
*---------------------------------------------------------------*
	lea		usp_stack,sp
*---------------------------------------------------------------*
*	Enter supervisor mode					*
*---------------------------------------------------------------*
	pea		ssp_stack
	push.w		#32
	trap		#1
	move.l		d0,os_stack
*---------------------------------------------------------------*
*	Sign-on message						*
*---------------------------------------------------------------*
	lea		sign_on,a0
	bsr		cconws
*---------------------------------------------------------------*
*	Install driver						*
*---------------------------------------------------------------*
	bsr		install
*---------------------------------------------------------------*
exit_program:
*---------------------------------------------------------------*
*	User mode						*
*---------------------------------------------------------------*
	push.l		os_stack
	push.w		#32
	trap		#1
*---------------------------------------------------------------*
*	Terminate						*
*---------------------------------------------------------------*
	clr.w		-(sp)
	trap		#1

*---------------------------------------------------------------*
install:
*---------------------------------------------------------------*
*	Change cache values here				*
*---------------------------------------------------------------*
	ifd		enable_hb
	bclr		#2,$FFFF8007.w
	elseif
	bset		#2,$FFFF8007.w
	endc
	rts

*---------------------------------------------------------------*
cookie_search:
*---------------------------------------------------------------*
	move.l		cookie_jar.w,a0
.loop:	cmp.l		(a0),d0
	beq.s		.find
	tst.l		(a0)
	beq.s		.fail
	addq.l		#8,a0
	bra.s		.loop
.find:	moveq		#0,d0
	bra.s		.end
.fail:	moveq		#-1,d0
.end:	rts

*---------------------------------------------------------------*
delay:
*---------------------------------------------------------------*
	mulu.w		#50,d0
.wt:	push.w		d0
	push.w		#37
	trap		#14
	addq.l		#2,sp
	pop.w		d0
	dbra		d0,.wt
	rts

*---------------------------------------------------------------*
cconws:
*---------------------------------------------------------------*
	pea		(a0)
	push.w		#9
	trap		#1		; cconws
	addq.l		#6,sp
	rts

*---------------------------------------------------------------*
			data
*---------------------------------------------------------------*

sign_on:		dc.b	13,10
			dc.b	27,'p'
			ifd	enable_hb
			dc.b	' Blitter switched to HALF speed! ',13,10
			elseif
			dc.b	' Blitter switched to FULL speed! ',13,10
			endc
			dc.b	27,'q'
			dc.b	0

missing:		dc.b	27,'E'
			dc.b	'MC68040 driver is not installed!',13,10
			dc.b	0
			even
		
*---------------------------------------------------------------*
			bss
*---------------------------------------------------------------*

exit_code:		ds.l	1

*---------------------------------------------------------------*

os_stack:		ds.l	1

			ds.b	2048
ssp_stack:		ds.l	1
			ds.b	2048
usp_stack:		ds.l	1

*---------------------------------------------------------------*
