*---------------------------------------------------------------*
*	Assember options					*
*---------------------------------------------------------------*

	OPT		W-
	COMMENT		HEAD=1		; *never* run from fastram!

enable_cbc		; enable for cbc_on / disable for cbc_off

	ifd		enable_cbc
	output		ecback40.tos
	elseif
	output		dcback40.tos
	endc
	
*---------------------------------------------------------------*
*	Equates							*
*---------------------------------------------------------------*

dc4			=	$80000000
ic4			=	$00008000

cookie_jar		=	$5a0

*---------------------------------------------------------------*

			rsreset
pmmu_start		rs.l	1
pmmu_end		rs.l	1
pmmu_read		rs.l	1
pmmu_write		rs.l	1
pmmu_cmw		rs.l	1
pmmu_cmc		rs.l	1
pmmu_cms		rs.l	1
pmmu_cmn		rs.l	1

*---------------------------------------------------------------*

push	macro
	move.\0		\1,-(sp)
	endm
	
pop	macro
	move.\0		(sp)+,\1
	endm

pushall	macro
	movem.l		d0-d7/a0-a6,-(sp)
	endm
	
popall	macro
	movem.l		(sp)+,d0-d7/a0-a6
	endm

fcache	macro		* flush cache(s) [type]
	nop
	cpusha		\1
	nop
	endm

icache	macro		* invalidate cache(s) [type]
	nop
	cinva		\1
	nop
	endm

ecache	macro		* flush & edit cache(s) [type], [reg]
	fcache		\1
	movec		\2,cacr
	endm

*---------------------------------------------------------------*
*	Program start						*
*---------------------------------------------------------------*
start:
*---------------------------------------------------------------*
	lea		usp_stack,sp
*---------------------------------------------------------------*
*	Enter supervisor mode					*
*---------------------------------------------------------------*
	pea		ssp_stack
	push.w		#32
	trap		#1
	move.l		d0,os_stack
*---------------------------------------------------------------*
*	Check driver status					*
*---------------------------------------------------------------*
	clr.l		exit_code
	bsr		check_driver
	tst.l		exit_code
	beq.s		switch_caches
*---------------------------------------------------------------*
driver_missing:
*---------------------------------------------------------------*
	lea		missing,a0
	bsr		cconws
	moveq		#4,d0
	bsr		delay
	bra		exit_program
*---------------------------------------------------------------*
switch_caches:
*---------------------------------------------------------------*
*	Sign-on message						*
*---------------------------------------------------------------*
	lea		sign_on,a0
	bsr		cconws
*---------------------------------------------------------------*
*	Install driver						*
*---------------------------------------------------------------*
	bsr		install
*---------------------------------------------------------------*
exit_program:
*---------------------------------------------------------------*
*	User mode						*
*---------------------------------------------------------------*
	push.l		os_stack
	push.w		#32
	trap		#1
*---------------------------------------------------------------*
*	Terminate						*
*---------------------------------------------------------------*
	clr.w		-(sp)
	trap		#1

*---------------------------------------------------------------*
*	Check for previous 68040 driver installation		*
*---------------------------------------------------------------*
check_driver:
*---------------------------------------------------------------*
	move.l		#'XMMU',d0
	bsr		cookie_search
	move.l		d0,exit_code
	rts

*---------------------------------------------------------------*
install:
*---------------------------------------------------------------*
	move.l		#'AB40',d0
	bsr		cookie_search
	move.l		4(a0),a1
	move.l		a1,softcacr_ptr	
*---------------------------------------------------------------*
*	Disable caches						*
*---------------------------------------------------------------*
	move.l		softcacr_ptr,a1
	moveq		#0,d0
	push.l		(a1)
	move.l		d0,(a1)
	ecache		bc,d0
*---------------------------------------------------------------*
*	Find XMMU table						*
*---------------------------------------------------------------*
	move.l		#'XMMU',d0
	bsr		cookie_search
	move.l		4(a0),pmmu_ptr
*---------------------------------------------------------------*
*	Check for alt-ram					*
*---------------------------------------------------------------*
	cmp.l		#$1357bd13,$5a8.w	; magic
	bne		.err
*---------------------------------------------------------------*
	move.l		pmmu_ptr,a0
	ifd		enable_cbc
	move.l		pmmu_cmc(a0),a2
	elseif
	move.l		pmmu_cmw(a0),a2
	endc
	lea		$01000000,a0
	move.l		$5a4.w,a1		; end of alternate ram
	jsr		(a2)	
*---------------------------------------------------------------*
*	Restore caches						*
*---------------------------------------------------------------*
.err:	pop.l		d0
	move.l		softcacr_ptr,a1
	move.l		d0,(a1)
	ecache		bc,d0
	rts

*---------------------------------------------------------------*
cookie_search:
*---------------------------------------------------------------*
	move.l		cookie_jar.w,a0
.loop:	cmp.l		(a0),d0
	beq.s		.find
	tst.l		(a0)
	beq.s		.fail
	addq.l		#8,a0
	bra.s		.loop
.find:	moveq		#0,d0
	bra.s		.end
.fail:	moveq		#-1,d0
.end:	rts

*---------------------------------------------------------------*
delay:
*---------------------------------------------------------------*
	mulu.w		#50,d0
.wt:	push.w		d0
	push.w		#37
	trap		#14
	addq.l		#2,sp
	pop.w		d0
	dbra		d0,.wt
	rts

*---------------------------------------------------------------*
cconws:
*---------------------------------------------------------------*
	pea		(a0)
	push.w		#9
	trap		#1		; cconws
	addq.l		#6,sp
	rts

*---------------------------------------------------------------*
			data
*---------------------------------------------------------------*

sign_on:		dc.b	13,10
			dc.b	27,'p'
			ifd	enable_cbc
			dc.b	' FastRAM has been marked as [copyback]! ',13,10
			elseif
			dc.b	' FastRAM has been marked as [write-though]! ',13,10
			endc
			dc.b	27,'q'
			dc.b	0

missing:		dc.b	27,'E'
			dc.b	'XMMU cookie is not installed!',13,10
			dc.b	0
		
*---------------------------------------------------------------*
			bss
*---------------------------------------------------------------*

softcacr_ptr:		ds.l	1
pmmu_ptr:		ds.l	1
exit_code:		ds.l	1

*---------------------------------------------------------------*

os_stack:		ds.l	1

			ds.b	2048
ssp_stack:		ds.l	1
			ds.b	2048
usp_stack:		ds.l	1

*---------------------------------------------------------------*
