VLM_MODULE:	=	1
SHOWVBL:	=	0

******** OBJECT EQUS ********

	TEXT

	IFNE	VLM_MODULE
	OPT	D-
	OUTPUT	E:\WHIP!\VLM\BLUR.VLM
	ELSE
	OPT	ATARI
	COMMENT	HEAD=%101
	INCBIN	MINIWHIP.BIN
	ENDC

	DC.B	"VLM2"
	DC.L	infotext
	DC.L	settings
	DC.L	init
	DC.L	deinit
	DC.L	main

	INCLUDE	VLMSERV.S
	INCLUDE	FIMATH.I
	TEXT
	INCLUDE	FSCR.I
	TEXT

main:	vlm_get_left_volume	leftvol
	vlm_get_right_volume	rightvol
	move.l	leftvol,d0
	add.l	rightvol,d0
	lsr.l	#1,d0
	move.l	d0,midvol

.blur:	movea.l	scr,a0
	movea.l	scr+8,a1
	tst.w	blurtype+2
	bne.s	.xblur
	bsr	BLUR_320100
	bra.s	.end_blur
.xblur:
	bsr	XBLUR_320100
.end_blur:

	move.w	fxselect+2,d0
	btst	#0,d0
	beq.s	.skip_balls

	move.l	leftvol,d0
	lsr.l	#1,d0
	move.w	$4bc.w,d1
	mulu.w	speed+2,d1
	lsr.l	#6,d1
	addi.w	#sintbllen/3,d1
	Do_SinModulo	d1
	lea	tiet_dat,a1
	bsr	PAINT_TIET
	move.l	rightvol,d0
	lsr.l	#1,d0
	move.w	$4bc.w,d1
	mulu.w	speed+2,d1
	lsr.l	#6,d1
	addi.w	#(sintbllen*2)/3,d1
	Do_SinModulo	d1
	lea	tietr_dat,a1
	bsr	PAINT_TIET
	move.l	midvol,d0
	lsr.l	#1,d0
	move.w	$4bc.w,d1
	mulu.w	speed+2,d1
	lsr.l	#6,d1
	Do_SinModulo	d1
	lea	tietg_dat,a1
	bsr	PAINT_TIET
.skip_balls:

	move.w	fxselect+2,d0
	btst	#1,d0
	beq.s	.skipscope
	bsr	PAINT_SCOPE
.skipscope:

	addq.w	#1,framecount

	IFNE	SHOWVBL

	movea.l	scr,a3
	move.w	$4bc.w,d7
	move.w	.old4bc(pc),d6
	move.w	d7,.old4bc
	sub.w	d6,d7
	subq.w	#1,d7
	cmpi.w	#50,d7
	bhs.s	.end_showvbl

.vsl:	move.l	#$ffff0000,(a3)+
	dbra	d7,.vsl

.end_showvbl:
	moveq	#0,d0
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+

	ENDC

	lea	scr,a0
	move.l	(a0)+,d0
	move.l	(a0)+,-8(a0)
	move.l	(a0),-4(a0)
	move.l	d0,(a0)
	vlm_set_scradr	d0
	rts

.old4bc:
	DC.W	0

init:	move.l	a0,service_struct
	vlm_set_resolution #VLM_320x100x16

	bsr	CALC_XYLOOKUPTABLE

	lea	tiet_dat,a0
	bsr	LYPOSUCTEER_TIET
	lea	tietr_dat,a0
	bsr	LYPOSUCTEER_TIET
	lea	tietg_dat,a0
	bsr	LYPOSUCTEER_TIET

	bsr	CALC_FADEPAL

	lea	scr1,a0
	bsr	CLEAR_320100TSCR
	lea	scr2,a0
	bsr	CLEAR_320100TSCR
	lea	scr3,a0
	bsr	CLEAR_320100TSCR
	rts

deinit:	rts

CALC_XYLOOKUPTABLE:
	lea	xylookup_tbl,a0
	moveq	#0,d1

.yloop:	moveq	#0,d0
	move.b	d1,d3
	ext.w	d3
	addi.w	#50,d3
	cmpi.w	#100,d3
	blo.s	.yonscreen
	moveq	#0,d7
	moveq	#-1,d2
.clrloop:
	move.w	d2,(a0)+
	addq.b	#1,d7
	bne.s	.clrloop
	bra.s	.endy
.yonscreen:
	mulu.w	#320,d3

.xloop:	move.b	d0,d2
	ext.w	d2
	addi.w	#80,d2
	cmpi.w	#160,d2
	blo.s	.xonscreen
	move.w	#-1,(a0)+
	bra.s	.endx
.xonscreen:
	ext.l	d2
	add.l	d2,d2
	add.l	d3,d2
	move.w	d2,(a0)+
.endx:	addq.b	#1,d0
	bne.s	.xloop

.endy:	addq.b	#1,d1
	bne.s	.yloop
	rts

LYPOSUCTEER_TIET:
	move.w	#32*32-1,d7

.loop:	move.w	(a0)+,d0
	move.w	d0,d1
	move.w	d0,d2
	lsr.w	#8,d0
	lsr.w	#1,d0
	lsr.w	#6,d1
	andi.w	#%0000000000011111,d1
	andi.w	#%0000000000011111,d2
	add.w	d0,d2
	add.w	d1,d2
	cmpi.w	#100,d2
	bhs.s	.leave
	clr.w	-2(a0)
.leave:	dbra	d7,.loop
	rts

CALC_FADEPAL:
	lea	fadepal_tbl,a0
	moveq	#0,d7

.loop:	move.w	d7,d0
	move.w	d7,d1
	move.w	d7,d2
	andi.w	#%1111100000000000,d0
	andi.w	#%0000011111000000,d1
	andi.w	#%0000000000011111,d2
	mulu.w	#$00ff,d0
	mulu.w	#$00ff,d1
	mulu.w	#$00ff,d2
	lsr.l	#8,d0
	lsr.l	#8,d1
	lsr.l	#8,d2
	andi.w	#%1111100000000000,d0
	andi.w	#%0000011111000000,d1
	andi.w	#%0000000000011111,d2
	or.w	d2,d0
	or.w	d1,d0
	move.w	d0,(a0)+
	addq.w	#1,d7	
	bne.s	.loop
	rts

* INPUT: d0.w: volume (0 - 32767)
*        d1.w: angle
PAINT_TIET:
	movea.l	scr,a0
	Get_SinCos	sine_tbl,d1,d2,d3
	
 	muls.w	d0,d2
	swap	d2
	muls.w	response+2,d2
	swap	d2

	muls.w	d0,d3
	swap	d3
	muls.w	response+2,d3
	swap	d3

* d2.w: x coordinate
* d3.w: y coordinate

	addi.w	#160/2-32/2,d2
	addi.w	#100/2-32/2,d3

* d2.w: absolute x coordinate
* d3.w: absolute y coordinate

.check_x:
.check_x_low:
	tst.w	d2
	bpl.s	.end_check_x_low
	neg.w	d2
	cmpi.w	#32,d2
	bhs	.end
	moveq	#32-1,d5
	sub.w	d2,d5
	add.w	d2,d2
	adda.w	d2,a1
	movea.w	d2,a5
	add.w	d2,d2
	movea.w	#(160-32)*4,a6
	adda.w	d2,a6
	moveq	#0,d2
	bra.s	.end_check_x
.end_check_x_low:

.check_x_high:
	cmpi.w	#160,d2
	bhs	.end
	cmpi.w	#160-32,d2
	bls.s	.normal_x
	move.w	d2,a6
	add.l	a6,a6
	add.l	a6,a6
	move.w	#160,d5
	sub.w	d2,d5
	movea.w	#32,a5
	sub.w	d5,a5
	adda.l	a5,a5
	subq.w	#1,d5
	bra.s	.end_check_x_high
.normal_x:
	moveq	#32-1,d5
	suba.l	a5,a5
	movea.w	#640-32*4,a6
.end_check_x_high:	
.end_check_x:

* a1:
* d2.w:
* d5.w:
* a5:
* a6:

.check_y:
.check_y_low:
	tst.w	d3
	bpl.s	.end_check_y_low
	neg.w	d3
	cmpi.w	#32,d3
	bhs.s	.end
	moveq	#32-1,d7
	sub.w	d3,d7
	mulu.w	#32*2,d3
	adda.l	d3,a1
	moveq	#0,d3
	bra.s	.end_check_y
.end_check_y_low:
.check_y_high:
	cmpi.w	#100-32,d3
	bls.s	.y_normal
	cmpi.w	#100,d3
	bhs.s	.end
	move.w	d3,d7
	subi.w	#100-1,d7
	neg.w	d7
	bra.s	.end_check_y_high
.y_normal:
	moveq	#32-1,d7
.end_check_y_high:
.end_check_y:

* a1:
* d3.w:
* d7.w:

	lsl.w	#2,d2
	ext.l	d2
	mulu.w	#640,d3
	add.l	d2,d3
	lea	(a0,d3.l),a0
	move.w	#%0111101111101111,d2

* d2.w: overflow and-mask
* d5.w:	width-1
* d6.w: height-1
* a1: sprite
* a5: offset to next spriteline
* a6: offset to next screenline

.yloop:	move.w	d5,d6

.xloop:	move.w	(a1)+,d0
	beq.s	.skip
	move.w	(a0),d1
	lsr.w	#1,d0
	lsr.w	#1,d1
	and.w	d2,d0
	and.w	d2,d1
	add.w	d1,d0
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	bra.s	.skipdaskip
.skip:	addq	#4,a0
.skipdaskip:
	dbra	d6,.xloop
	
	adda.l	a5,a1
	adda.l	a6,a0
	dbra	d7,.yloop
.end:	rts

PAINT_SCOPE:
	vlm_get_left_spec	a2
	vlm_get_right_spec	a3
	movea.l	scr,a0
	lea	sine_tbl,a1
	moveq	#128-1,d7
	moveq	#0,d0
	move.l	#$0000ffff,d4
	move.l	#$80008000,d5
	move.w	$4bc.w,d0
	mulu.w	scopespeed+2,d0
	lea	xylookup_tbl,a4

.loop:	Do_SinModulo	d0
	move.w	(a2)+,d1
	lsr.w	#1,d1
	Get_SinCos	a1,d0,d2,d3
	muls.w	d1,d2
	muls.w	d1,d3
	swap	d2
	swap	d3
	asr.w	#7,d2
	asr.w	#7,d3
	and.l	d4,d3
	lsl.w	#8,d3
	move.b	d2,d3
	move.w	(a4,d3.l*2),d3
	bmi.s	.offscreen
	or.l	d5,(a0,d3.l*2)
.offscreen:
	addq.w	#8,d0
	dbra	d7,.loop

	move.l	#$001f001f,d5
	moveq	#128-1,d7

.loop2:	Do_SinModulo	d0
	move.w	(a3)+,d1
	lsr.w	#1,d1
	Get_SinCos	a1,d0,d2,d3
	muls.w	d1,d2
	muls.w	d1,d3
	swap	d2
	swap	d3
	asr.w	#7,d2
	asr.w	#7,d3
	and.l	d4,d3
	lsl.w	#8,d3
	move.b	d2,d3
	move.w	(a4,d3.l*2),d3
	bmi.s	.offscreen2
	or.l	d5,(a0,d3.l*2)
.offscreen2:
	addq.w	#8,d0
	dbra	d7,.loop2
	rts

* INPUT: a0: destination screenaddress
*        a1: source screenaddress
BLUR_320100:
	move.w	#160*100-1,d7
	move.w	#%0111101111101111,d1

.loop:	move.w	(a1),d0
	addq	#4,a1
	lsr.w	#1,d0
	and.w	d1,d0
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	dbra	d7,.loop
	rts

* INPUT: a0: destination screenaddress
*        a1: source screenaddress
FADEBLUR_320100:
	move.w	#160*100-1,d7
	move.w	#%0111101111101111,d2
	move.w	#%0011100111100111,d3
	move.w	#%0001100011100011,d5

.loop:	move.w	(a1),d0
	addq	#4,a1
	move.w	(a0),d1
	move.w	d0,d4			;
	lsr.w	#1,d0
	lsr.w	#1,d1
	lsr.w	#3,d4			;
	and.w	d2,d0
	and.w	d2,d1
	and.w	d5,d4			;
	sub.w	d4,d1			;
	add.w	d0,d1
	move.w	d1,(a0)+
	move.w	d1,(a0)+
	dbra	d7,.loop
	rts

XBLUR_320100:
	lea	fadepal_tbl,a2
	move.w	#160/16*100-1,d7
	moveq	#0,d0

.loop:	REPT	16
	move.w	(a1),d0
	addq	#4,a1
	move.w	(a2,d0.l*2),d0
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	ENDR
	dbra	d7,.loop
	rts

	DATA

tiet_dat:
	INCBIN	TIET.RAW
tietr_dat:
	INCBIN	TIETR.RAW
tietg_dat:
	INCBIN	TIETG.RAW
sine_tbl:
	INCBIN	SINUS.DAT

scr:	DC.L	scr1,scr2,scr3

settings:
	DC.L	5

	DC.L	fxselect_txt
	DC.L	2
fxselect:
	DC.L	1
	DC.L	fxselect_tbl

	DC.L	blurtype_txt
	DC.L	2
blurtype:
	DC.L	1
	DC.L	blurtype_tbl

	DC.L	response_txt
	DC.L	3
response:
	DC.L	400
	DC.L	response_tbl

	DC.L	speed_txt
	DC.L	3
speed:
	DC.L	300
	DC.L	response_tbl

	DC.L	scopespeed_txt
	DC.L	3
scopespeed:
	DC.L	5
	DC.L	scopespeed_tbl

fxselect_tbl:
	DC.L	4
	DC.B	"OFF",0
	DC.B	"BALLS ONLY",0
	DC.B	"SCOPE ONLY",0
	DC.B	"BALLS & SCOPE",0
blurtype_tbl:
	DC.L	2
	DC.B	"MIGRAINE",0
	DC.B	"DELERIUM",0
response_tbl:
	DC.L	0,2000
scopespeed_tbl:
	DC.L	0,100

fxselect_txt:
	DC.B	"EFFECTA SELECTA",0
blurtype_txt:
	DC.B	"BLURTYPE",0
response_txt:
	DC.B	"RESPONSE",0
speed_txt:
	DC.B	"SPEED",0
scopespeed_txt:
	DC.B	"SCOPE SPEED",0

infotext:
	DC.B	"Blur effect (New Order)",0
	DC.B	"Author:  eARx/fUN InD.",0
	DC.B	"Version: 1.1",0
	DC.B	"Date:    04-01-2000",0
	DC.B	0
	EVEN

	BSS

;	DS.W	1

framecount:
	DS.L	1

fadepal_tbl:
	DS.W	1<<16
xylookup_tbl:
	DS.W	256*256

service_struct:
	DS.L	1
	
leftvol:
	DS.L	1
rightvol:
	DS.L	1
midvol:	DS.L	1
leftspec_tbl:
	DS.L	128
rightspec_tbl:
	DS.L	128

scr1:	DS.W	320*240
scr2:	DS.W	320*240
scr3:	DS.W	320*240