; 
; Flummer Dummer vlm.
;
; My whip module for the vlm-module compo 1999
;
; Coded by Blind Io.
;

VLM	EQU	1

	IFNE	VLM
	output	e:\source\whip\flummer.vlm
	ELSE
 	incbin	e:\source\whip\miniwhip.bin
	ENDC


	section	text
;--------------------------------------------------------
;
; VLM STRUCTURE
;

	dc.b	"VLM2"     ; vlm module type 2
	dc.l	infotext   ; pointer to infotext
	dc.l	settings   ; pointer to settings-structure
	dc.l	init       ; pointer to init routine
	dc.l	deinit     ; pointer to deinit routine
	dc.l	main       ; pointer to mainloop routine


;
;SERVICE ROUTINES PROVIDED BY THE CALLING PROGRAM
;

wait_vbl:
	movea.l service_struct,a1
	movea.l 4(a1),a1
	jsr     (a1)
	rts

set_scradr:
;a0: new screen adress
	movea.l	service_struct,a1
	movea.l	8(a1),a1
	jsr     (a1)
	rts

set_resolution:
;d0: number of the wanted resolution
; 1 - 320*240*16, 2 - 320*100*8, 3 - 320*240*8, 4 - 320*200*8
	movea.l service_struct,a1
	movea.l 12(a1),a1
	jsr     (a1)
	rts

get_left_spec:
	movea.l service_struct,a1
	movea.l 16(a1),a1
	jsr     (a1)            ;returns in a0 the adress of left spec
	rts

get_right_spec:
	movea.l service_struct,a1
	movea.l 20(a1),a1
	jsr     (a1)            ;returns in a0 the adress of right spec
	rts

get_left_volume:
	movea.l service_struct,a1
	movea.l 24(a1),a1
	jsr     (a1)            ;returns in d0 the left volume value
	rts

get_right_volume:
	movea.l service_struct,a1
	movea.l 28(a1),a1
	jsr     (a1)            ;returns in d0 the right volume value
	rts


service_struct: dc.l 0          ;must be set in 'init'



;----------------------------------------------------------
;
; The info stuff and settingstuff and stuff.. :)
;

infotext:
	dc.b	'FLUMMER DUMMER',0
	dc.b	' author: Blind Io',0
	dc.b	'version: 1.0',0
	dc.b	'   date: 12 Oct. 1999',0
	dc.b	'Written for DHS VLm compo',0
	dc.b	0
	EVEN

settings:
	dc.l	3		; Number of settings


; color settings
	dc.l	color_name
	dc.l	2		; parameter type = vaddenuheter..
color	dc.l	0		; default
	dc.l	color_para_struct


; alpha parameter (the use of)
	dc.l	alpha_use_name	; pointer to setting name
	dc.l	1		; parameter type = activator
alpha_val	dc.l	1		; defalut value = on
	dc.l	0		; no parameterstruct


	dc.l	alpha_freq_name
	dc.l	3		; Slider?
alpha_freq
	dc.l	4		; default value
	dc.l	alpha_freq_para_list



alpha_use_name
	dc.b	"ALPHA LAYER",0
	even
alpha_freq_name
	dc.b	"ALPHA FREQUENCY",0
	EVEN

alpha_freq_para_list
	dc.l	0		; minimum value
	dc.l	127		; maxumum value


color_name
	dc.b	"COLORS",0
	even
color_para_struct
	dc.l	3		; number of choises
	dc.b	"DEFAULT",0
	dc.b	"BLACK AND WHITE",0
	dc.b	"PASTELL",0










;------------------------------------------------------------
;
; init
;
; in: 	a0 - pointer to service struct
;

init:
	move.l	a0,service_struct	; saves service struct for later use.

	move.l	#2,d0		; set resolution to 320x100
	bsr	set_resolution

	clr.b	scrn_1+3
	clr.b	scrn_2+3

	bsr	calc_palette

	rts


;------------------------------------------------------------
;
; calc_palette - make 32 palettes from black to current.. (to white? (64?)
;


calc_palette:
	lea	palt_list,a0
	move.l	color,d0
	move.l	(a0,d0.w*4),a0

	lea	256*2(a0),a0

	lea	palettes+256*32*4,a1	; points to last color in last palette.
	lea	palette_list+32*4,a2	; points to last color in palette

	move.w	#256-1,d7
.copy_first
	 move.w	-(a0),d0
	 move.w	d0,-(a1)
	 move.w	d0,-(a1)
	dbra	d7,.copy_first

	lea	palettes+256*32*4,a0	; points to last color in last palette.

	move.w	#32-1,d6		; setup loop counter
.make_palette
	 move.w	#256-1,d7		; setup loop counter
.make_colors
	  move.l	-(a0),d0		; get color

	  btst	#0,d6		; this is kind of stupid, but i don't ids to fix it
	  bne.s	.red_0

	  bfextu	d0{11:5},d1	; blue
	  bfextu	d0{5:6},d2	; green
	  bfextu	d0{0:5},d3	; red

	  sub.w	#1,d1
	  bmi.s	.blue_0
	  bfins	d1,d0{27:5}	; blue

.blue_0	  sub.w	#2,d2
	  bmi.s	.green_0
	  bfins	d2,d0{21:6}	; green

.green_0	  sub.w	#1,d3
	  bmi.s	.red_0
	  bfins	d3,d0{16:5}	; red

.red_0	  move.w	d0,-(a1)
	  move.w	d0,-(a1)
.cont	 dbra	d7,.make_colors
	 move.l	a1,-(a2)
	dbra	d6,.make_palette


	rts




;------------------------------------------------------------
;
; deinit
;

deinit:

	rts





;------------------------------------------------------------
;
; main - this is the core of the.
;

main:
	tst.l	alpha_val
	bne.s	.get_alpha
	moveq	#31,d4			; use brightes palette
	bra.s	.do_alpha
.get_alpha
	moveq	#0,d4
	move.l	alpha_freq,d0
	bsr	get_left_spec
	move.w	(a0,d0.w*2),d4

	moveq	#0,d3
	bsr	get_right_spec
	move.w	(a0,d0.w*2),d3
	add.l	d3,d4

	moveq	#12,d1
	lsr.l	d1,d4
.do_alpha
	lea	palette_list,a4
	move.l	(a4,d4.w*4),a4

	bsr	get_left_volume
	move.w	d0,d4

	bsr	get_right_volume
	divu	#$aaa>>2,d0
	divu	#$aaa>>2,d4

	lea	offset_table+48+256,a0	; offset table is 256*104..
	move.l	a0,a1

	adda.w	d4,a1			; right side
	suba.w	d0,a0			; left side

	moveq	#0,d0
	move.l	scrn_1,a3
	move.w	#100-1,d3
.main_loop
	 move.w	#160-1,d4
.scan_line
	  move.b	(a0)+,d0
	  add.b	(a1)+,d0
	  move.l	(a4,d0.w*4),(a3)+
	 dbra	d4,.scan_line
	 adda.l	#(256-160),a0
	 adda.l	#(256-160),a1
	dbra	d3,.main_loop

	move.l	scrn_1,d0			; swap screens
	move.l	scrn_2,scrn_1
	move.l	d0,scrn_2

	bsr	wait_vbl

	move.l	scrn_2,a0
	bsr	set_scradr		; Set new screen

	rts



	section	data
;------------------------------------------------------

scrn_1		dc.l	scrn_mem_1+256
scrn_2		dc.l	scrn_mem_2+256

offset_table	incbin	"e:\source\whip\offset.dat"

palt_list		dc.l	default_palt
		dc.l	bow_palt
		dc.l	pastell_palt

default_palt	incbin	default.epp
bow_palt		incbin	bow.epp
pastell_palt	incbin	pastell.epp


	section 	bss
;------------------------------------------------------

palettes		ds.l	256*32		; reserve memory for every palette

palette_list	ds.l	32		; list to each palette

scrn_mem_1	ds.w	320*240+128
scrn_mem_2	ds.w	320*240+128

	end


