;
; VLM EXAMPLE MODULE                                             NO/Escape'98
;

		section	text

*** VLM STRUCTURE **************************************************************

		dc.b	"VLM2"		;vlm module type
		dc.l	infotext	;pointer to infotext
		dc.l	settings	;pointer to settings-structure
		dc.l	init		;pointer to init routine
		dc.l	deinit		;pointer to deinit routine
		dc.l	main		;pointer to mainloop routine

;SERVICE ROUTINES PROVIDED BY THE CALLING PROGRAM

set_vblrout:
;a0: new vbl subroutine
		movea.l service_struct,a1
		movea.l (a1),a1
		jsr     (a1)
		rts

wait_vbl:	movea.l	service_struct,a1
		movea.l	4(a1),a1
		jsr	(a1)
		rts

set_scradr:
;a0: new screen adress
		movea.l	service_struct,a1
		movea.l	8(a1),a1
		jsr	(a1)
		rts

set_resolution:
;d0: number of the wanted resolution
		movea.l	service_struct,a1
		movea.l	12(a1),a1
		jsr	(a1)
		rts

get_left_spec:	movea.l	service_struct,a1
		movea.l	16(a1),a1
		jsr	(a1)		;returns in a0 the adress of left spec
                rts

get_right_spec:	movea.l	service_struct,a1
		movea.l	20(a1),a1
		jsr	(a1)            ;returns in a0 the adress of right spec
		rts

get_left_volume:movea.l	service_struct,a1
		movea.l 24(A1),A1
		jsr	(A1)		;returns in d0 the left volume value
		rts

get_right_volume:
		movea.l service_struct,a1
		movea.l 28(a1),a1
		jsr	(a1)		;returns in d0 the right volume value
		rts

get_left_osci:	movea.l service_struct,a1
		movea.l	32(A1),a1
		jsr	(a1)		;returns in a0 the adress of osci data
		rts

get_right_osci:	movea.l	service_struct,a1
		movea.l	36(a1),a1
		jsr	(a1)		;returns in a0 the adress of osci data
		rts

service_struct:	dc.l	0		;must be set in 'init'

********************************************************************************
infotext:       
		dc.b	'blur oscillo',0
		dc.b	' author: evil ',0
		dc.b	'version: 1.0',0
		dc.b	'   date: june 22, 1999',0
		dc.b	0
		even

settings:       dc.l	3

		dc.l	colourname
		dc.l	2
colour:		dc.l	0
		dc.l	colourstruct

		dc.l	xname
		dc.l	3
xadd:		dc.l	3
		dc.l	xstruct

		dc.l	yname
		dc.l	3
yadd:		dc.l	4
		dc.l	ystruct

xstruct:	dc.l	0,20
ystruct:	dc.l	0,20

xname:		dc.b	'X-SINUS:',0
		even
yname:		dc.b	'Y-SINUS:',0
		even
colourname:	dc.b	'SELECT COLOURS:',0
		even
colourstruct:	dc.l	3
		dc.b	'DEFAULT',0
		dc.b	'SAFTSOPPA',0
		dc.b	'RECTUM',0
		even




init:           
;a0: service structure
		move.l	a0,service_struct
		bsr.w	blur_init
		bsr.w	clear_screens
		movea.l	scradr2,a0	;set new screen adress
		bsr.w	set_scradr
		move.l	#2,d0		;set resolution to 320x100
		bsr.w	set_resolution
                rts
deinit:		rts


clear_screens:	move.l	scradr1,a0
		move.l	scradr2,a1
		move.l	scradr3,a2
		move.w	#320*100*2/64-1,d7
.loop:		rept	16
		clr.l	(a0)+
		clr.l	(a1)+
		clr.l	(a2)+
		endr
		dbra	d7,.loop
		rts


main:		jsr	switch_screens
		bsr.w	blur_main
		rts			;end of the mainroutine



blur_vbl:	add.l	#2+512,blur_scroll
		and.l	#$1ffff,blur_scroll
		move.l	xadd,d0
		lsl.l	#2,d0
		add.l	d0,xsin
		and.l	#$1fff,xsin
		move.l	yadd,d0
		lsl.l	#2,d0
		add.l	d0,ysin
		and.l	#$1fff,ysin
		rts


blur_main:	bsr.w	draw_blur
		bsr.w	draw_oscillos
		rts


draw_blur:	lea.l	sinus,a0
                move.l	xsin,d0
	        move.l	(a0,d0.w),d1
                muls.w	#288,d1
                asr.l	#8,d1
                asr.l	#7,d1
		bclr	#0,d1
		move.l	d1,xpos
                move.l	ysin,d0
                move.l	(a0,d0.w),d1
                muls.w	#100,d1
                asr.l	#8,d1
                asr.l	#7,d1
		muls.w	#576,d1
		move.l	d1,ypos
		move.l	scradr1,a0
		lea.l	64(a0),a0
		move.l	scradr2,a1
		lea.l	64(a1),a1
		lea.l	lut+576*50+160,a2
		add.l	xpos,a2
		add.l	ypos,a2
		lea.l	startdata(pc),a3
		add.l	#startbss-startdata+64*1024*2,a3
		add.l	blur_scroll,a3
		lea.l	startdata(pc),a4
		add.l	#startbss-startdata,a4
		clr.l	d0
		clr.l	d1
		move.w	#100-1,d7
.loop:		move.w	#128-1,d6
.loop2:		move.w	(a1),d0
		addq.l	#4,a1
		move.w	(a4,d0.l*2),d0
		move.w	(a2)+,d1
		add.w	(a3,d1.l*2),d0
		move.w	d0,(a0)+
		move.w	d0,(a0)+
		dbra	d6,.loop2
		lea.l	128(a0),a0
		lea.l	128(a1),a1
		lea.l	576-256(a2),a2
		dbra	d7,.loop
		rts


blur_scroll:	ds.l	1
xsin:		ds.l	1
ysin:		ds.l	1
xpos:		ds.l	1
ypos:		ds.l	1


draw_oscillos:	cmp.l	#1,colour
		beq.s	.col2
		cmp.l	#2,colour
		beq.s	.col3
.col1:		lea.l	col2+256*32,a5
		move.l	a5,a4
		bra.s	.done
.col2:		lea.l	col1+256*32,a5
		move.l	a5,a4
		bra.s	.done
.col3:		lea.l	col3+256*32,a5
		move.l	a5,a4
.done:		bsr.w	get_left_osci
		move.l	a0,a3
		move.l	scradr1,a0
		add.l	#640*50+2+64,a0
		move.l	a0,a1
		bsr.w	draw_one
		bsr.w	get_right_osci
		move.l	a0,a3
		move.l	scradr1,a0
		add.l	#640*50+256+2+64,a0
		move.l	a0,a1
		bsr.w	draw_one
		rts

draw_one:	move.w	#62-1,d7
.loop:		clr.l	d0
		move.w	(a3),d0	
		addq.l	#8,a3
		bge.s	.pos 
		neg.w	d0
		move.l	#-640,d5
		move.l	#-256,d4
		bra.s	.done
.pos:		move.l	#640,d5
		move.l	#256,d4
.done:		lsl.l	#6,d0
		swap	d0
		move.w	d0,d1
.loop2:		move.l	(a5),(a0)
		add.l	d5,a0
		add.l	d4,a5	
		dbra	d0,.loop2
		addq.l	#4,a1
		move.l	a1,a0
		addq.l	#2,a4
		move.l	a4,a5
		dbra	d7,.loop
		rts

blur_init:	lea.l	blur_vbl,a0
		bsr.w	set_vblrout
		lea.l	startdata(pc),a0
		add.l	#startbss-startdata,a0
		lea.l	blur_b_red_blue,a3
		lea.l	blur_b_green,a4
		clr.w	d0
.loop:		bfextu	d0{16:5},d1
		move.w	(a3,d1.w*2),d1
		bfextu	d0{21:6},d2
		move.w	(a4,d2.w*2),d2
		bfextu	d0{27:5},d3
		move.w	(a3,d3.w*2),d3
		bfins	d1,d4{16:5}
		bfins	d2,d4{21:6}
		bfins	d3,d4{27:5}
		move.w	d4,(a0)+
		addq	#1,d0
		bne.s	.loop
		lea.l	startdata(pc),a0
		add.l	#startbss-startdata+64*1024*2,a0
		move.l	a0,a1
		add.l	#256*256*2,a1
		lea.l	rawtxt,a2
		move.w	#256*256/2-1,d7
.loop2:		move.l	(a2)+,d0
		move.l	d0,(a0)+
		move.l	d0,(a1)+
		dbra	d7,.loop2
		rts




;ROUTINE SWITCHES VISIBLE SCREEN AND CYCLES THE SCREENADRESSES
switch_screens:	move.l	scradr3,d0
		move.l	scradr2,scradr3
		move.l	scradr1,scradr2
		move.l	d0,scradr1
		movea.l	scradr2,a0
		jsr	set_scradr
		rts

		section	data

		even
startdata:
lut:		incbin	'blurzoom.dat'
		even
rawtxt:		incbin	'blurzoom.16b'
		even
sinus:		incbin	'sinus.dat'
		even
col1:		incbin	'col1.16b'
		even
col2:		incbin	'col2.16b'
		even
col3:		incbin	'col3.16b'
		even

blur_b_red_blue:dc.w	0,0,0,1,2,3,5,5,6,7,8,8,9,10,11,11,12,13,14,14,15,16,17,17,18,19,20,20,21,22,23,23
blur_b_green:	dc.w	0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,17,18,19,20,20,21,22,23,23,24,25,26,26,27,28,29,29
		dc.w	30,31,32,32,33,34,35,35,36,37,38,38,39,40,41,41,42,43,44,44,45,46,47,47

scradr1:	dc.l	scr1+256
scradr2:	dc.l	scr2+256
scradr3:	dc.l	scr3+256

		section	bss

		even
startbss:
colsub:		ds.w	64*1024
text:		ds.w	256*512

scr1:		ds.w	320*100
scr2:		ds.w	320*100
scr3:		ds.w	320*100

		end
