;
; VLM EXAMPLE MODULE                                             NO/Escape'98
;

                ;OUTPUT 'E:\VOODOO\VLM\EXAMPLE.VLM'
                TEXT

*** VLM STRUCTURE **************************************************************

                DC.B "VLM2"     ;vlm module type
                DC.L infotext   ;pointer to infotext
                DC.L settings   ;pointer to settings-structure
                DC.L init       ;pointer to init routine
                DC.L deinit     ;pointer to deinit routine
                DC.L main       ;pointer to mainloop routine

;SERVICE ROUTINES PROVIDED BY THE CALLING PROGRAM

set_vblrout:
;a0: new vbl subroutine
                movea.l service_struct,A1
                movea.l (A1),A1
                jsr     (A1)
                rts

wait_vbl:
                movea.l service_struct,A1
                movea.l 4(A1),A1
                jsr     (A1)
                rts

set_scradr:
;a0: new screen adress
                movea.l service_struct,A1
                movea.l 8(A1),A1
                jsr     (A1)
                rts

set_resolution:
;d0: number of the wanted resolution
                movea.l service_struct,A1
                movea.l 12(A1),A1
                jsr     (A1)
                rts

get_left_spec:
                movea.l service_struct,A1
                movea.l 16(A1),A1
                jsr     (A1)            ;returns in a0 the adress of left spec
                rts

get_right_spec:
                movea.l service_struct,A1
                movea.l 20(A1),A1
                jsr     (A1)            ;returns in a0 the adress of right spec
                rts

get_left_volume:
                movea.l service_struct,A1
                movea.l 24(A1),A1
                jsr     (A1)            ;returns in d0 the left volume value
                rts

get_right_volume:
                movea.l service_struct,A1
                movea.l 28(A1),A1
                jsr     (A1)            ;returns in d0 the right volume value
                rts

get_left_osci:
                movea.l service_struct,A1
                movea.l 32(A1),A1
                jsr     (A1)            ;returns in a0 the adress of osci data
                rts

get_right_osci:
                movea.l service_struct,A1
                movea.l 36(A1),A1
                jsr     (A1)            ;returns in a0 the adress of osci data
                rts

service_struct: DC.L 0          ;must be set in 'init'

********************************************************************************
infotext:       
                DC.B 'bumpmapper',0
                DC.B ' author: evil ',0
                DC.B 'version: 1.0',0
                DC.B '   date: june 12, 1999',0
                DC.B 0
                EVEN

settings:       dc.l	6


		dc.l	stepname
		dc.l	2
steprate:	dc.l	0
		dc.l	stepstruct

		dc.l	brightname
		dc.l	3
brightness:	dc.l	256
		dc.l	brightstruct


		dc.l	colname
		dc.l	2
palette:	dc.l	0
		dc.l	colstruct

		dc.l	slicename
		dc.l	3
timeslice:	dc.l	2
		dc.l	slicestruct

		dc.l	sinxname
		dc.l	3
sinxadd:	dc.l	5
		dc.l	sinxstruct

		dc.l	sinyname
		dc.l	3
sinyadd:	dc.l	4
		dc.l	sinystruct


slicestruct:	dc.l	1,20
brightstruct:	dc.l	0,768

sinxstruct:	dc.l	0,20
sinystruct:	dc.l	0,20

stepstruct:	dc.l	3
		dc.b	'NORMAL',0
		dc.b	'INTENSE',0
		dc.b	'EXTREME',0
		even

colstruct:	dc.l	5
		dc.b	'PALETTE 1 (BLUE)',0
		dc.b	'PALETTE 2 (RED)',0
		dc.b	'PALETTE 3 (CYAN-BLUE)',0
		dc.b	'PALETTE 4 (MAGNETA)',0
		dc.b	'PALETTE 5 (YELLOW)',0
		even

colname:	dc.b	'COLOUR PALETTE:',0
		even
slicename:	dc.b	'TIMESLICE:',0
		even
stepname:	dc.b	'STEPRATE (SENSITIVITY)',0
		even
brightname:	dc.b	'BRIGHTNESS:',0
		even
sinxname:	dc.b	'X-SINUS SPEED:',0
		even
sinyname:	dc.b	'Y-SINUS SPEED:',0
		even




init:           
;a0: service structure
                move.l  A0,service_struct

		bsr.w	bump_init
		bsr.w	clear_screens

                movea.l scradr2,A0      ;set new screen adress
                bsr     set_scradr

                move.l  #2,D0           ;set resolution to 320x100
                bsr     set_resolution
                rts
deinit:         rts


clear_screens:
		move.l	scradr1,a0
		move.l	scradr2,a1
		move.l	scradr3,a2
		move.w	#320*100*2/64-1,d7
.loop:		rept	16
		clr.l	(a0)+
		clr.l	(a1)+
		clr.l	(a2)+
		endr
		dbra	d7,.loop
		rts


main:           jsr     wait_vbl
                jsr     switch_screens

		bsr.w	bump_main

                rts                     ;end of the mainroutine


bump_vbl:	move.l	d0,-(sp)

		move.l	sinxadd,d0
		lsl.l	#2,d0
		add.l	d0,xsin
		and.l	#$1fff,xsin

		move.l	sinyadd,d0
		lsl.l	#2,d0
		add.l	d0,ysin
		and.l	#$1fff,ysin

		tst.l	countdown
		beq.s	.no
		subq.l	#1,countdown
.no:		cmp.l	#8,voladd
		ble.s	.no2
		subq.l	#8,voladd
.no2:

		move.l	(sp)+,d0
		rts


bump_main:

		lea.l	sinus,a0

                move.l	xsin,d0
	        move.l	(a0,d0.w),d1
                muls.w	#128,d1
                asr.l	#8,d1
                asr.l	#7,d1
		bclr	#0,d1
		move.l	d1,xpos

                move.l	ysin,d0
                move.l	(a0,d0.w),d1
                muls.w	#64,d1
                asr.l	#8,d1
                asr.l	#7,d1
		asl.l	#8,d1
		move.l	d1,ypos



		tst.l	countdown
		bne.s	.novoladd
		move.l	timeslice,countdown


		bsr.w	get_left_volume
		move.l	d0,d1
		bsr.w	get_right_volume
		add.l	d0,d1


		cmp.l	#1,steprate
		beq.s	.normal2
		cmp.l	#2,steprate
		beq.s	.normal4

.normal:	lsr.l	#7,d1
		and.l	#%00000000000000000000000111111110,d1
		bra.s	.stepdone
.normal2:	lsr.l	#6,d1
		and.l	#%00000000000000000000001111111110,d1
		bra.s	.stepdone
.normal4:	lsr.l	#5,d1
		and.l	#%00000000000000000000011111111110,d1



.stepdone:	move.l	d1,voladd
.novoladd:


		move.l	scradr1,a0
		lea.l	64(a0),a0

		lea.l	bumpmap,a1

		lea.l	flare+788+256*78+64,a2
		add.l	xpos,a2
		add.l	ypos,a2


		cmp.l	#1,palette
		beq.s	.setpal2
		cmp.l	#2,palette
		beq.s	.setpal3
		cmp.l	#3,palette
		beq.s	.setpal4
		cmp.l	#4,palette
		beq.s	.setpal5

.setpal1:	lea.l	pal01,a3
		bra.s	.addit
.setpal2:	lea.l	pal02,a3
		bra.s	.addit
.setpal3:	lea.l	pal03,a3
		bra.s	.addit
.setpal4:	lea.l	pal04,a3
		bra.s	.addit
.setpal5:	lea.l	pal05,a3

.addit:		add.l	voladd,a3
		move.l	brightness,d0
		bclr	#0,d0
		add.l	d0,a3



		clr.l	d0
		clr.l	d1

		move.w	#100-1,d7
.loop:		swap	d7
		move.w	#128/16-1,d7
.loop2:	
		rept	16
		move.w	(a1)+,d0
		move.b	(a2,d0.w),d1
		addq.l	#1,a2
		move.l	(a3,d1.w*2),(a0)+
		endr
				
		dbra	d7,.loop2
		lea.l	640-512(a0),a0
		lea.l	256-128(a2),a2
		swap	d7
		dbra	d7,.loop

		rts




bump_init:
		lea.l	bump_vbl,a0
		bsr.w	set_vblrout

		lea.l	pal,a0
		lea.l	pal02+512,a1
		lea.l	pal01+512,a2
		lea.l	pal03+512,a3
		lea.l	pal04+512,a4
		lea.l	pal05+512,a5
		move.w	#256/2-1,d7
.loop:		move.l	512*1(a0),d0
		clr.l	-512(a2)
		move.l	d0,(a2)+
		move.l	512*2(a0),d0
		clr.l	-512(a3)
		move.l	d0,(a3)+
		move.l	512*3(a0),d0
		clr.l	-512(a4)
		move.l	d0,(a4)+
		move.l	512*4(a0),d0
		clr.l	-512(a5)
		move.l	d0,(a5)+
		move.l	(a0)+,d0
		clr.l	-512(a1)
		move.l	d0,(a1)+
		dbra	d7,.loop

		lea.l	pal01+1024,a0
		lea.l	pal02+1024,a1
		lea.l	pal03+1024,a2
		lea.l	pal04+1024,a3
		lea.l	pal05+1024,a4
		move.l	#-1,d0
		move.w	#256*6/2-1,d7
.loop2:		move.l	d0,(a0)+
		move.l	d0,(a1)+
		move.l	d0,(a2)+
		move.l	d0,(a3)+
		move.l	d0,(a4)+
		dbra	d7,.loop2
		rts



countdown:	ds.l	1
voladd:		ds.l	1
ysin:		ds.l	1
xsin:		ds.l	1
xpos:		ds.l	1
ypos:		ds.l	1





;ROUTINE SWITCHES VISIBLE SCREEN AND CYCLES THE SCREENADRESSES
switch_screens:
                move.l  scradr3,D0
                move.l  scradr2,scradr3
                move.l  scradr1,scradr2
                move.l  D0,scradr1
                movea.l scradr2,A0
                jsr     set_scradr
                rts

		section	data

		even

bumpmap:	incbin	'bump.dat'
		even
flare:		incbin	'flare.apx'
		even
sinus:		incbin	'sinus.dat'
		even
pal:		incbin	'pal.16b'
		even

scradr1:        Dc.L scr1+256
scradr2:        Dc.L scr2+256
scradr3:        Dc.L scr3+256

                section	bss


pal01:		ds.w	256+256+(256*6)
pal02:		ds.w	256+256+(256*6)
pal03:		ds.w	256+256+(256*6)
pal04:		ds.w	256+256+(256*6)
pal05:		ds.w	256+256+(256*6)


scr1:		ds.w	320*100
scr2:		ds.w	320*100
scr3:		ds.w	320*100

                END
