; Copyright 1999 Tomas Berndtsson <tomas@nocrew.org>

  	include	macros.s

VLM_MODULE	=	1
GFXMODE	=	%100110100
SHOWVBL	=	0

XRES	=	320
YRES	=	240

PADSIZE	=	42
BALLSIZE	=	4

NUMWIDTH	=	5
NUMHEIGHT	=	5

P1NUMPOS	=	176
P2NUMPOS	=	(XRES-44)*2-P1NUMPOS

	ifne	VLM_MODULE
	opt	nodebug
	output	d:\sound\whip!\vlm\whipong.vlm
	include	vlmserv.s
	endc

	text

	ifne	VLM_MODULE

	dc.b	"VLM2"
	dc.l	infotext
	dc.l	settings
	dc.l	init
	dc.l	deinit
	dc.l	main

	else
	
	bsr.w	init

	endc

	ifne	VLM_MODULE
	nop
	endc

;	nop
main
	bsr	scrswap

	ifne	SHOWVBL
	move.l	scrp,a3
	move.w	$468.w,d7
	subq.w	#1,d7
.vsl
	move.l	#$ffffffff,(a3)+
	move.l	#$00000000,(a3)+
	dbra	d7,.vsl

	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	endc

	ifne	VLM_MODULE
	vlm_wait_vbl
	else
	vsync
	endc

	bsr	clrpads
	bsr	clrball

	bsr	movepads
	bsr	moveball

	bsr	drawpads
	bsr	drawball
	
	ifne	VLM_MODULE

	rts
	
	else

	cmp.b	#$3b,$fffffc02.w
	bne	main

slu
	stdexit
	pea	0.w
	trap	#1

	endc

init	
	ifne	VLM_MODULE

	move.l	a0,service_struct
	vlm_set_resolution #VLM_320x240x16
	
	else

	super
	stdinit	#-1,#-1,#GFXMODE

	endc
	
	clr.w	p1pos
	clr.w	p2pos
	move.w	#160-BALLSIZE/2,ballx
	move.w	#160-BALLSIZE/2,ballx+2
	move.w	#120-BALLSIZE/2,bally
	move.w	#120-BALLSIZE/2,bally+2
	move.w	option_speedx+2,balldx
	move.w	option_speedy+2,balldy

	lea	savedback1,a0
	lea	savedback2,a1
	move.w	#BALLSIZE*BALLSIZE-1,d7
.csbl
	clr.w	(a0)+
	clr.w	(a1)+
	dbra	d7,.csbl

	lea	scr1,a0
	lea	scr2,a1
	move.w	#XRES*YRES/4-1,d7
.csl
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a1)+
	clr.l	(a1)+
	dbra	d7,.csl

	moveq	#0,d0
	move.l	#P1NUMPOS,d1
	bsr	drawwins
	moveq	#0,d0
	move.l	#P2NUMPOS,d1
	bsr	drawwins

	rts

deinit
	rts


scrswap
	ifeq	VLM_MODULE
	move.l	scrp,-(sp)
	move.l	scrp+4,scrp
	move.b	1(sp),$ffff8201.w
	move.b	2(sp),$ffff8203.w
	move.b	3(sp),$ffff820d.w
	move.l	(sp)+,scrp+4

	else

	move.l	scrp,tmpscrp
	move.l	scrp+4,scrp
	move.l	tmpscrp,scrp+4
	vlm_set_scradr	tmpscrp

	endc

	move.w	p1pos,d0
	move.w	p1pos+2,p1pos
	move.w	d0,p1pos+2
	move.w	p2pos,d0
	move.w	p2pos+2,p2pos
	move.w	d0,p2pos+2
	move.w	ballx,d0
	move.w	ballx+2,ballx
	move.w	d0,ballx+2
	move.w	bally,d0
	move.w	bally+2,bally
	move.w	d0,bally+2

	move.l	savedbackp,d0
	move.l	savedbackp+4,savedbackp
	move.l	d0,savedbackp+4

	rts


drawpads
	move.l	scrp,a0
	move.w	p1pos,d0
	mulu.w	#XRES*2,d0
	add.l	d0,a0
	move.w	#PADSIZE,d7
.dp1l
	move.l	#$ffffffff,(a0)
	lea	XRES*2(a0),a0
	dbra	d7,.dp1l

	move.l	scrp,a0
	move.w	p2pos,d0
	mulu.w	#XRES*2,d0
	add.l	d0,a0
	add.w	#(XRES-2)*2,a0
	move.w	#PADSIZE,d7
.dp2l
	move.l	#$ffffffff,(a0)
	lea	XRES*2(a0),a0
	dbra	d7,.dp2l
	
	rts
	
drawball
	move.l	scrp,a0
	move.l	savedbackp,a1
	move.w	ballx,d0
	ext.l	d0
	move.w	bally,d1
	mulu.w	#XRES*2,d1
	add.l	d1,a0
	add.l	d0,a0
	add.l	d0,a0
	move.w	#BALLSIZE-1,d7
.yl
	move.w	#BALLSIZE-1,d6
.xl
	move.w	(a0),(a1)+
	move.w	#$f800,(a0)+
	dbra	d6,.xl
	lea	(XRES-BALLSIZE)*2(a0),a0
	dbra	d7,.yl
	rts


clrpads
	move.l	scrp,a0
	move.w	p1pos,d0
	mulu.w	#640,d0
	add.l	d0,a0
	move.w	#PADSIZE,d7
.dp1l
	clr.l	(a0)
	lea	640(a0),a0
	dbra	d7,.dp1l

	move.l	scrp,a0
	move.w	p2pos,d0
	mulu.w	#640,d0
	add.l	d0,a0
	add.w	#318*2,a0
	move.w	#PADSIZE,d7
.dp2l
	clr.l	(a0)
	lea	640(a0),a0
	dbra	d7,.dp2l
	rts

clrball
	move.l	scrp,a0
	move.l	savedbackp,a1
	move.w	ballx,d0
	ext.l	d0
	move.w	bally,d1
	mulu.w	#XRES*2,d1
	add.l	d1,a0
	add.l	d0,a0
	add.l	d0,a0
	move.w	#BALLSIZE-1,d7
.yl
	move.w	#BALLSIZE-1,d6
.xl
	move.w	(a1)+,(a0)+
	dbra	d6,.xl
	lea	(XRES-BALLSIZE)*2(a0),a0
	dbra	d7,.yl
	rts
	
movepads
	ifne	VLM_MODULE

	vlm_get_left_volume d7
	and.l	#$ffff,d7
	move.l	option_sense,d0
	mulu.w	d0,d7
	swap	d7
	cmp.w	#YRES-PADSIZE,d7
	blt.s	.lok
	move.w	#YRES-PADSIZE-1,d7
.lok
	move.w	p1pos+2,d6
	sub.w	d6,d7
	bpl.s	.lnoneg
	neg.w	d7
	cmp.w	option_smooth+2,d7
	ble.s	.lnotmin
	move.w	option_smooth+2,d7
.lnotmin
	sub.w	d7,d6
	move.w	d6,p1pos
	bra.s	.ldone
.lnoneg
	cmp.w	option_smooth+2,d7
	ble.s	.lnotmax
	move.w	option_smooth+2,d7
.lnotmax
	add.w	d7,d6
	move.w	d6,p1pos
.ldone
	vlm_get_right_volume d7
	and.l	#$ffff,d7
	move.l	option_sense,d0
	mulu.w	d0,d7
	swap	d7
	cmp.w	#YRES-PADSIZE,d7
	blt.s	.rok
	move.w	#YRES-PADSIZE-1,d7
.rok
	
	move.w	p2pos+2,d6
	sub.w	d6,d7
	bpl.s	.rnoneg
	neg.w	d7
	cmp.w	option_smooth+2,d7
	ble.s	.rnotmin
	move.w	option_smooth+2,d7
.rnotmin
	sub.w	d7,d6
	move.w	d6,p2pos
	bra.s	.rdone
.rnoneg
	cmp.w	option_smooth+2,d7
	ble.s	.rnotmax
	move.w	option_smooth+2,d7
.rnotmax
	add.w	d7,d6
	move.w	d6,p2pos
.rdone

	else

	addq.w	#1,p1pos
	cmp.w	#YRES-PADSIZE,p1pos
	blt.s	.noreset1
	clr.w	p1pos
.noreset1
	addq.w	#1,p2pos
	cmp.w	#YRES-PADSIZE,p2pos
	blt.s	.noreset2
	clr.w	p2pos
.noreset2
	endc
	rts

moveball
	move.w	ballx+2,d0
	move.w	bally+2,d1
	move.w	#2,d2
	add.w	option_speedx+2,d2
	cmp.w	d2,d0
	bgt.s	.noxmin
	move.w	p1pos+2,d2
	sub.w	#BALLSIZE,d2
	bpl.s	.notneg11
	clr.w	d2
.notneg11
	cmp.w	d2,d1
	blt.s	.sec1
	add.w	#PADSIZE-BALLSIZE,d2
	cmp.w	d2,d1
	ble	.on1
.sec1
	move.w	p1pos,d2
	sub.w	#BALLSIZE,d2
	bpl.s	.notneg12
	clr.w	d2
.notneg12
	cmp.w	d2,d1
	blt	p2won
	add.w	#PADSIZE-BALLSIZE,d2
	cmp.w	d2,d1
	bgt	p2won
.on1
	neg.w	balldx
.noxmin
	cmp.w	#0,d1
	bgt.s	.noymin
	neg.w	balldy
.noymin
	move.w	#XRES-BALLSIZE-2,d2
	sub.w	option_speedx+2,d2
	cmp.w	d2,d0
	blt.s	.noxmax
	move.w	p2pos+2,d2
	sub.w	#BALLSIZE,d2
	bpl.s	.notneg21
	clr.w	d2
.notneg21
	cmp.w	d2,d1
	blt	.sec2
	add.w	#PADSIZE-BALLSIZE,d2
	cmp.w	d2,d1
	ble	.on2
.sec2
	move.w	p2pos,d2
	sub.w	#BALLSIZE,d2
	bpl.s	.notneg22
	clr.w	d2
.notneg22
	cmp.w	d2,d1
	blt	p1won
	add.w	#PADSIZE-BALLSIZE,d2
	cmp.w	d2,d1
	bgt	p1won
.on2
	neg.w	balldx
.noxmax
	move.w	#YRES-BALLSIZE,d2
	sub.w	option_speedy+2,d2
	cmp.w	d2,d1
	blt.s	.noymax
	neg.w	balldy
.noymax
	
	add.w	balldx,d0
	move.w	d0,ballx
	
	add.w	balldy,d1
	move.w	d1,bally
	rts

p1won
	moveq	#1,d0
	move.w	p1wins,d1
	abcd	d0,d1
	move.w	d1,p1wins
	move.w	p1wins,d0
	move.l	#P1NUMPOS,d1
	bsr	drawwins
	move.w	#160,ballx
	move.w	#120,bally
	move.w	option_speedx+2,balldx
	neg.w	balldx
	rts
p2won
	moveq	#1,d0
	move.w	p2wins,d1
	abcd	d0,d1
	move.w	d1,p2wins
	move.w	p2wins,d0
	move.l	#P2NUMPOS,d1
	bsr	drawwins
	move.w	#160,ballx
	move.w	#120,bally
	move.w	option_speedx+2,balldx
	rts

drawwins
	move.l	scrp,a0
	lea	numbers,a1
	moveq	#0,d2
	move.b	d0,d2
	lsr.w	#4,d2
	mulu.w	#NUMWIDTH*NUMHEIGHT*2,d2
	lea	(a1,d2.l),a3
	lea	(a0,d1.l),a2
	bsr	setnum

	moveq	#0,d2
	move.b	d0,d2
	and.w	#$f,d2
	mulu.w	#NUMWIDTH*NUMHEIGHT*2,d2
	lea	(a1,d2.l),a3
	lea	(a0,d1.l),a2
	lea	(NUMWIDTH+1)*4*2(a2),a2
	bsr	setnum

	move.l	scrp+4,a0
	moveq	#0,d2
	move.b	d0,d2
	lsr.w	#4,d2
	mulu.w	#NUMWIDTH*NUMHEIGHT*2,d2
	lea	(a1,d2.l),a3
	lea	(a0,d1.l),a2
	bsr	setnum

	moveq	#0,d2
	move.b	d0,d2
	and.w	#$f,d2
	mulu.w	#NUMWIDTH*NUMHEIGHT*2,d2
	lea	(a1,d2.l),a3
	lea	(a0,d1.l),a2
	lea	(NUMWIDTH+1)*4*2(a2),a2
	bsr	setnum
	rts


setnum
	move.w	#NUMHEIGHT-1,d7
.yl
	move.w	#NUMWIDTH-1,d6
.xl
	moveq	#0,d5
	tst.w	(a3)+
	beq.s	.set
	move.w	#$07e0,d5
.set
	bsr	setdot
	lea	4*2(a2),a2
	dbra	d6,.xl
	lea	(3*XRES+XRES-NUMWIDTH*4)*2(a2),a2
	dbra	d7,.yl
	rts

setdot
	move.l	a2,a4
	move.w	#4-1,d4
.yl
	move.w	#4-1,d3
.xl
	move.w	d5,(a4)+
	dbra	d3,.xl
	lea	(XRES-4)*2(a4),a4
	dbra	d4,.yl
	rts


	data

scrp	dc.l	scr1,scr2
savedbackp	dc.l	savedback1,savedback2

p1wins	dc.w	0
p2wins	dc.w	0

	ifne	VLM_MODULE
infotext	dc.b	'WHIPONG',0
	dc.b	'Author:  NoBrain/NoCrew',0
	dc.b	'Version: 0.42',0
	dc.b	'Date:    1999-06-22',0
	dc.b	0
	even
	
settings	dc.l	4

	dc.l	par1name
	dc.l	3
option_sense	dc.l	YRES-PADSIZE
	dc.l	sensestruct

	dc.l	par2name
	dc.l	3
option_smooth	dc.l	(YRES-PADSIZE)/2
	dc.l	smoothstruct

	dc.l	par3name
	dc.l	3
option_speedx	dc.l	1
	dc.l	speedstruct

	dc.l	par4name
	dc.l	3
option_speedy	dc.l	1
	dc.l	speedstruct

par1name	dc.b	'SENSITIVITY',0
par2name	dc.b	'SMOOTHNESS',0
par3name	dc.b	'BALL X SPEED',0
par4name	dc.b	'BALL Y SPEED',0
	even

sensestruct	dc.l	0,2*YRES
smoothstruct	dc.l	1,YRES-PADSIZE
speedstruct	dc.l	1,8
		
	endc

numbers
	dc.w	1,1,1,1,1
	dc.w	1,0,0,0,1
	dc.w	1,0,0,0,1
	dc.w	1,0,0,0,1
	dc.w	1,1,1,1,1

	dc.w	1,1,1,0,0
	dc.w	0,0,1,0,0
	dc.w	0,0,1,0,0
	dc.w	0,0,1,0,0
	dc.w	1,1,1,1,1

	dc.w	1,1,1,1,1
	dc.w	0,0,0,0,1
	dc.w	1,1,1,1,1
	dc.w	1,0,0,0,0
	dc.w	1,1,1,1,1

	dc.w	1,1,1,1,1
	dc.w	0,0,0,0,1
	dc.w	0,0,1,1,1
	dc.w	0,0,0,0,1
	dc.w	1,1,1,1,1

	dc.w	1,0,0,0,1
	dc.w	1,0,0,0,1
	dc.w	1,1,1,1,1
	dc.w	0,0,0,0,1
	dc.w	0,0,0,0,1

	dc.w	1,1,1,1,1
	dc.w	1,0,0,0,0
	dc.w	1,1,1,1,1
	dc.w	0,0,0,0,1
	dc.w	1,1,1,1,1

	dc.w	1,1,1,1,1
	dc.w	1,0,0,0,0
	dc.w	1,1,1,1,1
	dc.w	1,0,0,0,1
	dc.w	1,1,1,1,1

	dc.w	1,1,1,1,1
	dc.w	0,0,0,0,1
	dc.w	0,0,0,0,1
	dc.w	0,0,0,0,1
	dc.w	0,0,0,0,1

	dc.w	1,1,1,1,1
	dc.w	1,0,0,0,1
	dc.w	1,1,1,1,1
	dc.w	1,0,0,0,1
	dc.w	1,1,1,1,1

	dc.w	1,1,1,1,1
	dc.w	1,0,0,0,1
	dc.w	1,1,1,1,1
	dc.w	0,0,0,0,1
	dc.w	1,1,1,1,1

	bss

	ifne	VLM_MODULE
tmpscrp	ds.l	1
service_struct ds.l	1
	endc

p1pos	ds.w	2
p2pos	ds.w	2
ballx	ds.w	2
bally	ds.w	2
balldx	ds.w	1
balldy	ds.w	1

savedback1	ds.w	BALLSIZE*BALLSIZE
savedback2	ds.w	BALLSIZE*BALLSIZE
	
	ifeq	VLM_MODULE
	stdbss
	endc
scr1	ds.w	XRES*YRES
scr2	ds.w	XRES*YRES
