;
; VLM EXAMPLE MODULE                                             NO/Escape'98
;

numb_cols:	equ	256
baseriple:	equ	64
basedeep:	equ	64


		section	text

*** VLM STRUCTURE **************************************************************

		dc.b	"VLM2"		;vlm module type
		dc.l	infotext	;pointer to infotext
		dc.l	settings	;pointer to settings-structure
		dc.l	init		;pointer to init routine
		dc.l	deinit		;pointer to deinit routine
		dc.l	main		;pointer to mainloop routine

;SERVICE ROUTINES PROVIDED BY THE CALLING PROGRAM

set_vblrout:
;a0: new vbl subroutine
		movea.l service_struct,a1
		movea.l (a1),a1
		jsr     (a1)
		rts

wait_vbl:	movea.l	service_struct,a1
		movea.l	4(a1),a1
		jsr	(a1)
		rts

set_scradr:
;a0: new screen adress
		movea.l	service_struct,a1
		movea.l	8(a1),a1
		jsr	(a1)
		rts

set_resolution:
;d0: number of the wanted resolution
		movea.l	service_struct,a1
		movea.l	12(a1),a1
		jsr	(a1)
		rts

get_left_spec:	movea.l	service_struct,a1
		movea.l	16(a1),a1
		jsr	(a1)		;returns in a0 the adress of left spec
                rts

get_right_spec:	movea.l	service_struct,a1
		movea.l	20(a1),a1
		jsr	(a1)            ;returns in a0 the adress of right spec
		rts

get_left_volume:movea.l	service_struct,a1
		movea.l 24(A1),A1
		jsr	(A1)		;returns in d0 the left volume value
		rts

get_right_volume:
		movea.l service_struct,a1
		movea.l 28(a1),a1
		jsr	(a1)		;returns in d0 the right volume value
		rts

get_left_osci:	movea.l service_struct,a1
		movea.l	32(A1),a1
		jsr	(a1)		;returns in a0 the adress of osci data
		rts

get_right_osci:	movea.l	service_struct,a1
		movea.l	36(a1),a1
		jsr	(a1)		;returns in a0 the adress of osci data
		rts

service_struct:	dc.l	0		;must be set in 'init'

********************************************************************************
infotext:       
		dc.b	' plugin: ripples',0
		dc.b	' author: evil ',0
		dc.b	'version: 1.0',0
		dc.b	'   date: october 16, 1999',0
		dc.b	0
		even

settings:       dc.l	6

		dc.l	layername
		dc.l	2
layermode:	dc.l	0
		dc.l	layerstruct

		dc.l	typename
		dc.l	2
type:		dc.l	0
		dc.l	typestruct


		dc.l	ripplename
		dc.l	2
ripplesize:	dc.l	1
		dc.l	ripplestruct


		dc.l	deepname
		dc.l	2
rippledepth:	dc.l	1
		dc.l	deepstruct

		dc.l	brightname
		dc.l	3
brightness:	dc.l	6
		dc.l	brightstruct

		dc.l	brmusicname
		dc.l	2
brmusic:	dc.l	1
		dc.l	brmusicstruct



layername:	dc.b	"LAYER SELECTION:",0
		even
layerstruct:	dc.l	2
		dc.b	"SINGLE LAYER",0
		dc.b	"MULTIPLE LAYERS",0
		even

ripplename:	dc.b	"NUMBER OF RIPPLES",0
		even
ripplestruct:	dc.l	3
		dc.b	"SJOBRIS (FEW)",0
		dc.b	"SURFING (SOME)",0
		dc.b	"ESTONIA (ALOT!)",0
		even

deepname:	dc.b	"RIPPLE DEPTH",0
		even
deepstruct:	dc.l	3
		dc.b	"RED SEA (BORING)",0
		dc.b	"BALTIC SEA (OK)",0
		dc.b	"NORTH SEA (SEASICK!)",0
		even

brightname:	dc.b	"BRIGHTNESS (M-LAYER)",0
		even
brightstruct:	dc.l	0,63
		even

brmusicname:	dc.b	"FLASHING (M-LAYER)",0
		even
brmusicstruct:	dc.l	2
		dc.b	"NO",0
		dc.b	"YES",0
		even

typename:	dc.b	"RIPPLE SOURCE",0
		even
typestruct:	dc.l	2
		dc.b	"DEEP BASS",0
		dc.b	"VOLUME",0
		even





init:           move.l	a0,service_struct
		bsr.w	whip_init
		bsr.w	clear_screens
		movea.l	scradr2,a0
		bsr.w	set_scradr
		move.l	#2,d0
		bsr.w	set_resolution
		lea.l	vbl,a0
		jsr	set_vblrout
                rts

deinit:		rts







main:		jsr	switch_screens
		clr.l	d1
		clr.l	d0
		tst.l	type
		bne.s	.vol
.bass:		bsr.w	get_right_spec
		move.w	(a0)+,d0
		lsr.w	#1,d0
		move.w	(a0)+,d1
		lsr.w	#1,d1
		add.w	d1,d0
		bsr.w	get_left_spec
		lsr.w	#1,d0
		move.w	(a0)+,d1
		lsr.w	#1,d1
		add.w	d1,d0
		lsr.w	#1,d0
		move.w	(a0)+,d1
		lsr.w	#1,d1
		add.w	d1,d0
		move.w	d0,d1
		move.w	d0,d2
		lsr.w	#8,d1
		lsr.w	#1,d1
		bra.s	.rippledo
.vol:		bsr.w	get_left_volume
		move.w	d0,d1
		lsr.w	#1,d1
		bsr.w	get_right_volume		
		lsr.w	#1,d0
		add.w	d0,d1
		move.w	d1,d2
		lsr.w	#7,d1
.rippledo:	move.w	deepshift,d3
		lsr.w	d3,d2
		move.w	mulsval,d3
		cmp.w	d3,d1
		blt.s	.no
		move.w	d1,mulsval
		move.w	d2,deepmul
.no:		cmp.l	#2,ripplesize
		bne.s	.next1
		move.l	#60*3,rippleadd
		bra.s	.rippledone
.next1:		cmp.l	#1,ripplesize
		bne.s	.next2
		move.l	#60*2,rippleadd
		bra.s	.rippledone
.next2:		move.l	#60*1,rippleadd
.rippledone:	cmp.l	#2,rippledepth
		bne.s	.next3
		move.w	#6,deepshift
		bra.s	.deepdone
.next3:		cmp.l	#1,rippledepth
		bne.s	.next4
		move.w	#7,deepshift
		bra.s	.deepdone
.next4:		move.w	#8,deepshift
.deepdone:	tst.l	layermode
		bne.s	.multi
		bsr.w	whip_main2
		bra.s	.done
.multi:		move.l	brightness,d0
		lsl.w	#8,d0
		lsl.w	#2,d0
		move.l	d0,brightnessadd
		tst.l	brmusic
		beq.s	.nobrmusic
		clr.l	d1
		bsr.w	get_left_volume
		lsr.w	#1,d0
		move.w	d0,d1
		bsr.w	get_right_volume
		add.w	d0,d1
		and.w	#$fc00,d1
		move.l	d1,brightnessvol
		bra.s	.brmusicdone
.nobrmusic:	clr.l	brightnessvol
.brmusicdone:	bsr.w	whip_main
.done:		rts		


vbl:		bsr.w	whip_vbl
		rts

; ------------------------------------------------------
; EFX MAINLOOP
; ------------------------------------------------------

whip_main:	move.l	scradr1,a0
		lea.l	spiral,a1
		lea.l	palette,a2
		lea.l	texture,a4
		lea.l	light,a5
		add.l	brightnessvol,a2
		add.l	brightnessadd,a2
		add.l	texture_pos,a4
		lea.l	ringlist,a6
		clr.l	d0
		clr.l	d1
		clr.l	d2
		clr.l	d3
		move.w	#280/2-1,d7
.varv:		move.w	(a6)+,d6
		move.l	rippleadd,d5
		add.l	d5,sin
		and.l	#$1fff,sin
		lea.l	sinus,a3
                move.l	sin,d5
                move.l	(a3,d5.w),d5
		move.w	mulsval,d4
		muls.w	d4,d5
		asr.l	#8,d5
                asr.l	#7,d5
		lsl.l	#2,d5
		lea.l	4096(a3),a3
                move.l	(a3,d5.w),d5
		move.w	deepmul,d4
                muls.w	d4,d5
                asr.l	#8,d5
                asr.l	#7,d5
		add.l	d5,d5
		move.l	d5,sinpos
		lea.l	ringtexture,a3
		add.l	sinpos,a3
		move.l	a6,d5
		lea.l	logo,a6
.ring:		move.w	(a1)+,d0
		move.w	(a5,d0.w),d1
		move.w	(a4,d1.l*2),d1
		add.w	(a3,d0.w),d1
		add.w	(a6,d0.w),d1
		move.l	(a2,d1.l*4),(a0,d0.w*2)
		dbra	d6,.ring
		move.l	d5,a6
		dbra	d7,.varv
		bsr.w	bugfix
		rts

whip_main2:	move.l	scradr1,a0
		lea.l	spiral,a1
		lea.l	ringlist,a6
		clr.l	d0
		clr.l	d1
		move.w	#280/2-1,d7
.varv:		move.w	(a6)+,d6
		move.l	rippleadd,d5
		add.l	d5,sin
		and.l	#$1fff,sin
		lea.l	sinus,a3
                move.l	sin,d5
                move.l	(a3,d5.w),d5
		move.w	mulsval,d4
		muls.w	d4,d5
		asr.l	#8,d5
                asr.l	#7,d5
		lsl.l	#2,d5
		lea.l	4096(a3),a3
                move.l	(a3,d5.w),d5
		move.w	deepmul,d4
                muls.w	d4,d5
                asr.l	#8,d5
                asr.l	#7,d5
		add.l	d5,d5
		move.l	d5,sinpos
		lea.l	ringtexture2,a3
		add.l	sinpos,a3
.ring:		move.w	(a1)+,d0
		move.l	(a3,d0.l*2),(a0,d0.l*2)
		dbra	d6,.ring
		dbra	d7,.varv
		bsr.w	bugfix
		rts

; lame offsetbug workarounds...
bugfix:		move.l	scradr1,a0
		move.l	640*48+312(a0),640*48+316(a0)
		move.l	640*50+312(a0),640*49+316(a0)
		move.l	640*49+308(a0),640*49+312(a0)
		move.l	640*48+320(a0),640*49+320(a0)
		move.l	640*50+320(a0),640*50+316(a0)
		move.l	scradr1,a0
		lea.l	60(a0),a0
		move.l	a0,a1
		add.l	#640*99,a1
		move.w	#520/4-1,d7
.lineclr:	clr.l	(a0)+
		clr.l	(a1)+
		dbra	d7,.lineclr
		move.l	scradr1,a0
		lea.l	640+64(a0),a0
		lea.l	512-4(a0),a1
		move.w	#100-3,d7
.colclr:	clr.l	(a0)
		clr.l	(a1)
		lea.l	640(a0),a0
		lea.l	640(a1),a1
		dbra	d7,.colclr
		rts




; ------------------------------------------------------
; EFX VBL
; ------------------------------------------------------

whip_vbl:	add.l	#24,sin
		and.l	#$1fff,sin
		sub.l	#512,texture_pos
		and.l	#$1ffff,texture_pos
		tst.w	deepmul
		beq.s	.next
		cmp.w	#7,deepmul
		blt.s	.deepclr
		sub.w	#8,deepmul
		bra.s	.next
.deepclr:	clr.w	deepmul
.next:		tst.w	mulsval
		beq.s	.ok
		cmp.w	#3,mulsval
		blt.s	.mulsclr
		subq.w	#4,mulsval
		bra.s	.ok
.mulsclr:	clr.w	mulsval
.ok:		rts






; ------------------------------------------------------
; EFX INIT
; ------------------------------------------------------

whip_init:	tst.l	layermode
		beq.w	.singleinit
		lea.l	rawpal+20+512,a0
		lea.l	palette+1024*63,a1
		move.w	#256-1,d7
.loop:		move.w	(a0),(a1)+
		move.w	(a0)+,(a1)+
		dbra	d7,.loop
		lea.l	palette,a0
		lea.l	palette+1024*63,a1
		bsr.w	make_palette
		lea.l	rawpal+20+512*2,a0
		lea.l	palette+1024*127,a1
		move.w	#256-1,d7
.loop2:		move.w	(a0),(a1)+
		move.w	(a0)+,(a1)+
		dbra	d7,.loop2
		lea.l	palette+1024*63,a0
		lea.l	palette+1024*127,a1
		bsr.w	make_palette
		lea.l	palette+1024*128,a0
		moveq.l	#-1,d0	
		move.w	#1024*128/4-1,d7
.whiteloop:	move.l	d0,(a0)+
		dbra	d7,.whiteloop
		lea.l	rawtexture+788,a0
		lea.l	texture,a1
		lea.l	texture+512,a2
		clr.l	d0
		move.w	#128-1,d7
.txtloop:	move.w	#128-1,d6
.txtloop2:	move.b	(a0)+,d0
		move.w	d0,(a1)+
		move.w	d0,-(a2)
		dbra	d6,.txtloop2
		lea.l	256(a1),a1
		lea.l	512+256(a2),a2
		dbra	d7,.txtloop
		lea.l	texture,a0
		lea.l	texture+512*255,a1
		move.w	#128-1,d7
.mirror:	move.w	#256/2-1,d6
.mirror2:	move.l	(a0)+,(a1)+
		dbra	d6,.mirror2
		lea.l	-1024(a1),a1
		dbra	d7,.mirror
		lea.l	texture,a0
		lea.l	texture+256*256*2,a1
		move.w	#256*256-1,d7
.gfxcopy:	clr.l	d0
		move.w	(a0),d0
		lsl.w	#8,d0
		lsl.w	#1,d0
		move.w	d0,(a0)+
		move.w	d0,(a1)+
		dbra	d7,.gfxcopy
		lea.l	rawlogo+788,a0
		lea.l	logo,a1
		move.w	#160*100-1,d7
.logoreduce:	clr.l	d0
		move.b	(a0)+,d0
		lsl.w	#8,d0
		move.w	d0,(a1)+
		dbra	d7,.logoreduce
		lea.l	rawring+788,a0
		lea.l	ringtexture,a1
		clr.l	d0
		move.w	#160*100-1,d7
.ring:		move.b	(a0)+,d0
		move.w	d0,(a1)+
		dbra	d7,.ring
		rts

.singleinit:	lea.l	rawring2+20,a0
		lea.l	ringtexture2,a1
		clr.l	d0
		move.w	#160*100-1,d7
.ring2:		move.w	(a0)+,d0
		move.w	d0,(a1)+
		move.w	d0,(a1)+
		dbra	d7,.ring2
		rts



; ------------------------------------------------------
; EFX COLOURS
; ------------------------------------------------------

make_palette:
		moveq.l	#0,d2
		moveq.l	#0,d3
		move.w	#numb_cols-1,d7
.colour:	move.l	a0,a2
		move.l	a1,a3
		addq.l	#4,a0
		addq.l	#4,a1
		swap	d7
		move.w	#64-2,d7
.step:		move.w	(a2),d0
		lea.l	numb_cols*4(a2),a2
		move.w	(a3),d1
.red:		move.w	d0,d2
		and.w	#%1111100000000000,d2
		rol.w	#5,d2
		move.w	d1,d3
		and.w	#%1111100000000000,d3
		rol.w	#5,d3
		tst.w	.var
		beq.s	.redok
		cmp.b	d2,d3
		beq.s	.redok
		bge.s	.redup
		subq.b	#1,d2
		bra.s	.redok
.redup:		addq.b	#1,d2
.redok:		ror.w	#5,d2
		move.w	d2,d4
.blue:		move.w	d0,d2
		and.w	#%0000000000011111,d2
		move.w	d1,d3
		and.w	#%0000000000011111,d3
		tst.w	.var
		beq.s	.blueok
		cmp.b	d2,d3
		beq.s	.blueok
		bge.s	.blueup
		subq.b	#1,d2
		bra.s	.blueok
.blueup:	addq.b	#1,d2
.blueok:	or.w	d2,d4
.green:		move.w	d0,d2
		and.w	#%0000011111100000,d2
		lsr.w	#5,d2
		move.w	d1,d3
		and.w	#%0000011111100000,d3
		lsr.w	#5,d3
		cmp.b	d2,d3
		beq.s	.greenok
		bge.s	.greenup
		subq.b	#1,d2
		bra.s	.greenok
.greenup:	addq.b	#1,d2
.greenok:	lsl.w	#5,d2
		or.w	d2,d4
		move.w	d4,(a2)
		move.w	d4,2(a2)
		not.w	.var
		dbra	d7,.step
		swap	d7
		dbra	d7,.colour
		rts
.var:		ds.w	1



clear_screens:	move.l	scradr1,a0
		move.l	scradr2,a1
		move.l	scradr3,a2
		move.w	#320*100*2/64-1,d7
.loop:		rept	16
		clr.l	(a0)+
		clr.l	(a1)+
		clr.l	(a2)+
		endr
		dbra	d7,.loop
		rts


switch_screens:	move.l	scradr3,d0
		move.l	scradr2,scradr3
		move.l	scradr1,scradr2
		move.l	d0,scradr1
		movea.l	scradr2,a0
		jsr	set_scradr
		rts

		section	data

		even
startdata:



deepmul:	dc.w	basedeep
mulsval:	dc.w	baseriple

sinus:		incbin	'sinus.dat
		even

ringlist:	incbin	'circles4.dat'
		even

spiral:		incbin	'sprial4.dat'
		even

rawring:	incbin	'back.apx'
		even

rawring2:	incbin	'back16b.apx'
		even

rawlogo:	incbin	'logo.apx'  
		even

rawtexture:	incbin	'texture.apx'
		even

light:		incbin	'sun.dat'
		even

rawpal:		incbin	'realpal.apx'
		even

scradr1:	dc.l	scr1+256
scradr2:	dc.l	scr2+256
scradr3:	dc.l	scr3+256



		section	bss

		even

brightnessvol:	ds.l	1
brightnessadd:	ds.l	1
deepshift:	ds.w	1
rippleadd:	ds.l	1
texture_pos:	ds.l	1
sin:		ds.l	1
sinpos:		ds.l	1
sinpos2:	ds.l	1

ringtexture:	ds.w	160*100
ringtexture2:	ds.l	160*100
texture:	ds.w	256*256*2
logo:		ds.w	160*100
palette:	ds.b	1024*256
scr1:		ds.w	320*100+256
scr2:		ds.w	320*100+256
scr3:		ds.w	320*100+256

		end
