;
; VLM EXAMPLE MODULE                                             NO/Escape'98
;

		section	text

*** VLM STRUCTURE **************************************************************

		dc.b	"VLM2"		;vlm module type
		dc.l	infotext	;pointer to infotext
		dc.l	settings	;pointer to settings-structure
		dc.l	init		;pointer to init routine
		dc.l	deinit		;pointer to deinit routine
		dc.l	main		;pointer to mainloop routine

;SERVICE ROUTINES PROVIDED BY THE CALLING PROGRAM

set_vblrout:
;a0: new vbl subroutine
		movea.l service_struct,a1
		movea.l (a1),a1
		jsr     (a1)
		rts

wait_vbl:	movea.l	service_struct,a1
		movea.l	4(a1),a1
		jsr	(a1)
		rts

set_scradr:
;a0: new screen adress
		movea.l	service_struct,a1
		movea.l	8(a1),a1
		jsr	(a1)
		rts

set_resolution:
;d0: number of the wanted resolution
		movea.l	service_struct,a1
		movea.l	12(a1),a1
		jsr	(a1)
		rts

get_left_spec:	movea.l	service_struct,a1
		movea.l	16(a1),a1
		jsr	(a1)		;returns in a0 the adress of left spec
                rts

get_right_spec:	movea.l	service_struct,a1
		movea.l	20(a1),a1
		jsr	(a1)            ;returns in a0 the adress of right spec
		rts

get_left_volume:movea.l	service_struct,a1
		movea.l 24(A1),A1
		jsr	(A1)		;returns in d0 the left volume value
		rts

get_right_volume:
		movea.l service_struct,a1
		movea.l 28(a1),a1
		jsr	(a1)		;returns in d0 the right volume value
		rts

get_left_osci:	movea.l service_struct,a1
		movea.l	32(A1),a1
		jsr	(a1)		;returns in a0 the adress of osci data
		rts

get_right_osci:	movea.l	service_struct,a1
		movea.l	36(a1),a1
		jsr	(a1)		;returns in a0 the adress of osci data
		rts

service_struct:	dc.l	0		;must be set in 'init'

********************************************************************************
infotext:       
		dc.b	'rgbsplitter',0
		dc.b	' author: evil ',0
		dc.b	'version: 1.1',0
		dc.b	'   date: june 15, 1999',0
		dc.b	0
		even

settings:       dc.l	7

		dc.l	stepratename
		dc.l	2
steprate:	dc.l	0
		dc.l	stepratestruct

		dc.l	redbrightname
		dc.l	3
redbrightness:	dc.l	384
		dc.l	redbrightstruct

		dc.l	greenbrightname
		dc.l	3
greenbrightness:dc.l	384
		dc.l	greenbrightstruct

		dc.l	bluebrightname
		dc.l	3
bluebrightness:	dc.l	384
		dc.l	bluebrightstruct

		dc.l	sinxname
		dc.l	3
sinxadd:	dc.l	3
		dc.l	sinxstruct

		dc.l	sinyname
		dc.l	3
sinyadd:	dc.l	4
		dc.l	sinystruct

		dc.l	timeslicename
		dc.l	3
timeslice:	dc.l	4
		dc.l	timeslicestruct

redbrightstruct:dc.l	0,1024
greenbrightstruct:dc.l	0,1024
bluebrightstruct:dc.l	0,1024
timeslicestruct:dc.l	1,20
sinxstruct:	dc.l	0,10
sinystruct:	dc.l	0,10


stepratestruct:	dc.l	3
		dc.b	'NORMAL',0
		dc.b	'STRONG',0
		dc.b	'HEFTIG!',0
		even
redbrightname:	dc.b	'RED BRIGHTNESS(LEFT VOL)',0
		even
greenbrightname:dc.b	'GREEN BRIGHTNESS(MAIN VOL)',0
		even
bluebrightname:	dc.b	'BLUE BRIGHTNESS(RIGHT VOL)',0
		even
timeslicename:	dc.b	'TIMESLICE:',0
		even
sinxname:	dc.b	'SINUS-X SPEED:',0
		even
sinyname:	dc.b	'SINUS-Y SPEED:',0
		even
stepratename:	dc.b	'STEPRATE (SENSITIVITY):',0
		even




init:           
;a0: service structure
		move.l	a0,service_struct

		bsr.w	split_init
		bsr.w	clear_screens

		movea.l	scradr2,a0	;set new screen adress
		bsr.w	set_scradr

		move.l	#2,d0		;set resolution to 320x100
		bsr.w	set_resolution
                rts
deinit:		rts


clear_screens:
		move.l	scradr1,a0
		move.l	scradr2,a1
		move.l	scradr3,a2
		move.w	#320*100*2/64-1,d7
.loop:		rept	16
		clr.l	(a0)+
		clr.l	(a1)+
		clr.l	(a2)+
		endr
		dbra	d7,.loop
		rts


main:		jsr	wait_vbl
		jsr	switch_screens

		bsr.w	split_main

		rts			;end of the mainroutine



split_vbl:
		move.l	sinxadd,d0
		lsl.l	#2,d0

		move.l	sinyadd,d1
		lsl.l	#2,d1

		add.l	d0,xsinred
		and.l	#$1fff,xsinred
		add.l	d1,ysinred
		and.l	#$1fff,ysinred

		add.l	d0,xsingreen
		and.l	#$1fff,xsingreen
		add.l	d1,ysingreen
		and.l	#$1fff,ysingreen

		add.l	d0,xsinblue
		and.l	#$1fff,xsinblue
		add.l	d1,ysinblue
		and.l	#$1fff,ysinblue


		tst.l	countdown
		beq.s	.no
		subq.l	#1,countdown
.no:
		cmp.l	#8,leftvol
		blt.s	.noleft
		subq.l	#8,leftvol
.noleft:	cmp.l	#8,rightvol
		blt.s	.noright
		subq.l	#8,rightvol
.noright:	cmp.l	#8,mainvol
		blt.s	.nomain
		subq.l	#8,mainvol
.nomain:


		rts


split_main:

		lea.l	sinus,a0

		move.l	xsinred,d0
		move.l	(a0,d0.w),d1
		muls.w	#80,d1
		asr.l	#8,d1
		asr.l	#7,d1
		move.l	d1,xposred

                move.l	ysinred,d0
                move.l	(a0,d0.w),d1
                muls.w	#64,d1
                asr.l	#8,d1
                asr.l	#7,d1
		asl.l	#8,d1
		move.l	d1,yposred

                move.l	xsingreen,d0
	        move.l	(a0,d0.w),d1
                muls.w	#144,d1
                asr.l	#8,d1
                asr.l	#7,d1
		move.l	d1,xposgreen

     		move.l	ysingreen,d0
                move.l	(a0,d0.w),d1
                muls.w	#80,d1
                asr.l	#8,d1
                asr.l	#7,d1
		asl.l	#8,d1
		move.l	d1,yposgreen

                move.l	xsinblue,d0
	        move.l	(a0,d0.w),d1
                muls.w	#48,d1
                asr.l	#8,d1
                asr.l	#7,d1
		move.l	d1,xposblue

                move.l	ysinblue,d0
                move.l	(a0,d0.w),d1
                muls.w	#32,d1
                asr.l	#8,d1
                asr.l	#7,d1
		asl.l	#8,d1
		move.l	d1,yposblue


		bsr.w	get_left_volume
		move.l	d0,d1
		bsr.w	get_right_volume
		move.l	d0,d2
		add.l	d1,d0
		lsr.l	#1,d0


		tst.l	countdown
		bne.w	.stepdone
		move.l	timeslice,countdown

		cmp.l	#1,steprate
		beq.s	.step1
		cmp.l	#2,steprate
		beq.s	.step2

.step0:		lsr.l	#7,d0
		and.l	#%00000000000000000000000111111110,d0
		move.l	d0,mainvol
		lsr.l	#7,d1
		and.l	#%00000000000000000000000111111110,d1
		move.l	d1,leftvol
		lsr.l	#7,d2
		and.l	#%00000000000000000000000111111110,d2
		move.l	d2,rightvol
		bra.s	.stepdone
.step1:		lsr.l	#6,d0
		and.l	#%00000000000000000000001111111110,d0
		move.l	d0,mainvol
		lsr.l	#6,d1
		and.l	#%00000000000000000000001111111110,d1
		move.l	d1,leftvol
		lsr.l	#6,d2
		and.l	#%00000000000000000000001111111110,d2
		move.l	d2,rightvol
		bra.s	.stepdone
.step2:		lsr.l	#5,d0
		and.l	#%00000000000000000000011111111110,d0
		move.l	d0,mainvol
		lsr.l	#5,d1
		and.l	#%00000000000000000000011111111110,d1
		move.l	d1,leftvol
		lsr.l	#5,d2
		and.l	#%00000000000000000000011111111110,d2
		move.l	d2,rightvol

.stepdone:

		move.l	scradr1,a0
		lea.l	64(a0),a0

		lea.l	flare+788+256*78+64,a1
		move.l	a1,a2
		move.l	a1,a3
		add.l	xposred,a1
		add.l	yposred,a1
		add.l	xposgreen,a2
		add.l	yposgreen,a2
		add.l	xposblue,a3
		add.l	yposblue,a3

		lea.l	redpal,a4
		lea.l	greenpal,a5
		lea.l	bluepal,a6

		add.l	leftvol,a4
		add.l	mainvol,a5
		add.l	rightvol,a6

		move.l	redbrightness,d0
		bclr	#0,d0
		add.l	d0,a4

		move.l	greenbrightness,d0
		bclr	#0,d0
		add.l	d0,a5

		move.l	bluebrightness,d0
		bclr	#0,d0
		add.l	d0,a6

		clr.l	d0

		move.w	#100-1,d7
.loop:		move.w	#128/8-1,d6
.loop2:
		rept	8
		move.b	(a1)+,d0
		move.w	(a4,d0.w*2),d1
		move.b	(a2)+,d0
		add.w	(a5,d0.w*2),d1
		move.b	(a3)+,d0
		add.w	(a6,d0.w*2),d1
		move.w	d1,(a0)+
		move.w	d1,(a0)+
		endr

		dbra	d6,.loop2
		lea.l	640-512(a0),a0
		lea.l	128(a1),a1
		lea.l	128(a2),a2
		lea.l	128(a3),a3
		dbra	d7,.loop

		rts



split_init:
		lea.l	split_vbl,a0
		bsr.w	set_vblrout

		lea.l	pal,a0
		lea.l	redpal+512,a1
		lea.l	greenpal+512,a2
		lea.l	bluepal+512,a3

		move.w	#256/2-1,d7
.loop		clr.l	-512(a1)
		clr.l	-512(a2)
		clr.l	-512(a3)
		move.l	512(a0),(a2)+
		move.l	1024(a0),(a3)+
		move.l	(a0)+,(a1)+
		dbra	d7,.loop

		lea.l	redpal+1024,a1
		lea.l	greenpal+1024,a2
		lea.l	bluepal+1024,a3

		move.l	-4(a1),d0
		move.l	-4(a2),d1
		move.l	-4(a3),d2

		move.w	#256*8/2-1,d7
.loop2:		move.l	d0,(a1)+
		move.l	d1,(a2)+
		move.l	d2,(a3)+
		dbra	d7,.loop2
		rts



xsinred:	ds.l	1
xsingreen:	ds.l	1
xsinblue:	ds.l	1
ysinred:	ds.l	1
ysingreen:	ds.l	1
ysinblue:	ds.l	1
xposred:	ds.l	1
xposgreen:	ds.l	1
xposblue:	ds.l	1
yposred:	ds.l	1
yposgreen:	ds.l	1
yposblue:	ds.l	1

leftvol:	ds.l	1
rightvol:	ds.l	1
mainvol:	ds.l	1

countdown:	ds.l	1


;ROUTINE SWITCHES VISIBLE SCREEN AND CYCLES THE SCREENADRESSES
switch_screens:
		move.l	scradr3,d0
		move.l	scradr2,scradr3
		move.l	scradr1,scradr2
		move.l	d0,scradr1
		movea.l	scradr2,a0
		jsr	set_scradr
		rts

		section	data

		even

flare:		incbin	'flare.apx'
		even
sinus:		incbin	'sinus.dat'
		even
pal:		incbin	'pal.16b'
		even


scradr1:	dc.l	scr1+256
scradr2:	dc.l	scr2+256
scradr3:	dc.l	scr3+256

		section	bss

redpal:		ds.w	256+256+(256*8)
greenpal:	ds.w	256+256+(256*8)
bluepal:	ds.w	256+256+(256*8)

scr1:		ds.w	320*100
scr2:		ds.w	320*100
scr3:		ds.w	320*100

		end