;*======================================================================*
;*                TITLE:                  BLIT.INC			*
;*                Function:               Blitter variables		*
;*                                                                      *
;*                Project #:              JAGUAR                        *
;*                Programmer:             Andrew J. Burgess		*
;*                                                                      *
;*			COPYRIGHT 1992 Atari Computer Corporation       *
;*          UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,         *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.			*
;*                                                                      *
;*======================================================================*

;*======================================================================*
;* ADDRESS REGISTERS	- see jaguar.s					*
;*======================================================================*

;*======================================================================*
;* BLITTER Command Register equates					*
;*======================================================================*

SRCEN		EQU	$00000001	; d00:     source data read (inner loop)
SRCENZ		EQU	$00000002	; d01:     source Z read (inner loop)
SRCENX		EQU	$00000004	; d02:     source data read (realign)
DSTEN		EQU	$00000008	; d03:     destination data read (inner loop)
DSTENZ		EQU	$00000010	; d04:     destination Z read (inner loop)
DSTWRZ		EQU	$00000020	; d05:     destination Z write (inner loop)
DISO_A1		EQU	$00000040	; d06:     A1 clipping enable
NOGO		EQU	$00000080	; d07:     diagnostic
UPDA1F		EQU	$00000100	; d08:     A1 update step fraction
UPDA1		EQU	$00000200	; d09:     A1 update step
UPDA2		EQU	$00000400	; d10:     A2 update step
DSTA2		EQU	$00000800	; d11:     reverse usage of A1 and A2
GOURD		EQU	$00001000	; d12:     enable Gouraud shading
GOURZ		EQU	$00002000	; d13:     polygon Z data updates
TOPBEN		EQU	$00004000	; d14:     intensity carry into byte
TOPNEN		EQU	$00008000	; d15:     intensity carry into nibble
PATDSEL		EQU	$00010000	; d16:     Select pattern data
ADDDSEL		EQU	$00020000	; d17:     diagnostic
					; d18-d20: Z comparator inhibit
ZMODELT		EQU	$00040000	; 	     source < destination
ZMODEEQ		EQU	$00080000	;	     source = destination
ZMODEGT		EQU	$00100000	;	     source > destination
					; d21-d24: Logic function control
LFUFUNC_NAN	EQU	$00200000	; 	     !source & !destination
LFUFUNC_NA	EQU	$00400000	; 	     !source &  destination
LFUFUNC_AN	EQU	$00800000	; 	      source & !destination
LFUFUNC_A	EQU	$01000000	; 	      source &  destination
CMPDST		EQU	$02000000	; d25:     pixel compare pattern & dest
BCOMPEN		EQU	$04000000	; d26:     bit compare write inhibit
DCOMPEN		EQU	$08000000	; d27:     data compare write inhibit
BKGWREN		EQU	$10000000	; d28:     data write back

;*======================================================================*
;* BLITTER Flags (A1 or A2) register equates
;*======================================================================*

; Pitch d00-d01:
;	distance between pixel phrases
PITCH1		EQU	$00000000	; 0 phrase gap
PITCH2		EQU	$00000001	; 1 phrase gap
PITCH4		EQU	$00000002	; 3 phrase gap
PITCH8		EQU	$00000003	; 7 phrase gap

; Pixel d03-d05
;	bit depth (2^n)
PIXEL1		EQU	$00000000	; n = 0	0 color
PIXEL2		EQU	$00000008	; n = 1	2 colors
PIXEL4		EQU	$00000010	; n = 2	4 colors 
PIXEL8		EQU	$00000018	; n = 3	8 colors
PIXEL16		EQU	$00000020	; n = 4	16 colors
PIXEL32		EQU	$00000028	; n = 5	32 colors

; Z offset d06-d08
;	offset from phrase of pixel data from its corresponding
;	Z data phrases
ZOFFS0		EQU	$00000000	; offset = 0	UNUSED
ZOFFS1		EQU	$00000040	; offset = 1
ZOFFS2		EQU	$00000080	; offset = 2
ZOFFS3		EQU	$000000C0	; offset = 3
ZOFFS4		EQU	$00000100	; offset = 4
ZOFFS5		EQU	$00000140	; offset = 5
ZOFFS6		EQU	$00000180	; offset = 6
ZOFFS7		EQU	$000001C0	; offset = 7	UNUSED

; Width d09-d14
;	width used for address generation
;	This is a 6-bit floating point value in pixels
;	4-bit unsigned exponent
;	2-bit mantissa with implied 3rd bit of 1
WIDTH2		EQU	$00000800	; 1.00 X 2^1  ( 4<<9)
WIDTH4 		EQU	$00001000	; 1.00 X 2^2  ( 8<<9)
WIDTH6		EQU	$00001400	; 1.10 X 2^2  (10<<9)
WIDTH8		EQU	$00001800	; 1.00 x 2^3  (12<<9)
WIDTH10		EQU	$00001A00	; 1.01 X 2^3  (13<<9)
WIDTH12		EQU	$00001C00	; 1.10 X 2^3  (14<<9)
WIDTH14		EQU	$00001E00	; 1.11 X 2^3  (15<<9)
WIDTH16		EQU	$00002000	; 1.00 X 2^4  (16<<9)
WIDTH20		EQU	$00002200	; 1.01 X 2^4  (17<<9)
WIDTH24		EQU	$00002400	; 1.10 X 2^4  (18<<9)
WIDTH28		EQU	$00002600	; 1.11 X 2^4  (19<<9)
WIDTH32		EQU	$00002800	; 1.00 X 2^5  (20<<9)
WIDTH40		EQU	$00002A00	; 1.01 X 2^5  (21<<9)
WIDTH48		EQU	$00002C00	; 1.10 X 2^5  (22<<9)
WIDTH56		EQU	$00002E00	; 1.11 X 2^5  (23<<9)
WIDTH64		EQU	$00003000	; 1.00 X 2^6  (24<<9)
WIDTH80		EQU	$00003200	; 1.01 X 2^6  (25<<9)
WIDTH96		EQU	$00003400	; 1.10 X 2^6  (26<<9)
WIDTH112	EQU	$00003600	; 1.11 X 2^6  (27<<9)
WIDTH128	EQU	$00003800	; 1.00 X 2^7  (28<<9)
WIDTH160	EQU	$00003A00	; 1.01 X 2^7  (29<<9)
WIDTH192	EQU	$00003C00	; 1.10 X 2^7  (30<<9)
WIDTH224	EQU	$00003E00	; 1.11 X 2^7  (31<<9)
WIDTH256	EQU	$00004000	; 1.00 X 2^8  (32<<9)
WIDTH320	EQU	$00004200	; 1.01 X 2^8  (33<<9)
WIDTH384	EQU	$00004400	; 1.10 X 2^8  (34<<9)
WIDTH448	EQU	$00004600	; 1.11 X 2^8  (35<<9)
WIDTH512	EQU	$00004800	; 1.00 X 2^9  (36<<9)
WIDTH640	EQU	$00004A00	; 1.01 X 2^9  (37<<9)
WIDTH768	EQU	$00004C00	; 1.10 X 2^9  (38<<9)
WIDTH896	EQU	$00004E00	; 1.11 X 2^9  (39<<9)
WIDTH1024	EQU	$00005000	; 1.00 X 2^10 (40<<9)
WIDTH1280	EQU	$00005200	; 1.01 X 2^10 (41<<9)
WIDTH1536	EQU	$00005400	; 1.10 X 2^10 (42<<9)
WIDTH1792	EQU	$00005600	; 1.11 X 2^10 (43<<9)
WIDTH2048	EQU	$00005800	; 1.00 X 2^11 (44<<9)
WIDTH2560	EQU	$00005A00	; 1.01 X 2^11 (45<<9)
WIDTH3072	EQU	$00005C00	; 1.10 X 2^11 (46<<9)
WIDTH3584	EQU	$00005E00	; 1.11 X 2^11 (47<<9)

; X add control d16-d17
;	controls the update of the X pointer on each pass
;	round the inner loop
XADDPHR		EQU	$00000000	; 00 - add phrase width and truncate
XADDPIX		EQU	$00010000	; 01 - add pixel size (add 1)	
XADD0		EQU	$00020000	; 10 - add zero
XADDINC		EQU	$00030000	; 11 - add the increment

; Y add control	d18
;	controls the update of the Y pointer within the inner loop.
;	it is overridden by the X add control if they are in add increment
YADD0		EQU	$00000000	; 00 - add zero
YADD1		EQU	$00040000	; 01 - add 1

; X sign d19
;	add or subtract pixel size if X add control = 01 (XADDPIX)
XSIGNADD	EQU	$00000000	; 0 - add pixel size
XSIGNSUB	EQU	$00080000	; 1 - subtract pixel size

; X sign d20
;	add or subtract pixel size if X add control = 01 (YADD1)
YSIGNADD	EQU	$00000000	; 0 - add 1
YSIGNSUB	EQU	$00100000	; 1 - sub 1

;*======================================================================*
;*	GLOBAL VARIABLES						*
;*======================================================================*
