;
;	Defiitions file for the GPU in Jaguar
;
GPUFLAGS		equ	$2100+Base		; GPU Flags Register 			Read/Write
MTXCTRL			equ	$2104+Base	; Matrix Control Register		Write Only
MTXADDR			equ	$2108+Base		; Matrix Address Register		Write Only
DATAORG			equ	$210c+Base		; Data Organisation Register	Write Only
GPU_PC			equ	$2110+Base		; GPU Program Counter			Read/Write
GPUCTRL			equ	$2114+Base		; GPU Control/Status Register	Read/Write
HIGHDATA		equ	$2118+Base		; High Data Register			Read/Write
REMAINDER		equ	$211C+Base		; Divide Unit Remainder			Read
DIVCTRL			equ	$211C+Base		; Divide Unit Control			Write
;
; Bits in the GPU FLags Register
;
GPU$M_ZERO_FLAG		equ	$0001		; ALU Zero Flag Mask
GPU$V_ZERO_FLAG		equ	0			; ALU Zero Flag Bit
GPU$M_CARRY_FLAG	equ	$0002		; ALU Carry Flag Mask
GPU$M_NEGA_FLAG		equ	$0004		; ALU Negative Flag
GPU$M_IMASK			equ	$0008		; ALU Interrupt Mask
GPU$M_INT_ENA0		equ	$0010		; Interrupt enable 0
GPU$M_INT_ENA1		equ	$0020		; Interrupt enable 1
GPU$M_INT_ENA2		equ	$0040		; Interrupt enable 2
GPU$M_INT_ENA3		equ	$0080		; Interrupt enable 3
GPU$M_INT_ENA4		equ	$0100		; Interrupt enable 4
GPU$M_INT_CLR0		equ	$0200		; Interrupt Clear 0
GPU$M_INT_CLR1		equ	$0400		; Interrupt Clear 1
GPU$M_INT_CLR2		equ	$0800		; Interrupt Clear 2
GPU$M_INT_CLR3		equ	$1000		; Interrupt Clear 3
GPU$M_INT_CLR4		equ	$2000		; Interrupt Clear 4
GPU$M_REGPAGE		equ	$4000		; Register Bank Select
GPU$M_DMAEN			equ	$8000		; Enable DMA Priority
GPU_RAM	equ	Base + $3000	; GPU Internal RAM
;
; Bits in the MTXCTRL Register
;

