.include	'jaguar.s'

	.globl	VideoIni

; Note that the horizontal timing numbers are for NTSC
; in units of 100 ps

vclk		equ	834
ivclk		equ	(vclk*3)/2

horiz_per	equ	317778
sync_per	equ	46050
eq_per		equ	23500
front_porch	equ	17450
line_blank	equ	109500
disp_width	equ	320+64	;this is in pixels
disp_height	equ	200+40	;this is in lines

; Horizontal computations

n_hp		equ	horiz_per/ivclk
n_hbb		equ	((horiz_per-sync_per-front_porch)/ivclk)+$400
n_hbe		equ	(line_blank-sync_per-front_porch)/ivclk
n_hs		equ	((horiz_per-sync_per)/ivclk)+$400
n_hvs		equ	(horiz_per-(2*sync_per))/ivclk
n_heq		equ	(horiz_per-eq_per)/ivclk
n_hde		equ	((disp_width/2)-1)+$400
n_hdb1		equ	((n_hp)-(disp_width/2))
n_hdb2		equ	n_hdb1

n_vmode		equ	$c1

; Vertical

n_vp		equ	523
n_vee		equ	6
n_vbe		equ	40
n_vdb		equ	n_vbe+26
n_vde		equ	n_vdb+(disp_height*2)
n_vbb		equ	n_vde+40
n_vs		equ	n_vp-10
n_veb		equ	n_vs-n_vee

VideoIni:
	move.w	#n_hp,HP
	move.w	#n_hbb,HBB
	move.w	#n_hbe,HBE
	move.w	#n_hs,HS
	move.w	#n_hvs,HVS
	move.w	#n_heq,HEQ
	move.w	#n_hde,HDE
	move.w	#n_hdb1,HDB1
	move.w	#n_hdb2,HDB2

	move.w	#n_vp,VP
	move.w	#n_vee,VEE
	move.w	#n_vbe,VBE
	move.w	#n_vdb,VDB
	move.w	#n_vde,VDE
	move.w	#n_vbb,VBB
	move.w	#n_veb,VEB
	move.w	#n_vs,VS

; Also lets set up some default colors

	move.w	#$0,BG
	move.l	#$ffffffff,BORD1

	rts

