;
; Program: tunnel.prg    - GPU Cyber Tunnel
;  Module: init.s    	- Program entry and initialization
;			  And joypad reader routine
; Revision History:



	.include		"jaguar.inc"
	.include		"tunnel.inc"
	.include		"scrtxt.inc"


; Globals
	.globl		_SetUpPart2
	.globl		_ParseInput
	.globl		_ReadJoypads

; Externals
	.extern	vsync

	.extern	swapflag

	.extern	LOOPCOUNT

	.extern	InitLister
	.extern	TVBI
	.extern	LoadAndGoGPU
	.extern	BMP_ADDR
	.extern	_VID_vdb	; Vertical display begin
	.extern	_VID_vde	; Vertical display end
	.extern	_VIDwidth	; Width of display (in pixel clocks)
	.extern	_VIDheight	; Height of display (in pixel clocks)

	.extern	_Xpos
	.extern	_Ypos


;;;;;;;;;;;;;;;;;;; Program Entry Point Follows...

	.text


_SetUpPart2:
	bsr.w	InitScrTxtPos			; Init Positions
	bsr.w	InitLister              ; Initialize Object Display List
	
	move.l	#TVBI,LEVEL0			; Install Auto-Vector 0 handler = vbi


	move.l	vsync,d1
dwaitvbl:
	move.l	vsync,d2
	cmp.l	d1,d2
	beq.b	dwaitvbl

	move.l	d0,OLP					; Value of D0 from InitLister

	move.l	#0,swapflag

	move.w  #(PWIDTH5|BGEN|CSYNC|CRY16|VIDEN),VMODE	; Configure Video ($6C1)

	bsr.w	LoadAndGoGPU
	rts								;return to c-main again


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: ReadJoypads
;	      Read both joypads and update state variables.
;
; Store a bitmask of the current state of the joysticks in joy1cur
; and joy2cur. The variables joy1edge and joy2edge stores a state
; bitmap of new key 'down' events (never 'up' events) since the last time
; ReadJoypads was called.
;
; The code below may be altered by removing two AND instructions so that
; joy1edge and joy2edge contain a bitmap of keys that have changed (not
; pressed). If desired, this data could be compared to joy1cur and joy2cur
; to determine the actual button state.

_ReadJoypads:
ReadJoypads:
		movem.l	d0-d2/a0,-(sp)

		lea	JOYSTICK,a0

		move.l	#$f0fffffc,d1		; d1 = Joypad data mask
		moveq.l	#-1,d2		 	; d2 = Cumulative joypad reading

		move.w	#$81fe,(a0)
		move.l	(a0),d0		 	; Read joypad, pause button, A button
		or.l	d1,d0			; Mask off unused bits
		ror.l	#4,d0
		and.l	d0,d2			; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
		move.w	#$81fd,(a0)
		move.l	(a0),d0			; Read *741 keys, B button
		or.l	d1,d0			; Mask off unused bits
		ror.l	#8,d0
		and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
		move.w	#$81fb,(a0)
		move.l	(a0),d0			; Read 2580 keys, C button
		or.l	d1,d0			; Mask off unused bits
		rol.l	#6,d0
		rol.l	#6,d0
		and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
		move.w	#$81f7,(a0)
		move.l	(a0),d0			; Read 369# keys, Option button
		or.l	d1,d0			; Mask off unused bits
		rol.l	#8,d0
		and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

		moveq.l	#-1,d1
		eor.l	d2,d1			; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

		;move.l	joy1cur,d0		; old joycur needed for determining the new joyedge
		;move.l	d1,joy1cur		; Current joypad reading stored into joycur
		;eor.l	d1,d0
		;and.l	d1,d0			; IF DESIRED (AS DOCUMENTED ABOVE)
						; REMOVE THIS AND
		;move.l	d0,joy1edge		;joypad, buttons, keys that were just pressed


		move.l	d1,joy1edge	;cur		; Current joypad reading stored into joycur

		movem.l	(sp)+,d0-d2/a0
		rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: ParseInput
;	      Use joystick inputs to update objects
;

_ParseInput:
ParseInput:
		movem.l	d0-d2/a0-a2,-(sp)

		;move.l	#XposDRAM,a1	;lea	curs1_x,a1
		;move.l	#YposDRAM,a2
		move.l	joy1edge,d0
ck_up:
		btst.l	#JOY_UP,d0
		beq.b	ck_down

			;move.l	(a2),d2
		add.l	#1,_Ypos		;Y -1
			;and.l	#128-1,d2
			;move.l	d2,(a2)
		nop
		bra.b	ck_left
ck_down:
		btst.l	#JOY_DOWN,d0
		beq.b	ck_left
		nop
			;move.l	(a2),d2
		sub.l	#1,_Ypos		; Y+1
			;and.l	#128-1,d2
			;move.l	d2,(a2)

ck_left:
		btst.l	#JOY_LEFT,d0
		beq.b	ck_right
			;move.w	(a2),d2
			;sub.w	#1,d2			;x-1
			;move.w	d2,(a2)
	add.l	#1,_Xpos

	
		bra	ck_next
ck_right:
		btst.l	#JOY_RIGHT,d0
		beq.b	ck_next
		;move.w	(a2),d2
		;add.w	#1,d2			;x+1
		;move.w	d2,(a2)
	sub.l	#1,_Xpos

		nop
;  Evaluate each fire button status and execute code

ck_next:
					;lea	fire2_data,a1
		move.l	joy1edge,d0	;cur,d0
ck_fire:
		btst.l	#FIRE_A,d0
		beq	ck_fireb
			;move.l	(a1),d2
		add.l	#2,_Xpos		;angle+1 (@moment anticlock)
			;and.l	#128-1,d2
			;move.l	d2,(a1)
		bra	fire_done
ck_fireb:
		btst.l	#FIRE_B,d0
		beq	fire_done
			;move.l	(a1),d2
		sub.l	#2,_Xpos		;a-1, clockwise
			;and.l	#128-1,d2
			;move.l	d2,(a1)


fire_done:
	movem.l	(sp)+,d0-d2/a0-a2
	rts

	.bss


joy1edge:		.ds.l		1
joy1cur:		.ds.l		1

	.phrase
		.end
