;
; Program: mars.prg
;  Module: list.s   - Object List Refresh and Initialization
;
;030615 remake of double framebuffer in phrase interleaved form.


	.include		"jaguar.inc"
	.include		"tunnel.inc"
	.include		"scrtxt.inc"

	.globl	InitLister
	.globl	TVBI
	.globl	vsync
	.globl	physicscr
	.globl	logicscr
	.globl	scrollbm
	.globl	cbm			;bitmap, centered
	.globl	BMP_ADDR	;Tunnel bitmap

	.extern	swapflag		;now in gpu ram
	.extern	_VID_vde
	.extern	_VID_vdb
	.extern	_VIDheight
	.extern	MODPLAYER
	.extern	_VIDtick
	.extern __timestamp


	.text

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; InitLister: Initialize Object List Processor List
;
;    Returns: Pre-word-swapped address of current object list in d0.l
;
;  Registers: d1.l/d0.l - Phrase being built
;             d2.l      - Address of STOP object in destination buffer
;             d3.l      - Calculation register
;             d4.l      - Width of image in phrases
;             d5.l      - Height of image in scanlines
;             a0.l      - Roving object list pointer
		
InitLister:
	movem.l d1-d5/a0,-(sp)          ; Save registers
			
	lea     bra1,a0			;adress of the first two branchobj
	
	move.l   #stopobj,d2      ; Address of STOP object

; Write first BRANCH object (branch if YPOS > a_vde )

	clr.l   d1
	move.l  #(BRANCHOBJ|O_BRLT),d0 ; $4000 = YPOS > VC

	jsr     format_link             ; Stuff in our LINK address
					
	move.w  _VID_vde,d3                ; for YPOS
	lsl.w   #3,d3                   ; Make it bits 13-3
	or.w    d3,d0

	move.l  d1,(a0)+                                
	move.l  d0,(a0)+                ; First OBJ is done.

; Write second branch object (branch if YPOS < a_vdb)   
; Note: LINK address is the same so preserve it
	lea     bra2,a0			;adress of the first two branchobj
	
	move.l   #stopobj,d2      ; Address of STOP object

	andi.l  #$FF000007,d0           ; Mask off CC and YPOS
	ori.l   #O_BRGT,d0              ; $8000 = YPOS < VC
	move.w  _VID_vdb,d3                ; for YPOS
	lsl.w   #3,d3                   ; Make it bits 13-3
	or.w    d3,d0

	move.l  d1,(a0)+                ; Second OBJ is done
	move.l  d0,(a0)+        



; Write a standard BITMAP object
	lea     bm,a0			;adress of the first two branchobj
	
	;move.l   #stopobj,d2      ; Address of STOP object
	move.l	a0,d2
	add.l	#16,d2
	clr.l   d1
	clr.l   d0                      ; Type = BITOBJ
			
	jsr     format_link

	move.l  #BMP_HEIGHT,d5          ; Height of image
	;move.w  d5,bmp_height           ; Store for later update

	lsl.l   #8,d5                   ; HEIGHT
	lsl.l   #6,d5
	or.l    d5,d0

	move.w  _VIDheight,d3               ; Center bitmap vertically
	sub.w   #BMP_HEIGHT,d3
	add.w   _VID_vdb,d3
	;move.w	d3,cbm
	move.w	#0,cbm
	add.w	#520,d3
	;andi.w  #$FFFE,d3               ; Must be even

	lsl.w   #3,d3
	or.w    d3,d0                   ; Stuff YPOS in low phrase

	move.l  #BMP_ADDR,d3
	andi.l  #$FFFFF0,d3
	lsl.l   #8,d3                   ; Shift bitmap_addr into position
	or.l    d3,d1
     

	move.l  d1,tbmp_highl            ; Store good bitmap phrase 1

				;set physicscr by default
	;---dbl buffer thing
	move.l	d1,physicscr
	move.l	physicscr,logicscr
	add.l	#8<<8,logicscr		;logic scr is phrase interleaved
	;---end

	move.l  d0,tbmp_lowl             ; for UpdateList=VBI

	move.l  d1,(a0)+
	move.l  d0,(a0)+		;write 1st Phrase of bitmap object

	move.l  #O_TRANS,d1
	move.l  #O_DEPTH16|O_1GAP,d0	;NOGAP,d0   ; Bit Depth = 16-bit, Contiguous data

	move.w	#0,d3		;raw set xpos=0

	or.w    d3,d0



	move.l  #BMP_PHRASES*2,d4 	;pitch: alternating phrase
	move.l  d4,d3                   ; Copy for below

	lsl.l   #8,d4                   ; DWIDTH bits 18-27
	lsl.l   #8,d4
	lsl.l   #2,d4
	or.l    d4,d0

	lsr.l	#1,d4		;BMP_PHRASES*2/2

	lsl.l   #8,d4                   ; IWIDTH Bits 28-31
	lsl.l   #2,d4			
	or.l    d4,d0

	;lsr.l	#1,d3		;BMP_PHRASES*2/2

	lsr.l   #4+1,d3                   ; IWIDTH Bits 37-32
	or.l    d3,d1

	move.l  d1,(a0)+                ; Write second PHRASE of BITOBJ
	move.l  d0,(a0)+

; Write a STOP object at end of list
	lea		stopobj,a0
	clr.l   d1
	move.l  #(STOPOBJ|O_STOPINTS),d0

	move.l  d1,(a0)+                
	move.l  d0,(a0)+
; fix the scroll text objects
	jsr		InitScrTxtOL			;Init Scroll text Objects
; Now return swapped list pointer in D0                      

	move.l  #tunnel_obj_list,d0  
	swap    d0

	movem.l (sp)+,d1-d5/a0
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: format_link
;
;    Inputs: d1.l/d0.l is a 64-bit phrase
;            d2.l contains the LINK address to put into bits 42-24 of phrase
;
;   Returns: Updated phrase in d1.l/d0.l

format_link:
	movem.l d2-d3,-(sp)

	andi.l  #$3FFFF8,d2             ; Ensure alignment/valid address
	move.l  d2,d3                   ; Make a copy

	swap    d2
	clr.w   d2
	lsl.l   #5,d2
	or.l    d2,d0

	lsr.l   #8,d3                   ; Put bits 21-11 in bits 42-32
	lsr.l   #3,d3
	or.l    d3,d1

	movem.l (sp)+,d2-d3             ; Restore regs
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; VBI: Update bitmap object destroyed by the object processor.
;

TVBI:
	movem.l  d0-d2/a0,-(sp)

	move.l  #bm,a0
	move.w	cbm,d2
	cmp.w	#520,d2
	beq.b	.cont
	addq.w	#2,d2
	move.w	d2,cbm
.cont:
	lsl.w	#3,d2
	move.l	swapflag,d0	;gpu sets swapflag when a logic scr is done
	cmp.l	#0,d0
	beq.s	.displayphys
	move.l	physicscr,d1		;when so: make OP display drawn img
	move.l	logicscr,physicscr
	move.l	d1,logicscr

	move.l	#0,swapflag	;and reset swapflag, gpu waits for this

	move.l	physicscr,tbmp_highl

.displayphys:

	add.l	#1,vsync

	moveq.l	#0,d0					;This is from Ataris sync, makes
	move.w	_VIDtick,d0				;VIDsync function work
	add.l	d0,__timestamp


; HEIGHT and DATA fields must be updated for a BITMAP object


	move.l	tbmp_highl,(a0)+
	move.l	tbmp_lowl,d0
	move.l	d0,d1
	and.l	#$FFFFC007,d0			;mask away old y pos
	and.l	#$0003FF8,d1			;just the y pos left

	sub.w	d2,d1
	and.w	#$fff8,d1
	add.w	d1,d0
	
	move.l	d0,(a0)
	;move.l	tbmp_lowl,(a0)
	jsr		UpdateScrollOL			;Update objects destroyed by OP
	;lea		obm,a0
	;move.l	bmp_highl,(a0)+
	;move.l	bmp_lowl,(a0)
	jsr		MoveScrTxtPos
	bsr	MODPLAYER+$8
	move.w  #$101,INT1
	move.w  #0,INT2

	movem.l  (sp)+,d0-d2/a0
	rte

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Storage space for our object lists

		.bss
		.dphrase                        
tunnel_obj_list:			;must be dphrase aligned!
bra1:			.ds.l	2
bra2:			.ds.l	2
;obm:			.ds.l	2*2
bm:				.ds.l	2*2
scrollbm:		.ds.l	2*2*NRBITMAPS
stopobj:		.ds.l	2

tbmp_highl:		.ds.l	1
tbmp_lowl:		.ds.l	1
cbm	:			.ds.w	1
;bmp_height:	.ds.w	1


	.long			;OBS!!!!! the .w above!!
physicscr:	.ds.l	1
logicscr:	.ds.l	1
vsync:		.ds.l	1

	.qphrase
BMP_ADDR:	.ds.w	3*BMP_WIDTH*BMP_HEIGHT*2
	.qphrase
	
		.end
