	.include	"jaguar.inc"
	.include	"scrtxt.inc"
	
	.extern		scrollbm
	.extern		_font8x8
	.extern		a_vdb
	
;To Init scrolltext, jsr InitScrollTxt
;in VBL, jsr UpdateScrollList
;UpdateScrollOL - Update objects destroyed by OP
;InitScrTxtOL - Init Scroll text Objects
;InitScrTxtPos - Init Positions
;moveScrTxtPos - move scroll text

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; InitScrollTxt: Initialize Object List Processor List
;
InitScrTxtOL:

	jsr	ClrPicture

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Write BITMAP objects
; first we must init some pointers and loop variables

	move.w	#NRBITMAPS-1,bmcounter	; nr of bitmap objects 4scroller
	move.w	bmcounter,d0
	
	move.l	#scrollbm,a0			; pointer to bitmap object in OL
	move.l	#scr_highl,a1			; pointer to save space obj high long
	move.l	#scr_lowl,a2			; pointer to save space obj low long
	move.w	#16,d3					; x pos for first obj.
	move.w	#100,d4					; y pos for first obj and the rest
	;add.w	a_vdb,d4
	lea		x_pos,a4				; save space for obj x pos
	move.l	a0,d2
	add.l	#16,d2					;next object, link addr
	move.l	#images,d6
									; Not optimized att all. The following
									; can be MUCH optimezed, but since
bmloop:								; it's not critical, I don't care! ;-)
	move.w	d0,bmcounter			; check if all scrolltext obj updated

	move.l	#O_TRANS,bmp_bit
	move.l	#SCR_PHRASES,bmp_phr

	move.l	#BITOBJ,d0				; type of object

	move.l	#SCR_HEIGHT,d5
	move.l	#O_DEPTH16|O_NOGAP,d7
	
	movem.l	d0-d7/a0-a6,-(sp)		; don't need to save all
	jsr		build_obj				; Build a bitmap object at bm
	movem.l	(sp)+,d0-d7/a0-a6
	
	move.w	bmcounter,d0			; count nr bitmap objects left (4scroller)
	add.l	#16,a0					; Next Object adress
	add.l	#4,a1					; Save pos for object high long
	add.l	#4,a2					; save pos for object low long
	move.w	d3,(a4)+				; store x pos for object
	add.w	#SCR_WIDTH+4,d3			; x pos, next char spaced with 4 pixels
	add.l	#16,d2					; pointer to next obj
	add.l	#SCR_WIDTH*SCR_HEIGHT*2,d6	;next char bitmap position
	dbra	d0,bmloop
	
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; UpdateList: Update list fields destroyed by the object processor.
;
UpdateScrollOL:
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 1. Bitmap
;
	move.l	#NRBITMAPS-1,d3
	move.l	#scrollbm,a0
	lea		scr_highl,a1
	lea		scr_lowl,a2
	lea		x_pos,a3
	
ubitmapdata:

	move.l	(a1)+,d1			; Grab low longword of phrase
	move.l	d1,(a0)				; Store high longword of phrase 1

	move.l	(a2)+,d0			; Grab low longword of phrase
	move.l	d0,4(a0)			; Store low longword of phrase 1

	move.l	12(a0),d0			; Low Phrase 2 -> d0.l
	andi.l	#$FFFFF000,d0		; Extract XPOS
	move.w	(a3)+,d1			; Grab new XPOS
	or.w	d1,d0				; store XPOS
	move.l	d0,12(a0)			; d0.l -> Low Phrase 2

	add.l	#16,a0
	dbra	d3,ubitmapdata
	tst.w	updatebitmap
	beq.b	no_update

nextchar:
	move.l	curchar,a0
	clr.l	d0
		
	move.b	(a0)+,d0
	cmp.b	#$ff,(a0)
	bne.s	.notatend
	move.l	#scrtxtdta,a0
	
.notatend:
	move.l	a0,curchar

	move.l	imagepos,a0
	move.w	col,d1
	bsr		build_char
	add.w	#$200,col			;color cycling
	clr.w	updatebitmap
	cmp.l	#lastimage,a0
	blt.b	.nowrap
	move.l	#images,a0
.nowrap:
	move.l	a0,imagepos
no_update:

	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ClrPicture:
	movem.l d0-d2/a0-a1, -(sp)

	lea.l	images, a1
	move.w	#NRBITMAPS-1,d1

.outerloop:
	move.w	#(SCR_PHRASES*2*SCR_HEIGHT-1), d0

.loop1:
	clr.l	(a1)+
	dbra	d0, .loop1
	dbra	d1,.outerloop

allok:
	movem.l	(sp)+, d0-d2/a0-a1
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
build_obj:
	movem.l	d0-d7/a0-a3,-(sp)

;	a0=Adress of object to process
;	a1=Adress of high long of (s)bmpobj phrase 1 for later update
;	a2=Adress of low long of (s)bmpobj phrase 1 for later update
;	a3=Adress of low long of scaleobj phrase 3 for later update
;	d0=Object type (0-4) and low long of phrase 1
;	d1=High long of phrase 1
;	d2=Link adress to next object
;	d3=X-Position of bitmap (.w)
;	d4=Y-Position of bitmap (.w)
;	d5=Bitmap height in pixel
;	d6=Adress of bitmap
;	d7=Bitmap depth, pitch (O_TRANS, O_NOGAP)

	move.l	d0,obj_typ

	cmp.l	#0,d0			; Bitmap object
	beq.w	.build_bitmap
	cmp.l	#1,d0			; Scaled bitmap  object (begins like bitmap)
	beq.w	.build_bitmap
	cmp.l	#2,d0			; GPU object
	beq.w	.build_gpu
	cmp.l	#3,d0			; Branch object
	beq.w	.build_branch
	cmp.l	#4,d0			; Stop object
	beq.w	.build_stop

	jmp	.all_done

.build_bitmap:
	clr.l   d1

	jsr	format_link		; Stuff in LINK address in d0 and d1

	and.w	#$FFFE,d4		; Y-Position must be even

	lsl.w	#3,d4
	or.w	d4,d0

	lsl.l	#8,d5			; Bitmap height
	lsl.l	#6,d5
	or.l	d5,d0

	lsl.l	#8,d6			; Adress of picture
	or.l	d6,d1

	move.l	d1,(a0)+
	move.l	d1,(a1)
	move.l	d0,(a0)+
	move.l	d0,(a2)

	clr.l	d0			; Now Phrase

	or.w	d3,d0			; X-Position
	or.l	d7,d0			; Depth...

	move.l	bmp_bit,d1		; Goon with phrase 2

	move.l	bmp_phr,d4		; DWIDTH
	move.l	d4,d3

	lsl.l	#8,d4
	lsl.l	#8,d4
	lsl.l	#2,d4
	or.l	d4,d0

	lsl.l	#8,d4			; IWIDTH Bits 28-31
	lsl.l	#2,d4
	or.l	d4,d0

	lsr.l	#4,d3			; IWIDTH Bits 37-32
	or.l	d3,d1

	move.l  d1,(a0)+
	move.l  d0,(a0)+

	move.l	obj_typ,d0

	cmp.l	#1,d0			; Scaled bitmap  object
	beq.w	.build_scale

	jmp	.all_done

.build_scale:
	illegal	;by mr spock, just to trace
	clr.l	(a0)+			; High long
	clr.l	d0

	;byspockmove.w	scl_vsc,d0		; Vscale
	lsl.w	#8,d0
	;byspockor.w	scl_hsc,d0		; Hscale

	move.l	d0,(a0)			; Low long
	move.l	d0,(a3)

	jmp	.all_done

.build_gpu:
	clr.l	d1

	move.l	d1,(a0)+
	move.l	d0,(a0)

	jmp	.all_done

.build_branch:
	clr.l	d1

	or.l	bra_con,d0		; Branch condition

	jsr	format_link			; Stuff in LINK address in d0 and d1

	move.w	bra_ypo,d3		; YPOS of branch object
	lsl.w	#3,d3			; Make it bits 13-3
	or.w	d3,d0

	move.l	d1,(a0)+
	move.l	d0,(a0)

	jmp	.all_done

.build_stop:
	clr.l	d1

	or.l	#O_STOPINTS,d0

	move.l	d1,(a0)+
	move.l	d0,(a0)

.all_done:
	movem.l	(sp)+,d0-d7/a0-a3
	rts


format_link:
	movem.l	d2-d3,-(sp)

	andi.l	#$3FFFF8,d2	; Ensure alignment/valid address
	move.l	d2,d3

	swap	d2			; Put bits 10-3 in bits 31-24
	clr.w	d2
	lsl.l	#5,d2
	or.l	d2,d0

	lsr.l	#8,d3		; Put bits 21-11 in bits 42-32
	lsr.l	#3,d3
	or.l	d3,d1

	movem.l	(sp)+,d2-d3
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; todo
;; must take parameters, two(?)
;; d0 - ascii value
;; d1 - fill value
;; a0 - were to save "image" of char

build_char:
	movem.l	d2-d5/a1,-(sp)
	
	lea		_font8x8,a1		;must be included by makefile
	add.l	d0,a1
	moveq.l	#1,d5

outer_loop:
	moveq.l	#3,d3

row_loop:
	moveq.l	#7,d2
	move.b	(a1),d4
	
col_loop:
	btst	d2,d4
	bne.b	fillpattern
	move.w	#0,(a0)+		;pixel 1
	move.w	#0,(a0)+		;pixel 2
	dbra	d2,col_loop
	add.l	#256,a1
	sub.b	#$1a,d1
	dbra	d3,row_loop
	;move.b	#$10,d1
	dbra	d5,outer_loop
	bra.b	char_copy_finish
fillpattern:
	move.w	d1,(a0)+	;pixel 1
	move.w	d1,(a0)+	;pixel 2
	dbra	d2,col_loop
	add.l	#256,a1
	sub.b	#$1a,d1
	dbra	d3,row_loop
	;move.b	#$80,d1
	dbra	d5,outer_loop
char_copy_finish:	
	movem.l	(sp)+,d2-d5/a1
	rts
	
	
	



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Move 1. bitmap object - move x_pos for the objekts
MoveScrTxtPos:
	lea		x_pos,a0				; Adress of x_pos
	move.w	#NRBITMAPS-1,d0			; nr of objekts
	move.w	#SCROLLSPEED,d2
	
uxvalueloop:
	move.w	(a0),d1					;get an x_pos
	sub.w	d2,d1					;move 
	
	cmp.w	#0,d1					; x_pos = x_min (0)?
	bhi.b	savex1					;if it's 

	move.w	x_max,d1				;reset xpos to right screen
	move.w	#$ff,updatebitmap		;flag to signal a new char image needed
									;so much easier &faster to do it all in
									;GPU,  but I don't have time now =(
savex1:
	move.w	d1,(a0)+				; Store x_pos back
	dbra	d0,uxvalueloop

	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: InitMoveVars
;            Initialize variables for our moving bitmap
;            Note: x_pos and y_pos are initialized in mov_list.s
;
; Registers: None
;

InitScrTxtPos:
	movem.l  d0-d1/a0,-(sp)

	clr.l	d0
	;move.w  width,d0		; Max X = Scr Width - Bmap Width
	move.w  #320+40,x_max

	move.l	#NRBITMAPS-1,d0
	lea		x_pos,a0
	move.w	#100,d1
initbitmapxval:
	move.w	d1,(a0)+
	add.w	#64,d1
	dbra	d0,initbitmapxval
	
	move.w	#100, y_pos
	move.w	#0,updatebitmap		;flag to update bitmapdata
	move.w	#$ff,col
	move.l	#images,imagepos
	move.l	#scrtxtdta,curchar
	

	movem.l  (sp)+,d0-d1/a0
	rts

	.data
	.even


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Some variables
;
	
scrtxtdta:
	dc.b "Weeeeeeeeeeee!! It works! (Move Joypad!) This is Mr Spock of TNG, the lapplander happy hacking association =) "
	dc.b "First I want to thank Nick(16/32 system) for selling me the jagdev environment. If you had asked me 6 month ago "
	dc.b "if I would write a intro to the Atari Jaguar, the answer would have been no. "

	dc.b "It's not that I didn't want to, it was more because I'm doing my Thesis work and is quite busy. However, I "
	dc.b "stumbled across info about the Falun Coding Convention (FuCK) and thought it would be nice going there. I can "
	
	dc.b "only say.. it was! Thanks DHS! I started working on how to code the Atari Jaguar at the party and looked into "
	dc.b "Atari's 3D libraries, and hence the intro. The nice tunnel was done by Sym of TNG. This simple scroller is "
	
	dc.b "very simple indeed. BTW. all source code for this demo is available and free, except for the tunnel code. The "
	dc.b "scroller was not in the original intro, but since there was trouble with the 3d libs and midi player that "
	
	dc.b "stopped working all of a sudden, I switched to Sinister's module player and wrote the simple scroller. "
	dc.b "I will now start developing some stuff to simplify jaguar programming, but as I'm currently in the "
	
	dc.b "finishing stages of the thesis work, I must concentrate on that in the first place. However, in the summer or "
	dc.b "autumn, I will release a game for the jaguar.. I will not say anything more than that right now and questions "
	
	dc.b "will not be answered :-) However, questions about C and Jaguar or coding in general will be answered. "
	dc.b "tng.spock@gmail.com is my mail address."
	
	dc.b "I've released my environment, or rather the environment from Atari for developing on the Jaguar and all code "
	dc.b "released that I gotten hold of is compiling on it. I'll also develop some C routines to simplify developing "
	
	dc.b "jaguar games. Enough bullshit, Greetings goes to Evil and Gizmo of DHS. I would also like to thank Copson of "
	dc.b "Unit 17. These are people that I have accually talked to in person. I must also thank TEX for the first real "
	
	dc.b "!WOW! feeling on the ST. TCB for making some off the best demos on the ST. I'll stop there. I'll do some more "
	dc.b "greetings in my next scroller. I've got some plans so stay tuned =). I must send some fucking greetings as "
	
	dc.b "well. Falcon pro center and Claes. I know, they have been out off business for quite some time now, but I "
	dc.b "promised my self that my first scroll text would have fucking greetings to them... Anyway TNG",191," rulez! "
	
	dc.b "We'll be back! Time to let Sym in on this scroller...."
	
	;Sym scroll text messege

	dc.b ".....Hello Atari computer scene, Symmetry at the keyboard.. most of you probably don't know who I am. I have "
	dc.b "unfortunately never had the budget (or time) to visit any of the Swedish hacks, but have always had at least "
	dc.b "one foot in the demo scene. Checking DHS homepage for updates every other day. Posting occasionally at the "
	dc.b "forum... Though I, some 4+years ago, decided to emigrate to the Jaguar scene... A scene which I have been "
	dc.b "virtually alone in since then, at least in Sweden.  .....Greetings goes to: EVERYONE in, and who ever was, in "
	dc.b "the Falcon demo scene! Your demos is a great inspiration for coding!.. Jaguar specific greetings: CTS/NLC, "
	dc.b "AtariOwl, Stone and everyone in the UGD Jaguar scene...last but not least SPOCK who finally decided to join "
	dc.b "this, last and final frontier of Atari computing ;) ..may it lead to many prosperous adventures.. ....enough "
	dc.b "talk... Time to warp!................                                   "

	;remove comment to see charset
	;dc.b 0,1,2,3,4,5,6,7,8,9
	;dc.b 10,11,12,13,14,15,16,17,18,19
	;dc.b 20,21,22,23,24,25,26,27,28,29
	;dc.b 30,31,32,33,34,35,36,37,38,39
	;dc.b 40,41,42,43,44,45,46,47,48,49
	;dc.b 50,51,52,53,54,55,56,57,58,59
	;dc.b 60,61,62,63,64,65,66,67,68,69
	;dc.b 70,71,72,73,74,75,76,77,78,79
	;dc.b 80,81,82,83,84,85,86,87,88,89
	;dc.b 90,91,92,93,94,95,96,97,98,99
	;dc.b 100,101,102,103,104,105,106,107,108,109
	;dc.b 110,111,112,113,114,115,116,117,118,119
	;dc.b 120,121,122,123,124,125,126,127,128,129
	;dc.b 130,131,132,133,134,135,136,137,138,139
	;dc.b 140,141,142,143,144,145,146,147,148,149
	;dc.b 150,151,152,153,154,155,156,157,158,159
	;dc.b 160,161,162,163,164,165,166,167,168,169
	;dc.b 170,171,172,173,174,175,176,177,178,179
	;dc.b 180,181,182,183,184,185,186,187,188,189
	;dc.b 190,191,192,193,194,195,196,197,198,199
	;dc.b 200,201,202,203,204,205,206,207,208,209
	;dc.b 210,211,212,213,214,215,216,217,218,219
	;dc.b 220,221,222,223,224,225,226,227,228,229
	;dc.b 230,231,232,233,234,235,236,237,238,239
	;dc.b 240,241,242,243,244,245,246,247,248,249
	;dc.b 250,251,252,253,254
	dc.b $ff

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Uninitialized Data!!!           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
		.bss
		.phrase
	
obj_typ:		ds.l	1
bra_ypo:		ds.w	1
bmcounter:		ds.w	1
bra_con:		ds.l	1
bmp_bit:		ds.l	1
bmp_phr:		ds.l	1
curchar:		ds.l	1
imagepos:		ds.l	1
scr_highl:		ds.l	NRBITMAPS
scr_lowl:		ds.l	NRBITMAPS
x_pos:			ds.w    NRBITMAPS
y_pos:			ds.w    1
x_max:			ds.w    1
updatebitmap:	ds.w	1
col:			ds.w	1


	.phrase
images:		ds.b	SCR_WIDTH*SCR_HEIGHT*2*NRBITMAPS
lastimage:
	.phrase
	.end