max_x           EQU 384
bytesline       EQU max_x/8
max_y           EQU 240
**********************
* Bildschirmausgaben *
**********************
                >PART 'PrintA0'
PrintA0:          movem.l d0/a0,-(sp)
loop_pa:          move.b  (a0)+,d0
                  beq.s   exit_pa
                  bsr     PrintChar
                  bra.s   loop_pa
exit_pa:          movem.l (sp)+,d0/a0
                  rts
                ENDPART
                >PART 'PrintBIN16'
PrintBIN16:       movem.l d0-d2,-(sp)
                  moveq   #15,d1
                  move.l  d0,d2
loop_pb16:        moveq   #0,d0
                  add.w   d2,d2
                  bcc.s   ok_pb16
                  addq.w  #1,d0
ok_pb16:          bsr     PrintZiffer
                  dbra    d1,loop_pb16
                  movem.l (sp)+,d0-d2
                  rts
                ENDPART
                >PART 'PrintBIN'
PrintBIN:         movem.l d0-d2,-(sp)
                  moveq   #31,d1
                  move.l  d0,d2
loop_pb:          moveq   #0,d0
                  add.l   d2,d2
                  bcc.s   ok_pb
                  addq.w  #1,d0
ok_pb:            bsr     PrintZiffer
                  dbra    d1,loop_pb
                  movem.l (sp)+,d0-d2
                  rts
                ENDPART
                >PART 'PrintDEZ'
PrintDEZ:         move.l  d0,-(sp)
                  and.l   #$0000FFFF,d0
                  divu    #10000,d0
                  bsr     PrintZiffer
                  swap    d0
                  ext.l   d0
                  divu    #1000,d0
                  bsr     PrintZiffer
                  swap    d0
                  ext.l   d0
                  divu    #100,d0
                  bsr     PrintZiffer
                  swap    d0
                  ext.l   d0
                  divu    #10,d0
                  bsr     PrintZiffer
                  swap    d0
                  ext.l   d0
                  bsr.s   PrintZiffer
                  move.l  (sp)+,d0
                  rts

PrintDEZ2:        and.l   #$0000FFFF,d0
                  divu    #10,d0
                  bsr.s   PrintZiffer
                  swap    d0
                  ext.l   d0
                  bsr.s   PrintZiffer
                  rts
                ENDPART
                >PART 'PrintHex'
PrintHEXl:        move.l  d0,-(sp)
                  swap    d0
                  bsr.s   PrintHEX
                  move.l  (sp),d0
                  bsr.s   PrintHEX
                  moveq   #" ",d0
                  bsr.s   PrintChar
                  move.l  (sp)+,d0
                  rts

PrintHEX:         move.w  d0,-(sp)
                  move.b  (sp),d0
                  bsr.s   PrintHEX1
                  move.w  (sp)+,d0
PrintHEX1:        move.w  d0,-(sp)
                  lsr.w   #4,d0
                  and.w   #$000F,d0
                  move.b  Ziffern(pc,d0.w),d0
                  bsr.s   PrintChar
                  moveq   #$0F,d0
                  and.w   (sp),d0
                  move.b  Ziffern(pc,d0.w),d0
                  bsr.s   PrintChar
                  move.w  (sp)+,d0
                  rts
Ziffern:        DC.B "ABCDEF"
                ENDPART
                >PART 'InitTxtScreen'
InitTxtScreen:    lea     TextScreen(a5),a0
                  move.l  #$0000F0FF,$00F00400
                  move.w  #max_x*max_y/32,d0
                  moveq   #0,d1
loop_its:         move.l  d1,(a0)+
                  dbra    d0,loop_its
                  clr.l   Cursor(a5)
                  rts

PrintZiffer:      add.b   #"0",d0
PrintChar:        movem.l d0/a0-a1,-(sp)
                  and.w   #$00FF,d0
                  add.w   d0,d0
                  add.w   d0,d0
                  add.w   d0,d0
                  lea     ASCII(pc,d0.w),a0
                  lea     TextScreen(a5),a1
                  move.w  Cursor+2(a5),d0
                  mulu    #max_x,d0
                  add.w   Cursor(a5),d0
                  adda.w  d0,a1
                  addq.w  #1,Cursor(a5)
                  cmpi.w  #bytesline,Cursor(a5)
                  bne.s   ok_pc
                  clr.w   Cursor(a5)
                  addq.w  #1,Cursor+2(a5)
                  cmpi.w  #max_y/8,Cursor+2(a5)
                  bne.s   ok_pc
                  clr.w   Cursor+2(a5)
ok_pc:            move.b  (a0)+,(a1)
                  move.b  (a0)+,bytesline(a1)
                  move.b  (a0)+,2*bytesline(a1)
                  move.b  (a0)+,3*bytesline(a1)
                  move.b  (a0)+,4*bytesline(a1)
                  move.b  (a0)+,5*bytesline(a1)
                  move.b  (a0)+,6*bytesline(a1)
                  move.b  (a0)+,7*bytesline(a1)
                  movem.l (sp)+,d0/a0-a1
                  rts
                PATH 'E:\JAGUAR\'
ASCII:          IBYTES 'ASCII8.BIN'

                ENDPART
                >PART 'TextObject'
* Text-Screen
                DC.W 0                     ; Type 0
                DC.L -TextScreen
                DC.W 30,81                 ; x,y
                DC.W max_y                 ; Hhe
                DC.W NEXT_OBJ
                DC.B 0,1
                DC.W max_x/64,max_x/64     ; Dwidth,Iwidth
                DC.B 0,0
                DC.W $0020,$0020,$0020
                DC.W $AFFE

                ENDPART
