;-------------------------------------;	
;
;	gpu fire
;
;	code
;	sebastian
;
;	code history
;	30 aug - soc
;	01 sep - interleaving introduced
;
;-------------------------------------;	
	path "e:\js\macro\"
	
	include	"js\macro\macro.js"
	include	"\inc\jag\jag__equ.s"
	include	"\inc\jag\blit_equ.s"

database	equ	$1000
screen	equ	$100000

;	local ram

width	equ	320
height	equ	200

image::	equ	$f04000-width*2
line1::	equ	image-width*2
line0::	equ	line1-width*2
next::	equ	line0-(64*4)*4
palette::	equ	next-(64*4)

	run	$f03000

lowmask	reg	8

a0	reg	9	;verschiedene adressregister
a1	reg	10
a2	reg	11

rnext	reg	14	;successor table
rel15	reg	15
rbcmd	reg	16	;blitter command

rcnt1	reg	17	;schleifenzhler 1
rpos1	reg	18	;schleifeneinsprung 1
rcnt2	reg	19
rpos2	reg	20

rimgptr	reg	23	;adr grafikzeile im lram
rextrd	reg	24	;diese zeile wird aus dem ram gel.
rextwt	reg	25	;diese zeile wird ins ram geschr.
rline0ptr	reg	26	;adr zeile n im lram
rline1ptr	reg	27	;adr zeile n+1 im lram
rscrn	reg	28	;adr grafikzeile im ram

bigcount.a	reg	0
rpal.a	reg	10	;adresse der palette im local ram
rblitbase.a	reg	11	;blitter base

gpufire::
;allgemeine initialisierung
	movei	screen,rscrn
	movei	line0,rline0ptr
	movei	line1,rline1ptr
	movei	image,rimgptr
	movei	next,rnext

	movei	height,r0
	moveta	r0,bigcount.a
	movei	palette,r0
	moveta	r0,rpal.a

;blitter initialisieren
	movei	$1000,r0
	load	(r0),rextrd
	move	rextrd,rextwt

	movei	$f02200,r15
	moveta	r15,rblitbase.a
	movei	b_xaddphr|b_pixel32,r0
	store	r0,(rel15+$04)
	store	r0,(rel15+$28)
	movei	b_lfu_replace|b_srcen,rbcmd

;2 zeilen feuerdaten (wegen start) ins lram
	store	rline0ptr,(rel15)
	store	rextrd,(rel15+$24)
	xor	r0,r0
	store	r0,(rel15+$0c)
	store	r0,(rel15+$30)
	movei	width|$00010000,r0
	store	r0,(rel15+$3c)
	store	rbcmd,(rel15+$38)

;bernchste zeile beim nchsten mal lesen ! (0->2 !!!)	
	movei	(width*2)*2,r0
	add	r0,rextrd

;auf blitter warten !
.blitidle	load	(rel15+$38),r0
	shrq	1,r0
	jr	cc,.blitidle
	nop

;-------------------------------------;
;feuer hauptschleife
;-------------------------------------;
;neue daten berechnen

bigloop:	
	move	rline0ptr,a0
	move	rline1ptr,a1
	move	rimgptr,a2
	movei	next,rnext
	movefa	rpal.a,rel15
	movei	width/2-2,rcnt1
	movei	loop1,rpos1
	movei	$ffff,lowmask

;-------------------------------------;
;die 2 pixel am linken rand
;-------------------------------------;
	load	(a0),r0
	movei	width*2-4,a1
	add	rline1ptr,a1
	load	(a1),r2
	move	rline1ptr,a1
	load	(a1),r3
	addqt	4,a1
	add	r3,r0
	load	(a1),r4
	rorq	16,r3
	subqt	4,a1
	add	r3,r0
	shrq	16,r4
	move	r0,r1
	shrq	16,r0
	add	r4,r1
	add	r2,r0
	and	lowmask,r1
	and	lowmask,r0
	load	(rnext+r1),r1
	load	(rnext+r0),r0
	and	lowmask,r1
	and	lowmask,r0
	load	(rel15+r1),r3
	load	(rel15+r0),r2
	shlq	16,r0	
	shlq	16,r2
	and	lowmask,r3
	or	r1,r0
	or	r3,r2
	store	r0,(a0)
	store	r2,(a2)
	addqt	4,a0
	addqt	4,a2

;-------------------------------------;
;die mittleren 318 pixel
;-------------------------------------;

	move	rline0ptr,a0
	addqt	4,a0
	move	rline1ptr,a1

loop1:	load	(a0),r0
	load	(a1),r2
	addqt	4,a1	
	load	(a1),r3
	addqt	4,a1
	add	r3,r0
	load	(a1),r4
	rorq	16,r3
	subqt	4,a1
	add	r3,r0
	rorq	16,r4
	move	r0,r1
	shrq	16,r0
	add	r4,r1
	add	r2,r0
	and	lowmask,r1
	and	lowmask,r0
	load	(rnext+r1),r1
	load	(rnext+r0),r0
	and	lowmask,r1
	and	lowmask,r0
	load	(rel15+r1),r3
	load	(rel15+r0),r2
	and	lowmask,r3
	shlq	16,r0
	shlq	16,r2
	or	r1,r0
	or	r3,r2
	store	r0,(a0)
	store	r2,(a2)
	subq	1,rcnt1
	addqt	4,a0
	jump	nz,(rpos1)
	addqt	4,a2

;-------------------------------------;
;die rechten beiden pixel
;-------------------------------------;
	load	(a0),r0
	load	(a1),r2
	addqt	4,a1
	load	(a1),r3
	move	rline1ptr,a1	
	load	(a1),r4
	add	r3,r0
	rorq	16,r3
	add	r3,r0
	move	r0,r1
	shrq	16,r0
	add	r2,r1
	shrq	16,r4
	add	r4,r0
	and	lowmask,r1
;	and	lowmask,r0
	load	(rnext+r1),r1
	load	(rnext+r0),r0
	and	lowmask,r1
	and	lowmask,r0
	load	(rel15+r1),r3
	load	(rel15+r0),r2
	and	lowmask,r3
	shlq	16,r0
	shlq	16,r2
	or	r1,r0
	or	r3,r2
	store	r0,(a0)
	store	r2,(a2)
	addqt	4,a0
	addqt	4,a2


	movefa	rblitbase.a,rel15

;jetzige, neuberechnete zeile 0 ins ram zurckschreiben

	xor	r0,r0
	movei	width/2|$00010000,r1
	store	rextwt,(rel15)
	store	rline0ptr,(rel15+$24)
	store	r0,(rel15+$0c)
	store	r0,(rel15+$30)
	store	r1,(rel15+$3c)
	store	rbcmd,(rel15+$38)
.blitidle5	load	(rel15+$38),r0
	shrq	1,r0
	jr	cc,.blitidle5
	nop
            movei	width*2,r0
            add	r0,rextwt
	
;neue zeile 1 aus dem normalen ram holen
	xor	r0,r0
	movei	width/2|$00010000,r1
	store	rline0ptr,(rel15)
	store	rextrd,(rel15+$24)
	store	r0,(rel15+$0c)
	store	r0,(rel15+$30)
	store	r1,(rel15+$3c)
	store	rbcmd,(rel15+$38)
	movei	width*2,r0
	add	r0,rextrd
.blitidle6	load	(rel15+$38),r0
	shrq	1,r0
	jr	cc,.blitidle6
	nop

;-------------------------------------;
;image in screen kopieren
;-------------------------------------;
	xor	r0,r0
	movei	width/2|$00010000,r1
	store	rscrn,(rel15)
	store	rimgptr,(rel15+$24)
	store	r0,(rel15+$0c)
	store	r0,(rel15+$30)
	store	r1,(rel15+$3c)
	movei	width*2,r0
	store	rbcmd,(rel15+$38)
	add	r0,rscrn

;warten bis blitter fertig
;.blitidle1	load	(rel15+$38),r0
;	shrq	1,r0
;	jr	cc,.blitidle1
;	nop


;zeilen 1 und 2 vertauschen
	SWAP	rline0ptr,rline1ptr

	movei	bigloop,r0
	movefa	bigcount.a,r1	
	subq	1,r1
	jump	nz,(r0)
	moveta	r1,bigcount.a
;	nop	
	
            movei	$800,r0
as:	load	(r0),r1
            shrq	1,r1
            jr	cc,as
	nop
	movei	gpufire,r0
	jump	(r0)
	nop
	
	STOPGPU

	
