*    remote-area   *
********************
* rmt_LoadFile  *

* IN : A0  = Filename
*      D0  = Length of filename
*      A1  = Dest. address
rmt_LoadFile:     movem.l d0-a6,-(sp)
;                  subq.w  #1,LockJoyPad(a6)
                  move.w  d0,d1

                  move.w  #$C0,d0
                  bsr     SendWord_STE
                  beq.s   exit
                  lsr.w   #2,d1
                  move.w  d1,d0
                  bsr     SendWord_STE
                  beq.s   exit
loop_fn:          move.l  (a0)+,d0
                  bsr     SendLong_STE
                  beq.s   exit
                  dbra    d1,loop_fn
                  move.l  a1,d0
                  bsr     SendLong_STE
;                 beq.s   exit
                  move.w  #255,d7
wait00:
;                  subq.w  #1,d7
;                  beq.s   exit
                  bsr.s   GetWord_STEt
                  beq.s   wait00
                  cmp.w   #WriteLongs,d0
                  bne.s   wait00

_again:            bsr     ReadDumpLong

                  bsr.s   GetWord_STEt
                  cmp.w   #WriteLongs,d0
                  beq.s   _again
;                 clr.w   LockJoyPad(a6)
                  moveq   #-1,d0
                  movem.l (sp)+,d0-a6
                  rts

exit:
;                  clr.w   LockJoyPad(a6)
                  moveq   #0,d0
                  movem.l (sp)+,d0-a6
                  rts
*****************
* trans-routs   *

FirstTimeOutInit  SET 125
TimeOutInit       SET 100
******************
* GetWord
* Z = 0 => D0 = Word
* Z = 1 => Fehler
******************
; A0/A1           Adressen
; D0              Empfangsdaten
; D1              letztes 4 Bit Packet
; D2              TimeOut Counter/Wait counter
; D3              Busy High
; D4              Busy Low
; D5              loop counter

regs_gwt          REG d1-d5/a0-a1

GetWord_STEt:     movem.l #regs_gwt,-(sp)
                  lea     $F14000,a1
                  lea     3(a1),a0
                  moveq   #0,d0
                  move.w  #$81F0,d3
                  move.w  #$8170,d4
                  moveq   #7,d5

                  move.w  d3,(a1)          ; Busy high
                  move.w  #FirstTimeOutInit,d2
GetWord_STEt1:    subq.w  #1,d2
                  beq.s   GetWord_STEt7    ; timed out
                  btst    #3,(a0)
                  beq.s   GetWord_STEt1
                  bra.s   GetWord_STEt4

GetWord_STEt2:    move.w  d3,(a1)          ; Busy high
                  moveq   #TimeOutInit,d2
GetWord_STEt3:    subq.w  #1,d2
                  beq.s   GetWord_STEt7    ; timed out
                  btst    #3,(a0)
                  beq.s   GetWord_STEt3
GetWord_STEt4:    move.w  (a1),d1
                  move.w  d4,(a1)          ; Busy low

;              moveq   #2,d2
;GetWord_STEt5:    dbra    d2,GetWord_STEt5 ; etwas bremsen

                  add.b   d1,d1
                  add.b   d1,d1
                  addx.w  d0,d0
                  add.b   d1,d1
                  addx.w  d0,d0
                  moveq   #TimeOutInit,d2
GetWord_STEt6:    subq.w  #1,d2
                  beq.s   GetWord_STEt7
                  btst    #3,(a0)
                  bne.s   GetWord_STEt6
                  dbra    d5,GetWord_STEt2
                  moveq   #-1,d1
                  movem.l (sp)+,#regs_gwt
                  rts
GetWord_STEt7:    move.w  d4,(a1)          ; busy low
                  moveq   #0,d0
                  movem.l (sp)+,#regs_gwt
                  rts
* A0 - Status lesen
* A1 - Status setzen
* D0 - Daten
* D1 - Daten aus Status ausmaskieren
* D2 - Status : BUSY high
* d3 - Status : BUSY low
* d4 - time out counter
* D7 - Schleifenzhler
regs_glstet       REG d1-d4/d7-a1

GetLong_STEt:     movem.l #regs_glstet,-(sp)

                  lea     $F14000,a1
                  lea     3(a1),a0

                  moveq   #0,d0
                  move.w  #$81F0,d2
                  move.w  #$8170,d3
                  moveq   #9,d7            ; 10 * 3 Bit
GetLong_STE1t:    move.w  d2,(a1)          ; Busy high
                  moveq   #127,d4
GetLong_STE2t:    subq.w  #1,d4
                  beq.s   GetLong_STE7t
                  btst    #3,(a0)
                  beq.s   GetLong_STE2t    ; auf STROBE high warten
                  moveq   #$70,d1
                  and.w   (a1),d1
                  move.w  d3,(a1)          ; Busy low
                  rol.l   #3,d0
                  or.w    d1,d0
                  moveq   #127,d4
GetLong_STE4t:    subq.w  #1,d4
                  beq.s   GetLong_STE7t
                  btst    #3,(a0)
                  bne.s   GetLong_STE4t    ; auf STROBE low warten
                  dbra    d7,GetLong_STE1t

                  move.w  d2,(a1)          ; Busy high
                  moveq   #127,d4
GetLong_STE5t:    subq.w  #1,d4
                  beq.s   GetLong_STE7t
                  btst    #3,(a0)
                  beq.s   GetLong_STE5t    ; auf STROBE high warten
                  moveq   #$60,d1
                  and.w   (a1),d1
                  move.w  d3,(a1)          ; Busy low
                  rol.l   #3,d0
                  or.w    d1,d0
                  moveq   #127,d4
GetLong_STE6t:    subq.w  #1,d4
                  beq.s   GetLong_STE7t
                  btst    #3,(a0)
                  bne.s   GetLong_STE6t    ; auf STROBE low warten
                  moveq   #-1,d1
                  movem.l (sp)+,#regs_glstet
                  rts
GetLong_STE7t:    move.w  d3,(a1)
                  moveq   #0,d0
                  movem.l (sp)+,#regs_glstet
                  rts
SendByte_STE:
SendWord_STE:     movem.l d0-d4/d6-a1,-(sp)
                  lea     $F14000,a0
                  lea     3(a0),a1
                  rol.w   #7,d0
                  move.w  #$8180,d2
                  moveq   #3,d3
                  move.w  #$8170,d4

                  moveq   #7,d7
                  move.w  d4,(a0)          ; STROBE auf low
SendWord_STE1:    moveq   #$60,d1
                  and.w   d0,d1
                  rol.w   #2,d0
                  or.w    d2,d1

                  moveq   #0,d6
SendWord_STE2:    addq.w  #1,d6
                  beq.s   SendWord_STE4
                  btst    d3,(a1)          ; Busy high
                  beq.s   SendWord_STE2

                  move.w  d1,(a0)          ; Bit mit STROBE
                  moveq   #0,d6
SendWord_STE3:    addq.w  #1,d6
                  beq.s   SendWord_STE4
                  btst    d3,(a1)
                  bne.s   SendWord_STE3    ; auf Busy low warten
                  move.w  d4,(a0)          ; STROBE low

                  dbra    d7,SendWord_STE1
                  moveq   #-1,d0
                  movem.l (sp)+,d0-d4/d6-a1
                  rts
SendWord_STE4:    moveq   #0,d0
                  movem.l (sp)+,d0-d4/d6-a1
                  rts

SendLong_STE:     movem.l d0-d4/d6-a1,-(sp)
                  lea     $F14000,a0
                  lea     3(a0),a1
                  move.w  #$8180,d2
                  moveq   #3,d3
                  move.w  #$8170,d4
                  moveq   #9,d7            ; 10*3 Bit

                  move.w  d4,(a0)          ; STROBE auf low
SendLong_STE1:    moveq   #$70,d1
                  and.w   d0,d1
                  or.w    d2,d1
                  moveq   #0,d6
SendLong_STE2:    addq.w  #1,d6
                  beq.s   SendLong_STE4
                  btst    d3,(a1)          ; Busy high ?
                  beq.s   SendLong_STE2    ; nein => warten

                  move.w  d1,(a0)          ; Bits mit STROBE
                  rol.l   #3,d0
                  moveq   #0,d6
SendLong_STE3:    addq.w  #1,d6
                  beq.s   SendLong_STE4
                  btst    d3,(a1)
                  bne.s   SendLong_STE3    ; auf Busy low warten
                  move.w  d4,(a0)          ; STROBE low
                  dbra    d7,SendLong_STE1

                  moveq   #$60,d1
                  and.w   d0,d1
                  or.w    d2,d1
                  moveq   #0,d6
SendLong_STE5:    addq.w  #1,d6
                  beq.s   SendLong_STE4
                  btst    d3,(a1)          ; Busy high
                  beq.s   SendLong_STE5

                  move.w  d1,(a0)          ; Bits mit STROBE
                  moveq   #0,d6
SendLong_STE6:    addq.w  #1,d6
                  beq.s   SendLong_STE4
                  btst    d3,(a1)
                  bne.s   SendLong_STE6    ; auf Busy low warten
                  move.w  d4,(a0)          ; STROBE low

                  moveq   #-1,d0
                  movem.l (sp)+,d0-d4/d6-a1
                  rts
SendLong_STE4:    moveq   #0,d0
                  movem.l (sp)+,d0-d4/d6-a1
                  rts

WriteLongs        EQU $88


ReadDumpLong:
;                  move.w  #$8170,$F14000   ; BUSY low

                  bsr     GetLong_STEt
                  beq.s     exit_rdl
                  movea.l d0,a2
                  bsr     GetLong_STEt
                  beq.s   exit_rdl
                  move.l  d0,d5

                  move.w  #WriteLongs,d0
                  bsr     SendWord_STE

                  moveq   #0,d4

                  lea     $F14000,a1
                  lea     3(a1),a0

                  move.w  #$81F0,d2
                  move.w  #$8170,d3
                  moveq   #0,d4
loop_rd1:
*********************
* A0 - Status lesen
* A1 - Status setzen
* D0 - Daten
* D1 - Daten aus Status ausmaskieren
* D2 - Status : BUSY high
* d3 - Status : BUSY low
* D7 - Schleifenzhler

                  moveq   #0,d0
                  moveq   #9,d7            ; 10 * 3 Bit
_GetLong_STE1:    move.w  d2,(a1)          ; Busy high

_GetLong_STE2:    btst    #3,(a0)
                  beq.s   _GetLong_STE2    ; auf STROBE high warten
                  moveq   #$70,d1
                  and.w   (a1),d1
                  move.w  d3,(a1)          ; Busy low
                  rol.l   #3,d0
                  or.w    d1,d0

_GetLong_STE4:    btst    #3,(a0)
                  bne.s   _GetLong_STE4    ; auf STROBE low warten
                  dbra    d7,_GetLong_STE1

                  move.w  d2,(a1)          ; Busy high
_GetLong_STE5:    btst    #3,(a0)
                  beq.s   _GetLong_STE5    ; auf STROBE high warten
                  moveq   #$60,d1
                  and.w   (a1),d1
                  move.w  d3,(a1)          ; Busy low
                  rol.l   #3,d0
                  or.w    d1,d0

_GetLong_STE6:    btst    #3,(a0)
                  bne.s   _GetLong_STE6    ; auf STROBE low warten
******************
                  move.l  d0,(a2)+

                  eor.l   d4,d0
                  add.l   d0,d4

                  dbra    d5,loop_rd1
                  sub.l   #$010000,d5
                  bpl.s   loop_rd1


                  move.l  d4,d0

                  bsr     SendLong_STE

exit_rdl:         rts
*****************

