****************
* GAME
* created : ??.7.95
****************

LSUB GAME,LSUBend_MAIN
*****************
*  main loop    *

game::          movei #draw_pf,r0
                JSR (r0)
                movei #joypad,JOYPAD            ; reinit
                MyINITLSUB GAME1
again::         WaitVBL
                movefa sec.a,r1
                movei #ShowTime,r0
                cmp last_sec,r1
                move r1,last_sec
                JSR nz,(r0)
                movei #ClearSecond,r0
                JSR (r0)
                
if 0
movefa LinesToGo.a,r0
moveq #1,r1
moveta r1,Cursor.a
movei #PrintHex,r1
JSR (r1)
endif
                cmpq #0,UPDATE
                movei #.cont,r0
                jump z,(r0)
                nop
                MyINITLSUB GAME2
                movei #SettleStone,r0           ; game2
                JSR (r0)
                movei #draw_pf,r0               ; game
                JSR (r0)
                movei #IncPoints,r1             ; main
                moveq #1,r0
                JSR (r1)
                movei #CheckLines,r0            ; game2
                JSR (r0)
                movei #NewStone,r0              ; main
                JSR (r0)
                MyINITLSUB GAME1

                movefa x_pos.a,r0
                movei #CheckNewPos,r2           ; game
                movefa y_pos.a,r1
                JSR (r2)
                cmpq #0,r0
                movei #ExitGame,r0
                jump nz,(r0)
                nop
                movefa DropInit0.a,r0
                movefa Level.a,r1
                moveta r0,DropInit.a
                addq #2,r1
                mult r1,r0
                moveta r0,DropCounter.a
                moveq #0,Y_Flag
                moveq #0,X_Flag
.cont           movei #DrawCurrentStone,r0      ; game1
                JSR (r0)
;---------------
;--- test horizontal move
;---------------
MoveHor::       movei #.cont1,r1
                cmpq #0,X_Flag
                jump z,(r1)
                movefa x_pos.a,r0
                jr nn,.cont
                nop
                 subq #1,r0
                jump (r1)
                 addq #1,X_Flag

.cont            addqt #1,r0
                 subq #1,X_Flag
.cont1          moveta r0,x_pos.a
;---------------
;--- test move down
;---------------
y_pos           REG 5
CONT0           REG 4
CONT2           REG 3
MoveDown::      PUSH r4,r5
                movei #.cont0,CONT0
                movei #.cont2,CONT2
                movefa y_pos.a,y_pos
                cmpq #8,Y_Flag
                movei #CheckNewPos,r2
                jump nz,(CONT0)                 ; Y_Flag=8 => cont0
                cmpq #0,Y_Flag
                movefa y_pos.a,r1
                movefa x_pos.a,r0
                JSR (r2)
                cmpq #0,r0
                jr z,.cont1
                cmpq #0,X_Flag                  ; hori. move active ?
                jump nz,(CONT2)                 ; nz => yes => cont2
                movefa y_pos.a,y_pos
                jump (CONT2)
                subq #1,UPDATE  

.cont0          jump z,(CONT2)                  ; Y_Flag=0 => .cont2
                movefa y_pos.a,y_pos

.cont1          sub YADD,Y_Flag
                jump nn,(CONT2)
                add YADD,y_pos
.loop           addq #1,Y_Flag
                jr nz,.loop
                subq #1,y_pos

.cont2          moveta y_pos,y_pos.a
                POP r4,r5
UNREG y_pos,CONT0,CONT2
;-----------------
weiter::
;>               moveq #0,r0
;>               movei #$f00058,r1
;>               store r0,(r1)

                MyINITLSUB JOYSTICK
                JSR (JOYPAD)
                MyINITLSUB GAME1
                movei #again,r0
                jump (r0)
                nop
ExitGame        RTS
*****************
* draw play-field
y_count         REG  6
x_count         REG  5
PF_ptr          REG  4
LOOP            REG  3

draw_pf::       PUSH r2,r3,r4,r5,r6

                WAITBLITTER

                xor UPDATE,UPDATE
                movei #1<<16|(-8&$ffff),r0
                store r0,(blitter+$10)          ; a1 step
                xor r0,r0
                store r0,(blitter+$14)          ; a1 step frac
                store r0,(blitter+$18)          ; a1 ptr frac
                movei #$3f,r1
                
                store r0,(blitter+$34)          ; a2 step
                store r0,(blitter+$30)          ; a2 win ptr
                store r1,(blitter+$2c)          ; a2 win mask
                movei #BLIT_PITCH1|BLIT_PIXEL16|BLIT_WID96|BLIT_XADDPHR,r1
                store screen_ptr,(blitter)
                store r1,(blitter+4)

                movei #BLIT_MASK|BLIT_PITCH1|BLIT_PIXEL16|BLIT_WID64|BLIT_XADDPHR,r1
                store r1,(blitter+$28)

                movei #PlayFieldTop,PF_ptr
                moveq #PFmax_x,x_count
                moveq #PFmax_y,y_count
                shlq #3,x_count
                shlq #3,y_count
                movei #.loop0,LOOP

.loop0          move y_count,r0
                move x_count,r1
                shlq #16,r0
                or r1,r0

                
                load (PF_ptr),r1
                shlq #7,r1
                add pattern_ptr,r1


.wait1          load (blitter+$38),r2
                shrq #1,r2
                jr cc,.wait1
                nop

                store r0,(blitter+$0c)
;---------------
                store r1,(blitter+$24)
;---------------
                movei #8<<16|8,r0
                movei #BLIT_UPDA1|BLIT_SRCEN|BLIT_LFU_REPLACE|BLIT_BUSHI*0,r1
                store r0,(blitter+$3c)
                store r1,(blitter+$38)
;---------------
                subq #8,x_count
                jump nn,(LOOP)
                subq #4,PF_ptr
                subq #8,y_count
                moveq #PFmax_x,x_count
                jump nn,(LOOP)
                shlq #3,x_count

                POP r6,r5,r4,r3,r2
                RTS
UNREG LOOP,PF_ptr,x_count,y_count
*****************
* Overlay lschen
ClearSecond::   WAITBLITTER
                movei #screen1,r0
                movei #BLIT_PITCH1|BLIT_PIXEL32|BLIT_WID3584|BLIT_XADDPHR,r1
                store r0,(blitter)
                store r1,(blitter+4)
                moveq #0,r0
                store r0,(blitter+$c)           ; a1 ptr
                store r0,(blitter+$10)          ; a1 step
                store r0,(blitter+$68)
                addq #4,r1
                store r0,(r1)                   ; pat data
                movei #1<<16|(PFmax_x*8+8)*(PFmax_y*8+8)*2>>2,r0
                movei #BLIT_PATDSEL|BLIT_BUSHI*0,r1
                store r0,(blitter+$3c)
                store r1,(blitter+$38)
                RTS
*****************
* CheckNewPos
* r0 = new_x / r1 = new_y

COUNTER2        REG 7
EXIT            REG 6
LINEOFFSET      REG 5
MASKE           REG 4
PFptr           REG 3

CheckNewPos::   PUSH r3,r4,r5,r6,r7

                movefa StonePtr2.a,r5           ; Stein
                movefa StonePtr.a,r6            ; Drehung
                shlq #2,r5
                or r5,r6
                movei #steine,r3                ; Position des Drehpunktes
                shlq #3,r6
                add r6,r3
                shlq #3,r6
                movei #Maske,MASKE
                add r6,MASKE
                movei #.exit,EXIT

                load (r3),r5
                addq #4,r3
                addq #8,r0
                add r5,r0                       ; x korrigieren
                add X_Flag,r0
                jump n,(EXIT)
                load (r3),r5
                shrq #3,r0
                add r5,r1                       ; y korrigieren
                add Y_Flag,r1
                sharq #3,r1
                movei #(PFmax_x+1)<<2,LINEOFFSET
                shlq #2,r0                      ; fr Longs
                movei #PlayField,PFptr
                imult LINEOFFSET,r1
                add r0,PFptr
                add r1,PFptr
                subq #4*4,LINEOFFSET
                moveq #4,r0     ; 16 Blcke
                moveq #4,COUNTER2
.loop           load (MASKE),r1
                addq #4,MASKE
                load (PFptr),r2
                addq #4,PFptr
                and r2,r1
                jump nz,(EXIT)
                subq #1,r0
                jr nz,.loop
                nop
                add LINEOFFSET,PFptr
                subq #1,COUNTER2
                jr nz,.loop
                moveq #4,r0

                moveq #0,r0
                POP r7,r6,r5,r4,r3
                RTS
.exit
                moveq #1,r0
                POP r7,r6,r5,r4,r3
                RTS


UNREG PFptr,MASKE,LINEOFFSET,EXIT,COUNTER2
*****************
ENDLSUB GAME
;-------------------------------
LSUB GAME1,LSUBend_GAME
*****************
* DrawCurrentStone
Stone           REG 4
x_pos           REG 3
y_pos           REG 2

DrawCurrentStone::
                PUSH r2,r3,r4
                WAITBLITTER
                
                movei #1<<16|(-32&$ffff),r0
                moveq #0,r1
                store r0,(blitter+$10)          ; a1 step
                store r1,(blitter+$14)          ; a1 step frac
                store r1,(blitter+$18)          ; a1 ptr frac
                store r1,(blitter+$30)          ; a2 win ptr
                
                movefa x_pos.a,x_pos
                movefa y_pos.a,y_pos
                addq #8,x_pos                   ; Offset fr Rand
                movefa StonePtr2.a,r1           ; stein
                movefa StonePtr.a,r0            ; drehung
                shlq #2,r1
                add r1,r0
                move r0,Stone
                movei #steine,r1
                shlq #3,r0
                add r0,r1
                load (r1),r0
                addq #4,r1
                add r0,x_pos
                load (r1),r0
                add r0,y_pos
                shlq #16,x_pos
                shlq #16,y_pos
                shrq #16,x_pos
                or x_pos,y_pos
                store y_pos,(blitter+$0c)
                
                move x_pos,r0
                neg r0
                shlq #30,r0
                shrq #30,r0     ; = AND #$3
                addq #32,r0
                neg r0
                shlq #16,r0
                shrq #16,r0
                bset #16,r0
                store r0,(blitter+$10)
                
                movei #screen1,r0
                movei #BLIT_PITCH1|BLIT_PIXEL16|BLIT_WID96|BLIT_XADDPHR,r1
                store r0,(blitter)
                store r1,(blitter+4)
;---------------
                movei #Stones,r0
                shlq #11,Stone
                movei #BLIT_PITCH1|BLIT_PIXEL16|BLIT_WID32|BLIT_XADDPHR,r1
                add Stone,r0
                store r1,(blitter+$28)
                store r0,(blitter+$24)
                movei #-4&$ffff,r0
                store r0,(blitter+$34)          ; a2 step
;---------------
                movei #32<<16|32,r0
                movei #BLIT_UPDA1|BLIT_SRCEN|BLIT_LFU_REPLACE,r1
                store r0,(blitter+$3c)
                movefa x_pos.a,r0
                shlq #30,r0
                shrq #30,r0
                jr z,.cont
                nop
                  bset #10,r1     ; UPDA2
.cont           store r1,(blitter+$38)
                POP r4,r3,r2
                RTS
UNREG x_pos,y_pos,Stone
*****************
ENDLSUB GAME1
***************************************************************
***************************************************************

LSUB GAME2,LSUBend_GAME
;---------------
; settle current stone
;---------------
COLOR           REG 7
COUNTER2        REG 6
LINEOFFSET      REG 5
MASKE           REG 4
PFptr           REG 3

SettleStone::   PUSH r3,r4,r5,r6,r7

                movefa StonePtr2.a,r5           ; Stein
                movefa StonePtr.a,r6            ; Drehung
                move r5,COLOR
                shlq #2,r5
                or r5,r6
                movei #steine,r3                ; Position des Drehpunktes
                shlq #3,r6
                addq #1,COLOR
                add r6,r3
                shlq #3,r6
                movei #Maske,MASKE
                add r6,MASKE

                load (r3),r5
                movefa x_pos.a,r0
                addq #4,r3
                addq #8,r0
                add r5,r0                       ; x korrigieren
                load (r3),r5
                movefa y_pos.a,r1
                shrq #3,r0
                add r5,r1                       ; y korrigieren
                sharq #3,r1
                movei #(PFmax_x+1)<<2,LINEOFFSET
                shlq #2,r0                      ; fr Longs
                movei #PlayField,PFptr
                imult LINEOFFSET,r1
                add r0,PFptr
                add r1,PFptr
                subq #4*4,LINEOFFSET
                moveq #4,r0     ; 16 Blcke
                moveq #4,COUNTER2
.loop           load (MASKE),r1
                addq #4,MASKE
                and COLOR,r1
                load (PFptr),r2
                or r2,r1
                subq #1,r0
                store r1,(PFptr)
                jr nz,.loop
                addq #4,PFptr
                add LINEOFFSET,PFptr
                subq #1,COUNTER2
                jr nz,.loop
                moveq #4,r0
                nop
                POP r7,r6,r5,r4,r3
                RTS

UNREG PFptr,MASKE,LINEOFFSET,COUNTER2,COLOR
;---------------
; test for completed lines
;---------------
LOOP2           REG 16
Points          REG 13
Y1              REG 12
Y               REG 11
CONT            REG 10
LOOP1           REG  9
LOOP0           REG  8
Counter         REG  7
LineCount       REG  6
ptr_save        REG  5
ptr             REG  4
ptr2            REG  3
LineOffset      REG  2


CheckLines::    PUSH r2,r3,r4,r5,r6,r7,r8,r9
                PUSH r10,r11,r12,r13,r16
                movei #.loop0,LOOP0
                movei #.loop1,LOOP1
                movei #.loop2,LOOP2
                movei #.cont,CONT
                movei #PlayFieldTop,ptr
                movei #(PFmax_x+1)*4,LineOffset ; field width
                moveq #4,LineCount              ; max. 4 lines
                moveq #10,Points
                moveq #PFmax_y,Y

.loop0          sub LineOffset,ptr
                move ptr,ptr_save
                subq #4,ptr                     ; border
                moveq #PFmax_x-2,Counter        ; field width - border
.loop1          load (ptr),r0
                subq #4,ptr
                cmpq #0,r0
                jump z,(CONT)                   ; empty space
                subq #1,Counter
                jump nn,(LOOP1)
                nop
                                              ; well, all spaces filled

                                moveq #7,r1
                                move ptr_save,ptr

.loop2                          moveq #PFmax_x-2,Counter
                                subq #4,ptr
.loop3                                          store r1,(ptr)
                                                subq #1,Counter
                                                subqt #4,ptr
                                                jr nn,.loop3
                                                nop
                                                moveq #2,r0
.wait                                           WaitVBL
                                                subq #1,r0
                                                jr nn,.wait
                                                nop
                                                movei #draw_pf,r0
                                                PUSH r1
                                                JSR (r0)
                                                POP r1
                                                subq #1,r1
                                jump nn,(LOOP2)
                                move ptr_save,ptr

                                move ptr_save,ptr2              ; dest
                                subq #4,ptr2
                                move ptr2,ptr
                                sub LineOffset,ptr
                                move Y,Y1
                                moveq #10,Counter
.loop4                                                          load (ptr),r0
                                                                subq #4,ptr
                                                                store r0,(ptr2)
                                                                subq #1,Counter
                                                                jr nz,.loop4
                                                                subq #4,ptr2
                                                subq #8,ptr
                                                subq #8,ptr2
                                                subq #1,Y1
                                jr nn,.loop4
                                moveq #10,Counter

                                WaitVBL
                                movei #draw_pf,r0
                                JSR (r0)
                                movei #IncLines,r0
                                JSR (r0)
                                movei #IncPoints,r1
                                move Points,r0
                                JSR (r1)
                                shlq #1,Points
                                subq #1,LineCount
                                addqt #1,Y
                                jr z,.exit
                                add LineOffset,ptr_save
.cont           subq #1,Y
                jump nn,(LOOP0)
                move ptr_save,ptr

.exit           POP r16,r13,r12,r11,r10
                POP r9,r8,r7,r6,r5,r4,r3,r2
                RTS

UNREG Y1,Y,CONT,LOOP2,LOOP1,LOOP0,Counter,LineCount
UNREG ptr_save,ptr,ptr2,LineOffset,Points

ENDLSUB GAME2
**********************************************************
**********************************************************

LSUB JOYSTICK,LSUBend_GAME

joypad::        movei #LastJoy,r0
                load (r0),r0
                load (SP),r1
                cmpq #0,r0
                jump z,(r1)                     ; RET
                addqt #4,SP
                subqt #4,SP

;               cmpq #0,PauseFlag
;               movei #.cont2,r2
;               jump nz,(r2)

                btst #22,r0
                movei #left,r2
                jump nz,(r2)
                btst #23,r0
                movei #right,r2
                jump nz,(r2)
                nop

joypad1         movei #LastJoy,r0
                load (r0),r1
                cmpq #0,r1
                load (SP),r2
                jump z,(r2)
                addqt #4,SP
                subqt #4,SP

                btst #29,r1
                movei #rotate_right,r2          ; "A"
                jump nz,(r2)
                btst #25,r1
                movei #rotate_left,r2           ; "B"
                jump nz,(r2)
                btst #21,r1
                movei #drop,r2
                jump nz,(r2)

;               btst #28,r1                     ; "PAUSE"
;               movei #do_pause,r2
;               jump nz,(r2)

                nop
                RTS

.cont2          movei #LastJoy,r0
                load (r0),r1
                cmpq #0,r1
                jr nz,.cont3
                nop
.exit           RTS
.cont3          btst #28,r1
                jr z,.exit
                nop
                moveq #0,PauseFlag
                RTS

if 0
****************
LOOP            REG 7
light           REG 6
RANDOM          REG 5
CounterX        REG 4
CounterY        REG 3
ptr             REG 2

do_pause::      PUSH r2,r3,r4,r5,r6,r7
                movei #screen1+16,ptr
                movei #(PFmax_x-1)<<3,CounterX
                movei #PFmax_y<<3,CounterY
                movei #Random,RANDOM
                movei #$ff,light
                movei #.loop,LOOP
.loop           JSR (RANDOM)
                shrq #2,r0
                and r6,r0
                shlq #8,r0
                or r6,r0
                subq #1,CounterX
                storew r0,(ptr)
                jump nz,(LOOP)
                addq #2,ptr
                addq #32,ptr
                subq #1,CounterY
                movei #(PFmax_x-1)<<3,CounterX
                jump nz,(LOOP)
                nop
                moveq #1,PauseFlag
                movefa sec.a,r2
                movefa ms.a,r3
.wait           JSR (JOYPAD)
                cmpq #0,PauseFlag
                jr nz,.wait
                nop
                moveta r2,sec.a
                moveta r3,ms.a
                POP r7,r6,r5,r4,r3,r2
                WaitVBL
                RTS
                movei #ClearSecond,r0
                JSR (r0)
                RTS
;               movei #DrawCurrentStone,r0
;               jump (r0)
;               nop
UNREG ptr,CounterX,CounterY,RANDOM,light,LOOP
endif
***************
drop::          moveq #1,r0
                moveq #4,YADD
                moveta r0,DropInit.a
                moveta r0,DropCounter.a
                RTS
rotate_left::   moveq #1,r1
                neg r1
                jr .cont0
rotate_right    movefa StonePtr.a,r0
                moveq #1,r1
.cont0          PUSH r0
                add r1,r0
                shlq #30,r0
                shrq #30,r0
                moveta r0,StonePtr.a
                moveta r0,StonePtr.a
                movefa x_pos.a,r0
                movei #CheckNewPos,r2
                movefa y_pos.a,r1
                JSR (r2)
                POP r1
                cmpq #0,r0
                jr z,.cont
                nop
                moveta r1,StonePtr.a
.cont           RTS

right::         jr .cont
left            moveq #8,r1
                neg r1
.cont           movei #joypad1,r0
                cmpq #0,X_Flag
                jump nz,(r0)
                movefa x_pos.a,r0
                movei #CheckNewPos,r2
                add r1,r0
                PUSH r1
                movefa y_pos.a,r1
                JSR (r2)
                POP X_Flag
                cmpq #0,r0
                movei #joypad1,r0
                jump z,(r0)
                nop
                jump (r0)
                moveq #0,X_Flag

if 0
                moveq #8,X_Flag
                movei #PFmax_x*8,r2
                movefa x_pos.a,r1
                cmp r2,r1
                jump nz,(r0)
                nop
                jump (r0)
                moveq #0,X_Flag

next_stone::    movefa StonePtr2.a,r0
                addq #1,r0
                shlq #29,r0
                shrq #29,r0
                moveta r0,StonePtr2.a
                RTS

inc_level::     POP r1
                movefa Level.a,r0
                cmpq #9,r0
                addqt #1,r0
                jump nz,(r1)
                moveta r0,Level.a
                moveq #9,r0
                jump (r1)
                moveta r0,Level.a 

dec_level::     POP r1
                movefa Level.a,r0
                subq #1,r0
                jump nn,(r1)
                moveta r0,Level.a
                moveq #0,r0
                jump (r1)
                moveta r0,Level.a
ENDIF
                ENDLSUB JOYSTICK
