****************
* MODUL IRQ
* created 30/07/95
****************
* exports MODrun.IRQ_SUB
*         MODend.IRQ_SUB
*         MODlen.IRQ_SUB

GPU             set 1

AnzObjekte      equ 11
OBL             equ $9f000
OBL0            equ $9f200

                path "e:\bjl\js\symbols\"

                isyms "blit_eq.sym"
                isyms "jagregeq.sym"
                
                path "..\macro\"
                include "help.mac"
                include "joypad1.mac"

                path "e:\bjl\newsrc\tetris\"
****************
* global register equates
                include "globlreg.inc"
****************
* local macros
MACRO IRQ_PUSH
                subqt #4,IRQ_SP.a
                store \0,(IRQ_SP.a)
ENDM
MACRO IRQ_POP
                load (IRQ_SP.a),\0
                addqt #4,IRQ_SP.a
ENDM
****************
* vars
_sec            equ GPU_ENDRAM-4
LastJoy         equ _sec-8
seed1           equ LastJoy-3*4
stone_stat      equ seed1-7*4
STACK           EQU stone_stat-4
****************


                MODULE IRQ_SUB,$f03000
;- IRQ-hooks ---

IRQ_START::

 IF 0
                movei #cpu_irq,IRQ_RTS.a
                load (IRQ_FLAGADR.a),IRQ_FLAG.a
                jump (IRQ_RTS.a)
                load (IRQ_SP.a),IRQ_RTS.a
 ENDIF
                org $f03020
                movei #timer_irq,IRQ_RTS.a
                load (IRQ_FLAGADR.a),IRQ_FLAG.a
                jump (IRQ_RTS.a)
                load (IRQ_SP.a),IRQ_RTS.a

                org $f03030
                movei #obj_irq,IRQ_RTS.a
                load (IRQ_FLAGADR.a),IRQ_FLAG.a
                jump (IRQ_RTS.a)
                load (IRQ_SP.a),IRQ_RTS.a
****************
* ms-timer
****************
timer_irq::     bclr #3,IRQ_FLAG.a
                addq #4,IRQ_SP.a
                bset #11,IRQ_FLAG.a
;---------------
                subq #1,_50Hz.a
                movei #$f02114,r10
                jr nz,.cont0
                load (r10),r11
                moveq #20,_50Hz.a
                bset #1,r11
                store r11,(r10)                 ; CPU-VBL anstoen



.cont0          subq #1,ms.a
                jr nz,.cont
                addq #2,IRQ_RTS.a
                movei #1000,ms.a
                addq #1,sec.a   ; sec erhhen
.cont
                subq #1,DropCounter.a
                movei #.exit,r10
                jump nn,(r10)
                movefa Y_Flag,r11
                cmpq #0,r11
                jump nz,(r10)
                moveq #8,r11

                move Level.a,DropCounter.a
                addq #1,DropCounter.a
                moveta r11,Y_Flag
                mult DropInit.a,DropCounter.a


.exit           moveta IRQ_RTS.a,IRQ_RTS
                jump (IRQ_RTS.a)
                store IRQ_FLAG.a,(IRQ_FLAGADR.a)

 IF 0
****************
* Interrupt through the CPU (during VI)
****************

cpu_irq::       bclr #3,IRQ_FLAG.a
                addq #4,IRQ_SP.a
                bset #9,IRQ_FLAG.a
                addq #2,IRQ_RTS.a
                moveta IRQ_RTS.a,IRQ_RTS
;---------------                
                IRQ_PUSH r1
                IRQ_PUSH r0

                moveq #1,r11
                movei #OBL,r10
                moveta r11,FLAG
                movei #OBL0,r11
                movei #AnzObjekte*4,r1
                loadp (r11),r0
.loop           addq #8,r11
                subq #1,r1
                storep r0,(r10)
                addqt #8,r10
                jr nz,.loop
                loadp (r11),r0


                IRQ_POP r0
                IRQ_POP r1

                jump (IRQ_RTS.a)
                store IRQ_FLAG.a,(IRQ_FLAGADR.a)
****************
 ENDIF

****************
* GPU-object
obj_irq::
                movei #$f00026,r10
                storew r11,(r10)                ; resume OP

                bclr #3,IRQ_FLAG.a
                addq #4,IRQ_SP.a
                bset #12,IRQ_FLAG.a
                addq #2,IRQ_RTS.a
;---------------                
                IRQ_PUSH r11
                IRQ_PUSH r10
                IRQ_PUSH r1
                IRQ_PUSH r0

* no need to up-date the branch-objects, so skip them

                moveq #1,r11
                movei #OBL+3*$20,r10
                moveta r11,FLAG
                movei #OBL0+3*$20,r11

                movei #(AnzObjekte-3-3)*4,r1    ; also, don't update stop/gpu object
                loadp (r11),r0
.loop           addq #8,r11
                subq #1,r1
                storep r0,(r10)
                addqt #8,r10
                jr nz,.loop
                loadp (r11),r0

                IRQ_POP r0
                IRQ_POP r1
                IRQ_POP r10
                IRQ_POP r11

                jump (IRQ_RTS.a)
                store IRQ_FLAG.a,(IRQ_FLAGADR.a)
****************

ENDMODULE IRQ_SUB

                END
