******************************************************************************
* Autor   :  Bastian Schick                                                  *
******************************************************************************
* history                                                                    *
* 02.10.95      An die neue Entwicklungsumgebung angepasst                   *
* 25.01.96      Fr Verffentlichung vorbereitet                             *
* 26.01.96      Light-Font eingebaut                                         *
* 27.01.96      VI rausgeschmissen und dafr GPU-Objekt eingefhrt           *
*               Player-Timing auf 50Hz ber ms-Timer der GPU                 *
* 07.05.96      Anpassungen fr NEWSRC                                       *
* 23.09.96      Neu Keyboard-Rountine eingebaut                              *
*               Fehler in ClearPf                                            *
******************************************************************************


DEBUG           EQU 0
                 OPT C+,T+,S+,P+,B+,Z+,Q+,K+
                 opt d+,X+,w+
                IFNE DEBUG
*****************
*  StartPrg     *
* Routinen um vom STE/Falcon ber die JoyPad-Ports ein Programm
* an den Jaguar zu schicken
*
* (c) 1994 Bastian Schick
* Version 4  -  29.5.95

DestAdr         EQU $00004000

                  pea     doit(pc)
                  move.w  #38,-(sp)
                  trap    #14
                  addq.l  #6,sp
                  clr.w   -(sp)
                  trap    #1


doit:             move.l  $000004BA.w,-(sp)
                  sf      $FFFF9203.w
                  lea     jag_prg(pc),a0
                  lea     DestAdr.w,a1
                  move.l  #jag_end-jag_prg,d0
                  bsr.s   SendPRG2Jaggy
                  move.l  $000004BA.w,d7
                  sub.l   (sp)+,d7
                  trap    #1
                  rts
SendPRG2Jaggy:    lea     jag_prg(pc),a0
                  move.l  #(jag_end-jag_prg)>>2,d2
                  move.l  #DestAdr,d1
                  bsr     WriteDumpL
                  beq.s   error_sp
                  move.w  #StartSub,d0
                  bsr.s   SendWord_STE
                  beq.s   error_sp
                  move.l  #DestAdr,d0
                  bsr     SendLong_STE
error_sp:         rts
;-----------------
Print:            movem.l d0-d2/a0-a2,-(sp)
                  move.l  7*4(sp),-(sp)
                  move.w  #9,-(sp)
                  trap    #1
                  addq.l  #6,sp
                  movem.l (sp)+,d0-d2/a0-a2
                  move.l  (sp)+,(sp)
                  rts
*************************
* transmission-routines *
*************************
StartSub        EQU $00000083
WriteLongs      EQU $00000088
FirstTimeOutInit EQU 120
TimeOutInit     EQU 70

SendRegs        REG d1-d3/d6-a2
SendWord_STE:     movem.l #SendRegs,-(sp)
                  lea     $000004BA.w,a2
                  moveq   #FirstTimeOutInit,d7
                  add.l   (a2),d7
                  lea     $FFFF9201,a0

SendWord_STE2:    btst    #3,(a0)
                  bne.s   SendWord_STE3
                  cmp.l   (a2),d7
                  bhi.s   SendWord_STE2
                  moveq   #0,d0
                  movem.l (sp)+,#SendRegs
                  rts
SendWord_STE3:    lea     2(a0),a1
                  rol.w   #8,d0
                  moveq   #$10,d2
                  moveq   #3,d3
                  moveq   #7,d6
SendWord_STE4:    moveq   #$C0,d1
                  and.w   d0,d1
                  rol.w   #2,d0
                  or.b    d2,d1

                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
SendWord_STE5:    btst    #3,(a0)
                  bne.s   SendWord_STE6    ; auf BUSY high warten
                  cmp.l   (a2),d7
                  bhi.s   SendWord_STE5
                  bra     TimeOut2

SendWord_STE6:    move.b  d1,(a1)          ; Bit mit STROBE
                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
SendWord_STE7:    btst    #3,(a0)
                  beq.s   SendWord_STE8    ; auf BUSY low warten
                  cmp.l   (a2),d7
                  bhi.s   SendWord_STE7
                  bra     TimeOut2
SendWord_STE8:    clr.b   (a1)             ; STROBE low

                  dbra    d6,SendWord_STE4
                  moveq   #-1,d0
                  movem.l (sp)+,#endRegs
                  rts
** SendLong_STE **
SendLong_STE:     movem.l #endRegs,-(sp)
                  lea     $FFFF9201,a0
                  lea     2(a0),a1
                  lea     $000004BA.w,a2
                  moveq   #FirstTimeOutInit,d7
                  add.l   (a2),d7

SendLong_STE1:    btst    #3,(a0)
                  bne.s   SendLong_STE2    ; auf BUSY high warten
                  cmp.l   (a2),d7
                  bhi.s   SendLong_STE1
                  moveq   #0,d0
                  movem.l (sp)+,#endRegs
                  rts

SendLong_STE2:    rol.l   #3,d0
                  moveq   #$10,d2
                  moveq   #3,d3
                  moveq   #9,d6            ; 10*3 Bit
SendLong_STE3:    moveq   #$E0,d1
                  and.w   d0,d1
                  rol.l   #3,d0
                  or.b    d2,d1

                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
SendLong_STE4:    btst    #3,(a0)
                  bne.s   SendLong_STE5    ; auf BUSY high warten
                  cmp.l   (a2),d7
                  bhi.s   SendLong_STE4
                  bra     TimeOut2
SendLong_STE5:    move.b  d1,(a1)          ; Bit mit STROBE
                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
SendLong_STE6:    btst    d3,(a0)
                  beq.s   SendLong_STE7
                  cmp.l   (a2),d7
                  bhi.s   SendLong_STE6
                  bra     TimeOut2         ; auf Busy low warten
SendLong_STE7:    sf      (a1)             ; STROBE low
                  dbra    d6,SendLong_STE3

                  moveq   #$C0,d1
                  and.w   d0,d1
                  or.b    d2,d1

                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
SendLong_STE8:    btst    #3,(a0)
                  bne.s   SendLong_STE9    ; auf BUSY high warten
                  cmp.l   (a2),d7
                  bhi.s   SendLong_STE8
                  bra     TimeOut2
SendLong_STE9:    move.b  d1,(a1)          ; Bit mit STROBE
                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
SendLong_STE10:   btst    d3,(a0)
                  beq.s   SendLong_STE11
                  cmp.l   (a2),d7
                  bhi.s   SendLong_STE10
                  bra     TimeOut2         ; auf Busy low warten
SendLong_STE11:   sf      (a1)             ; STROBE low

                  moveq   #-1,d0
                  movem.l (sp)+,#endRegs
                  rts
*****************
** GetWord_STE **
*****************
GetWord_STE:      movem.l #endRegs,-(sp)
                  moveq   #FirstTimeOutInit,d7
                  add.l   $000004BA.w,d7
                  lea     $FFFF9201,a0
GetWord_STE1:     btst    #3,(a0)
                  beq.s   GetWord_STE2
                  cmp.l   $000004BA.w,d7
                  bhi.s   GetWord_STE1

                  moveq   #0,d0
                  movem.l (sp)+,#endRegs
                  rts

GetWord_STE2:     lea     2(a0),a1
                  moveq   #0,d0
                  moveq   #0,d2

                  moveq   #7,d6
GetWord_STE3:     st      (a1)             ; /Busy high
                  bsr     _WaitStrobeHigh
                  move.b  (a1),d1
                  sf      (a1)             ; /Busy low
                  add.b   d1,d1
                  roxl.w  #1,d0
                  add.b   d1,d1
                  roxl.w  #1,d0
                  bsr     _WaitStrobeLow
                  dbra    d6,GetWord_STE3
                  moveq   #-1,d1
                  movem.l (sp)+,#endRegs
                  rts
*****************
** GetLong_STE **
*****************
GetLong_STE:      movem.l #endRegs,-(sp)
                  lea     $000004BA.w,a2
                  moveq   #20,d7
                  add.l   (a2),d7
                  lea     $FFFF9201,a0
                  sf      2(a0)
GetLong_STE1:     btst    #3,(a0)
                  beq.s   GetLong_STE2
                  cmp.l   (a2),d7
                  bhi.s   GetLong_STE1
                  sf      2(a0)
                  moveq   #0,d0
                  movem.l (sp)+,#endRegs
                  rts

GetLong_STE2:     lea     2(a0),a1
                  moveq   #0,d0
                  moveq   #0,d2
                  moveq   #9,d6
GetLong_STE3:     st      (a1)             ; Busy high
                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
GetLong_STE6:     btst    #3,(a0)
                  bne.s   GetLong_STE7
                  cmp.l   (a2),d7
                  bhi.s   GetLong_STE6
                  bra.s   TimeOut2
GetLong_STE7:     moveq   #$E0,d1
                  and.b   (a1),d1
                  sf      (a1)             ; Busy low
                  rol.l   #3,d0
                  or.b    d1,d0

                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
GetLong_STE8:     btst    #3,(a0)
                  beq.s   GetLong_STE9
                  cmp.l   (a2),d7
                  bhi.s   GetLong_STE8
                  bra.s   TimeOut2
GetLong_STE9:     dbra    d6,GetLong_STE3

                  st      (a1)
                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
GetLong_STE10:    btst    #3,(a0)
                  bne.s   GetLong_STE11
                  cmp.l   (a2),d7
                  bhi.s   GetLong_STE10
                  bra.s   TimeOut2

GetLong_STE11:    moveq   #$C0,d1
                  and.b   (a1),d1
                  sf      (a1)             ; Busy low
                  rol.l   #3,d0
                  or.b    d1,d0
                  rol.l   #1,d0

                  moveq   #TimeOutInit,d7
                  add.l   (a2),d7
GetLong_STE12:    btst    #3,(a0)
                  beq.s   GetLong_STE13
                  cmp.l   (a2),d7
                  bhi.s   GetLong_STE12
                  bra.s   TimeOut2
GetLong_STE13:    moveq   #-1,d1
                  movem.l (sp)+,#endRegs
                  rts
*****************
_WaitStrobeHigh:  moveq   #60,d7
                  add.l   $000004BA.w,d7
_wait0_sw:        btst    #3,(a0)          ; 12
                  bne.s   _ok_wbh          ;  8    auf BUSY high warten
                  cmp.l   $000004BA.w,d7
                  bhi.s   _wait0_sw
                  bra.s   TimeOut
_ok_wbh:          rts
******************
_WaitStrobeLow:   moveq   #60,d7
                  add.l   $000004BA.w,d7
_wait_bl:         btst    #3,(a0)          ; 12
                  beq.s   _ok_wbl          ;  8    auf BUSY high warten
                  cmp.l   $000004BA.w,d7
                  bhi.s   _wait_bl
******************
TimeOut:          addq.l  #4,sp
TimeOut2:         movem.l (sp)+,d1-d3/d6-a1
                  sf      $FFFF9203.w
                  pea     timeout(pc)
                  bsr     Print
                  moveq   #0,d0
_ok_wbl:          rts
timeout:        DC.B "TimeOut",13,10,0
                EVEN
******************
* In D1,D2,A0
******************
WriteDumpL:       movem.l d0-d2/a0-a2,-(sp)
                  sf      $FFFF9203.w

again_wdl:        move.w  #WriteLongs,d0
                  bsr     SendWord_STE     ; Commando
                  beq.s   exit_wdl

                  move.l  d1,d0
                  bsr     SendLong_STE     ; Start-Adress
                  beq.s   exit_wdl

                  move.l  d2,d0
                  bsr     SendLong_STE     ; Anzahl der Lang-Worte
                  beq.s   exit_wdl

                  sf      $FFFF9203.w

wait_wdl:         bsr     GetWord_STE
                  beq.s   exit_wdl1
                  cmp.w   #WriteLongs,d0
                  bne.s   exit_wdl

                  moveq   #0,d3
loop_wdl:         move.l  (a0)+,d0
                  move.l  d0,d1

                  eor.l   d3,d1
                  add.l   d1,d3

                  bsr     SendLong_STE
                  beq.s   exit_wdl

                  dbra    d2,loop_wdl
                  sub.l   #$00010000,d2
                  bpl.s   loop_wdl
                  bsr     GetLong_STE
                  cmp.l   d0,d3
                  bne.s   error_wdl

                  moveq   #-1,d0
                  movem.l (sp)+,d0-d2/a0-a2
                  rts
exit_wdl1:        pea     timeout1(pc)
                  bra.s   cont_wdl

exit_wdl:         pea     timeout(pc)
                  bra.s   cont_wdl
error_wdl:        pea     WriteDumpErr(pc)
cont_wdl:         bsr     Print
                  moveq   #0,d0
                  movem.l (sp)+,d0-d2/a0-a2
                  rts
timeout1:       DC.B "WriteDumpL-TimeOut",13,10,0
WriteDumpErr:   DC.B "Error in transmission !",13,10,0
                EVEN

*****************
                ENDIF
jag_prg:

*BASE A6 = VARS
vars            EQU $1000

                include "\bjl\js\symbols\blit_eq.js"

                PATH 'E:\BJL\NEWSRC\'
                INCLUDE "68k_mac\help.mac"
                INCLUDE 'TETRIS\TETRIS.EQU'

*****************
*  Variablen    *
                RSRESET
                RS.W count_obj
                RS.W a_hde
                RS.W a_hdb
                RS.W a_vdb
                RS.W a_vde
                RS.L Cursor
                RS.W ResetFlag
                INCLUDE "68k_var\keyboard.var"

                RS.L StackBottom,100
                RS.L stack

vars_len        EQU RSCOUNT
*****************

VID_MODE        EQU $7c1

max_x           EQU 8*(10+2)
max_y           EQU 8*(24+1)
score_max_y     EQU 25*8
score_max_x     EQU 16*8

GraphicScreen   EQU $00100000
GraphicScreen2  EQU $00100000+max_x*max_y*2
ScoreScreen     EQU GraphicScreen2+max_x*(max_y+3*8)*2

OBL             equ $9f000                 ; max. 10 Objekte
OBL0            equ $9f200
Pattern         EQU $000A0000              ; 13*64 words
Stones          EQU $000B0000
Maske           EQU $000C0000
PlayField       EQU $000F0000

KeyDelay        equ 5

start:          INCLUDE "68k_inc\startup.inc"
                move.w #$100,$f14000

                lea     vars,a6
                lea     (a6),a0
                move.w  #vars_len>>2,d0
clear_var:      clr.l   (a0)+
                dbra    d0,clear_var

                move.l #$ff3fffff,KeyMask(a6)

                lea $f00400,a0
                moveq #127,d0
clear_clut      clr.l (a0)+
                dbra d0,clear_clut

                lea GraphicScreen,a0
                move.w #max_x*max_y>>1,d0
clear_scr       clr.l (a0)+
                dbra d0,clear_scr

                lea GraphicScreen2,a0
                move.w #max_x*max_y>>1,d0
clear_scr2      clr.l (a0)+
                dbra d0,clear_scr2
                  lea     stack(a6),sp

                  lea     Phobyx(pc),a0
                  lea     pPhobyx(pc),a1
                  move.l  a0,(a1)
                  lea Credits(pc),a0
                  lea pCredits(pc),a1
                  move.l a0,(a1)

                  bsr     VideoInit
                  bsr     InitOP
                  move    sr,-(sp)
                  ori     #$0700,sr
                  bsr     InitGPU
                  bsr     MakePattern
                  bsr     MakeStones

                  movem.l d0-a6,-(sp)
                  lea     GPUcode(pc),a0
                  lea     mod-GPUcode(a0),a0
                  bsr     PLAYER           ; init player and MOD
                  movem.l (sp)+,d0-a6

                  move    (sp)+,sr

                  move.l  #-1,ScoreScreen
                  lea     $00F02114,a3
                  move.l  GPUcode+4(pc),-4(a3)
                  move.l  #1<<11|1,$00F1A114
                  move.l  #0<<11|1,(a3)

                  bsr     LynxPAL2RGB

                  clr.b   ResetFlag(a6)
.loop             stop    #$2000
                  tst.b   ResetFlag(a6)
                  beq.s   .loop
*****************
*   reset       *
reset:
reset0:           move.w   #255,d6
                  lea     $00F00400,a1 ;+16*2,a1
                  moveq   #0,d5
reset1:           move.w  (a1),d0
                  move.w d0,d1
                  move.w d0,d2
                  and.w #%1111100000000000,d0
                  beq.s reset2
                  subq.w #1,d0
reset2            and.w #%1111100000000000,d0

                  and.w #%0000011111000000,d1
                  beq.s reset21
                  subq.w #1,d1
reset21           and.w #%0000011111000000,d1
                  and.w #%0000000000111110,d2
                  beq.s reset22
                  subq.w #1,d2
reset22           and.w #%0000000000111110,d2
                  or.w d1,d0
                  or.w d2,d0
                  or.w d0,d5
                  or.w #1,d0
reset23:          move.w  d0,(a1)+
                  dbra    d6,reset1
                  moveq #0,d6
reset24:          stop #$2000
                  stop #$2000
                  dbra    d6,reset24
                  tst.w d5
                  bne.s reset0

reset3:           moveq   #0,d0
                  move.l  d0,$00F02114
                  move.l  d0,$00F1A114
                  move.l  d0,$00F10000
                  move.l  #$FF00FF00,$00F00020
                  move.l  d0,$00F1A154
                  move.l  d0,$00F1A150
                  move.l  d0,$00F00050
                  move.l  d0,$00F03FF4

                  move.w  #$1861,$00F00000
                  move.l  $00E00004,-(sp)
                  rts
*****************
*  MakePattern  *
MakePattern:      movem.l d0/d5-a2,-(sp)
                  lea     Pattern,a0
                  moveq   #63,d0
mp9:              clr.w   (a0)+
                  dbra    d0,mp9

                  lea     Colors(pc),a1
                  moveq   #6,d7
mp0:              lea     maske(pc),a2
                  move.w  (a1)+,d0
                  moveq   #63,d5
mp1:              move.b  (a2)+,d0
                  bclr    #0,d0
                  move.w  d0,(a0)+
                  dbra    d5,mp1
                  dbra    d7,mp0
                  move.w  (a1)+,d0         ; Wandfarbe
                  moveq   #4,d7
mp2:              moveq   #63,d5
mp3:              move.b  (a2)+,d0
                  not.b   d0
                  move.w  d0,(a0)+
                  dbra    d5,mp3
                  dbra    d7,mp2
                  movem.l (sp)+,d0/d5-a2
                  rts
Colors:         DC.W $F000,$8800,$0F00,$4F00,$C700,$FF00,$0000,$8000
maske:

                DC.L $FFFFFFFF,$FFFFFFFF
                DC.L $FFDDDDDD,$DDDDDDFF
                DC.L $FFDDBBBB,$BBBBDDFF
                DC.L $FFDDBB77,$77BBDDFF
                DC.L $FFDDBB77,$77BBDDFF
                DC.L $FFDDBBBB,$BBBBDDFF
                DC.L $FFDDDDDD,$DDDDDDFF
                DC.L $FFFFFFFF,$FFFFFFFF
; wand links
                REPEAT
                DC.L $FFDDBB99,$77553311
                UNTIL #7

; wand rechts
                REPEAT
                DC.L $11335577,$99BBDDFF
                UNTIL #7

; wand unten
                DC.L $11111111,$11111111
                DC.L $33333333,$33333333
                DC.L $55555555,$55555555
                DC.L $77777777,$77777777
                DC.L $99999999,$99999999
                DC.L $BBBBBBBB,$BBBBBBBB
                DC.L $DDDDDDDD,$DDDDDDDD
                DC.L $FFFFFFFF,$FFFFFFFF
; ecke links
                DC.L $FFDDBB99,$77553311
                DC.L $FFDDBB99,$77553333
                DC.L $FFDDBB99,$77555555
                DC.L $FFDDBB99,$77777777
                DC.L $FFDDBB99,$99999999
                DC.L $FFDDBBBB,$BBBBBBBB
                DC.L $FFDDDDDD,$DDDDDDDD
                DC.L $FFFFFFFF,$FFFFFFFF
; ecke rechts
                DC.L $11335577,$99BBDDFF
                DC.L $33335577,$99BBDDFF
                DC.L $55555577,$99BBDDFF
                DC.L $77777777,$99BBDDFF
                DC.L $99999999,$99BBDDFF
                DC.L $BBBBBBBB,$BBBBDDFF
                DC.L $DDDDDDDD,$DDDDDDFF
                DC.L $FFFFFFFF,$FFFFFFFF
*****************
*  MakeStones   *
MakeStones:       movem.l d0-a6,-(sp)
                  moveq   #6,d7            ; 7 Steine
                  lea     Stones,a0
                  lea     Pattern,a2       ; Null
                  lea     128(a2),a3       ; Muster
                  move.l  a3,d3
                  lea     Maske,a6
                  lea     StonesRaw(pc),a5

ms0:              move.w  #4*4-1,d6        ; 4*4 Blcken Variationen
ms1:              movea.l d3,a3            ; Muster merken
                  moveq   #7,d5            ; a 8 Pel-Zeilen
ms2:              moveq   #3,d4            ; 4 Blcke
                  lea     (a5),a4          ; akt. Blockzeile merken
ms3:              lea     (a2),a1          ; nix
                  tst.b   (a4)+            ; oder Farbe ?
                  beq.s   ms_c0            ; <>0 => nix
                  lea     (a3),a1          ; akt. Farbe
ms_c0:            move.l  (a1)+,(a0)+
                  move.l  (a1)+,(a0)+      ; 8 Pixel kopieren
                  move.l  (a1)+,(a0)+
                  move.l  (a1)+,(a0)+
                  dbra    d4,ms3           ; nchster Block
                  lea     16(a3),a3
                  dbra    d5,ms2           ; nchste Pel-Zeile
                  moveq   #0,d0
                REPEAT
                  move.b  (a5)+,d0
                  move.l  d0,(a6)+
                UNTIL #3
                  dbra    d6,ms1
                  move.l  a3,d3
                  dbra    d7,ms0
                  movem.l (sp)+,d0-a6
                  rts
 IFNE 0
;--------------
; MMM
; M
                DC.W %1110100000000000
                DC.W %1100010001000000
                DC.W %0010111000000000
                DC.W %1000100011000000
;--------------
; MMM
;   M
                DC.W %1110001000000000
                DC.W %0100010011000000
                DC.W %1000111000000000
                DC.W %1100100010000000
;--------------
;  MM
; MM
                DC.W %0110110000000000
                DC.W %1000110001000000
                DC.W %0110110000000000
                DC.W %1000110001000000
;--------------
; MM
;  MM
                DC.W %1100011000000000
                DC.W %0100110010000000
                DC.W %1100011000000000
                DC.W %0100110010000000
;--------------
; MMMM
                DC.W %1111000000000000
                DC.W %1000100010001000
                DC.W %1111000000000000
                DC.W %1000100010001000
;--------------
; MMMM
;  M
                DC.W %1110010000000000
                DC.W %0100110001000000
                DC.W %0100111000000000
                DC.W %1000110010000000
;--------------
; MM
; MM
                DC.W %1100110000000000
                DC.W %1100110000000000
                DC.W %1100110000000000
                DC.W %1100110000000000
  ENDIF
StonesRaw:
                DC.L $FFFFFF00
                DC.L $FF000000
                DC.L $00000000
                DC.L $00000000

                DC.L $FFFF0000
                DC.L $00FF0000
                DC.L $00FF0000
                DC.L $00000000

                DC.L $0000FF00
                DC.L $FFFFFF00
                DC.L $00000000
                DC.L $00000000

                DC.L $FF000000
                DC.L $FF000000
                DC.L $FFFF0000
                DC.L $00000000

;--------------

                DC.L $FFFFFF00
                DC.L $0000FF00
                DC.L $00000000
                DC.L $00000000

                DC.L $00FF0000
                DC.L $00FF0000
                DC.L $FFFF0000
                DC.L $00000000

                DC.L $FF000000
                DC.L $FFFFFF00
                DC.L $00000000
                DC.L $00000000

                DC.L $FFFF0000
                DC.L $FF000000
                DC.L $FF000000
                DC.L $00000000
;---------------
                DC.L $00FFFF00
                DC.L $FFFF0000
                DC.L $00000000
                DC.L $00000000

                DC.L $FF000000
                DC.L $FFFF0000
                DC.L $00FF0000
                DC.L $00000000

                DC.L $00FFFF00
                DC.L $FFFF0000
                DC.L $00000000
                DC.L $00000000

                DC.L $FF000000
                DC.L $FFFF0000
                DC.L $00FF0000
                DC.L $00000000
;---------------
                DC.L $FFFF0000
                DC.L $00FFFF00
                DC.L $00000000
                DC.L $00000000

                DC.L $00FF0000
                DC.L $FFFF0000
                DC.L $FF000000
                DC.L $00000000

                DC.L $FFFF0000
                DC.L $00FFFF00
                DC.L $00000000
                DC.L $00000000

                DC.L $00FF0000
                DC.L $FFFF0000
                DC.L $FF000000
                DC.L $00000000
;---------------
                DC.L $FFFFFFFF
                DC.L $00000000
                DC.L $00000000
                DC.L $00000000

                DC.L $FF000000
                DC.L $FF000000
                DC.L $FF000000
                DC.L $FF000000

                DC.L $FFFFFFFF
                DC.L $00000000
                DC.L $00000000
                DC.L $00000000

                DC.L $FF000000
                DC.L $FF000000
                DC.L $FF000000
                DC.L $FF000000
;---------------

                DC.L $FFFFFF00
                DC.L $00FF0000
                DC.L $00000000
                DC.L $00000000

                DC.L $00FF0000
                DC.L $FFFF0000
                DC.L $00FF0000
                DC.L $00000000

                DC.L $00FF0000
                DC.L $FFFFFF00
                DC.L $00000000
                DC.L $00000000

                DC.L $FF000000
                DC.L $FFFF0000
                DC.L $FF000000
                DC.L $00000000
;---------------
                DC.L $FFFF0000
                DC.L $FFFF0000
                DC.L $00000000
                DC.L $00000000

                DC.L $FFFF0000
                DC.L $FFFF0000
                DC.L $00000000
                DC.L $00000000

                DC.L $FFFF0000
                DC.L $FFFF0000
                DC.L $00000000
                DC.L $00000000

                DC.L $FFFF0000
                DC.L $FFFF0000
                DC.L $00000000
                DC.L $00000000


*****************
                INCLUDE "68k_inc\keyboard.inc"

                IFNE 0
*****************
*  ShowPattern  *
ShowPattern:      lea     $00F02200,a0
                  move.l  #GraphicScreen,(a0)
                  move.l  #PITCH0|PIXEL16|WIN80|XADD_PHRASE,4(a0)
                  move.w  d7,d0
                  lsl.w   #3,d0            ; y
                  swap    d0
                  move.w  d6,d0            ; x
                  lsl.w   #3,d0
                  move.l  d0,$000C(a0)     ; pel ptr
;-----------------
                  move.l  #1<<16|(-8&$FFFF),$0010(a0) ; step
                  move.l  #0,$0014(a0)     ; step frac
                  move.l  #0,$0018(a0)     ; pel ptr frac
;-----------------
                  move.w  d5,d0
                  and.w   #7,d0
                  ext.l   d0
                  lsl.l   #7,d0
                  add.l   #Pattern,d0
                  move.l  d0,$0024(a0)

                  move.l  #$8000|PITCH0|PIXEL16|WIN8|XADD_PHRASE,$0028(a0)
                  move.l  #$0000003F,$002C(a0)
                  moveq   #0,d0
                  move.l  d0,$0030(a0)     ; win ptr
                  move.l  d0,$0034(a0)     ; step
;-----------------
                  move.l  #8<<16|8,$003C(a0) ; counter
;-----------------
                  move.l  #UPDA1|SRCEN|BLIT_LFU_REPLACE,d0
ok:
                  move.l  d0,$0038(a0)
wait_sp:          move.l  $0038(a0),d0
                  lsr.w   #1,d0
                  bcc.s   wait_sp
                  rts
*****************
                ENDIF
*****************
*    InitGPU    *
InitGPU:          movem.l d0-d1/a0-a2,-(sp)
                  lea     $00F02110,a0
                  moveq   #0,d0
                  move.w  #$3E00,d0
                  move.l  d0,-$0010(a0)
                  lea     GPUcode+4(pc),a1
                  moveq   #0,d0
                  move.l  d0,4(a0)         ; GPU halt
                  movea.l (a1)+,a2
                  move.l  a2,(a0)
                  move.l  (a1)+,d1         ; Lnge in Bytes
                  lsr.l   #2,d1
copy_gpu:         move.l  (a1)+,(a2)+
                  dbra    d1,copy_gpu
                  sub.l   #$00010000,d1
                  bpl.s   copy_gpu
                  movem.l (sp)+,d0-d1/a0-a2
                  rts
*****************
*  LynxPAL2RGB  *
_FDA0:         DC.B $00,$05,$04,$05,$06,$07,$0A,$0B,$0D,$0E,$0F,$06,$09,$07,$0A,$0A
_FDB0:         DC.B $00,$74,$34,$55,$56,$99,$9A,$CC,$CD,$FF,$AF,$95,$B7,$A6,$AB,$C9
LynxPAL2RGB:      movem.l d0-d3/a0-a2,-(sp)
                  lea     _FDA0(pc),a0
                  lea     _FDB0(pc),a1
contLP:           lea     $00F00400+16*2,a2
                  moveq   #15,d3
LynxPAL2RGB1:     move.b  (a1)+,d0         ; BBBbRRRr
                  moveq   #$0F,d1
                  and.w   d0,d1
                  moveq   #12,d2

                  lsl.w   d2,d1            ; RRRRrXXXXxXXXXXx
                  and.w   #$00F0,d0
                  lsl.w   #3,d0
                  or.w    d1,d0            ; RRRRrBBBBbXXXXXx
                  moveq   #$0F,d1
                  and.b   (a0)+,d1
                  lsl.w   #2,d1
                  or.w    d1,d0
                  bset    #0,d0
;                  or.w    #%100001000011,d0
                  move.w  d0,(a2)+
                  dbra    d3,LynxPAL2RGB1
                  movem.l (sp)+,d0-d3/a0-a2
                  rts
******************
* Init- und Hilfsroutine fr den Bildschirm
* (c) 1994 Bastian Schick
*****************
* Objekt-Defs   *
NEXT_OBJ         EQU 1
***************************************
* BitMap oder Scaled BitMap - Objekte *
***************************************
                RSRESET
                RS.w obj_bm_type                ; Type
                RS.w obj_bm_l                   ; Gre des Objektes (fr MakeOBL)
                RS.l obj_bm_data                ; Data
                RS.w obj_bm_x                   ; X
                RS.w obj_bm_y                   ; Y pos in Halbzeilen
                RS.w obj_bm_height              ; Hhe ODER cc bei BRANCH OBJECT
                RS.w obj_bm_link                ; Abstand zum Nchsten Objekt in Objekten
                RS.b obj_bm_bits                ; Bits pro Pixel
                RS.b obj_bm_pitch               ; Pitch
                RS.w obj_bm_dwidth              ; Breite in Phrases
                RS.w obj_bm_iwidth              ; Bildbreite (sichtbar)
                RS.b obj_bm_cindex              ; Farb-Offset
                RS.b obj_bm_flags               ; Flags
                RS.w obj_bm_firstpx             ; FirstPixel
obj_bm_len      EQU RSCOUNT
                RS.b obj_dummy1
                RS.b obj_sc_rem
                RS.b obj_sc_vscale
                RS.b obj_sc_hscale              ; Ergnzungen fr Scaled BitMap
obj_sc_len      EQU RSCOUNT

**************
* GPU-Object *
**************
                RSRESET
                RS.w obj_gp_type
                RS.w obj_gp_l                   ; Gre des Objektes (fr MakeOBL)
                RS.l obj_gp_data1
                RS.l obj_gp_data2
                RS.w obj_gp_link

obj_gp_len      EQU RSCOUNT
*****************
* Branch-Object *
*****************
                RSRESET
                RS.w obj_br_type
                RS.w obj_br_l                   ; Gre des Objektes (fr MakeOBL)
                RS.w obj_br_y
                RS.w obj_br_cc                  ; Bedingung
                RS.w obj_br_link,2
obj_br_len      EQU RSCOUNT

BRA_OBJ         MACRO ; y_pos,cc,dest
                dc.w 3,obj_br_len
                dc.w \1         ; y
                IFNE "\2"="<"
                dc.w 1
                ELSE
                IFNE "\2"=">"
                dc.w 2
                ELSE
                IFNE "\2"="="
                dc.w 0
                ENDIF
                ENDIF
                ENDIF
                dc.w \3,NEXT_OBJ
                ENDM

***************
* Stop-Object *
***************
                RSRESET
                RS.w obj_st_type
                RS.w obj_st_l
                RS.w obj_st_int
                RS.l obj_st_data1
                RS.l obj_st_data2
obj_st_len      EQU RSCOUNT
*****************
*    MakeOBL    *
NO_SCALED       EQU 0

MakeOBL:          movem.l d0-a4,-(sp)

                  move.l  #$FF000000,d4

;>                  lea     OBL0(a6),a0      ; for re-init
;>                  lea     OBL(a6),a1
                lea OBL0,a0
                lea OBL,a1
                  lea     (a1),a4          ; start merken
                  moveq   #0,d7            ; object counter

                  lea     Objekte(pc),a2    ; source
loop_mo:          lea     (a2),a3          ; Ptr auf akt. Objekt retten
                  movem.w (a2)+,d1/d5      ; Type
                  tst.w   d1
                  bpl.s   ok_mo
                  cmp.w   #$AFFE,d1
                  beq     exit_mo
                  lea     -4(a2,d5.w),a2
                  bra.s   loop_mo

ok_mo:            addq.w  #1,d7
                  and.w   #7,d1
                  ext.l   d1
                  move.w  d1,d0
                  subq.w  #2,d0
                  bmi     bm_sc_mo
                  beq     gpu_mo           ; 2=GPU-Object
                  subq.w  #2,d0
                  bmi.s   branch_mo        ; 3=Branch Object
* Stop-Objekt erzeugen
                  moveq   #1,d0
                  and.w   (a2)+,d0
                  lsl.w   #3,d0
                  or.w    d0,d1            ; Interrupt Flag
                  movem.l (a2)+,d0/d2

                  lsl.l   #4,d2
                  or.l    d2,d1
                  move.l  d0,(a0)+
                  move.l  d1,(a0)+
 IFNE NO_SCALED
                  addq.l #8,a0
                  lea 16(a1),a1
 ELSE
                  lea     24(a0),a0
                  lea     32(a1),a1
 ENDIF
                  bra.s   loop_mo
* branch_object
branch_mo:        move.w  #$07FF,d0
                  and.w   (a2)+,d0
                  lsl.w   #3,d0
                  or.w    d0,d1            ; Ypos
                  moveq   #7,d0
                  and.w   (a2)+,d0
                  swap    d0
                  lsr.l   #2,d0
                  or.l    d0,d1            ; CC

                  move.l  a1,d3            ; akt. Pos merken
                  move.w  (a2)+,d0         ; nchstes Objekt falls CC true
                  bpl.s   ok_bra_mo
                  neg.w   d0
                  move.l  a4,d3            ; sonst absolute
ok_bra_mo:
 IFNE NO_SCALED
                  asl.w   #4,d0
 ELSE
                  asl.w   #5,d0            ; * 32
 ENDIF
                  ext.l   d0
                  add.l   d3,d0
                  lsr.l   #3,d0
                  ror.l   #8,d0
                  move.l  d0,d3
                  and.l   d4,d0
                  or.l    d0,d1            ; Link (24..31)
                  move.l  d3,d0
                  and.l   #$00FFFFFF,d0
                  move.l  d0,(a0)+
                  move.l  d1,(a0)+

                  move.w  #($07FF<<3)|3,d1 ; Branch Always
                  ext.l   d1
                  move.w  (a2)+,d0         ; nchstes Objekt
 IFNE NO_SCALED
                  asl.w   #4,d0
 ELSE
                  asl.w   #5,d0            ; * 32
 ENDIF
                  ext.l   d0
                  add.l   a1,d0
                  lsr.l   #3,d0
                  ror.l   #8,d0
                  move.l  d0,d3
                  and.l   d4,d0
                  or.l    d0,d1            ; Link (24..31)
                  move.l  d3,d0
                  and.l   #$00FFFFFF,d0
                  move.l  d0,(a0)+
                  move.l  d1,(a0)+
 IFNE NO_SCALED
                  lea 16(a1),a1
 ELSE
                  lea     16(a0),a0
                  lea     32(a1),a1
 ENDIF
                  bra     loop_mo
* GPU Object
gpu_mo:           movem.l (a2)+,d0/d1
                  and.w   #$FFF8,d1
                  addq #2,d1
                  move.l  d0,(a0)+
                  move.l  d1,(a0)+

                  move.w  #($07FF<<3)|3,d1 ; Branch Always
                  ext.l   d1
                  move.w  (a2)+,d0         ; nchstes Objekt
 IFNE NO_SCALED
                  asl.w #4,d0
 ELSE
                  asl.w #5,d0            ; * 32
 ENDIF
                  ext.l   d0
                  add.l   a1,d0
                  lsr.l   #3,d0
                  ror.l   #8,d0
                  move.l  d0,d3
                  and.l   d4,d0
                  or.l    d0,d1            ; Link (24..31)
                  move.l  d3,d0
                  and.l   #$00FFFFFF,d0
                  move.l  d0,(a0)+
                  move.l  d1,(a0)+
 IFNE NO_SCALED
                  lea 16(a1),a1
 ELSE
                  lea     16(a0),a0
                  lea     32(a1),a1
 ENDIF
                  bra     loop_mo

* BitMap oder Scaled BitMap
bm_sc_mo:         moveq   #$F8,d0
                  and.l   (a2)+,d0         ; Data-Adress (3..23)
                  bpl.s   ok_bm_sc_mo
                  neg.l d0
                  add.l   a6,d0
ok_bm_sc_mo:      lsl.l   #8,d0            ; an 63..43

                  move.w  (a2)+,d6         ; X
                  and.w   #$0FFF,d6        ; im 2. Phrase 0..11
                  ext.l   d6

                  move.w  (a2)+,d3
                  and.w   #$07FF,d3
                  lsl.w   #3,d3
                  or.w    d3,d1            ; Y-Pos (3..13)

                  moveq   #0,d3
                  move.w  (a2)+,d3
                  and.w   #$03FF,d3
                  swap    d3
                  lsr.l   #2,d3
                  or.l    d3,d1            ; Hhe (14..23)

                  move.w  (a2)+,d3         ; nchstes Objekt
 IFNE NO_SCALED
                  asl.w #4,d3
 ELSE
                  asl.w #5,d3            ; * 32
 ENDIF
                  ext.l   d3
                  add.l   a1,d3
                  lsr.l   #3,d3
                  ror.l   #8,d3
                  move.l  d3,d2            ; Link retten
                  and.l   d4,d3
                  or.l    d3,d1            ; Link (24..31)

                  move.l  d2,d3
                  and.l   #$00FFFFFF,d3
                  or.l    d3,d0
                  move.l  d0,(a0)+
                  move.l  d1,(a0)+

                  moveq   #7,d0
                  and.b   (a2)+,d0
                  ror.w   #4,d0
                  or.w    d0,d6            ; Depth (12..14)

                  moveq   #7,d0
                  and.b   (a2)+,d0
                  swap    d0
                  lsr.l   #1,d0
                  or.l    d0,d6            ; Pitch (15..17)

                  moveq   #0,d0
                  move.w  (a2)+,d0
                  and.w   #$03FF,d0
                  lsl.w   #2,d0
                  swap    d0
                  or.l    d0,d6            ; Dwidth (18..27)

                  moveq   #0,d0
                  move.w  (a2)+,d0
                  and.w   #$03FF,d0
                  ror.l   #4,d0
                  move.l  d0,d1
                  clr.w   d0
                  or.l    d0,d6            ; IWidth (28..31)
                  ext.l   d1               ; und (32..37)

                  move    #$FE,d0
                  and.b   (a2)+,d0
                  lsl.w   #5,d0
                  or.w    d0,d1            ; Index (38..44)

                  moveq   #$0F,d0
                  and.b   (a2)+,d0
                  swap    d0
                  lsr.l   #3,d0
                  or.l    d0,d1            ; Flags (45..48)

                  moveq   #$3F,d0
                  and.w   (a2)+,d0

                  add.w   d0,d0
                  swap    d0
                  or.l    d0,d1
                  move.l  d1,(a0)+
                  move.l  d6,(a0)+
 IFNE NO_SCALED
                  lea 16(a1),a1
 ELSE
                  lea     16(a0),a0
                  lea     32(a1),a1
                  cmp.w   #obj_sc_len,d5   ; Sized Object
                  bne     loop_mo
                  move.l  (a2)+,-12(a0)
;                  move.b  d0,-8(a0)
;                  move.b  d1,-9(a0)
;                  move.b  d2,-10(a0)
;                  clr.b   -11(a0)
 ENDIF
                  bra     loop_mo
exit_mo:          clr.l   (a0)+
                  moveq   #4,d0
                  move.l  d0,(a0)+
                  addq.w  #1,d7
                  move.w  d7,count_obj(a6)
                  movem.l (sp)+,d0-a4
                  rts
*****************
*    CopyOBL    *
                LOCAL
CopyOBL::         movem.l d1/a0,-(sp)
;>                  lea     OBL(a6),a0
;>                  lea     OBL0(a6),a1
                lea OBL,a0
                lea OBL0,a1
                  move.w  count_obj(a6),d1
.loop
                  move.l  (a1)+,(a0)+
                  move.l  (a1)+,(a0)+
                  move.l  (a1)+,(a0)+
                  move.l  (a1)+,(a0)+
 IFEQ NO_SCALED
                  move.l  (a1)+,(a0)+
                  move.l  (a1)+,(a0)+
                  move.l  (a1)+,(a0)+
                  move.l  (a1)+,(a0)+
 ENDIF
                  dbra    d1,.loop
                  movem.l (sp)+,d1/a0
                  rts
*****************
*     InitOP    *
InitOP:           lea     $F00000,a0
                  moveq #$fe,d0
                  and.w  a_vde(a6),d0

                  lea bra1+obj_br_y(pc),a1      ; branch if count > vde
                  move.w d0,(a1)
                  lea bra2+obj_br_y(pc),a1      ; branch if count = vde (GPU-Object)
                  move.w d0,(a1)

;>                  move.w  d0,$4E(a0)

;>                  addq.w #1,d0
;>                  move.w  d0,$48(a0)            ; vde

                  bsr     MakeOBL
                  bsr     CopyOBL
                  move.l #OBL,d0
                  swap    d0
                  move.l  d0,$20(a0)
                  move.w #VID_MODE,$28(a0)
                  lea     my_irq(pc),a1
                  move.l  a1,$0100.w
                  move.w #$2000,sr
                  move.l  #$1F02<<16,$E0(a0)
                  rts
*****************
*    objekt     *
Y_POS           equ 20
Objekte:

* 0
                BRA_OBJ 30,<,-10              ; y<30 => STOP
bra1            BRA_OBJ 600,>,-10              ; y>500 => STOP
* 2
bra2            BRA_OBJ 600,=,-9             ; GPU_OBJ
* 3

                DC.W 1,obj_sc_len
pPhobyx:        DC.L 0                     ;Phobyx
                DC.W 20,Y_POS+45-2
                DC.W 102-1
                DC.W NEXT_OBJ
                DC.B 2,1                   ; 4 Bit, Pitch 1
                DC.W 160/2/8,160/2/8
                DC.B $10,0
                DC.W 0
                DC.B 0,$40,$40,$40
* 4
* Score-Screen
                DC.W 0,obj_bm_len
                DC.L ScoreScreen
                DC.W 24,Y_POS+45              ; x_start,y_start
                DC.W score_max_y           ; Hhe
                DC.W NEXT_OBJ
                DC.B 0,1                   ; 1 Bit Farbtiefe
                DC.W score_max_x>>6,score_max_x>>6
                DC.B $0,4                   ; transparent
                DC.W 0
* 5
                DC.W 0,obj_bm_len
                DC.L GraphicScreen
                DC.W 320/2-max_x/2+28,Y_POS+45 ;3*8*2
                DC.W max_y
                DC.W NEXT_OBJ
                DC.B 4,1
                DC.W max_x*2/8,max_x*2/8
                DC.B 0,0
                DC.W 0
* 6
                DC.W 0,obj_bm_len
                DC.L GraphicScreen2
                DC.W 320/2-max_x/2+28,Y_POS+45 ;3*8*2
                DC.W max_y
                DC.W NEXT_OBJ
                DC.B 4,1
                DC.W max_x*2/8,max_x*2/8
                DC.B 0,4
                DC.W 0
* 7
                dc.w 0,obj_bm_len
pCredits        dc.l 0
                dc.w 20,Y_POS+45-2+102<<2
                dc.w 32
                dc.w NEXT_OBJ
                dc.b 0,1
                dc.w 320>>6,320>>6
                dc.b $10,0
                dc.w 0
* 8
                dc.w 4,obj_st_len
                dc.w 0
                dc.l 0,0
* 9
                dc.w 2,obj_gp_len
                dc.l 0,0
                dc.w NEXT_OBJ


                DC.W $AFFE                 ; generates STOPOBJ

*****************
*   videoinit   *

; THESE ARE THE NTSC DEFINITIONS
ntsc_width      EQU 1409
ntsc_hmid       EQU 823

ntsc_height     EQU 241
ntsc_vmid       EQU 266

; THESE ARE THE PAL DEFINITIONS
pal_width       EQU 1381
pal_hmid        EQU 843

pal_height      EQU 287
pal_vmid        EQU 322

VideoInit:        movem.l d0-d3/a0,-(sp)
                  lea     $00F00000,a0
                  move.w  #322-287,d0      ; vdb
                  move.w  #322+287,d1      ; vde
                  move.w  #(1381+28)>>1-1|$0400,d2 ; hde
                  move.w  #843-(1381+28)>>1+4,d3 ; hdb
                  btst    #4,$00F14003
                  beq.s   VideoInit1       ; =0 => PAL
                  move.w  #266-241,d0
                  move.w  #266+241,d1
                  move.w  #(1409>>1-1)|$0400,d2
                  move.w  #823-(1409>>1)+4,d3
VideoInit1:       move.w  d0,$0046(a0)
                  move.w  #$ffff,$0048(a0)
;>                  move.w  d1,$0048(a0)
                  move.w  d2,$003C(a0)
                  move.w  d3,$0038(a0)
                  move.w  d3,$003A(a0)
                  move.w  d0,a_vdb(a6)
                  move.w  d1,a_vde(a6)
                  movem.l (sp)+,d0-d3/a0
                  rts
*****************
*****************
*       IRQ     *
my_irq:
                  movem.l d0/a6,-(sp)
                  btst    #1,$00F000E1          ; GPU-Interrupt ?
                  beq.s   no_timer
                  move.w d0,$f000e2

                  bsr     PLAYER+28+4
                  bsr Keyboard
                  bsr GetKey
                  move.l d0,LastJoy

                  lea vars,a6
                  move.l  LastJoy,d0
                  and.l   #$00010001,d0
                  cmp.l   #$00010001,d0
                  seq     ResetFlag(a6)
no_timer:         move.l  #$0202<<16,$00F000E0
                  movem.l (sp)+,d0/a6
                  rte
*****************
*    Back-gfx   *
                myALIGN.P
Phobyx:         INLINE 'TETRIS\PHOBYX.PIC'

*****************
* Credits       *
                myALIGN.P
Credits:        inline 'tetris\credit.dat'

*****************
*    GPU-Code   *
                myALIGN.P

GPUcode:        INLINE 'TETRIS\TETRIS.O'
                EVEN
*****************
*  MOD-Player   *
                PATH 'E:\BJL\'
; MOD-Replayer (c) 1994 by Mark Fechtner
; Init : Call PLAYER ;A0 ptr to MOD
;        Call PLAYER+32 during VBL

PLAYER:         INLINE 'REPLAYER.PRG'
*****************
                PATH '\BJL\'
mod:
                INLINE 'BUBSY2.MOD'

jag_end:

