#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tgadefs.h"

extern int dither_flag;			/* flag for dithering (1 if we should dither) */

extern unsigned char cry[];		/* cry lookup table */
extern unsigned short cryred[],crygreen[],cryblue[];	/* lookup tables for cry->rgb conversion */

static INLINE void
diffuse_error(Pixel newcolor, Pixel origcolor, Pixel *where, long linelen)
{
	int	err;
	int	x;

/* diffuse error in red */
	err = (int)origcolor.red - (int)newcolor.red;
	x = where[1].red + ((7*err)>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[1].red = x;

	x = where[linelen-1].red + ((3*err)>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[linelen-1].red = x;

	x = where[linelen].red + ((5*err)>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[linelen].red = x;

	x = where[linelen+1].red + (err>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[linelen+1].red = x;

/* diffuse error in green */
	err = (int)origcolor.green - (int)newcolor.green;
	x = where[1].green + ((7*err)>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[1].green = x;

	x = where[linelen-1].green + ((3*err)>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[linelen-1].green = x;

	x = where[linelen].green + ((5*err)>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[linelen].green = x;

	x = where[linelen+1].green + (err>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[linelen+1].green = x;

/* diffuse error in blue */
	err = (int)origcolor.blue - (int)newcolor.blue;
	x = where[1].blue + ((7*err)>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[1].blue = x;

	x = where[linelen-1].blue + ((3*err)>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[linelen-1].blue = x;

	x = where[linelen].blue + ((5*err)>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[linelen].blue = x;

	x = where[linelen+1].blue + (err>>4);
	if (x < 0) x = 0;
	if (x > 255) x = 255;
	where[linelen+1].blue = x;
}

static INLINE Pixel
do_cry(Pixel *newdata,unsigned char red, unsigned char green, unsigned char blue, int line, int column, unsigned image_w, unsigned image_h)
{
	int intensity;
	unsigned int color_offset;		/* offset for cry lookup table */
	unsigned int result;
	unsigned int rcomp,gcomp,bcomp;
	long linelen = image_w;
	Pixel oldcolor, newcolor, *where;

	intensity = red;				/* start with red */
	if(green > intensity)
		intensity = green;
	if(blue > intensity)
		intensity = blue;			/* get highest RGB value */
	if(intensity != 0)
	{
		rcomp = (unsigned int)red * 255 / intensity;
		gcomp = (unsigned int)green * 255 / intensity;
		bcomp = (unsigned int)blue * 255 / intensity;
	}
	else
		rcomp = gcomp = bcomp = 0;		/* R, G, B, were all 0 (black) */

	color_offset = (rcomp & 0xF8) << 7;
	color_offset |= (gcomp & 0xF8) << 2;
	color_offset |= (bcomp & 0xF8) >> 3;		/* now we have offset for cry table */

	result = ((color_offset = cry[color_offset]) << 8) | (intensity & 0x00ff);

/* now convert back from CRY */

	oldcolor.red = red;
	oldcolor.green = green;
	oldcolor.blue = blue;

	newcolor.red = (intensity*cryred[color_offset]) >> 8;
	newcolor.green = (intensity*crygreen[color_offset]) >> 8;
	newcolor.blue = (intensity*cryblue[color_offset]) >> 8;

	if (dither_flag) {
		if (column >= 3 && column < linelen - 3 && line < image_h - 1) {
			where = &newdata[line*linelen + column];
			diffuse_error(newcolor, oldcolor, where, linelen);
		}
	}

	return newcolor;
}

Pixel *
convertCRY(Pixel *newdata, unsigned image_w, unsigned image_h)
{
	unsigned red, green, blue;
	long linelen = image_w;
	Pixel *newpix, *newpixptr;
	unsigned line, column;

	newpixptr = newpix = calloc(image_w*(size_t)image_h, sizeof(Pixel));
	if (!newpix) return 0;

	for(line = 0; line < image_h; line++)
	{
		for(column = 0; column < image_w; column++)
		{
			blue = newdata[line * linelen + column].blue;
			green = newdata[line * linelen + column].green;
			red = newdata[line * linelen + column].red;
			*newpixptr++ = do_cry(newdata, red,green,blue,line,column,image_w,image_h);
		}
	}

	return newpix;
}

