
* BADBLIT - Hacked from pblit.s by Roy Stedman @ Atari 9/13/91

* - BLT.S - Blitter test program 
*       Dec 17, 87:     .prod conditional for manufac or field service
*       Dec 1, 87       don't turn green!
*       Nov 18, 87      added missing HOP function test.
*       OCT 16, 87      error codes changed to G_.
*       aug 29, 87      adapt for field service cart
*	       beefed up RAM test, op test (and fix bug in op decode).
*       april 20, 1987  endmask, op, hop, fxsr, skew forward, reverse, smudge
* - PBLIT -
* v2 :	Sep 9, 91 : RWS : hacked up for testing a bad combo chip.

	.include	"var.s"
	.include	"hardware.s"
	.include	"Super.s"

lin_span equ    40	;line span in words

b_halft equ     0	;32 bytes RAM
b_snxwd equ     $20	;source x inc
b_swrap equ     $22	;source y inc
b_sadd  equ     $24	;source address
b_f1msk equ     $28
b_ctmsk equ     $2a
b_f2msk equ     $2c
b_dnxwd equ     $2e	;destination x inc
b_dwrap equ     $30	;destination y inc
b_dadd  equ     $32	;destination address
b_dspan equ     $36	;x count
b_ht    equ     $38	;y count
b_hop   equ     $3a	;Halftone OPerations
hop0    equ     0	;use all ones
hop1    equ     1	;use halftone ram
hop2    equ     2	;use source
hop3    equ     3	;use source & halftone
b_op    equ     $3b	;logic OPerations
b_line  equ     $3c     ;7=busy, 6=hog, 5=smudge, 3-0=line number
b_skew  equ     $3d     ;7=fxsr, 6=nfsr, 3-0=skew

	.text
start:
	Super
blttst: clr.b   erflg0
	clr.b   erflg1
got_blt:
*       set up parameters for display memory (blt register values)
blt_init:
	lea     blt,a6
	moveq   #2,d1
	bsr     blt_inc	 ;set up blt increment registers
	move.b  v_shf_mod,d0
	andi    #3,d0
	lsl     d0
	move    #400,n_lines    	; # of lines
	move    #lin_span,dspan
	move    #0,b_line(a6)   	;init control word (skew and line number)
	
*--------------------------------
*       skew test
*       blt from word aligned source to non-aligned dest
skewstart:
	move.b  #3,b_op(a6)     	;op=source
	move.b  #hop2,b_hop(a6) 	;hop=source
	move    #$ffff,b_f1msk(a6)      
	move    #$ffff,b_ctmsk(a6)
	move    #$ffff,b_f2msk(a6)

*       shift 15 bits to the right, blt from left to right
*       also test nfsr 
*       s = aaaa,...    d = 1555,5555,...,5554
skewmove:
	moveq   #0,d0
	lea     dram,a0
	move    dspan,d1	
	bsr     bfill	   	;fill destination with 0's
	move    cpvalue,d0
	lea     sram,a0
	bsr     bfill	   	;fill source with 1's

	move.b	skewdist,b_skew(a6)	; flush (write w/o read) (was $4f)
	add     #1,dspan	;extra write
	move    #1,b_ht(a6)     ;no. of lines
	bsr     blast	   	;blast away
skewdone:
sb:
;	bsr     sk_cmp	  	;and verify
;	beq     ht_gd
	bset    #4,erflg0
ht_gd:
blt_end:
*       print pass/fail and go home (RED screen = BAD)
	move.b  erflg0,d0
	or.b    erflg1,d0
	beq     bltpas
bad_blt:
	move    #red,palette
bltpas:
	rts

*--------------------------------
*       let 'er rip
*       exit:   ne if error, erflg1 bits 2 or 3 set
blast:  move.l  #dram,b_dadd(a6) 	;re-init values changed by blaster
	move.l  #sram,b_sadd(a6)
	move    dspan,b_dspan(a6)
	bset    #7,b_line(a6)
	move.l  #$100000,d7
wt_blt: btst    #7,b_line(a6)
	beq     blt_don
	subq    #1,d7
	bne     wt_blt
	bset    #2,erflg1
	andi    #$1f,ccr
blt_don:
	rts

*-------------------------------
*       init blt inc registers
*       d1 = init value
blt_inc:
	move    d1,b_snxwd(a6)  ; inc to next word, same line
	move    d1,b_dnxwd(a6)
	move    d1,b_swrap(a6)  ; inc to first word, next line
	move    d1,b_dwrap(a6)
	rts

*--------------------------------
*       compare skew test
*       compare dest data to masks
*       exit:   eq if pass
sk_cmp: lea     dram,a0	 	;start address
	move    dspan,d7
	subq    #3,d7	   	;number of words in middle
	cmpi    #1,(a0)+	;1st word skewed 15 bits
	bne     sk_out
sk_cm1: cmpi    #$5555,(a0)+
	bne     sk_out
	dbra    d7,sk_cm1
	cmpi    #$5554,(a0)+    ;last word skewed 15 bits
sk_out: rts

*----------------------------------
*       Fill a block with a word
*       d0.w = data
*       d1.w = size (words)
*       a0 = start
*       exit:   registers preserved
bfill:  movem.l d1/a0,-(sp)
	subq    #1,d1
bfill0: move.w  d0,(a0)+
	dbra    d1,bfill0
	movem.l (sp)+,d1/a0
	rts
* -------------------------------------
* VARIABLES

cpvalue:	dc.w	$aaaa
skewdist:	dc.b	$4F
.fill:		dc.b	$00
	.bss
	.abs $70000

sram:	ds.b	$10000
dram:	ds.b	$10000
