
*       Blitter test program
*       Dec 17, 87:     .prod conditional for manufac or field service
*       Dec 1, 87       don't turn green!
*       Nov 18, 87      added missing HOP function test.
*       OCT 16, 87      error codes changed to G_.
*       aug 29, 87      adapt for field service cart
*	       beefed up RAM test, op test (and fix bug in op decode).
*       april 20, 1987  endmask, op, hop, fxsr, skew forward, reverse, smudge

	.include	"var.s"
	.include	"hardware.s"
	.include	"Super.s"

lin_span equ    40	      ;line span in words

b_halft equ     0	       ;32 bytes RAM
b_snxwd equ     $20	     ;source x inc
b_swrap equ     $22	     ;source y inc
b_sadd  equ     $24	     ;source address
b_f1msk equ     $28
b_ctmsk equ     $2a
b_f2msk equ     $2c
b_dnxwd equ     $2e	     ;destination x inc
b_dwrap equ     $30	     ;destination y inc
b_dadd  equ     $32	     ;destination address
b_dspan equ     $36	     ;x count
b_ht    equ     $38	     ;y count
b_hop   equ     $3a	     ;Halftone OPerations
hop0    equ     0	       ;use all ones
hop1    equ     1	       ;use halftone ram
hop2    equ     2	       ;use source
hop3    equ     3	       ;use source & halftone
b_op    equ     $3b	     ;logic OPerations
b_line  equ     $3c     ;7=busy, 6=hog, 5=smudge, 3-0=line number
b_skew  equ     $3d     ;7=fxsr, 6=nfsr, 3-0=skew

;dram    equ     $90000
;sram    equ     $80000
dram     equ     $70000
sram     equ     $60000

	.text

	Super
blttst: clr.b   erflg0
	clr.b   erflg1
got_blt:
*       set up parameters for display memory (blt register values)
blt_init:
	lea     blt,a6
	moveq   #2,d1
	bsr     blt_inc	 ;set up blt increment registers
	move.b  v_shf_mod,d0
	andi    #3,d0
	lsl     d0
	move    #400,n_lines    	; # of lines
	move    #lin_span,dspan
	move    #0,b_line(a6)   	;init control word (skew and line number)
	
*--------------------------------
*       skew test
*       blt from word aligned source to non-aligned dest

tst_sk: move.b  #3,b_op(a6)     	;op=source
	move.b  #hop2,b_hop(a6) 	;hop=source
	move    #$0001,b_f1msk(a6)      
	move    #$ffff,b_ctmsk(a6)
	move    #$fffe,b_f2msk(a6)

*       shift 15 bits to the right, blt from left to right
*       also test nfsr 
*       s = aaaa,...    d = 1555,5555,...,5554
	moveq   #0,d0
	lea     dram,a0
	move    dspan,d1	
	bsr     bfill	   	;fill destination with 0's
	move    #$aaaa,d0
	lea     sram,a0
	bsr     bfill	   	;fill source with 1's
	move.b  #$4f,b_skew(a6) ;flush (write w/o read)
	add     #1,dspan	;extra write
	move    #1,b_ht(a6)     ;no. of lines
	bsr     blast	   	;blast away
	bsr     sk_cmp	  	;and verify
	beq     ht_gd
	bset    #4,erflg0
ht_gd:

*       force extra source read
*       s = 1234,1234,1234,1234,5555
*       d =    4123,4123,4123,4555
fxsr:   lea     sram,a0	 ;fill source
	move    #$1234,d0
	moveq   #3,d7   
fxsr0:  move    d0,(a0)+	;4 words of 1234
	dbra    d7,fxsr0
	move    #$5555,(a0)     ;end word
	move.b  #$84,b_skew(a6) ;fxsr, nfsr and shift 4
	move    #1,b_ht(a6)     ;1 line
	move    #4,dspan	;line length
	lea     dram,a0
	move    #$10,d1
	moveq   #0,d0
	bsr     bfill	   	;clear dest
	move    #$ffff,b_f1msk(a6)      
	move    #$ffff,b_ctmsk(a6)
	move    #$ffff,b_f2msk(a6)
	bsr     blast	   	;blast out a line
	lea     dram,a0	 	;check result
	moveq   #$2,d7
fxsr1:  cmpi    #$4123,(a0)+    ;check 3 words
	bne     fxsrf
	dbra    d7,fxsr1
	cmpi    #$4555,(a0)+    ;check last word
	beq     sk2
fxsrf:  bset    #5,erflg0

*       blt from right to left
*       s = aaaa,aaaa,...       d = 1555,5555,...,5554
sk2:
	move    #-2,d1
	bsr     blt_inc	 ; write inc reg
	move    #$fffe,b_f1msk(a6)      
	move    #$ffff,b_ctmsk(a6)
	move    #$0001,b_f2msk(a6)
	move    #$aaaa,d0
	move    #80,d1
	lea     sram,a0
	bsr     bfillr	  	;fill source
	moveq   #0,d0
	lea     dram,a0
	add     #$10,d1
	bsr     bfillr	  	;fill destination with 0's
	move    #2,b_ht(a6)     ;no. of lines
	move.b  #$4f,b_skew(a6)
	bsr     blast	   	;blast out data
	bsr     skr_cmp
	beq     smudg
	bset    #6,erflg0
smudg:
blt_end:
	move.b  erflg1,d3
	lsl     #8,d3
	move.b  erflg0,d3
	moveq   #0,d1	   	;bit ptr
	moveq   #0,d2
	lea     bmsgtb(pc),a0   ;message ptr
blte0:  btst    d1,d3	   	;test error bit
	beq     blte1
	move.l  0(a0,d2),a5     ;print message if set
;	bsr     dspmsg
blte1:  add.l   #4,d2	   	;add to message ptr index
	addq    #1,d1	   	;bump bit ptr
	cmp.l   #bmsgte,d2
	blt     blte0

*       print pass/fail and go home
	move.b  erflg0,d0
	or.b    erflg1,d0
	beq     bltpas
bad_blt:
	move    #red,palette
;	lea     falmsg,a5
	bra     blt_ex

bltpas:
;	lea     pasmsg,a5
blt_ex: ;bsr     dsppf	   	;if field service, don't change color,
	rts

bmsgtb: dc.l    htrfm	   	;erflg0
	dc.l    em_flm
	dc.l    op_fail
	dc.l    ht_fail
	dc.l    sk_fail
	dc.l    fx_fail
	dc.l    sk2_fail
	dc.l    smg_fail
	dc.l    xf_msg	  	;erflg1
	dc.l    yf_msg
	dc.l    b_to
	dc.l    b_addcnt
bmsgte  equ     *-bmsgtb

*--------------------------------
*       let 'er rip
*       exit:   ne if error, erflg1 bits 2 or 3 set
blast:  move.l  #dram,b_dadd(a6) 	;re-init values changed by blaster
	move.l  #sram,b_sadd(a6)
	move    dspan,b_dspan(a6)
	bset    #7,b_line(a6)
	move.l  #$100000,d7
wt_blt: btst    #7,b_line(a6)
	beq     blt_don
	subq    #1,d7
	bne     wt_blt
	bset    #2,erflg1
	andi    #$1f,ccr
blt_don:
	rts

*-------------------------------
*       init blt inc registers
*       d1 = init value
blt_inc:
	move    d1,b_snxwd(a6)  ; inc to next word, same line
	move    d1,b_dnxwd(a6)
	move    d1,b_swrap(a6)  ; inc to first word, next line
	move    d1,b_dwrap(a6)
	rts

*--------------------------------
*       compare skew test
*       compare dest data to masks
*       exit:   eq if pass
sk_cmp: lea     dram,a0	 	;start address
	move    dspan,d7
	subq    #3,d7	   	;number of words in middle
	cmpi    #1,(a0)+	;1st word skewed 15 bits
	bne     sk_out
sk_cm1: cmpi    #$5555,(a0)+
	bne     sk_out
	dbra    d7,sk_cm1
	cmpi    #$5554,(a0)+    ;last word skewed 15 bits
sk_out: rts


*--------------------------------
*       compare skew reverse
*       compare dest data to masks
*       exit:   eq if pass
skr_cmp:
	lea     dram,a0	 	;start address
	adda.l  #2,a0	   	;set for pre-dec
	move    dspan,d7
	subq    #3,d7	   	;number of words in middle
	cmpi    #$5554,-(a0)    ;last word skewed 15 bits right
	bne     skr_out
skr_cm1:
	cmpi    #$5555,-(a0)
	bne     skr_out
	dbra    d7,skr_cm1
	cmpi    #1,-(a0)	;1st word skewed 15 bits
skr_out: rts
		
*----------------------------------
*       Fill a block with a word
*       d0.w = data
*       d1.w = size (words)
*       a0 = start
*       exit:   registers preserved
bfill:  movem.l d1/a0,-(sp)
	subq    #1,d1
bfill0: move.w  d0,(a0)+
	dbra    d1,bfill0
	movem.l (sp)+,d1/a0
	rts

*----------------------------------
*       Fill a block with a word, decrement
*       d0.w = data
*       d1.w = size (words)
*       a0 = start
*       exit:   registers preserved
bfillr: movem.l d1/a0,-(sp)
	subq    #1,d1
	adda.l  #2,a0
bfilr0: move.w  d0,-(a0)
	dbra    d1,bfilr0
	movem.l (sp)+,d1/a0
	rts

*       bus error handler
bltbe:  move    #$ff,d7	 	;set flag if bus
	add	#8,sp
	rte
	
	.data

bltmsg:		dc.b	'Testing Blitter',cr,lf,eot
htrfm:  	dc.b	'G1 halftone RAM',cr,lf,eot
em_flm: 	dc.b	'G2 endmask',cr,lf,eot
op_fail: 	dc.b	'G3 operation ',cr,lf,eot
ht_fail: 	dc.b	'G4 halftone op',cr,lf,eot
sk_fail: 	dc.b	'G5 skew',cr,lf,eot
sk2_fail: 	dc.b	'G6 reverse blt',cr,lf,eot
fx_fail: 	dc.b	'G7 force extra source read',cr,lf,eot
smg_fail: 	dc.b	'G8 smudge',cr,lf,eot
xf_msg: 	dc.b	'G9 x count',cr,lf,eot
yf_msg: 	dc.b	'G10 y count',cr,lf,eot
b_to:   	dc.b	'G11 time-out',cr,lf,eot
b_addcnt: 	dc.b	'G12 address count',cr,lf,eot
no_blt: 	dc.b	'No Blitter installed',cr,lf,eot
