* Disk2.s - Rom Based Raw Hardware Disk Testing
* DISK Formatter

* By Roy Stedman @ Atari

* V0.0 : 08NOV91 : RWS : First code from disk1.s (Scrubber)
* V1.0 : 11NOV91 : RWS : Working code W&R one track

	.include "Atari.s"
	.include "FDC.s"
	.include "DiskMac.s"

d0s0	=	$4	; Drive 0, Side 0

Start:
	Super		; Needed for ROM code?

* SetDrive&Side
	move.w	#d0s0,PSGWrite
 
* ClearDMAFIFO
	move.w	#$190,DMAMode
	move.w	#$90, DMAMode	; toggle W/_R
	move.w	#$190,DMAMode
	 
* SetDMAAddress
	move.l	#Buffer,d0
	SetDMAAddr

* AnnoyTOS	; Remove for ROM test	
	move.b	#$ff,$43e	

* Set Buffer
	lea.l	Buffer,a1
	move.l	#1023,d0
.bfill:
	move.l	#$aaaa5555,(a1)+
	dbra	d0,.bfill

SetHeader:
	lea.l	Bdata,a0
	lea.l	Buffer,a1
	move.l	#6,d0
.bfill:
	move.l	(a0)+,(a1)+
	dbra	d0,.bfill

FmtLoop:	  
       	SeekTrack $4f		; last track
	move.w	DISKData,d2	; Errors in D2

* SetDMAAddress
	move.l	#Buffer,d0
	SetDMAAddr
* ClearDMAFIFO
	move.w	#$190,DMAMode
	move.w	#$90, DMAMode	; toggle W/_R
	move.w	#$190,DMAMode
	move.w	#8,$ffff8604	

* Format Track

	move.w	#$180,$ffff8606	;	cmd reg mem -> disk
	nop
	nop
	nop
	nop
	nop
	nop
	move.w	#$f0,$ffff8604	;	write track
.fmt1:
	btst.b	#5,MFPGPIO
	bne	.fmt1
	move.w	DISKData,d2
WriteDone:
	lea.l	Buffer,a1
	move.l	#1023,d0
.bfill:
	move.l	#$FF00FF00,(a1)+
	dbra	d0,.bfill

* SetDMAAddress
	move.l	#Buffer,d0
	SetDMAAddr
* ClearDMAFIFO
	move.w	#$190,DMAMode
	move.w	#$90, DMAMode	; toggle W/_R
;	move.w	#$190,DMAMode
	move.w	#8,$ffff8604	; 2kBytes

	move.w	#$80,$ffff8606	;	cmd reg disk -> mem
	nop
	nop
	nop
	nop
	nop
	nop
	move.w	#$e0,$ffff8604	;	read track
.fmt2:
	btst.b	#5,MFPGPIO
	bne	.fmt2
	move.w	DISKData,d2

DoneRead:

* UnAnnoyTOS	; Remove for ROM test
	move.b	#0,$43e
	
	Pterm0		; Remove for ROM test
	rts

Errors:	dc.w	0

Bdata:	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	$00f5f5f5

	dc.l	$a5a5a5a5
	dc.l	$5a5a5a5a

	.bss

Buffer:
	ds.l	1024

	.end
