
*	HARDWARE EQUATES

userint	equ	$100		;start of user interrupt vectors

mconfig	equ	$ffff8000	;memory configuration register

blt	equ	$ffff8a00		;blitter

*	video registers
v_bas_h	equ	$ffff8201		;video base high
v_bas_m	equ	$ffff8203		;video base mid 
v_bas_l	equ	$ffff820d
vadcnth	equ	$ffff8205		;video address counter
vadcntm	equ	$ffff8207
vadcntl	equ	$ffff8209
synmod	equ	$ffff820a		;sync mode
palette	equ	$ffff8240		;start of color palette
v_shf_mod equ	$ffff8260		;00=4 plane, 01=2 plane, 10=1 plane

*	DMA control
dskctl	equ	$ffff8604		;disk controller access
fifo	equ	$ffff8606		;DMA mode control, status
dmactl	equ	fifo
dmahigh	equ	$ffff8609		;DMA base high
dmamid	equ	$ffff860b
dmalow	equ	$ffff860d

*	Programmable Sound Generator
psgsel	equ	$ffff8800		;register select (W)
psgrd	equ	psgsel		;read data
psgwr	equ	$ffff8802		;write data
porta	equ	14

*************************************************************************
*									*
*	68901 multifunction peripheral chip equates			*
*	(interrupt controller,timers,serial i/o)			*
*									*
*************************************************************************

*	register and base addresses

mfp	equ	$fffffa01	;base address, +1 offset !!!!!!!!

*	system interrupt register offsets

gpip	equ	0			;general purpose i/o
aer	equ	2			;active edge register
ddr	equ	4			;data direction register
iera	equ	6			;interrupt enable register a
ierb	equ	8			;interrupt enable register b
ipra	equ	10			;interrupt pending register a
iprb	equ	12			;interrupt pending register b
isra	equ	14			;interrupt in-service register a
isrb	equ	16			;interrupt in-service register b
imra	equ	18			;interrupt mask register a
imrb	equ	20			;interrupt mask register b
vr	equ	22			;vector register

*	system timer registers offsets

tacr	equ	24			;timer a control register
tbcr	equ	26			;timer b control register
tcdcr	equ	28			;timer c and d control register
tadr	equ	30			;timer a data register
tbdr	equ	32			;timer b data register
tcdr	equ	34			;timer c data register
tddr	equ	36			;timer d data register

*	timer relative locations
atimer	equ	0
btiber	equ	1
ctimer	equ	2
dtimer	equ	3

*	rs232/rs422/async/sync serial i/o registers offsets

scr	equ	38			;sync character register
ucr	equ	40			;usart control register
rsr	equ	42			;receiver status register
tsr	equ	44			;transmitter status register
udr	equ	46			;usart data register

*	6850 ACIA
keyboard equ	$fffffc00
midi	equ	$fffffc04
comstat	equ	$0		;command/status register
iodata	equ	2		;data register

rsetacia equ	%00000011	;reset
div64	equ	%00000010	;clock /64
div16	equ	%00000001	;clock /16

protocol equ	%00010100	;8 bits/1 stop/no parity

rtsld	equ	%00000000	;rts low/int disabled
rtsle	equ	%00100000	;rts low/int enabled
rtshd	equ	%01000000	;rts high/int disabled
rtsbrk	equ	%01100000	;rts low/int disabled/break

intron	equ	%10000000	;interrupts enabled
introff	equ	%00000000	;interrupts disabled

*	ACIA status
rdrf	equ	%00000001
tdre	equ	%00000010
dcd	equ	%00000100
cts	equ	%00001000
fe	equ	%00010000
ovrn	equ	%00100000
pe	equ	%01000000
irq	equ	%10000000

