* Code for NMI button - By Roy Stedman @ Atari 9/6/91

* Enable VME Bus SYSFAIL for button to generate an NMI to the 68030
* Pressing the button repeatedly (contact bounces) will sometimes cause
* a spurious interrupt (signal removed before ackowledged)

* V0.1 : 06SEP91 : RWS : Original code
* V0.2 : 09SEP91 : RWS : Works

.include "Atari.s"

DDR2	=	ddr+$80
GPIP2	=	gpip+$80


SPIPlatz	=	$00000060	; spurious interrupt vector
NMIPlatz	=	$0000007c	; NMI vector
	
	Super
	move.l	#MySPIRtn,SPIPlatz
	move.l	#MyNMIRtn,NMIPlatz
	ori.b	#$80,$00ff8e01		; system interrupt  mask
	
* --------------------------------- SIGNAL INSTALLATION W/LED's
	move.b	#$03,DDR2
	move.b	#$00,GPIP2
	move.l	#$f,d2
blink:
	addi.b	#$01,GPIP2
	move.l	#$FFFF,d1
.b1:
	nop
	dbf	d1,.b1
	dbf	d2,blink

* --------------------------------- Terminate & Stick Around	
	Ptermres #$200,#$0 	; save $200 bytes

* --------------------------------- NMI handler
MyNMIRtn:
	move.b	#15,giselect
	move.b	NumNMIs,giselect+2
	addq.b	#1,NumNMIs
	rte

NumNMIs:	dc.b	0

* --------------------------------- Spurious Interrupt handler
MySPIRtn:
	rte

*---------------------------------- END
