*
* Roy's String Functions - by Roy Stedman @ Atari
* Started 8/15/91 : RWS
*
	CR	= 13		; carriage return ascii code

* READSTRING
*------------------------------------------------------------------------------
* 8/15/91 : RWS / Abacus

* Reads in a string of characters into 'string' until a CR is reached
* resulting string has no CR and is zero-terminated.

.macro ReadString string	;Pass string address
	move.l	a5,-(sp)	;save a5
	movea.l	#\string,a5
.in\~:
	Gemdos	1,2		; read char from console
	move.b	d0,(a5)+	; into string
	cmpi.b	#CR,d0		; CR?
	bne	.in\~		; N:Next Char
	move.b	#0,-(a5)	; erase CR
	move.l	(sp)+,a5	; restore a5
.endm
* -----------------------------------------------------------------------------

* STRTOCARD
* -----------------------------------------------------------------------------
* 8/15/91 : RWS

* Converts a zero-terminated string into cardinal equivalent (no negatives)
* leading spaces and zeroes ok
* NOTE: You MUST send this a set of ASCII digits
* DO NOT EXCEED 65535!

.macro StrToCard string, result
	movem.l	d0-d1/a5,-(sp)
	movea.l	#\string,a5
	moveq.l	#0,d0
	moveq.l	#0,d1
.sticonv1\~:
	move.b	(a5)+,d0
	cmpi.b	#0,d0		; stop at end
	beq	.stiexit\~		
	cmpi.b	#' ',d0		; skip leading spaces
	beq	.sticonv1\~
	cmpi.b	#'0',d0		; and zeros
	beq	.sticonv1\~
.sticonv2\~:
	subi.b	#'0',d0		; convert ascii digit to integer
	mulu.w	#10,d1
	add.w	d0,d1
	move.b	(a5)+,d0
	bne	.sticonv2\~		; zero terminated = end
.stiexit\~:
	move.w	d1,\result
	movem.l	(sp)+,d0-d1/a5
.endm
* -----------------------------------------------------------------------------

* CARDTOSTR
*------------------------------------------------------------------------------
* 8/15/91 : RWS

* Convert a cardinal (stored as a word) into an existing ascii string
* your string MUST be long enough to hold converted result and zero terminated
* THE RESULT STRING WILL BE RIGHT-JUSTIFIED. NOTHING WILL BE FILLED ON THE LEFT.

.macro CardToStr	input, string

	movem.l	d0/a5,-(sp)	; save registers
	movea.l	#\string,a5

.cts0\~	cmpi.b	#0,(a5)+	; search for end of string
	bne	.cts0\~
	subq.l	#2,a5		; fix a5 pointing to before zero

	moveq.l	#0,d0	
	move.w	input,d0
.cts1\~:	
	cmpi.w	#$10,d0		; if less than 10, don't divide
	blt	.ctsfinish\~
	divu.w	#$10,d0		; divide down
	swap.w	d0		; get remainder to useful area
	addi.b	#'0',d0		; remainder has to be <10 - turn to ascii
	move.b	d0,-(a5)	; put into string Least remaining Sig. Digit
	clr.w	d0
	swap.w	d0
	bra	.cts1\~		; next digit
.ctsfinish\~:
	addi.b	#'0',d0		; slap last digit down
	move.b	d0,-(a5)
	movem.l	(sp)+,d0/a5
.endm

* -----------------------------------------------------------------------------
