 
; initialize the volume control chip
mwset:	movea.l	#MWMASK,a5	; pointer to the MicroWire mask register
	move.w	#$7FF,d1
	move.w	d1,(a5)		; set the MicroWire mask register
	movea.l	#mwinit,a4	; pointer to bytes to be sent to MicroWire
.1:	move.w	(a4)+,d0	; get the next command word
	beq.s	dacset		; all done
	ori.w	#$400,d0	; or in the 1992's address
	move	sr,d5		; save the old status
	move	#$2700,sr	; disable interrupts
	move.w	d0,MWDATA	; write the command byte
.2:	cmp.w	(a5),d1		; wait for it to start out
	beq.s	.2
.3:	cmp.w	(a5),d1		; wait for it to get back to orig state
	bne.s	.3
	move	d5,sr
	bra.s	.1
dacset:
	rts

mwinit:	dc.w	@001		; enable PSG sound
	dc.w	@350		; set master volume
	dc.w	@524		; set left volume
	dc.w	@424		; set right volume
	dc.w	@206		; treble: flat
	dc.w	@106		; bass: flat
	dc.w	0		; end of list

