* Disk2.s - Rom Based Raw Hardware Disk Testing
* DISK Formatter

* By Roy Stedman @ Atari

* V0.0  : 08NOV91 : RWS : First code from disk1.s (Scrubber)
* V1.0  : 11NOV91 : RWS : Working code W&R one track
* V1.0a : 14NOV91 : RWS : Cleaned up code w/macros subroutines
* V1.1  : 19NOV91 : RWS : Added extra buffers, made loop
 
	.include "Atari.s"
	.include "FDC.s"
	.include "DiskMac.s"


BUFSIZE	=	1020
DATAMRK	=	$52	; start of buffer
d0s0	=	$4	; Drive 0, Side 0

.macro	FindDataStart	addr		; check for tag value in 10 bytes of start of buffer
	move.l	d0,-(sp)
	move.w	#10,d0			; check for ten bytes
.a\~:
	cmpi.b	#DATAMRK,( \addr )+
	dbeq	d0,.a\~
	tst.w	d0
	bpl	.b\~
	clr.l	addr
.b\~:	
	move.l	(sp)+,d0
	tst.l	addr			; returns Z set if not found
.endm

*---------------------------------------------------------------

Start:
	Super			; Needed for ROM code?
	jsr	Setup		;- d0,a0,a1

Format:
	move.l	#$4f,d1		; HiTrack
FmtLoop:	  
	jsr	CopyBuffer1	;- d0,a1,a2	; copy buffer to buffer1
       	SeekTrack d1			; last track
	jsr	CheckErrors	;- d2
Write:					;* SetDMAAddress
	move.w	#$190,DMAMode		;* ClearDMAFIFO
	move.w	#$90, DMAMode		; toggle W/_R
	move.w	#$190,DMAMode

	move.l	#Buffer1,d0
	SetDMAAddr		;- d0
				
	move.w	#8,DISKData		; 2Kb

	cmpi.w	#$27,d0			; middle track
	ble	LoWrite	
	WriteHiTrack
	bra	WriteDone
LoWrite:
	WriteLoTrack
WriteDone:
	jsr	CheckErrors	;- d2
	jsr	FillBuffer2	;- d0,a1	; fill write buffer to verify read
Read:		
	move.w	#$190,DMAMode		;* ClearDMAFIFO
	move.w	#$90, DMAMode		; toggle W/_R
*	move.w	#$190,DMAMode

	move.l	#Buffer2,d0		;* SetDMAAddress
	SetDMAAddr		;- d0
 
	move.w	#8,DISKData		; 2kBytes
	ReadHiTrack         

	jsr	CheckErrors	;- d2

	jsr	CompareBuffers	;- d0,a0,a1,a2 ; compare buffer w/buffer1 & buffer2    
	dbra	d1,FmtLoop

* UnAnnoyTOS				; Remove for ROM test
	move.b	#0,$43e
	
	Pterm0			; Remove for ROM test
	rts

*---------------------------------------------
* Setup				d0,a0,a1
Setup:		 
* SetDrive&Side
	move.w	#d0s0,PSGWrite
 
* ClearDMAFIFO
	move.w	#$190,DMAMode
	move.w	#$90, DMAMode	; toggle W/_R
	move.w	#$190,DMAMode
	 
* SetDMAAddress
	move.l	#Buffer,d0
	SetDMAAddr

* AnnoyTOS	; Remove for ROM test	
	move.b	#$ff,$43e	

* Set Buffer
	lea.l	Buffer,a1
	move.l	#BUFSIZE,d0
.bfill:
	move.l	#$aaaa5555,(a1)+
	dbra	d0,.bfill

SetHeader:
	lea.l	Bdata,a0
	lea.l	Buffer,a1
	move.l	#6,d0
.bfill:
	move.l	(a0)+,(a1)+
	dbra	d0,.bfill

	rts

*-------------------------------------------
* Compare buffer with buffer1 and buffer2
*				d0,a0,a1,a2
CompareBuffers:
	lea.l	Buffer,a0
	lea.l	Buffer1,a1
	lea.l	Buffer2,a2
	FindDataStart a0
	beq	Offset1err	; should never happen
	FindDataStart a1
	beq	Offset2err	; out DMA writes
	FindDataStart a2
	beq	Offset3err	; in DMA wrong / disk err
	move.l	#BUFSIZE,d0
.CmpB:
	cmp.b	(a0)+,(a1)+
	bne	.Not01
	subq.l	#1,a1
	cmp.b	(a1)+,(a2)+
	bne	.Not12  

	dbra	d0,.CmpB
	
	rts

.Not01:
*	error	msgBuf01Diff
	addq.l	#1,a1
	subq.l	#1,d0
	bra	.CmpB
.Not12:
*	error	msgBuf12Diff
	subq.l	#1,d0
	bra	.CmpB   

Offset1err:
*	error	msgOrigBufSync
	rts
Offset2err:
*	error	msgWriteBufSync
	rts
Offset3err:
*	error	msgReadBufSync
	rts      

*--------------------------------------------
* Check for DMA errors		d2
CheckErrors:
	move.w	DISKData,d2
	andi.w	#$7f,d2		; strip junk & motor on
	btst	#6,d2
	bne	.CheckWP		; Write Protect
	btst	#4,d2
	bne	.CheckNF		; trk/sec not found
	btst	#3,d2
	bne	.CheckCRC	; crc/data error
	btst	#2,d2
	bne	.CheckDRQ	; lost data/trk00

	rts

.CheckWP:
*	error	msgWriteProt
	rts	 
.CheckNF:
*	error	msgTrkNF
	rts
.CheckCRC:
*	error	msgBadCRC
	rts
.CheckDRQ:
*	error	msgLostData
	rts
    
*--------------------------------------------
* fill buffer 2 with junk	d0,a1
FillBuffer2:
	lea.l	Buffer2,a1
	move.l	#BUFSIZE,d0
.bfill:
	move.l	#$FF00FF00,(a1)+
	dbra	d0,.bfill

	rts
*--------------------------------------------
* Copy buffer to buffer 1	d0,a1,a2                 

CopyBuffer1:
	lea.l	Buffer,a1
	lea.l	Buffer1,a2
	move.l	#BUFSIZE,d0
.CB1:
	move.l	(a1)+,(a2)+
	dbra	d0,.CB1
	rts    

*-------------------------------------------- 
Errors:	dc.w	0

Bdata:	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	$00f5f5f5

	dc.l	$a5a5a5a5
	dc.l	$526f7953	;data marker

	.bss

Buffer:
	ds.l	1024

Buffer1:
	ds.l	1024

Buffer2:
	ds.l	1024

