* DiskMac.s - Rom Based Raw Hardware Disk Testing Macros

* By Roy Stedman @ Atari

* V0.0 : 08NOV91 : RWS : First code
* V0.1 : 19NOV91 : RWS : Added Hi & Lo Tracks

* SetDMAAddress to Addr in d0
.macro	SetDMAAddr
	move.b	d0,DMABaseL
	lsr.l	#8,d0
	move.b	d0,DMABaseM
	lsr.l	#8,d0
	move.b	d0,DMABaseH
	lsr.l	#8,d0
*	move.b	d0,DMABaseVH	; optional for Falcon & TT
.endm

* Wait for disk done

.macro	WaitDone
.\~:
	btst.b	#5,MFPGPIO	; poll for done i/o
	bne	.\~
.endm

* SeekTrack
.macro	SeekTrack trk
	move.w	#$86,DMAMode
	move.w	\trk,DISKData	; Track Number
	move.w	#$80,DMAMode  
	nop
	nop
	nop
	nop
	nop
	nop
	move.w	#$17,DISKData
	WaitDone
.endm

.macro WriteHiTrack		;	Write Track in range $28-$4f
	move.w	#$180,DMAMode	;	cmd reg mem -> disk
	nop
	nop
	nop
	nop
	nop
	nop
	move.w	#$f0,DISKData	;	write track
	WaitDone
.endm

.macro WriteLoTrack		;	Write Track in range $28-$4f
	move.w	#$180,DMAMode	;	cmd reg mem -> disk
	nop
	nop
	nop
	nop
	nop
	nop
	move.w	#$f2,DISKData	;	write track
	WaitDone
.endm

.macro ReadHiTrack         
	move.w	#$80,DMAMode	;	cmd reg disk -> mem
	nop
	nop
	nop
	nop
	nop
	nop
	move.w	#$e0,DISKData	;	read track
	WaitDone
.endm
