* LED flipper - By Roy Stedman @ Atari

*
** Sets up a TSR to tell last disk operation - Green = read, Red = Write
** uses debug LED's - green = bit 1, red = bit 0
*

.include "Atari.s"

DDR2 	equ ddr+$80
GPIP2 	equ gpip+$80

; - Insert our handler into chain

	Super
	clr.l	a5		; get old vector
	move.l	hdv_rw(a5),oldtrap1
	move.l	#start,hdv_rw(a5)
	User
	
	move.l	#$200,d3	; save $200 bytes 
		
	clr.w	-(sp)		; TSR ---
	move.l	d3,-(sp)	; # of bytes to keep
	move.w	#$31,-(sp)	; Ptermres()
	trap	#1
	illegal

start:
	move.b	#$03,DDR2	; turn on output for bits 1&0 of the GPIP
	move.b	#$01,GPIP2	; set read (green) on
	tst.w	$4(sp)		; check read/write ... 1 = write
	bne	skip
	move.b	#$02,GPIP2	; turn write (red) on
skip:
	move.l	oldtrap1,a0
	jmp	(a0)

oldtrap1:	dc.l	0

