FALSE	EQU	0
TRUE    EQU	!FALSE

SCCS	EQU	TRUE	; include SCC code
DISKIO	EQU	TRUE	; disk support
AUTOBOOT EQU	FALSE	; boot automagically if left idle at prompt
PVIDEO	EQU	FALSE	; include Perihelion video initialization
VSCCI	EQU	TRUE	; support for vectored SCC interrupts
FASTRAM	EQU	TRUE	; has fast RAM and memory controller
MTESTS	EQU	TRUE	; include memory test code
MIDIIKBDINTS EQU FALSE	; use interrupts for MIDI and ikbd

REFRESHBASE EQU	$FFD00000	; writing to this address plus value (<255)
				;  sets clocks between refresh cycles
REFRESH	EQU	$E0	; initial refresh rate counter value

REGBASE	EQU	1	; most are on odd part of data bus
REGSTEP	EQU	2	; most registers are on word boundaries

CTLC	EQU	$03
BS	EQU	$08
TAB	EQU	$09
LF	EQU	$0A
CR	EQU	$0D
ESC	EQU	$1B
SPACE	EQU	$20
DEL	EQU	$7F

; trap definitions

BEVEC	EQU	4*2
AEVEC	EQU	4*3
IIVEC	EQU	4*4

MFPINT	EQU	$40
MKVEC	EQU	(MFPINT+6)*4
HCNTINT	EQU	MFPINT+$08
HCNTVEC	EQU	HCNTINT*4
TIMINT	EQU	MFPINT+$0D
TIMVEC	EQU	TIMINT*4

  .if VSCCI
SCCINT	EQU	$60
SCCVEC	EQU	SCCINT*4
  .endif

VSYNINT	EQU	28
VSYNVEC	EQU	VSYNINT*4

AVEC1	EQU	$64
AVEC2	EQU	$68
AVEC3	EQU	$6C
AVEC4	EQU	$70
AVEC5	EQU	$74
AVEC6	EQU	$78
AVEC7	EQU	$7C

ROMBASE	EQU	$00E00000

RAMSTART EQU	$00000000	; start of RAM
RAMSIZE	EQU	2*$100000	; 2 Mbytes
RAMEND	EQU	RAMSTART+RAMSIZE ; 1 past the end of RAM
RAMUSE	EQU	RAMSTART+$4000

RAMBASE	EQU	RAMSTART

FRAMSTART EQU	$01000000	; start of fast UXE RAM
FRAMSIZE EQU	4*$100000	; 4 Mbytes
FRAMEND	EQU	RAMSTART+RAMSIZE ; 1 past the end of RAM
FRAMUSE	EQU	RAMSTART+$4000

  .if 0 ;FASTRAM
STACK	EQU	FRAMEND
  .else ;FASTRAM
STACK	EQU	RAMEND
  .endif ;FASTRAM

CARTROMBASE	EQU	$00FA0000
CARTROMGO	EQU	CARTROMBASE+4

CARTMAGIC	EQU	$FA52235F	; magic number for diagnostic cart

MCONFIG	EQU	$FFFF8000	; dual purpose RAM configuration register
DPR256	EQU	$5		; configuration value for 256K parts

SWITCHES EQU	$FFFF9200	; motherboard switches

VTRAPS	EQU	$080+RAMSTART
VTRAP1	EQU	(1*4)+VTRAPS
VTRAP2	EQU	(2*4)+VTRAPS
VTRAP13	EQU	(13*4)+VTRAPS
VTRAP14	EQU	(14*4)+VTRAPS

BOOTDEV	EQU	$0A		; default device from which to boot
BOOTLET	EQU	'a'		; default device letter
BOOTREC	EQU	0		; the logical block number of boot sector(s)
BOOTCNT	EQU	2		; number of sectors to read on boot
BOOTLOC	EQU	RAMUSE		; location to put the boot sector(s)

TCDPRE	EQU	$11		; timer C & D prescale register value

TBAUD1	EQU	2		; baud rate divisors
TBAUD2	EQU	2

; 68901 MFP definitions

MFP	EQU	$FFFFFA01

GPIP	EQU	MFP+$00
AER	EQU	MFP+$02
DDR	EQU	MFP+$04
IERA	EQU	MFP+$06
IERB	EQU	MFP+$08
IPRA	EQU	MFP+$0A
IPRB	EQU	MFP+$0C
ISRA	EQU	MFP+$0E
ISRB	EQU	MFP+$10
IMRA	EQU	MFP+$12
IMRB	EQU	MFP+$14
VR	EQU	MFP+$16
TACR	EQU	MFP+$18
TBCR	EQU	MFP+$1A
TCDCR	EQU	MFP+$1C
TADR	EQU	MFP+$1E
TBDR	EQU	MFP+$20
TCDR	EQU	MFP+$22
TDDR	EQU	MFP+$24
SCR	EQU	MFP+$26
UCR	EQU	MFP+$28
RSR	EQU	MFP+$2A
TSR	EQU	MFP+$2C
UDR	EQU	MFP+$2E

; GPIP BIT ASSIGNMENTS
MONMON	EQU	7		; monochrome monitor indicator
RI	EQU	6		; ring indicator
DINT	EQU	5		; disk (floppy & hard) interrupt
MKINT	EQU	4		; MIDI & keyboard interrupt
BINT	EQU	3		; BLiT interrupt
CTS	EQU	2		; Clear To Send
DCD	EQU	1		; Data Carrier Detect
CBSY	EQU	0		; Centronics busy (active high)

MFP2	EQU	$FFFFFA81
GPIP2	EQU	MFP2+$00
AER2	EQU	MFP2+$02
DDR2	EQU	MFP2+$04
IERA2	EQU	MFP2+$06
IERB2	EQU	MFP2+$08
IPRA2	EQU	MFP2+$0A
IPRB2	EQU	MFP2+$0C
ISRA2	EQU	MFP2+$0E
ISRB2	EQU	MFP2+$10
IMRA2	EQU	MFP2+$12
IMRB2	EQU	MFP2+$14
VR2	EQU	MFP2+$16
TACR2	EQU	MFP2+$18
TBCR2	EQU	MFP2+$1A
TCDCR2	EQU	MFP2+$1C
TADR2	EQU	MFP2+$1E
TBDR2	EQU	MFP2+$20
TCDR2	EQU	MFP2+$22
TDDR2	EQU	MFP2+$24
SCR2	EQU	MFP2+$26
UCR2	EQU	MFP2+$28
RSR2	EQU	MFP2+$2A
TSR2	EQU	MFP2+$2C
UDR2	EQU	MFP2+$2E
	
; GPIP2 BIT ASSIGNMENTS
GPIP2SCSI	EQU	7	; SCSI xIRQ
GPIP2RTC	EQU	6	; RTC IRQ
GPIP25		EQU	5	; 
GPIP2CHGL	EQU	4	; ChangeLine
GPIP2RI		EQU	3	; Ring Indicator (SCC Port B)
GPIP2DBE	EQU	2	; DMA Bus Error
LED1		EQU	1	; debug LED
LED0		EQU	0	; debug LED

; Zilog SCC definitions
SCC	EQU	$FFFF8C80+REGBASE	; base address of SCC

SCCAC	EQU	SCC+($00*REGSTEP)
SCCAD	EQU	SCC+($01*REGSTEP)
SCCBC	EQU	SCC+($02*REGSTEP)
SCCBD	EQU	SCC+($03*REGSTEP)

mSRXR	EQU	01		; mask for receiver ready
mSTXE	EQU	04		; mask for transmitter empty

; Motorola Real Time Clock
RTCCHIP	EQU	$FFFF8960+REGBASE
RTCA	EQU	RTCCHIP+$00	; address (index) must be set here
RTCD	EQU	RTCCHIP+$02	; BEFORE reading/writing data here

; ST DMA
WDC	EQU	$FFFF8604
RDC	EQU	WDC
WDL	EQU	$FFFF8606
WDCWDL	EQU	WDC

; ST FDC
FDCCMD	EQU	$80
FDCTRK	EQU	$82
FDCSEC	EQU	$84
FDCDAT	EQU	$86

STEPRATE	EQU	$00

RESTOREFDC	EQU	$00+STEPRATE

; SCSI Interface (NCR 5380)
bSCSI	EQU	$FFFF8780+REGBASE
SCSID	EQU	bSCSI+($00*REGSTEP)
SCSIICR	EQU	bSCSI+($01*REGSTEP)
SCSIMR	EQU	bSCSI+($02*REGSTEP)
SCSITCR	EQU	bSCSI+($03*REGSTEP)
SCSICR	EQU	bSCSI+($04*REGSTEP)
SCSISR	EQU	bSCSI+($05*REGSTEP)

; SCSI DMA Controller
bSDMAPTR	EQU	$FFFF8701
bSDMACNT	EQU	$FFFF8709
SDMARES	EQU	$FFFF8710
SDMACTL	EQU	$FFFF8714	; WORD

DMAOUT	EQU	01
DMAIN	EQU	00
DMAENA	EQU	02
DMADIS	EQU	00

; system controller
bSCU	EQU	$FFFF8E00+REGBASE
SCUSIM	EQU	bSCU		; system interrupt mask
SCUSIS	EQU	bSCU+(REGSTEP)	; system interrupt state
SCUSI	EQU	bSCU+(2*REGSTEP); (b0=1 -> generate interrupt 1)
SCUVI	EQU	bSCU+(3*REGSTEP); (b0=1 -> generate VME interrupt 3)
SCUGR1	EQU	bSCU+(4*REGSTEP); general purpose configuration register 1
SCUGR2	EQU	bSCU+(5*REGSTEP); general purpose configuration register 2
SCUVIM	EQU	bSCU+(6*REGSTEP); VMEbus interrupt mask
SCUVIS	EQU	bSCU+(7*REGSTEP); VMEbus interrupt state

; EST/TT Video
VBASEH	EQU	$FFFF8201
VBASEM	EQU	$FFFF8203
VBASEL	EQU	$FFFF820D
SYNC	EQU	$FFFF820A	; set this byte to 01 for TT video
SMDE	EQU	$FFFF8260	; byte
TTSMDE	EQU	$FFFF8262	; word

STCMAP	EQU	$FFFF8240	; word ST color map (16 entries)
TTCMAP	EQU	$FFFF8400	; word TT color map (256 entries)

;; 6850 UART definitions
ACIA1	EQU	$FFFFFC00
IKBD	EQU	ACIA1
IKBDC	EQU	IKBD+$00
IKBDD	EQU	IKBD+$02

ACIA2	EQU	$FFFFFC04
MIDI	EQU	ACIA2
MIDIC	EQU	MIDI+$00
MIDID	EQU	MIDI+$02

;; Programmable Sound Gernerator
PSGA	EQU	$FFFF8800	; PSG set address latch
PSGW	EQU	$FFFF8802	; PSG write data to here
PSGR	EQU	$FFFF8800	; PSG read from here

; PSG Register Definitions
PSGACT	EQU	0		; A coarse tune
PSGAFT	EQU	1		; A fine tune
PSGBCT	EQU	2		; B coarse tune
PSGBFT	EQU	3		; B fine tune
PSGCCT	EQU	4		; C coarse tune
PSGCFT	EQU	5		; C fine tune
PSGNGC	EQU	6		; noise generator control
PSGMCE	EQU	7		; mixer control & I/O enable
PSGAAC	EQU	8		; A amplitude control
PSGBAC	EQU	9		; B amplitude control
PSGCAC	EQU	10		; C amplitude control
PSGEFT	EQU	11		; envelope fine tune
PSGECT	EQU	12		; envelope coarse tune
PSGESC	EQU	13		; envelope shape/cycle
PSGIO	EQU	14		; I/O port

; PSGIO port bit definitions
PSGSS0	EQU	0		; side select
PSGDS0	EQU	1		; drive 0 select
PSGDS1	EQU	2		; drive 1 select
PSGRTS	EQU	3		; ready to send output
PSGDTR	EQU	4		; data terminal ready output
PSGCSTB	EQU	5		; centronics strobe
PSGGPO	EQU	6		; general purpose output
; unused EQU	7		; unassigned output pin

PSGCENT	EQU	15		; Centronics Data Port

;; Perihelion Video definitions
PVIDBASE EQU	$40000000
VRAM	EQU	PVIDBASE+$00200000

VIDENA	EQU	PVIDBASE+$0000	; ?? video enable ??
VIDREF	EQU	PVIDBASE+$0008	; refresh enable
VIDTIM	EQU	PVIDBASE+$0040	; video timing parameter registers
VMEMMAP	EQU	PVIDBASE+$0100	; selects video memory organization
VIDMREG	EQU	PVIDBASE+$e100	; ?? mode select register ??

CLUTD12	EQU	PVIDBASE+$a100	; Mode 1/2 CLUT data register  LONG
CLUTA12	EQU	PVIDBASE+$c100	; Mode 1/2 CLUT index register LONG

CLUTD0	EQU	PVIDBASE+$2100	; Mode 0   CLUT data register  LONG
CLUTA0	EQU	PVIDBASE+$4100	; Mode 0   CLUT index register LONG

; DMA Sound Engine
SNDCTL	EQU	$FFFF8900	; control register {repeat, enable}
SNDPTR	EQU	$FFFF8902	; frame start
SNDADR	EQU	$FFFF8908	; current address
SNDEND	EQU	$FFFF890E	; frame end
SNDMDE	EQU	$FFFF8920	; mode register {mono, rate}
MWDATA	EQU	$FFFF8922	; MicroWire Shifter addresses
MWMASK	EQU	$FFFF8924

