*===================================
* SERMACS.S - serial port macros
*
* V 1.0 : Roy Stedman : 20FEB92
*====================================
* SPACE - wastes a0 & d1
*       Print space
.macro SPACE
	lea     .\~,a0
        moveq   #$20,d1
        bra     pout
.\~:
.endm
*-----------------
* CRLF - WASTES A0

.macro	CRLF	
	lea.l	.\~,a0
	bra	ptcrlf
.\~: 
.endm
*------------------------
* DSPCHAR - put character in d0 to screen, wastes a0
.macro DSPCHAR	
	lea.l	.\~,a0
	bra	pchar
.\~:
.endm

*------------------------
* DSPMSG - wastes a1 & a0
.macro DSPMSG	msg
	lea.l	\msg,a1
	lea.l	.\~,a0
	bra	ptmsg
.\~:
.endm

*------------------------
* DMSG2 - wastes a1 & a0
.macro DMSG2
	move.l	a5,a1
	lea.l	.\~,a0
	bra	ptmsg
.\~:
.endm
*---------------------------------------------
* DSPBYT - wastes d0,d1,a0,a1. d0 = byte to display
.macro DSPBYT
	lea.l	.\~1,a0
	bra	pbyt
.\~1:
.endm

*---------------------------------------------
* DSPWRD - wastes d0,d1,a0,a1. d0 = wrd to display
.macro DSPWRD
	rol.w	#8,d0
	lea.l	.\~1,a0
	bra	pbyt
.\~1:
	rol.w	#8,d0
	lea.l	.\~2,a0
	bra	pbyt
.\~2:
.endm

*---------------------------------------------
* DSPLONG - wastes d0 & a0 & a1. d0 = long to display
.macro DSPLONG
	swap	d0
	DSPWRD
	swap	d0
	DSPWRD
.endm

*----------------------------------------------
* GETCHAR - gets a character into d0, wastes a0
.macro GETCHAR
	lea.l	.\~,a0
	bra	rsin
.\~:        
.endm 

*----------------------------------------------
* DELAY - wipes d0
.macro	DELAY	delval
	move.l	#\delval,d0
.\~:
	subq.l	#1,d0
	bne	.\~
.endm

