* Sparrow Sound Test 1 - By Roy Stedman @ Atari

* V0.0 : RWS : 21NOV91

* Setup Simple PSG sound
* Pipe back to RASCAL
* Digitize inro RAM


	.include "atari.s"

UWIRE		= 	1

uWireMask	=	$ffff8924
uWireData	=	$ffff8922

GISELECT	=	$ffff8800
GIWRITE		=	$ffff8802

.macro	Giaccess val1, reg1
   	move.b	#\reg1,GISELECT		; add #$80 if necessary
	delay
	move.b	#\val1,GIWRITE 
	delay
.endm

.macro	delay
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

.endm

.macro uWireWait
.\~:
	cmp.w	#$07ff,uWireMask
	bne.s	.\~
.endm

start:	
	Super

* enable PSG on uWire
.if UWIRE 
; initialize the volume control chip
mwset:	movea.l	#uWireMask,a5	; pointer to the MicroWire mask register
	move.w	#$7FF,d1
	move.w	d1,(a5)		; set the MicroWire mask register
	movea.l	#mwinit,a4	; pointer to bytes to be sent to MicroWire
.1:	move.w	(a4)+,d0	; get the next command word
	beq.s	dacset		; all done
	ori.w	#$400,d0	; or in the 1992's address
	move	sr,d5		; save the old status
	move	#$2700,sr	; disable interrupts
	move.w	d0,uWireData	; write the command byte
.2:	cmp.w	(a5),d1		; wait for it to start out
	beq.s	.2
.3:	cmp.w	(a5),d1		; wait for it to get back to orig state
	bne.s	.3
	move	d5,sr
	bra.s	.1
dacset:

*	move.w	#$07ff,uWireMask	; 0000 0111 1111 1111
*	uWireWait
*	move.w	#$0201,uWireData	; xxxx x010 0000 0001 - enable psg
*  	uWireWait
*	move.w	#$02d4,uWireData	; xxxx x010 1101 0100 - vol = -40db
* set freq
.endif
	move.w	sr,d5
	move.w	#$2700,sr

  	Giaccess 125,128		; fine tune	1khz = 0+125
	Giaccess 0,129			; coarse	
* enable tone
	Giaccess $fe,135
* set vol  
	Giaccess 15,136


	move.l	#$ffffff,d0
.loop1:
	subq.l	#1,d0
	bne	.loop1

over:
	Giaccess 0,136			; turn off sound (vol = 0)
	Giaccess $ff,135
 
	Pterm0
	rts


 mwinit:
	dc.w	@001		; enable PSG sound
	dc.w	@350		; set master volume
	dc.w	@524		; set left volume
	dc.w	@424		; set right volume
	dc.w	@206		; treble: flat
	dc.w	@106		; bass: flat
	dc.w	0		; end of list

