;;;
;	STBook PadTOS Extensions
;
;	Copyright 1991 Atari Corp.

	.include "Atari.s"

UWIRE = 1


; uses d0-d1
 .macro	DELAY	time
	move.w	\time,d0
	subq.w	#1,d0
.dly1\~:
	move.l	#250,d1
.dly2\~:
	subq.l	#1,d1		;8      each pass through the loop takes <4uS
	nop			;4
	nop			; added for tt030
	nop
	nop
	nop	
	nop
	nop
	nop
	nop
	bra	.dly3\~		;10
.dly3\~:
	bne.s	.dly2\~		;10
	dbra	d0,.dly1\~
 .endm


uWireMask	equ	$ffff8924
uWireData	equ	$ffff8922

;; Programmable Sound Generator
bPSGA	EQU	$FFFF8800	; PSG set address latch
bPSGW	EQU	$FFFF8802	; PSG write data to here
bPSGR	EQU	$FFFF8800	; PSG read from here

; PSG Register Definitions
rPSGAFT	EQU	0		; A fine tune
rPSGACT	EQU	1		; A coarse tune
rPSGBFT	EQU	2		; B fine tune
rPSGBCT	EQU	3		; B coarse tune
rPSGCFT	EQU	4		; C fine tune
rPSGCCT	EQU	5		; C coarse tune
rPSGNGC	EQU	6		; noise generator control
rPSGMCE	EQU	7		; mixer control & I/O enable
rPSGAAC	EQU	8		; A amplitude control
rPSGBAC	EQU	9		; B amplitude control
rPSGCAC	EQU	10		; C amplitude control
rPSGEFT	EQU	11		; envelope fine tune
rPSGECT	EQU	12		; envelope coarse tune
rPSGESC	EQU	13		; envelope shape/cycle
rPSGIO	EQU	14		; I/O port


	.text

	Super
	move.w	#$2700,sr

mwset:	movea.l	#uWireMask,a5	; pointer to the MicroWire mask register
	move.w	#$7FF,d1
	move.w	d1,(a5)		; set the MicroWire mask register
	movea.l	#mwinit,a4	; pointer to bytes to be sent to MicroWire
.1:	move.w	(a4)+,d0	; get the next command word
	beq.s	dacset		; all done
	ori.w	#$400,d0	; or in the 1992's address
	move	sr,d5		; save the old status
	move 	#$2700,sr	; disable interrupts
	move.w	d0,uWireData	; write the command byte
.2:	cmp.w	(a5),d1		; wait for it to start out
	beq.s	.2
.3:	cmp.w	(a5),d1		; wait for it to get back to orig state
	bne.s	.3
	move	d5,sr
	bra.s	.1
dacset:
	move.b	#$00,$ff8901	;sound DMA off 

	move.b	#$80,$ffff8921	; mono

	lea	sHDDON1,a0
  	bsr	PlayPSG

	lea	sHDDON2,a0
	bsr	PlayPSG

	lea	sHDDR1,a0
	bsr	PlayPSG

	lea	sPOFF,a0
	bsr	PlayPSG

	Pterm0

PlayPSG:
	move.w	sr,-(sp)
	move.w	#$2700,sr

	move.b	#rPSGMCE,bPSGA	; make sure tone is enabled
	nop
	move.b	bPSGR,d0
	andi.b	#$F8,d0
	move.b	d0,bPSGW

.1:	move.b	(a0)+,d0	; get the register index
	beq.s	.99		; at the end of the string?
	cmpi.b	#$10,d0		; is it the special delay flag?
	bne.s	.20
	clr.w	d0
	move.b	(a0)+,d0	; get number of 10s of mS to delay
	mulu.w	#10,d0
	DELAY	d0

	bra	.1

.20:	move.b	d0,bPSGA	; write the register index
	nop
	move.b	(a0)+,bPSGW	; write the data byte
	bra	.1

.99:	move.w	(sp)+,sr
	rts

	.data

sHDDON1: dc.b	rPSGESC,$0d
	dc.b	rPSGEFT,$20
	dc.b	rPSGECT,$00
	dc.b	rPSGACT,3822>>8,rPSGAFT,3822&$0ff
	dc.b	rPSGAAC,15
	dc.b	$10,25
	dc.b	0,0
sHDDON2: dc.b	rPSGAAC,0
	dc.b	0,0
sHDDR1:	dc.b	rPSGACT,1911>>8,rPSGAFT,1911&$0ff
	dc.b	rPSGAAC,15
	dc.b	$10,25
	dc.b	rPSGAAC,0
	dc.b	0,0
sHDDR2:	dc.b	rPSGACT,956>>8,rPSGAFT,956&$0ff
	dc.b	rPSGAAC,15
	dc.b	$10,25
	dc.b	rPSGAAC,0
	dc.b	0,0
sPOFF:	dc.b	rPSGACT,478>>8,rPSGAFT,478&$0ff
	dc.b	rPSGAAC,15
	dc.b	$10,25
	dc.b	rPSGAAC,0
	dc.b	0,0

mwinit:
	dc.w	@001		; enable PSG sound
	dc.w	@350		; set master volume
	dc.w	@524		; set left volume
	dc.w	@424		; set right volume
	dc.w	@206		; treble: flat
	dc.w	@106		; bass: flat
	dc.w	@001
	dc.w	0		; end of list

	.end
           
