* ===================================
* XGA.S
* V1.0 : 27FEB92 : RWS
* ====================================

	.include	"68030.s"
	.include	hardware
	.include 	sermacs
	.include	super

vbash	equ	$ff8200		;video base high
vbasm	equ	$ff8202		;video base mid 
vbasl	equ	$ff820c
	
HORIZON	= 145
WIDTH = 640
        .text

*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
*	.include	initcart	; setup $FF8006,VMC,VBR,RS232
*-------------------------------------------------
	Super
	move.w	#$2700,sr
	move.l	#stack,sp
SPx12:
	move.w	#21718,seed
settime:
	movea.l	#spex12,a0
	movea.l	#spex1v,a1
	bsr	stuffSPregs
setvid:
	move.l	#screen,d0
	and.w	#$00ff,d0
	move.w	d0,vbasl	
	move.l	#screen,d0
	lsr.w	#8,d0		; zero fill
	move.w	d0,vbasm
	move.l	#screen,d0
	swap	d0
	lsr.w	#8,d0
	move.w	d0,vbash
setxga:
	move.w	#$100,v_spshiftmd
	move.w	#4,v_VTC
*	move.w	#6,v_VTC
setskip:
*	ori.w	#2,v_VTC
misc:
	move.b	#$0,synmod
	andi.w	#$ff,v_VMC
	move.w	#0,v_hoffset	; no extra words of video
	move.w	#0,v_pixscroll	; no pixel scroll
	move.w	#640,v_DLW	; displayed line width
readpal:
	move.l	#$000,sppalette	; hit sparrow palette
set16mhz:
	ori.b	#1,SPControl
	bsr	BlankXGA
	bsr	main
pix:
	bra	pix
	rts

********************************
* stuffSPregs - load horiz & vert data blocks into sp video
* entry:
*	a0 - address of horizontal data block
* 	a1 - address of vertical data block 
* uses: a0, a1, a2

stuffSPregs:
	movea.l	#v_VFT,a2
.spl2:
	move.w	(a1)+,(a2)+
	cmpa.l	#v_VSS+2,a2
	bne	.spl2

	movea.l	#v_HHT,a2	
.spl1:
	move.w	(a0)+,(a2)+
	cmpa.l	#v_HEE+2,a2
	bne	.spl1
	
	rts	

************************
* Main demo loop
main:
	bsr	drawsky	
*	bsr	drawgnd
	bsr	light1
*	bsr	BlankXGA
	bsr	risesign

*	bsr	upsign
*	bsr	runtext
	rts

************************
* RiseSign 
risesign:
	movem.l	d0-d4/a0,-(sp)
 
	move.l	#240,d0		; x pos
	move.l	#HORIZON-4,d1	; y pos
	move.l	#1,d2		; height
	move.l	#atsign,a0
	move.w	#$f800,d4	; full red & green
.lp1:
	bsr	DrawMask
	move.l	d0,-(sp)
	DELAY	$cfff
	move.l	(sp)+,d0
	addq.w	#1,d2
*	add.w	#$20,d4
	subq.w	#2,d1
	cmpi.w	#32,d2
	bne	.lp1

	move.l	#240,d0		; x pos
	move.l	#HORIZON-67,d1	; y pos
	move.l	#32,d2		; height
	move.l	#atsign,a0
*	move.w	#$f800,d4	; full red & green
.lp2:
	bsr	DrawMask
	move.l	d0,-(sp)
	DELAY	$8fff
	move.l	(sp)+,d0
	add.w	#$20,d4
	subq.w	#1,d1
	cmpi.w	#HORIZON-131,d1
	bne	.lp2

	move.l	#240,d0		; x pos
	move.l	#HORIZON-131,d1	; y pos
	move.l	#31,d2		; height
	move.l	#atsign,a0
	move.w	#$f800,d4	; full red
.lp3:
	bsr	DrawMask
	move.l	d0,-(sp)
	DELAY	$8fff
	move.l	(sp)+,d0
	add.w	#$40,d4
	dbra	d2,.lp3

	movem.l	(sp)+,d0-d4/a0
	rts

************************
*
.macro	subblue	rg
	subq.l	#1,\rg
	bpl	.\~
	move.l	#0,\rg
.\~:
.endm

.macro	subrgb rg
	sub.l	#$1000,\rg
	bpl	.1\~
	and.l	#$07ff,\rg
.1\~:
	sub.b	#1,\rg
	bpl	.3\~
	and.l	#$ffe0,\rg
.3\~:
.endm

.macro	doskyblock	low,hi,color
	movem.l	d1-d3,-(sp)
	move.w	\color,d3		; color
	move.l	#(\low * 2 * 640),d2
	move.l	#(\hi * 2 * 640),d1 
	bsr	prerise
	movem.l	(sp)+,d1-d3
.endm

.macro lite rtn,value
	move.l	d1,d0
.if !sunrise
	doskyblock	HORIZON,HORIZON-(HORIZON/64),d0
	\rtn d0
.endif
.if sunrise
	doskyblock	HORIZON,HORIZON-(HORIZON/80),d0	
	\rtn d0
	doskyblock	HORIZON-(HORIZON/80),HORIZON-(HORIZON/64),d0	; btw 140 & 64
	\rtn d0
.endif
.if !sunrise
	doskyblock	HORIZON-(HORIZON/64),HORIZON-(HORIZON/32),d0
	\rtn d0
.endif
.if sunrise
	doskyblock	HORIZON-(HORIZON/64),HORIZON-(HORIZON/48),d0
	\rtn d0
	doskyblock	HORIZON-(HORIZON/48),HORIZON-(HORIZON/32),d0	; btw 64 & 32
	\rtn d0
.endif
.if !sunrise
	doskyblock	HORIZON-(HORIZON/32),HORIZON-(HORIZON/16),d0		
	\rtn d0
.endif
.if sunrise
	doskyblock	HORIZON-(HORIZON/32),HORIZON-(HORIZON/24),d0		
	\rtn d0
	doskyblock	HORIZON-(HORIZON/24),HORIZON-(HORIZON/16),d0	; btw 32 & 16	
	\rtn d0
.endif
	doskyblock	HORIZON-(HORIZON/16),HORIZON-(HORIZON/12),d0		
	\rtn d0
	doskyblock	HORIZON-(HORIZON/12),HORIZON-(HORIZON/8),d0	; btw 16 & 8	
	\rtn d0
	doskyblock	HORIZON-(HORIZON/8),HORIZON-(HORIZON/6),d0		
	\rtn d0
	doskyblock	HORIZON-(HORIZON/6),HORIZON-(HORIZON/4),d0	; btw 8 & 4	
	\rtn d0
	doskyblock	HORIZON-(HORIZON/4),HORIZON-(HORIZON/3),d0
	\rtn d0
	doskyblock	HORIZON-(HORIZON/3),HORIZON-(HORIZON/2),d0	; bw 4 & 2
	\rtn d0
	doskyblock	HORIZON-(HORIZON/2),0,d0			; need one more?
.endm
***********************
* light1 - first lights
light1:
	move.l	#$1,d1
sunrise set 0
.lt1:
	lite	subblue
	addq.w	#1,d1
	cmp.w	#$10,d1
	bne	.lt1
	add.w	#$3000,d1
sunrise set 1
.lt2:
	add.w	#$3021,d1
	lite	subrgb
	cmp.w	#$a000,d1
	bmi	.lt2
	rts

***********************
* drawsky
drawsky:
	movem.l	d0-d7,-(sp)
	move.l	#$0000,d4	; color = black
	move.l	#1,d1		; y1
	move.l	#1,d0		; x1
	move.l	#640,d2		; x2
.draw1:
	bsr	DrawHLine
	addq.l	#1,d1		; y1
	cmpi.l	#HORIZON,d1
	blt	.draw1

	move.w	#$0000,d4	; full black
.draw2:				; gnd
	bsr	DrawHLine
	addq.l	#1,d1		; y1
	cmpi.l	#200,d1
	blt	.draw2

	move.w	#20000,seed
	move.w	#$f,d7		; # stars
.draw3:
 	move.w	#$ffff,d4	; full white
.dr31:
	bsr	random
	move.w	d0,d1		; y
	andi.w	#$ff,d1
	cmp.w	#HORIZON-5,d1
	bge	.dr31
.dr32:
	bsr	random
	andi.w	#$1ff,d0
	cmp.w	#640,d0
	bge	.dr32
	bsr	DrawPoint
	dbra	d7,.draw3
	
	move.w	#$1f,d7		; # stars
.draw4:
 	move.w	#$7bef,d4	; dim white
.dr41:
	bsr	random
	move.w	d0,d1		; y
	andi.w	#$ff,d1
	cmp.w	#HORIZON-5,d1
	bge	.dr41
.dr42:
	bsr	random
	andi.w	#$1ff,d0
	cmp.w	#640,d0
	bge	.dr42
	bsr	DrawPoint
	dbra	d7,.draw4	
	movem.l	(sp)+,d0-d7
	rts

***********************
* prerise d1 = top, d2 = bottom * 640 * 2, d3 = color (no stars) 
prerise:
	movem.l	a0-a1,-(sp)
	move.l	#screen,a0
	move.l	#screen,a1
	add.l	d2,a0		; lower address
	add.l	d1,a1		; high address (logically less than a0)
.pre1:
	cmp.w	#$ffff,(a0)
	beq	.nxtpixl
	cmp.w	#$7bef,(a0)
	beq	.nxtpixl
	move.w	d3,(a0)
.nxtpixl:
	subq.l	#2,a0
	cmp.l	a0,a1
	bmi	.pre1
	movem.l	(sp)+,a0-a1
	rts
	
***********************
* doodles in XGA colors
DrawXGA1:
	move.l	#$f800,d4	; color = full red
	move.l	#1,d1		; y1
	move.l	#1,d0		; x1
	move.l	#600,d2		; x2
.draw1:
	bsr	DrawHLine
	addq.l	#1,d1		; y1
	add.w	#$40,d4		; color
	cmp.w	#$0000,d4
	beq	.dr2		; overflow? 
	cmpi.l	#200,d1
	blt	.draw1
	rts
.dr2:
	rts

***********************
* random? word value in d0
random:
	move.w	seed,d0
	mulu.w	#31413,d0
	add.l	#6923,d0
	bpl.s	.rnd2
	add.l	#32767,d0
.rnd2:
	move.w	d0,seed
	rts

***********************
* clear screen
BlankXGA:
	move.l	#screen,a0
	move.w	#200,d0
	move.w	#$0,d3
.draw1:
	move.w	v_DLW,d2
	subq.l	#1,d2
.drawline:			; draw one line
	move.w	d3,(a0)+
	dbra	d2,.drawline
	dbra	d0,.draw1	; loop through lines
	rts

************************
* Draw Point in XGA d0,d1 = x,y d4 = color
* NO BOUNDS CHECKING - kills a0,d1,d3
DrawPoint:
	movem.l	d0-d4/a0,-(sp)
	move.w	v_DLW,d3	; get pixels (words)/line
	asl.l	#1,d3		; get bytes per line
	mulu.w	d3,d1		; figure y value
	asl.w	#1,d0		; get x pixel offset in words
	move.l	#screen,a0
	add.l	d1,a0
	move.w	d4,(a0,d0)
nodraw:
	movem.l	(sp)+,d0-d4/a0
	rts
************************
.macro	ComputeOffset x,y,addr
	mulu.w	#WIDTH,\y
	asl.l	#1,\y
	asl.w	#1,\x
	move.l	#screen,\addr
	add.l	\y,\addr
	add.l	\x,\addr
.endm
************************
* Draw Mask (3wds wide) in XGA
* d0=x, d1 = y, d2 = height, d4 = color
* a0 = address of mask (flagged with $ffff as last word)
DrawMask:
	movem.l	d0-d6/a0-a1,-(sp)
	ComputeOffset d0,d1,a1	;sets a1 to address
	move.w	d2,d6		; move height
.drma:
	move.w	#2,d2		; 3 words/line
.drm:
	move.w	(a0)+,d3
	cmp.w	#$ffff,d3
	beq	.lemmeout
	move.w	#15,d5		; index into 16 bits
.drm2:
	rol.w	#1,d3
	bcc	.noplot
	move.w	d4,(a1)+
	move.w	d4,(a1)+
	move.w	d4,(a1)+
	move.w	d4,(a1)+
	add.l	#(WIDTH*2)-(0*16*4),a1
	sub.l	#8,a1
	move.w	d4,(a1)+
	move.w	d4,(a1)+
	move.w	d4,(a1)+
	move.w	d4,(a1)+
	sub.l	#(WIDTH*2)-(0*16*4),a1
	bra	.nxtpix
.noplot:
	move.w	(a1),(a1)+
	move.w	(a1),(a1)+
	move.w	(a1),(a1)+
	move.w	(a1),(a1)+
	add.l	#(WIDTH*2)-(0*16*4),a1
	sub.l	#8,a1
	move.w	(a1),(a1)+
	move.w	(a1),(a1)+
	move.w	(a1),(a1)+
	move.w	(a1),(a1)+
	sub.l	#(WIDTH*2)-(0*16*4),a1
.nxtpix:
	dbra	d5,.drm2
	dbra	d2,.drm		; next word
	add.l	#(WIDTH*2)-(3*16*4),a1
	add.l	#(WIDTH*2)-(3*16*4),a1
	dbra	d6,.drma
.lemmeout:
	movem.l	(sp)+,d0-d6/a0-a1
	rts

************************
* DrawHLine - draw horizontal line left to right ONLY!
*	d0,d1 = x1,y1 d2 = x2 	d4=color
DrawHLine:
	movem.l	d0-d4/a0,-(sp)
	andi.l	#$ffff,d0
	andi.l	#$ffff,d1
	andi.l	#$ffff,d2
	andi.l	#$ffff,d4
	move.w	v_DLW,d3	; get pixels (words)/line
	asl.l	#1,d3		; get bytes per line
	mulu.w	d3,d1		; figure y value
	asl.l	#1,d0		; get x pixel offset in words
	asl.l	#1,d2
	move.l	#screen,a0
	add.l	d1,a0
.dhl:
	move.w	d4,(a0,d0)
*	addq.l	#2,d4
	addq.l	#2,d0	
	cmp.l	d2,d0
	blt	.dhl
	movem.l	(sp)+,d0-d4/a0
	rts

************************
* DrawLine	d0,d1 = x1,y1 d2,d3 = x2y2 color in d4
* connects the dots in the color in d4
DrawLine:
* find slope   
* while ticking along x axis
* figure y pos
* draw spot
* until line done
*--------------------------------------------------------------

*		VFT,VBB,VBE,VDB,VDE,VSS		* NOTE! WATCH VSS & HSS!!
spex1v:
*	dc.w	623-100,613-100,47-25,127-50,527-50,618-100
	dc.w	623,613,47,127,527,618
*
*		HHT,HBB,HBE,HDB,HDE,HSS,HFS,HEE
spex12:
*	dc.w	254,203,39,  34,147,214,362,474
	dc.w	510,410,92,1102,287,435,362,474


atsign:					;  48 X 32 block atari symbol (doubled horiz for display)
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$33cc,$0000
	dc.w	$0000,$73ce,$0000
	dc.w	$0000,$73ce,$0000
	dc.w	$0000,$73ce,$0000
	dc.w	$0000,$73ce,$0000
	dc.w	$0000,$f3cf,$0000
	dc.w	$0000,$f3cf,$0000
	dc.w	$0001,$f3cf,$8000
	dc.w	$0003,$f3cf,$c000
	dc.w	$0003,$e3c7,$c000
	dc.w	$0007,$e3c7,$e000
	dc.w	$001f,$c3c3,$f800
	dc.w	$003f,$c3c3,$fc00
	dc.w	$00ff,$83c1,$ff00
	dc.w	$0fff,$03c0,$fff0
	dc.w	$0ffe,$03c0,$7ff0
	dc.w	$0ffc,$03c0,$3ff0
	dc.w	$0ff0,$03c0,$0ff0
	dc.w	$0fc0,$03c0,$03f0
	dc.w	0,0,0			; blank line for scroll up
	dc.w	$ffff,$ffff,$ffff
      
        .bss

	ds.l	1000	; avoid vector table space
ScreenBase:	ds.l	1
	ds.l	1000	; stack space
stack:
	ds.l	1000              
seed:	ds.l	1
	.even
screen:
	ds.w	640*200
	ds.l	1   
                                            

