
;Blitter Command-Register

BLIT_SRCEN     EQU $01                            ; d00:source data read (inner loop)
BLIT_SRCENZ    EQU $02                            ; d01:source Z read (inner loop)
BLIT_SRCENX    EQU $04                            ; d02:source data read (realign)
BLIT_DSTEN     EQU $08                            ; d03:destination data read (inner loop)
BLIT_DSTENZ    EQU $10                            ; d04:destination Z read (inner loop)
BLIT_DSTWRZ    EQU $20                            ; d05:destination Z write (inner loop)
BLIT_CLIP_A1   EQU $40                            ; d06:A1 clipping enable
BLIT_NOGO      EQU $80                            ; d07:diagnostic
BLIT_UPDA1F    EQU $0100                          ; d08:A1 update step fraction
BLIT_UPDA1     EQU $0200                          ; d09:A1 update step
BLIT_UPDA2     EQU $0400                          ; d10:A2 update step
BLIT_DSTA2     EQU $0800                          ; d11:reverse usage of A1 and A2
BLIT_GOURD     EQU $1000                          ; d12:enable Gouraud shading
BLIT_ZBUFF     EQU $2000                          ; d13:polygon Z data updates
BLIT_TOPBEN    EQU $4000                          ; d14:intensity carry into byte
BLIT_TOPNEN    EQU $8000                          ; d15:intensity carry into nibble
BLIT_PATDSEL   EQU $010000                        ; d16:Select pattern data
BLIT_ADDDSEL   EQU $020000                        ; d17:diagnostic
; d18-d20: Z comparator inhibit
BLIT_ZMODELT   EQU $040000                        ;     source < destination
BLIT_ZMODEEQ   EQU $080000                        ;     source = destination
BLIT_ZMODEGT   EQU $100000                        ;     source > destination
; d21-d24: Logic function control
BLIT_LFU_NAN   EQU $200000                        ;     !source & !destination
BLIT_LFU_NA    EQU $400000                        ;     !source &  destination
BLIT_LFU_AN    EQU $800000                        ;      source & !destination
BLIT_LFU_A     EQU $01000000                      ;      source &  destination

; The following are ALL 16 possible logical operations of the LFUs

BLIT_LFU_ZERO  EQU $00                            ; All Zeros
BLIT_LFU_NSAND EQU $200000                        ; NOT Source AND NOT Destination
BLIT_LFU_NSAD  EQU $400000                        ; NOT Source AND Destination
BLIT_LFU_NOTS  EQU $600000                        ; NOT Source
BLIT_LFU_SAND  EQU $800000                        ; Source AND NOT Destination
BLIT_LFU_NOTD  EQU $A00000                        ; NOT Destination
BLIT_LFU_N_SXORD EQU $C00000                      ; NOT (Source XOR Destination)
BLIT_LFU_NSORND EQU $E00000                       ; NOT Source OR NOT Destination
BLIT_LFU_SAD   EQU $01000000                      ; Source AND Destination
BLIT_LFU_SXORD EQU $01200000                      ; Source XOR Destination
BLIT_LFU_D     EQU $01400000                      ; Destination
BLIT_LFU_NSORD EQU $01600000                      ; NOT Source OR Destination
BLIT_LFU_S     EQU $01800000                      ; Source
BLIT_LFU_SORND EQU $01A00000                      ; Source OR NOT Destination
BLIT_LFU_SORD  EQU $01C00000                      ; Source OR Destination
BLIT_LFU_ONE   EQU $01E00000                      ; All Ones

; These are some common combinations with less boolean names

BLIT_LFU_REPLACE EQU $01800000                    ; Source REPLACEs destination
BLIT_LFU_XOR   EQU $01200000                      ; Source XOR with destination
BLIT_LFU_CLEAR EQU $00                            ; CLEAR destination

BLIT_CMPDST    EQU $02000000                      ; d25: pixel compare pattern & dest
BLIT_BCOMPEN   EQU $04000000                      ; d26: bit compare write inhibit
BLIT_DCOMPEN   EQU $08000000                      ; d27: data compare write inhibit
BLIT_BKGWREN   EQU $10000000                      ; d28: data write back
BLIT_BUSHI     EQU $20000000                      ; d29: blitter priority
BLIT_SRCSHADE  EQU $40000000                      ; d30: shade src data w/IINC value
;*======================================================================*
;* BLITTER Flags (A1 or A2) register equates
;*======================================================================*

; Pitch d00-d01:
;       distance between pixel phrases
BLIT_PITCH1    EQU $00                            ; 0 phrase gap
BLIT_PITCH2    EQU $01                            ; 1 phrase gap
BLIT_PITCH4    EQU $02                            ; 3 phrase gap
BLIT_PITCH8    EQU $03                            ; 7 phrase gap
BLIT_PITCH3    EQU $03                            ; 3 phrase gap

; Pixel d03-d05
;       bit depth (2^n)
BLIT_PIXEL1    EQU $00                            ; n = 0 0 color
BLIT_PIXEL2    EQU $08                            ; n = 1 2 colors
BLIT_PIXEL4    EQU $10                            ; n = 2 4 colors
BLIT_PIXEL8    EQU $18                            ; n = 3 8 colors
BLIT_PIXEL16   EQU $20                            ; n = 4 16 colors
BLIT_PIXEL32   EQU $28                            ; n = 5 32 colors

; Z offset d06-d08
;       offset from phrase of pixel data from its corresponding
;       Z data phrases
BLIT_ZOFFS0    EQU $00                            ; offset = 0    UNUSED
BLIT_ZOFFS1    EQU $40                            ; offset = 1
BLIT_ZOFFS2    EQU $80                            ; offset = 2
BLIT_ZOFFS3    EQU $C0                            ; offset = 3
BLIT_ZOFFS4    EQU $0100                          ; offset = 4
BLIT_ZOFFS5    EQU $0140                          ; offset = 5
BLIT_ZOFFS6    EQU $0180                          ; offset = 6
BLIT_ZOFFS7    EQU $01C0                          ; offset = 7    UNUSED

; Width d09-d14
;       width used for address generation
;       This is a 6-bit floating point value in pixels
;       4-bit unsigned exponent
;       2-bit mantissa with implied 3rd bit of 1
BLIT_WID2      EQU $0800                          ; 1.00 X 2^1  ( 4<<9)
BLIT_WID4      EQU $1000                          ; 1.00 X 2^2  ( 8<<9)
BLIT_WID6      EQU $1400                          ; 1.10 X 2^2  (10<<9)
BLIT_WID8      EQU $1800                          ; 1.00 x 2^3  (12<<9)
BLIT_WID10     EQU $1A00                          ; 1.01 X 2^3  (13<<9)
BLIT_WID12     EQU $1C00                          ; 1.10 X 2^3  (14<<9)
BLIT_WID14     EQU $1E00                          ; 1.11 X 2^3  (15<<9)
BLIT_WID16     EQU $2000                          ; 1.00 X 2^4  (16<<9)
BLIT_WID20     EQU $2200                          ; 1.01 X 2^4  (17<<9)
BLIT_WID24     EQU $2400                          ; 1.10 X 2^4  (18<<9)
BLIT_WID28     EQU $2600                          ; 1.11 X 2^4  (19<<9)
BLIT_WID32     EQU $2800                          ; 1.00 X 2^5  (20<<9)
BLIT_WID40     EQU $2A00                          ; 1.01 X 2^5  (21<<9)
BLIT_WID48     EQU $2C00                          ; 1.10 X 2^5  (22<<9)
BLIT_WID56     EQU $2E00                          ; 1.11 X 2^5  (23<<9)
BLIT_WID64     EQU $3000                          ; 1.00 X 2^6  (24<<9)
BLIT_WID80     EQU $3200                          ; 1.01 X 2^6  (25<<9)
BLIT_WID96     EQU $3400                          ; 1.10 X 2^6  (26<<9)
BLIT_WID112    EQU $3600                          ; 1.11 X 2^6  (27<<9)
BLIT_WID128    EQU $3800                          ; 1.00 X 2^7  (28<<9)
BLIT_WID160    EQU $3A00                          ; 1.01 X 2^7  (29<<9)
BLIT_WID192    EQU $3C00                          ; 1.10 X 2^7  (30<<9)
BLIT_WID224    EQU $3E00                          ; 1.11 X 2^7  (31<<9)
BLIT_WID256    EQU $4000                          ; 1.00 X 2^8  (32<<9)
BLIT_WID320    EQU $4200                          ; 1.01 X 2^8  (33<<9)
BLIT_WID384    EQU $4400                          ; 1.10 X 2^8  (34<<9)
BLIT_WID448    EQU $4600                          ; 1.11 X 2^8  (35<<9)
BLIT_WID512    EQU $4800                          ; 1.00 X 2^9  (36<<9)
BLIT_WID640    EQU $4A00                          ; 1.01 X 2^9  (37<<9)
BLIT_WID768    EQU $4C00                          ; 1.10 X 2^9  (38<<9)
BLIT_WID896    EQU $4E00                          ; 1.11 X 2^9  (39<<9)
BLIT_WID1024   EQU $5000                          ; 1.00 X 2^10 (40<<9)
BLIT_WID1280   EQU $5200                          ; 1.01 X 2^10 (41<<9)
BLIT_WID1536   EQU $5400                          ; 1.10 X 2^10 (42<<9)
BLIT_WID1792   EQU $5600                          ; 1.11 X 2^10 (43<<9)
BLIT_WID2048   EQU $5800                          ; 1.00 X 2^11 (44<<9)
BLIT_WID2560   EQU $5A00                          ; 1.01 X 2^11 (45<<9)
BLIT_WID3072   EQU $5C00                          ; 1.10 X 2^11 (46<<9)
BLIT_WID3584   EQU $5E00                          ; 1.11 X 2^11 (47<<9)

; X add control d16-d17
;       controls the update of the X pointer on each pass
;       round the inner loop
BLIT_XADDPHR   EQU $00                            ; 00 - add phrase width and truncate
BLIT_XADDPIX   EQU $010000                        ; 01 - add pixel size (add 1)
BLIT_XADD0     EQU $020000                        ; 10 - add zero
BLIT_XADDINC   EQU $030000                        ; 11 - add the increment

; Y add control d18
;       controls the update of the Y pointer within the inner loop.
;       it is overridden by the X add control if they are in add increment
BLIT_YADD0     EQU $00                            ; 00 - add zero
BLIT_YADD1     EQU $040000                        ; 01 - add 1

; X sign d19
;       add or subtract pixel size if X add control = 01 (XADDPIX)
BLIT_XSIGNADD  EQU $00                            ; 0 - add pixel size
BLIT_XSIGNSUB  EQU $080000                        ; 1 - subtract pixel size

; X sign d20
;       add or subtract pixel size if X add control = 01 (YADD1)
BLIT_YSIGNADD  EQU $00                            ; 0 - add 1
BLIT_YSIGNSUB  EQU $100000                        ; 1 - sub 1

;*======================================================================*
;*      GLOBAL VARIABLES                                                *
;*======================================================================*
