;
;       JAGUAR REGISTERS
;

REGSTART       EQU $F00000                        ; TOM Internal Register Base
RST                                                EQU REGSTART


;       TOM REGISTERS

MEMCON1        EQU REGSTART+0                     ; Memory Configuration Register One
MEMCON2        EQU REGSTART+2                     ; Memory Configuration Register Two
HC             EQU REGSTART+4                     ; Horizontal Count
VC             EQU REGSTART+6                     ; Vertical Count
LPH            EQU REGSTART+8                     ; Horizontal Lightpen
LPV            EQU REGSTART+$0A                   ; Vertical Lightpen
OB0            EQU REGSTART+$10                   ; Current Object Phrase
OB1            EQU REGSTART+$12
OB2            EQU REGSTART+$14
OB3            EQU REGSTART+$16
OLP            EQU REGSTART+$20                   ; Object List Pointer
OLPLO          EQU REGSTART+$20
OLPHI          EQU REGSTART+$22
ODP            EQU REGSTART+$24                   ; Object Data Pointer
OBF            EQU REGSTART+$26                   ; Object Processor Flag
VMODE          EQU REGSTART+$28                   ; Video Mode
BORD1          EQU REGSTART+$2A                   ; Border Color (Red & Green)
BORD2          EQU REGSTART+$2C                   ; Border Color (Blue)
VID_HP         EQU REGSTART+$2E                   ; Horizontal Period
VID_HBB        EQU REGSTART+$30                   ; Horizontal Blanking Begin
VID_HBE        EQU REGSTART+$32                   ; Horizontal Blanking End
VID_HS         EQU REGSTART+$34                   ; Horizontal Sync
VID_HVS        EQU REGSTART+$36                   ; Horizontal Vertical Sync
VID_HDB1       EQU REGSTART+$38                   ; Horizontal Display Begin One
VID_HDB2       EQU REGSTART+$3A                   ; Horizontal Display Begin Two
VID_HDE        EQU REGSTART+$3C                   ; Horizontal Display End
VID_VP         EQU REGSTART+$3E                   ; Vertical Period
VID_VBB        EQU REGSTART+$40                   ; Vertical Blanking Begin
VID_VBE        EQU REGSTART+$42                   ; Vertical Blanking End
VID_VS         EQU REGSTART+$44                   ; Vertical Sync
VID_VDB        EQU REGSTART+$46                   ; Vertical Display Begin
VID_VDE        EQU REGSTART+$48                   ; Vertical Display End
VID_VEB        EQU REGSTART+$4A                   ; Vertical EQUalization Begin
VID_VEE        EQU REGSTART+$4C                   ; Vertical EQUalization End
VID_VI         EQU REGSTART+$4E                   ; Vertical Interrupt
VID_PIT0       EQU REGSTART+$50                   ; Programmable Interrupt Timer (Lo)
VID_PIT1       EQU REGSTART+$52                   ; Programmable Interrupt Timer (Hi)
VID_HEQ        EQU REGSTART+$54                   ; Horizontal EQUalization End
VID_TEST1      EQU REGSTART+$56                   ; Undocumented Register - DO NOT USE
VID_BG         EQU REGSTART+$58                   ; Background Color

INT1           EQU REGSTART+$E0                   ; CPU Interrupt Control Register
INT2           EQU REGSTART+$E2                   ; CPU Interrupt Resume Register

CLUT           EQU REGSTART+$0400                 ; Color Lookup Table

LBUFA          EQU REGSTART+$0800                 ; Line Buffer A
LBUFB          EQU REGSTART+$1000                 ; Line Buffer B
LBUFC          EQU REGSTART+$1800                 ; Line Buffer Current

;
;       GPU REGISTERS
;
GPU_FLAGS      EQU REGSTART+$2100                 ; GPU Flags
GPU_MTXC       EQU REGSTART+$2104                 ; GPU Matrix Control
GPU_MTXA       EQU REGSTART+$2108                 ; GPU Matrix Address
GPU_END        EQU REGSTART+$210C                 ; GPU Data Organization
GPU_PC         EQU REGSTART+$2110                 ; GPU Program Counter
GPU_CTRL       EQU REGSTART+$2114                 ; GPU Operation Control/Status
GPU_HIDATA     EQU REGSTART+$2118                 ; GPU Bus Interface high data
GPU_REMAIN     EQU REGSTART+$211C                 ; GPU Division Remainder
GPU_DIVCTRL    EQU REGSTART+$211C                 ; DSP Divider control
GPU_RAM        EQU REGSTART+$3000                 ; GPU Internal RAM
GPU_ENDRAM     EQU GPU_RAM+(4*1024)               ; 4K bytes
;
;       BLITTER REGISTERS
;
BLIT_A1_BASE   EQU REGSTART+$2200                 ; A1 Base Address
BLIT_A1_FLAGS  EQU REGSTART+$2204                 ; A1 Control Flags
BLIT_A1_CLIP   EQU REGSTART+$2208                 ; A1 Clipping Size
BLIT_A1_PIXEL  EQU REGSTART+$220C                 ; A1 Pixel Pointer
BLIT_A1_STEP   EQU REGSTART+$2210                 ; A1 Step (Integer Part)
BLIT_A1_FSTEP  EQU REGSTART+$2214                 ; A1 Step (Fractional Part)
BLIT_A1_FPIXEL EQU REGSTART+$2218                 ; A1 Pixel Pointer (Fractional)
BLIT_A1_INC    EQU REGSTART+$221C                 ; A1 Increment (Integer Part)
BLIT_A1_FINC   EQU REGSTART+$2220                 ; A1 Increment (Fractional Part)
BLIT_A2_BASE   EQU REGSTART+$2224                 ; A2 Base Address
BLIT_A2_FLAGS  EQU REGSTART+$2228                 ; A2 Control Flags
BLIT_A2_MASK   EQU REGSTART+$222C                 ; A2 Address Mask
BLIT_A2_PIXEL  EQU REGSTART+$2230                 ; A2 PIXEL
BLIT_A2_STEP   EQU REGSTART+$2234                 ; A2 Step (Integer)

BLIT_CMD       EQU REGSTART+$2238                 ; Command
BLIT_COUNT     EQU REGSTART+$223C                 ; Counters
BLIT_SRCD      EQU REGSTART+$2240                 ; Source Data
BLIT_DSTD      EQU REGSTART+$2248                 ; Destination Data
BLIT_DSTZ      EQU REGSTART+$2250                 ; Destination Z
BLIT_SRCZ1     EQU REGSTART+$2258                 ; Source Z (Integer)
BLIT_SRCZ2     EQU REGSTART+$2260                 ; Source Z (Fractional)
BLIT_PATD      EQU REGSTART+$2268                 ; Pattern Data
BLIT_IINC      EQU REGSTART+$2270                 ; Intensity Increment
BLIT_ZINC      EQU REGSTART+$2274                 ; Z Increment
BLIT_STOP      EQU REGSTART+$2278                 ; Collision stop control

BLIT_I3        EQU REGSTART+$227C                 ; Blitter Intensity 3
BLIT_I2        EQU REGSTART+$2280                 ; Blitter Intensity 2
BLIT_I1        EQU REGSTART+$2284                 ; Blitter Intensity 1
BLIT_I0        EQU REGSTART+$2288                 ; Blitter Intensity 0

BLIT_Z3        EQU REGSTART+$228C                 ; Blitter Z 3
BLIT_Z2        EQU REGSTART+$2290                 ; Blitter Z 2
BLIT_Z1        EQU REGSTART+$2294                 ; Blitter Z 1
BLIT_Z0        EQU REGSTART+$2298                 ; Blitter Z 0

;       JERRY REGISTERS

JPIT1          EQU REGSTART+$010000
JPIT1_PRE      EQU REGSTART+$010000
JPIT1_DIV      EQU REGSTART+$010002
JPIT2_PRE      EQU REGSTART+$010004
JPIT2_DIV      EQU REGSTART+$010006

CLK1           EQU REGSTART+$010010               ; Processor Clock Frequency
CLK2           EQU REGSTART+$010012               ; Video Clock Frequency
CHRO_CLK       EQU REGSTART+$010014               ; Chroma clock control

JOYSTICK       EQU REGSTART+$014000               ; Joystick register
JOYBUTS        EQU REGSTART+$014002               ; Joystick register
CONFIG         EQU REGSTART+$014002               ; Also has NTSC/PAL

MOD_MASK       EQU REGSTART+$01A118               ; Mask for ADDQ(SUBQ)MOD

SCLK           EQU REGSTART+$01A150               ; SSI Clock Frequency
SMODE          EQU REGSTART+$01A154               ; SSI Control

R_DAC          EQU REGSTART+$01A148
L_DAC          EQU REGSTART+$01A14C

L_I2S          EQU REGSTART+$01A148
R_I2S          EQU REGSTART+$01A14C

;       ROM Tables built into Jerry 128 samples
;       16 bit samples sign extended to 32

ROM_TABLE      EQU REGSTART+$01D000               ; Base of tables

; These are NEW CHANGED DIFFERENT Equates they should cause less confusion

ROM_TRI        EQU REGSTART+$01D000               ; A triangle wave
ROM_SINE       EQU REGSTART+$01D200               ; Full amplitude SINE
ROM_AMSINE     EQU REGSTART+$01D400               ; Linear (?) ramp SINE
ROM_12W        EQU REGSTART+$01D600               ; SINE(X)+SINE(2*X)
ROM_CHIRP16    EQU REGSTART+$01D800               ; SHORT SWEEP
ROM_NTRI       EQU REGSTART+$01DA00               ; Triangle w/NOISE
ROM_DELTA      EQU REGSTART+$01DC00               ; Positive spike
ROM_NOISE      EQU REGSTART+$01DE00               ; Guess

;       JERRY Registers (DSP)

DSP_INT        EQU REGSTART+$010020               ; DSP Interrupt Control
DSP_FLAGS      EQU REGSTART+$01A100               ; DSP Flags
DSP_MTXC       EQU REGSTART+$01A104               ; DSP Matrix Control
DSP_MTXA       EQU REGSTART+$01A108               ; DSP Matrix Address
DSP_END        EQU REGSTART+$01A10C               ; DSP Data Organization
DSP_PC         EQU REGSTART+$01A110               ; DSP Program Counter
DSP_CTRL       EQU REGSTART+$01A114               ; DSP Operation Control/Status
DSP_HIDATA     EQU REGSTART+$01A118               ; DSP Bus Interface high data
DSP_REMAIN     EQU REGSTART+$01A11C               ; DSP Division Remainder
DSP_DIVCTRL    EQU REGSTART+$01A11C               ; DSP Divider control
DSP_RAM        EQU REGSTART+$01B000               ; DSP Internal RAM
DSP_ENDRAM     EQU DSP_RAM+(8*1024)               ; 8K bytes
