*****************************************************************
*                Protracker 3.00B playroutine               *
* Written by Tom "Outland" Bech and Ivar "Heatseeker" J. Olsen. *
* Based upon Protracker 1.1A playroutine written by Lars Hamre. *
*          VBlank version. Not optimised in any way.            *
*****************************************************************
* Call pt_InitMusic before start. Then call pt_PlayMusic at VB. *
* To stop the music, call pt_StopMusic.                         *
* Please note that in this version, all SetTempo commands are   *
* ignored. This assembly language program has been tested with  *
* the Devpac 3.0, AsmOne 1.2, MCAsm 1.5 and a68k assemblers and *
* may have to be modified for other assemblers.         *
*****************************************************************
;================================================================
;   Erweitert auf zustzlichen 8-Stimmen-Support, die Variablen ;
;  pt_patternpos_shift, pt_patternpos_add und pt_patternpos_len ;
;           enthalten die Anpassungswerte fr 8 Stimmen         ;
;  Alle nderungen die ich fr die zustzliche 8-Stimmen-Unter- ;
;   Sttzung gemacht habe, sind mit dem Kommentar ";===8" ge-   ;
;                         kennzeichnet                          ;
;                  tIn/Absence/Independent in 1995              ;
;================================================================

; FileFormat offsets
sd_songname        EQU 0                ;songname offset
sd_sampleinfo      EQU 20               ;first sample starts here
sd_numofpatt       EQU 950              ;number of patterns are stored here
sd_pattpos         EQU 952              ;pattern positions table is here
sd_mahokakt        EQU 1080             ;"M.K." :)
sd_patterndata     EQU 1084             ;first pattern starts at this position

; Song offsets. W/L/B means word/longword/byte length.
n_note             EQU 0                ;W
n_cmd              EQU 2                ;W
n_cmdlo            EQU 3                ;low B of cmd
n_start            EQU 4                ;L
n_length           EQU 8                ;W
n_loopstart        EQU 10               ;L
n_replen           EQU 14               ;W
n_period           EQU 16               ;W
n_finetune         EQU 18               ;B
n_volume           EQU 19               ;B
n_dmabit           EQU 20               ;W
n_toneportdirec    EQU 22               ;B
n_toneportspeed    EQU 23               ;B
n_wantedperiod     EQU 24               ;W
n_vibratocmd       EQU 26               ;B
n_vibratopos       EQU 27               ;B
n_tremolocmd       EQU 28               ;B
n_tremolopos       EQU 29               ;B
n_wavecontrol      EQU 30               ;B
n_glissfunk        EQU 31               ;B
n_sampleoffset     EQU 32               ;B
n_pattpos          EQU 33               ;B
n_loopcount        EQU 34               ;B
n_funkoffset       EQU 35               ;B
n_wavestart        EQU 36               ;L
n_reallength       EQU 40               ;W
n_trigger          EQU 42               ;B
n_samplenum        EQU 43               ;B

***************************************************************************
dff096_contr:
                    move.w D0,-(SP)
                    move.w 4+2(SP),D0
                    btst   #15,D0       ;Bits setzen?
                    bne.s  ap_bits_set
                    not.w  D0
                    and.w  D0,dff096    ;Bits lschen
                    bra.s  dff096_contr_end
ap_bits_set:
                    or.w   D0,dff096    ;Bits setzen
dff096_contr_end:
                    move.w (SP)+,D0
                    rts
*****************************************************************************

pt_initmusic:
;original code by Aeon of AURA
;recoding by Chris of AURA
;a6: Modulbeginn
*****************************************************************************
ap_mod_init:
                    move.l A6,pt_songdataptr ;Moduladr. speichern
                    move.l 1080(A6),D0
                    cmp.l  #"M.K.",D0
                    beq.s  ap_mk
                    cmp.l  #"FLT4",D0
                    beq.s  ap_mk
                    cmp.l  #"8CHN",D0
                    beq.s  ap_8chn
                    cmp.l  #"CD81",D0
                    beq.s  ap_8chn
                    moveq  #-1,D0       ; MOD-Art nicht erkannt ==> Fehler
                    rts
ap_mk:
                    move.w #4,pt_patternpos_shift
                    move.l #16,pt_patternpos_add
                    move.l #1024,pt_patternpos_len
                    bra.s  ap_mod_continue
ap_8chn:
                    move.w #4+1,pt_patternpos_shift
                    move.l #16*2,pt_patternpos_add
                    move.l #1024*2,pt_patternpos_len

ap_mod_continue:
                    lea    $03B6(A6),A0 ;songlength-adresse
                    move.b (A0)+,D0
                    move.b (A0)+,D1
                    cmp.b  D0,D1        ;repeat <= songlength
                    bls.s  ap_no_buggy  ;dann alles ok
                    clr.b  -1(A0)       ;sonst bug entfernen

;a0: sequenzer-adresse
ap_no_buggy:
                    moveq  #128-1,D0    ;max.128 positions
                    moveq  #0,D1        ;max-pattern = 0

ap_search_max:
                    cmp.b  (A0)+,D1     ;pattern > d1
                    bhi.s  ap_searching ;sonst weitersuchen
                    move.b -1(A0),D1    ;max bernehmen
ap_searching:
                    dbra   D0,ap_search_max ;alle 128 positions durchsuchen
                    addq.l #1,D1        ;max-pattern +1
                    moveq  #10-4,D0     ;10 mal shiften
                    add.w  pt_patternpos_shift(PC),D0
                    lsl.l  D0,D1        ;*1024 (1024 bytes pro pattern)

                    lea    (A6),A0      ;module-adresse
                    lea    $14+$16(A0),A1 ;zeiger aus lnge sample 1
                    lea    $043C(A0),A0 ;offset zu den patterns
                    adda.l D1,A0        ;adresse sample 1
                    lea    pt_samplestarts(PC),A2 ;sample-tabelle

                    moveq  #31-1,D0     ;max.31 instumente
                    moveq  #0,D2        ;anzahl intrumente = 0

ap_set_tabl:
                    move.l A0,(A2)+     ;adresse in tabelle eintragen
                    moveq  #0,D1        ;d1.l lschen
                    move.w (A1),D1      ;sample-length lesen
                    beq.s  ap_any_spl   ;0:kein sample
                    adda.l D1,A0
                    adda.l D1,A0
;>            lea     (a0,d1.l*2),a0      ;Adr. des nchsten Samples
                    addq.w #1,D2        ;instrumenten-anzahl erhhen
ap_any_spl:
                    lea    $1E(A1),A1   ;zeiger auf nchste lnge   setzen
                    dbra   D0,ap_set_tabl ;alle 31 samples

;d2.l:anzahl der instrumente
;a1.l:ende sample-lngen + $1e
;a2.l:ende sample-tab + 4
                    subq.w #1,D2
                    moveq  #31-1,D0     ;max.31 samples
ap_convert_spls:
                    lea    -$1E(A1),A1  ;Zeiger auf vorherige Samplelnge
                    movea.l -(A2),A0    ;Samplestartadr. holen
                    moveq  #0,D3
                    move.w (A1),D3      ;Samplelnge holen
                    beq.s  ap_conv_no_sample

                    moveq  #0,D1
                    move.w D2,D1        ;Anzahl vorhandener Samples nach d1
                    mulu   #330*2,D1    ;* Verschiebedifferenz
                    lea    0(A0,D1.l),A3 ;neue Sampleadr.
                    move.l A3,(A2)      ;und speichern
;            lea     (a0,d3.l*2),a0      ;Sampleendadr. errechnen
                    adda.l D3,A0
                    adda.l D3,A0
                    lea    0(A0,D1.l),A3 ;neue Sampleendadr.
                    subq.w #1,D3
ap_copy_up:
                    move.w -(A0),D4     ;Sample holen
                    eori.w #$8080,D4    ;Integerkonvertierung
                    move.w D4,-(A3)     ;und speichern
                    dbra   D3,ap_copy_up

                    movea.l (A2),A3     ;Samplestartadr. holen
                    moveq  #0,D3
                    move.w 6(A1),D3     ;Repeatlnge holen
                    cmp.w  #1,D3        ;<=1?
                    bhi.s  ap_gen_loop
;kein Loop >> nach Sampleende lschen
                    moveq  #0,D3
                    move.w (A1),D3      ;Samplelnge holen
;>            lea     (a3,d3.l*2),a3      ;Sampleende errechnen
                    adda.l D3,A3
                    adda.l D3,A3
                    move.w #330-1,D3    ;330 Worte
ap_clr_sample:
                    move.w #$8080,(A3)+ ;lschen
                    dbra   D3,ap_clr_sample
                    bra.s  ap_nun_weiter
;Loop >> 330 Worte kopieren
ap_gen_loop:
                    moveq  #0,D4
                    move.w 4(A1),D4
;>            lea     (a3,d4.l*2),a3      ;Startadr. des Loops
                    adda.l D4,A3
                    adda.l D4,A3
;>            lea     (a3,d3.l*2),a4      ;Endadr. des Loops
                    movea.l A3,A4
                    adda.l D3,A4
                    adda.l D3,A4

                    move.w #330-1,D3    ;330 Worte
ap_copy_sample:
                    move.w (A3)+,(A4)+  ;kopieren
                    dbra   D3,ap_copy_sample

ap_nun_weiter:
                    subq.w #1,D2        ;vorhandene samples -1
                    bmi.s  ap_conv_ende ;wasserdicht !
ap_conv_no_sample:
                    dbra   D0,ap_convert_spls
ap_conv_ende:
*****************************************************************************
                    move.b #6,pt_speed  ;default speed
*   OR.B    #2,$BFE001
                    moveq  #0,D0
                    lea    dff0a0,A0
                    move.w D0,$08(A0)
                    move.w D0,$18(A0)
                    move.w D0,$28(A0)
                    move.w D0,$38(A0)
                    move.w D0,$48(A0)
                    move.w D0,$58(A0)
                    move.w D0,$68(A0)
                    move.w D0,$78(A0)
                    clr.b  pt_songpos
                    clr.b  pt_counter
                    clr.b  pt_pattpos
                    move.w #$0F,-(SP)
                    bsr    dff096_contr
                    addq.w #2,SP
                    moveq  #0,D0
                    rts

*pt_StopMusic
*   MOVEM.L D0/A0,-(SP)
*   MOVEQ   #0,D0
*   LEA DFF0A0,A0
*   MOVE.W  D0,$08(A0)
*   MOVE.W  D0,$18(A0)
*   MOVE.W  D0,$28(A0)
*   MOVE.W  D0,$38(A0)
*   MOVE.W  #$000F,DFF096       ;stop AudioDMA activity
*   MOVEM.L (SP)+,D0/A0
*   RTS

ap_playmusic:
pt_playmusic:
*   MOVEM.L D0-D7/A0-A6,-(SP)
                    movea.l pt_songdataptr(PC),A0
                    addq.l #1,pt_counter
                    move.l pt_counter(PC),D0
                    cmp.l  pt_currspeed(PC),D0
                    blo.s  pt_nonewnote
                    clr.l  pt_counter
                    tst.b  pt_pattdelaytime2
                    beq    pt_getnewnote
                    bsr.s  pt_nonewallchannels
                    bra    pt_dskip

pt_nonewnote:
                    bsr.s  pt_nonewallchannels
                    bra    pt_nonewpositionyet

pt_nonewallchannels:
                    lea    pt_audchan1temp(PC),A6
                    lea    dff0a0,A5
                    bsr    pt_checkeffects
                    lea    pt_audchan2temp(PC),A6
                    lea    dff0b0,A5
                    bsr    pt_checkeffects
                    lea    pt_audchan3temp(PC),A6
                    lea    dff0c0,A5
                    bsr    pt_checkeffects
                    lea    pt_audchan4temp(PC),A6
                    lea    dff0d0,A5

                    cmp    #4,pt_patternpos_shift
                    beq    pt_checkeffects

                    bsr    pt_checkeffects

;===8
                    lea    pt_audchan1temp2(PC),A6
                    lea    dff0a0_2,A5
                    bsr    pt_checkeffects
                    lea    pt_audchan2temp2(PC),A6
                    lea    dff0b0_2,A5
                    bsr    pt_checkeffects
                    lea    pt_audchan3temp2(PC),A6
                    lea    dff0c0_2,A5
                    bsr    pt_checkeffects
                    lea    pt_audchan4temp2(PC),A6
                    lea    dff0d0_2,A5
                    bra    pt_checkeffects


pt_getnewnote:
                    lea    12(A0),A3
                    lea    sd_pattpos(A0),A2
                    lea    sd_patterndata(A0),A0
                    moveq  #0,D1
                    move.l pt_songposition(PC),D0
                    move.b 0(A2,D0.w),D1
                    asl.l  #8-2,D1      ;*1024   Patternadresse berechnen
;===8
                    move.l D0,-(SP)     ; bei 8 Stimmen wird hier
                    move.w pt_patternpos_shift,D0 ;*2048 genommen
                    asl.l  D0,D1
                    move.l (SP)+,D0

                    add.l  pt_patternposition(PC),D1
                    move.l D1,pt_patternptr
                    clr.w  pt_dmacontemp
                    lea    dff0a0,A5
                    lea    pt_audchan1temp(PC),A6
                    moveq  #1,D2
                    bsr    pt_playvoice
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    move.w D0,8(A5)
                    lea    dff0b0,A5
                    lea    pt_audchan2temp(PC),A6
                    moveq  #2,D2
                    bsr    pt_playvoice
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    move.w D0,8(A5)
                    lea    dff0c0,A5
                    lea    pt_audchan3temp(PC),A6
                    moveq  #3,D2
                    bsr    pt_playvoice
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    move.w D0,8(A5)
                    lea    dff0d0,A5
                    lea    pt_audchan4temp(PC),A6
                    moveq  #4,D2
                    bsr    pt_playvoice
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    move.w D0,8(A5)
;===8
                    cmp    #4,pt_patternpos_shift
                    beq    pt_setdma

                    lea    dff0a0_2,A5
                    lea    pt_audchan1temp2(PC),A6
                    moveq  #5,D2
                    bsr    pt_playvoice
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    move.w D0,8(A5)
                    lea    dff0b0_2,A5
                    lea    pt_audchan2temp2(PC),A6
                    moveq  #6,D2
                    bsr.s  pt_playvoice
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    move.w D0,8(A5)
                    lea    dff0c0_2,A5
                    lea    pt_audchan3temp2(PC),A6
                    moveq  #7,D2
                    bsr.s  pt_playvoice
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    move.w D0,8(A5)
                    lea    dff0d0_2,A5
                    lea    pt_audchan4temp2(PC),A6
                    moveq  #8,D2
                    bsr.s  pt_playvoice
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    move.w D0,8(A5)

                    bra    pt_setdma

pt_checkmetronome:
                    cmp.b  pt_metrochannel,D2
                    bne    pt_return
                    move.b pt_metrospeed,D2
                    beq    pt_return
                    move.l pt_patternposition,D3
;===8
                    move.l D0,-(SP)
                    move.w pt_patternpos_shift(PC),D0
                    lsr.l  D0,D3        ;<<4 (<<5 nur fr 8 Stimmen)
                    move.l (SP)+,D0

                    divu   D2,D3
                    swap   D3
                    tst.w  D3
                    bne    pt_return
                    andi.l #$0FFF,(A6)
                    ori.l  #$10D6F000,(A6) ;Play sample $1F at period $0D6 (214)
                    rts

pt_playvoice:
                    tst.l  (A6)
                    bne.s  pt_plvskip
                    bsr    pt_pernop
pt_plvskip:
                    move.l 0(A0,D1.l),(A6) ;Read one track from pattern
                    bsr.s  pt_checkmetronome
                    addq.l #4,D1
                    moveq  #0,D2
                    move.b n_cmd(A6),D2 ;Get lower 4 bits of instrument
                    and.b  #$F0,D2
                    lsr.b  #4,D2
                    move.b (A6),D0      ;Get higher 4 bits of instrument
                    and.b  #$F0,D0
                    or.b   D0,D2
                    tst.b  D2
                    beq.s  pt_setregisters ;Instrument was zero
                    moveq  #0,D3
                    lea    pt_samplestarts(PC),A1
                    move.w D2,D4
                    move.b D2,n_samplenum(A6)
                    subq.l #1,D2
                    lsl.l  #2,D2
                    mulu   #30,D4
                    move.l 0(A1,D2.l),n_start(A6)
                    move.w 0(A3,D4.l),n_length(A6)
                    move.w 0(A3,D4.l),n_reallength(A6)
                    move.b 2(A3,D4.l),n_finetune(A6)
                    move.b 3(A3,D4.l),n_volume(A6)
                    move.w 4(A3,D4.l),D3 ;Get repeat
                    tst.w  D3
                    beq.s  pt_noloop
                    move.l n_start(A6),D2 ;Get start
                    asl.w  #1,D3
                    add.l  D3,D2        ;Add repeat
                    move.l D2,n_loopstart(A6)
                    move.l D2,n_wavestart(A6)
                    move.w 4(A3,D4.l),D0 ;Get repeat
                    add.w  6(A3,D4.l),D0 ;Add replen
                    move.w D0,n_length(A6)
                    move.w 6(A3,D4.l),n_replen(A6) ;Save replen
                    bra.s  pt_setregisters

pt_noloop:
                    move.l n_start(A6),D2
                    add.l  D3,D2
                    move.l D2,n_loopstart(A6)
                    move.l D2,n_wavestart(A6)
                    move.w 6(A3,D4.l),n_replen(A6) ;Save replen
pt_setregisters:
                    move.w (A6),D0
                    and.w  #$0FFF,D0
                    beq    pt_checkmoreeffects ;If no note ->
                    move.w 2(A6),D0
                    and.w  #$0FF0,D0
                    cmp.w  #$0E50,D0    ;finetune?
                    beq.s  pt_dosetfinetune
                    move.b 2(A6),D0
                    and.b  #$0F,D0
                    cmp.b  #3,D0        ;TonePortamento?
                    beq.s  pt_chktoneporta
                    cmp.b  #5,D0        ;TonePortamento + VolSlide?
                    beq.s  pt_chktoneporta
                    cmp.b  #9,D0        ;Sample Offset?
                    bne.s  pt_setperiod
                    bsr    pt_checkmoreeffects
                    bra.s  pt_setperiod

pt_dosetfinetune:
                    bsr    pt_setfinetune
                    bra.s  pt_setperiod

pt_chktoneporta:
                    bsr    pt_settoneporta
                    bra    pt_checkmoreeffects

pt_setperiod:
                    movem.l D0-D1/A0-A1,-(SP)
                    move.w (A6),D1
                    and.w  #$0FFF,D1
                    lea    pt_periodtable(PC),A1
                    moveq  #0,D0
                    moveq  #$24,D7
pt_ftuloop:
                    cmp.w  0(A1,D0.w),D1
                    bhs.s  pt_ftufound
                    addq.l #2,D0
                    dbra   D7,pt_ftuloop
pt_ftufound:
                    moveq  #0,D1
                    move.b n_finetune(A6),D1
                    mulu   #37*2,D1
                    adda.l D1,A1
                    move.w 0(A1,D0.w),n_period(A6)
                    movem.l (SP)+,D0-D1/A0-A1

                    move.w 2(A6),D0
                    and.w  #$0FF0,D0
                    cmp.w  #$0ED0,D0
                    beq    pt_checkmoreeffects

*   MOVE.W  n_dmabit(A6),DFF096
                    move.w n_dmabit(A6),-(SP)
                    bsr    dff096_contr
                    addq.w #2,SP
                    btst   #2,n_wavecontrol(A6)
                    bne.s  pt_vibnoc
                    clr.b  n_vibratopos(A6)
pt_vibnoc:
                    btst   #6,n_wavecontrol(A6)
                    bne.s  pt_trenoc
                    clr.b  n_tremolopos(A6)
pt_trenoc:
                    move.w n_length(A6),4(A5) ;Set length
                    move.l n_start(A6),(A5) ;Set start
                    bne.s  pt_sdmaskp
                    clr.l  n_loopstart(A6)
                    moveq  #1,D0
                    move.w D0,4(A5)
                    move.w D0,n_replen(A6)
pt_sdmaskp:
                    move.w n_period(A6),D0
                    move.w D0,6(A5)     ;Set period
                    st     n_trigger(A6)
                    move.w n_dmabit(A6),D0
                    or.w   D0,pt_dmacontemp
                    bra    pt_checkmoreeffects

pt_setdma:
*   move.b  pt_timeout,$bfe701  ;TimerB HI
*   move.b  pt_timeout+1,$bfe601    ;TimerB LO
*   move.b  #%000011001,$bfef01 ;set commandbits: OneShot & CLK & Start
*pt_timerwait1
*   btst    #0,$bfef01      ;timeout on timerB? (ICR TimerB)
*   bne.s   pt_timerwait1       ;nope...
                    move.w pt_dmacontemp,D0
                    and.w  pt_activechannels,D0 ;mask out inactive channels
                    or.w   #$8000,D0
*   MOVE.W  D0,DFF096
                    move.w D0,-(SP)
                    bsr    dff096_contr
                    addq.w #2,SP
*   move.b  pt_timeout,$bfe701  ;TimerB HI
*   move.b  pt_timeout+1,$bfe601    ;TimerB LO
*   move.b  #%000011001,$bfef01 ;set commandbits: OneShot & CLK & Start
*pt_timerwait2
*   btst    #0,$bfef01      ;timeout on timerB? (ICR TimerB)
*   bne.s   pt_timerwait2       ;nope...
                    lea    dff0a0,A5
                    lea    pt_audchan4temp(PC),A6
                    move.l n_loopstart(A6),$D0-$A0+10(A5)
                    move.w n_replen(A6),$D4-$A0+10(A5)
                    lea    pt_audchan3temp(PC),A6
                    move.l n_loopstart(A6),$C0-$A0+10(A5)
                    move.w n_replen(A6),$C4-$A0+10(A5)
                    lea    pt_audchan2temp(PC),A6
                    move.l n_loopstart(A6),$B0-$A0+10(A5)
                    move.w n_replen(A6),$B4-$A0+10(A5)
                    lea    pt_audchan1temp(PC),A6
                    move.l n_loopstart(A6),$A0-$A0+10(A5)
                    move.w n_replen(A6),$A4-$A0+10(A5)
;===8
                    cmp    #4,pt_patternpos_shift
                    beq.s  pt_dskip

                    lea    dff0a0_2,A5
                    lea    pt_audchan4temp2(PC),A6
                    move.l n_loopstart(A6),$D0-$A0+10(A5)
                    move.w n_replen(A6),$D4-$A0+10(A5)
                    lea    pt_audchan3temp2(PC),A6
                    move.l n_loopstart(A6),$C0-$A0+10(A5)
                    move.w n_replen(A6),$C4-$A0+10(A5)
                    lea    pt_audchan2temp2(PC),A6
                    move.l n_loopstart(A6),$B0-$A0+10(A5)
                    move.w n_replen(A6),$B4-$A0+10(A5)
                    lea    pt_audchan1temp2(PC),A6
                    move.l n_loopstart(A6),$A0-$A0+10(A5)
                    move.w n_replen(A6),$A4-$A0+10(A5)

pt_dskip:
;===8
                    move.l D0,-(SP)
                    move.l pt_patternpos_add(PC),D0
                    add.l  D0,pt_patternposition ;16 (*32 nur fr 8 Stimmen)
                    move.l (SP)+,D0

                    move.b pt_pattdelaytime,D0
                    beq.s  pt_dskpc
                    move.b D0,pt_pattdelaytime2
                    clr.b  pt_pattdelaytime
pt_dskpc:
                    tst.b  pt_pattdelaytime2
                    beq.s  pt_dskpa
                    subq.b #1,pt_pattdelaytime2
                    beq.s  pt_dskpa
;===8
                    move.l D0,-(SP)
                    move.l pt_patternpos_add(PC),D0
                    sub.l  D0,pt_patternposition ;16 (*32 nur fr 8 Stimmen)
                    move.l (SP)+,D0
pt_dskpa:
                    tst.b  pt_pbreakflag
                    beq.s  pt_nnpysk
                    sf     pt_pbreakflag
                    moveq  #0,D0
                    move.b pt_pbreakposition(PC),D0
;===8
                    move.l D1,-(SP)
                    move.w pt_patternpos_shift(PC),D1
                    lsl.w  D1,D0        ;<<4 (<<5 nur fr 8 Stimmen)
                    move.l (SP)+,D1

                    move.l D0,pt_patternposition
                    clr.b  pt_pbreakposition
pt_nnpysk:
;===8
;>                    move.l D2,-(SP)
                    move.l pt_patternpos_len(PC),D7
                    cmp.l  pt_patternposition,D7 ;1024 (2048 nur fr 8 Stimmen)
                    bne.s  pt_nonewpositionyet
pt_nextposition:
                    moveq  #0,D0
                    move.b pt_pbreakposition(PC),D0
;===8
                    move.l D1,-(SP)
                    move.w pt_patternpos_shift(PC),D1
                    lsl.w  D1,D0        ;<<4 (<<5 nur fr 8 Stimmen)
                    move.l (SP)+,D1

                    move.l D0,pt_patternposition
                    clr.b  pt_pbreakposition
                    clr.b  pt_posjumpassert
                    addq.l #1,pt_songposition
                    andi.l #$7F,pt_songposition
                    move.l pt_songposition(PC),D1
                    movea.l pt_songdataptr(PC),A0
                    cmp.b  sd_numofpatt(A0),D1
                    blo.s  pt_nonewpositionyet
                    clr.l  pt_songposition
pt_nonewpositionyet:
;>                    move.l (SP)+,D2
                    tst.b  pt_posjumpassert
                    bne.s  pt_nextposition
*   MOVEM.L (SP)+,D0-D7/A0-A6
                    rts

pt_checkeffects:
                    bsr.s  pt_chkefx2
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    move.w D0,8(A5)
                    rts

pt_chkefx2:
                    bsr    pt_updatefunk
                    move.w n_cmd(A6),D0
                    and.w  #$0FFF,D0
                    beq.s  pt_return
                    move.b n_cmd(A6),D0
                    and.b  #$0F,D0
                    tst.b  D0
                    beq.s  pt_arpeggio
                    cmp.b  #1,D0
                    beq    pt_portaup
                    cmp.b  #2,D0
                    beq    pt_portadown
                    cmp.b  #3,D0
                    beq    pt_toneportamento
                    cmp.b  #4,D0
                    beq    pt_vibrato
                    cmp.b  #5,D0
                    beq    pt_toneplusvolslide
                    cmp.b  #6,D0
                    beq    pt_vibratoplusvolslide
                    cmp.b  #$0E,D0
                    beq    pt_ecommands
pt_setback:
                    move.w n_period(A6),6(A5)
                    cmp.b  #7,D0
                    beq    pt_tremolo
                    cmp.b  #$0A,D0
                    beq    pt_volumeslide
pt_return:
                    rts

pt_pernop:
                    move.w n_period(A6),6(A5)
                    rts

pt_arpeggio:
                    moveq  #0,D0
                    move.l pt_counter(PC),D0
                    divs   #3,D0
                    swap   D0
                    cmp.w  #1,D0
                    beq.s  pt_arpeggio1
                    cmp.w  #2,D0
                    beq.s  pt_arpeggio2
pt_arpeggio0:
                    move.w n_period(A6),D2
                    bra.s  pt_arpeggioset

pt_arpeggio1:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    lsr.b  #4,D0
                    bra.s  pt_arpeggiofind

pt_arpeggio2:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    and.b  #15,D0
pt_arpeggiofind:
                    asl.w  #1,D0
                    moveq  #0,D1
                    move.b n_finetune(A6),D1
                    mulu   #37*2,D1
                    lea    pt_periodtable(PC),A0
                    adda.l D1,A0
                    moveq  #0,D1
                    move.w n_period(A6),D1
                    moveq  #$24,D7
pt_arploop:
                    move.w 0(A0,D0.w),D2
                    cmp.w  (A0),D1
                    bhs.s  pt_arpeggioset
                    addq.l #2,A0
                    dbra   D7,pt_arploop
                    rts

pt_arpeggioset:
                    move.w D2,6(A5)
                    rts

pt_fineportaup:
                    tst.l  pt_counter
                    bne.s  pt_return
                    move.b #$0F,pt_lowmask
pt_portaup:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    and.b  pt_lowmask,D0
                    move.b #$FF,pt_lowmask
                    sub.w  D0,n_period(A6)
                    move.w n_period(A6),D0
                    and.w  #$0FFF,D0
                    cmp.w  #$71,D0
                    bpl.s  pt_portauskip
                    andi.w #$F000,n_period(A6)
                    ori.w  #$71,n_period(A6)
pt_portauskip:
                    move.w n_period(A6),D0
                    and.w  #$0FFF,D0
                    move.w D0,6(A5)
                    rts

pt_fineportadown:
                    tst.l  pt_counter
                    bne    pt_return
                    move.b #$0F,pt_lowmask
pt_portadown:
                    clr.w  D0
                    move.b n_cmdlo(A6),D0
                    and.b  pt_lowmask,D0
                    move.b #$FF,pt_lowmask
                    add.w  D0,n_period(A6)
                    move.w n_period(A6),D0
                    and.w  #$0FFF,D0
                    cmp.w  #$0358,D0
                    bmi.s  pt_portadskip
                    andi.w #$F000,n_period(A6)
                    ori.w  #$0358,n_period(A6)
pt_portadskip:
                    move.w n_period(A6),D0
                    and.w  #$0FFF,D0
                    move.w D0,6(A5)
                    rts

pt_settoneporta:
                    move.l A0,-(SP)
                    move.w (A6),D2
                    and.w  #$0FFF,D2
                    moveq  #0,D0
                    move.b n_finetune(A6),D0
                    mulu   #37*2,D0
                    lea    pt_periodtable(PC),A0
                    adda.l D0,A0
                    moveq  #0,D0
pt_stploop:
                    cmp.w  0(A0,D0.w),D2
                    bhs.s  pt_stpfound
                    addq.w #2,D0
                    cmp.w  #37*2,D0
                    blo.s  pt_stploop
                    moveq  #35*2,D0
pt_stpfound:
                    move.b n_finetune(A6),D2
                    and.b  #8,D2
                    beq.s  pt_stpgoss
                    tst.w  D0
                    beq.s  pt_stpgoss
                    subq.w #2,D0
pt_stpgoss:
                    move.w 0(A0,D0.w),D2
                    movea.l (SP)+,A0
                    move.w D2,n_wantedperiod(A6)
                    move.w n_period(A6),D0
                    clr.b  n_toneportdirec(A6)
                    cmp.w  D0,D2
                    beq.s  pt_cleartoneporta
                    bge    pt_return
                    move.b #1,n_toneportdirec(A6)
                    rts

pt_cleartoneporta:
                    clr.w  n_wantedperiod(A6)
                    rts

pt_toneportamento:
                    move.b n_cmdlo(A6),D0
                    beq.s  pt_toneportnochange
                    move.b D0,n_toneportspeed(A6)
                    clr.b  n_cmdlo(A6)
pt_toneportnochange:
                    tst.w  n_wantedperiod(A6)
                    beq    pt_return
                    moveq  #0,D0
                    move.b n_toneportspeed(A6),D0
                    tst.b  n_toneportdirec(A6)
                    bne.s  pt_toneportaup
pt_toneportadown:
                    add.w  D0,n_period(A6)
                    move.w n_wantedperiod(A6),D0
                    cmp.w  n_period(A6),D0
                    bgt.s  pt_toneportasetper
                    move.w n_wantedperiod(A6),n_period(A6)
                    clr.w  n_wantedperiod(A6)
                    bra.s  pt_toneportasetper

pt_toneportaup:
                    sub.w  D0,n_period(A6)
                    move.w n_wantedperiod(A6),D0
                    cmp.w  n_period(A6),D0
                    blt.s  pt_toneportasetper
                    move.w n_wantedperiod(A6),n_period(A6)
                    clr.w  n_wantedperiod(A6)

pt_toneportasetper:
                    move.w n_period(A6),D2
                    move.b n_glissfunk(A6),D0
                    and.b  #$0F,D0
                    beq.s  pt_glissskip
                    moveq  #0,D0
                    move.b n_finetune(A6),D0
                    mulu   #37*2,D0
                    lea    pt_periodtable(PC),A0
                    adda.l D0,A0
                    moveq  #0,D0
pt_glissloop:
                    cmp.w  0(A0,D0.w),D2
                    bhs.s  pt_glissfound
                    addq.w #2,D0
                    cmp.w  #37*2,D0
                    blo.s  pt_glissloop
                    moveq  #35*2,D0
pt_glissfound:
                    move.w 0(A0,D0.w),D2
pt_glissskip:
                    move.w D2,6(A5)     ;Set period
                    rts

pt_vibrato:
                    move.b n_cmdlo(A6),D0
                    beq.s  pt_vibrato2
                    move.b n_vibratocmd(A6),D2
                    and.b  #$0F,D0
                    beq.s  pt_vibskip
                    and.b  #$F0,D2
                    or.b   D0,D2
pt_vibskip:
                    move.b n_cmdlo(A6),D0
                    and.b  #$F0,D0
                    beq.s  pt_vibskip2
                    and.b  #$0F,D2
                    or.b   D0,D2
pt_vibskip2:
                    move.b D2,n_vibratocmd(A6)
pt_vibrato2:
                    move.l A4,-(SP)
                    move.b n_vibratopos(A6),D0
                    lea    pt_vibratotable(PC),A4
                    lsr.w  #2,D0
                    and.w  #$1F,D0
                    moveq  #0,D2
                    move.b n_wavecontrol(A6),D2
                    and.b  #$03,D2
                    beq.s  pt_vib_sine
                    lsl.b  #3,D0
                    cmp.b  #1,D2
                    beq.s  pt_vib_rampdown
                    move.b #255,D2
                    bra.s  pt_vib_set
pt_vib_rampdown:
                    tst.b  n_vibratopos(A6)
                    bpl.s  pt_vib_rampdown2
                    move.b #255,D2
                    sub.b  D0,D2
                    bra.s  pt_vib_set
pt_vib_rampdown2:
                    move.b D0,D2
                    bra.s  pt_vib_set
pt_vib_sine:
                    move.b 0(A4,D0.w),D2
pt_vib_set:
                    move.b n_vibratocmd(A6),D0
                    and.w  #15,D0
                    mulu   D0,D2
                    lsr.w  #7,D2
                    move.w n_period(A6),D0
                    tst.b  n_vibratopos(A6)
                    bmi.s  pt_vibratoneg
                    add.w  D2,D0
                    bra.s  pt_vibrato3
pt_vibratoneg:
                    sub.w  D2,D0
pt_vibrato3:
                    move.w D0,6(A5)
                    move.b n_vibratocmd(A6),D0
                    lsr.w  #2,D0
                    and.w  #$3C,D0
                    add.b  D0,n_vibratopos(A6)
                    movea.l (SP)+,A4
                    rts

pt_toneplusvolslide:
                    bsr    pt_toneportnochange
                    bra    pt_volumeslide

pt_vibratoplusvolslide:
                    bsr.s  pt_vibrato2
                    bra    pt_volumeslide

pt_tremolo:
                    move.l A4,-(SP)
                    move.b n_cmdlo(A6),D0
                    beq.s  pt_tremolo2
                    move.b n_tremolocmd(A6),D2
                    and.b  #$0F,D0
                    beq.s  pt_treskip
                    and.b  #$F0,D2
                    or.b   D0,D2
pt_treskip:
                    move.b n_cmdlo(A6),D0
                    and.b  #$F0,D0
                    beq.s  pt_treskip2
                    and.b  #$0F,D2
                    or.b   D0,D2
pt_treskip2:
                    move.b D2,n_tremolocmd(A6)
pt_tremolo2:
                    move.b n_tremolopos(A6),D0
                    lea    pt_vibratotable(PC),A4
                    lsr.w  #2,D0
                    and.w  #$1F,D0
                    moveq  #0,D2
                    move.b n_wavecontrol(A6),D2
                    lsr.b  #4,D2
                    and.b  #$03,D2
                    beq.s  pt_tre_sine
                    lsl.b  #3,D0
                    cmp.b  #1,D2
                    beq.s  pt_tre_rampdown
                    move.b #255,D2
                    bra.s  pt_tre_set
pt_tre_rampdown:
                    tst.b  n_vibratopos(A6)
                    bpl.s  pt_tre_rampdown2
                    move.b #255,D2
                    sub.b  D0,D2
                    bra.s  pt_tre_set
pt_tre_rampdown2:
                    move.b D0,D2
                    bra.s  pt_tre_set
pt_tre_sine:
                    move.b 0(A4,D0.w),D2
pt_tre_set:
                    move.b n_tremolocmd(A6),D0
                    and.w  #15,D0
                    mulu   D0,D2
                    lsr.w  #6,D2
                    moveq  #0,D0
                    move.b n_volume(A6),D0
                    tst.b  n_tremolopos(A6)
                    bmi.s  pt_tremoloneg
                    add.w  D2,D0
                    bra.s  pt_tremolo3
pt_tremoloneg:
                    sub.w  D2,D0
pt_tremolo3:
                    bpl.s  pt_tremoloskip
                    clr.w  D0
pt_tremoloskip:
                    cmp.w  #$40,D0
                    bls.s  pt_tremolook
                    move.w #$40,D0
pt_tremolook:
                    move.w D0,8(A5)
                    move.b n_tremolocmd(A6),D0
                    lsr.w  #2,D0
                    and.w  #$3C,D0
                    add.b  D0,n_tremolopos(A6)
                    movea.l (SP)+,A4
                    addq.l #4,SP
                    rts

pt_sampleoffset:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    beq.s  pt_sononew
                    move.b D0,n_sampleoffset(A6)
pt_sononew:
                    move.b n_sampleoffset(A6),D0
                    lsl.w  #7,D0
                    cmp.w  n_length(A6),D0
                    bge.s  pt_sofskip
                    sub.w  D0,n_length(A6)
                    lsl.w  #1,D0
                    add.l  D0,n_start(A6)
                    rts
pt_sofskip:
                    move.w #1,n_length(A6)
                    rts

pt_volumeslide:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    lsr.b  #4,D0
                    tst.b  D0
                    beq.s  pt_volslidedown
pt_volslideup:
                    add.b  D0,n_volume(A6)
                    cmpi.b #$40,n_volume(A6)
                    bmi.s  pt_vsuskip
                    move.b #$40,n_volume(A6)
pt_vsuskip:
                    move.b n_volume(A6),D0
                    rts

pt_volslidedown:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
pt_volslidedown2:
                    sub.b  D0,n_volume(A6)
                    bpl.s  pt_vsdskip
                    clr.b  n_volume(A6)
pt_vsdskip:
                    move.b n_volume(A6),D0
                    rts

pt_positionjump:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    subq.b #1,D0
                    move.l D0,pt_songposition
pt_pj2:             clr.b  pt_pbreakposition
                    st     pt_posjumpassert
                    rts

pt_volumechange:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    cmp.b  #$40,D0
                    bls.s  pt_volumeok
                    moveq  #$40,D0
pt_volumeok:
                    move.b D0,n_volume(A6)
                    rts

pt_patternbreak:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    move.l D0,D2
                    lsr.b  #4,D0
                    mulu   #10,D0
                    and.b  #$0F,D2
                    add.b  D2,D0
                    cmp.b  #63,D0
                    bhi.s  pt_pj2
                    move.b D0,pt_pbreakposition
                    st     pt_posjumpassert
                    rts

pt_setspeed:
                    move.b 3(A6),D0
                    and.w  #$FF,D0
;xxx
                    cmp.w  #$f,d0
                    blt.s  pt_setspeedok
                    bra.s  pt_speednull
pt_setspeedok:
                    tst.w  d0
                    beq.s  pt_speednull
;   CMP.W   #32,D0          ;change this for lev6/CIA users
;   BLO.B   normspd         ;it updates the countervalues (Tempo)
;   MOVE.W  D0,RealTempo        ;for the BPM timer
;   MOVEM.L D0-D7/A0-A6,-(SP)
;   ST  UpdateTempo
;   JSR SetTempo
;   MOVEM.L (SP)+,D0-D7/A0-A6
;   RTS
pt_normspd:
                    clr.l  pt_counter
                    move.w D0,pt_currspeed+2
                    rts
pt_speednull:
                    rts

pt_checkmoreeffects:
                    move.b 2(A6),D0
                    and.b  #$0F,D0
                    cmp.b  #$09,D0
                    beq    pt_sampleoffset
                    cmp.b  #$0B,D0
                    beq    pt_positionjump
                    cmp.b  #$0D,D0
                    beq.s  pt_patternbreak
                    cmp.b  #$0E,D0
                    beq.s  pt_ecommands
                    cmp.b  #$0F,D0
                    beq.s  pt_setspeed
                    cmp.b  #$0C,D0
                    beq    pt_volumechange
                    bra    pt_pernop

pt_ecommands:
                    move.b n_cmdlo(A6),D0
                    and.b  #$F0,D0
                    lsr.b  #4,D0
                    beq.s  pt_filteronoff
                    cmp.b  #1,D0
                    beq    pt_fineportaup
                    cmp.b  #2,D0
                    beq    pt_fineportadown
                    cmp.b  #3,D0
                    beq.s  pt_setglisscontrol
                    cmp.b  #4,D0
                    beq    pt_setvibratocontrol
                    cmp.b  #5,D0
                    beq    pt_setfinetune
                    cmp.b  #6,D0
                    beq    pt_jumploop
                    cmp.b  #7,D0
                    beq    pt_settremolocontrol
                    cmp.b  #8,D0
                    beq    pt_karplusstrong
                    cmp.b  #$0E,D0
                    beq    pt_patterndelay
                    cmp.b  #9,D0
                    beq    pt_retrignote
                    cmp.b  #$0A,D0
                    beq    pt_volumefineup
                    cmp.b  #$0B,D0
                    beq    pt_volumefinedown
                    cmp.b  #$0C,D0
                    beq    pt_notecut
                    cmp.b  #$0D,D0
                    beq    pt_notedelay
                    cmp.b  #$0F,D0
                    beq    pt_funkit
                    rts

pt_filteronoff:
*   MOVE.B  n_cmdlo(A6),D0
*   AND.B   #1,D0
*   ASL.B   #1,D0
*   AND.B   #$FD,$BFE001
*   OR.B    D0,$BFE001
                    rts

pt_setglisscontrol:
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    andi.b #$F0,n_glissfunk(A6)
                    or.b   D0,n_glissfunk(A6)
                    rts

pt_setvibratocontrol:
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    andi.b #$F0,n_wavecontrol(A6)
                    or.b   D0,n_wavecontrol(A6)
                    rts

pt_setfinetune:
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    move.b D0,n_finetune(A6)
                    rts

pt_jumploop:
                    tst.l  pt_counter
                    bne    pt_return
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    beq.s  pt_setloop
                    tst.b  n_loopcount(A6)
                    beq.s  pt_jumpcnt
                    subi.b #1,n_loopcount(A6)
                    beq    pt_return
pt_jmploop:
                    move.b n_pattpos(A6),pt_pbreakposition
                    st     pt_pbreakflag
                    rts

pt_jumpcnt:
                    move.b D0,n_loopcount(A6)
                    bra.s  pt_jmploop

pt_setloop:
                    move.l pt_patternposition,D0
;===8
                    move.l D1,-(SP)
                    move.w pt_patternpos_shift(PC),D1
                    lsr.l  D1,D0        ;>>4 (>>5 nur fr 8 Stimmen)
                    move.l (SP)+,D1

                    and.b  #63,D0
                    move.b D0,n_pattpos(A6)
                    rts

pt_settremolocontrol:
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    lsl.b  #4,D0
                    andi.b #$0F,n_wavecontrol(A6)
                    or.b   D0,n_wavecontrol(A6)
                    rts

pt_karplusstrong:
                    movem.l D1-D2/A0-A1,-(SP)
                    movea.l n_loopstart(A6),A0
                    movea.l A0,A1
                    move.w n_replen(A6),D0
                    add.w  D0,D0
                    subq.w #2,D0
pt_karplop:
                    move.b (A0),D1
                    ext.w  D1
                    move.b 1(A0),D2
                    ext.w  D2
                    add.w  D1,D2
                    asr.w  #1,D2
                    move.b D2,(A0)+
                    dbra   D0,pt_karplop
                    move.b (A0),D1
                    ext.w  D1
                    move.b (A1),D2
                    ext.w  D2
                    add.w  D1,D2
                    asr.w  #1,D2
                    move.b D2,(A0)
                    movem.l (SP)+,D1-D2/A0-A1
                    rts

pt_retrignote:
                    move.l D1,-(SP)
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    beq    pt_rtnend
                    move.l pt_counter,D1
                    bne.s  pt_rtnskp
                    move.w n_note(A6),D1
                    and.w  #$0FFF,D1
                    bne    pt_rtnend
                    move.l pt_counter,D1
pt_rtnskp:
                    divu   D0,D1
                    swap   D1
                    tst.w  D1
                    bne    pt_rtnend
pt_doretrg:
*   MOVE.W  n_dmabit(A6),DFF096 ;Audio DMA off
*   move.w  n_dmabit(a6),-(sp)
*   bsr     dff096_contr
*   addq.w  #2,sp
                    move.l n_start(A6),(A5) ;Set sampledata pointer
                    move.w n_length(A6),4(A5) ;Set length
                    move.w n_period(A6),6(A5)
*   MOVEQ   #0,D0
*   MOVE.B  n_volume(A6),D0

*   move.b  pt_timeout,$bfe701  ;TimerB HI
*   move.b  pt_timeout+1,$bfe601    ;TimerB LO
*   move.b  #%000011001,$bfef01 ;set commandbits: OneShot & CLK & Start
*pt_timerwait3
*   btst    #0,$bfef01      ;timeout on timerB? (ICR TimerB)
*   bne.s   pt_timerwait3       ;nope...

*   MOVE.W  n_dmabit(A6),D0
*   BSET    #15,D0
*   MOVE.W  D0,DFF096
*   move.w  d0,-(sp)
*   bsr     dff096_contr
*   addq.w  #2,sp
*   move.b  pt_timeout,$bfe701  ;TimerB HI
*   move.b  pt_timeout+1,$bfe601    ;TimerB LO
*   move.b  #%000011001,$bfef01 ;set commandbits: OneShot & CLK & Start
*pt_timerwait4
*   btst    #0,$bfef01      ;timeout on timerB? (ICR TimerB)
*   bne.s   pt_timerwait4       ;nope...

                    move.l n_loopstart(A6),0+10(A5)
                    move.w n_replen(A6),4+10(A5) ;war .l
pt_rtnend:
                    move.l (SP)+,D1
                    rts

pt_volumefineup:
                    tst.l  pt_counter
                    bne    pt_return
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    bra    pt_volslideup

pt_volumefinedown:
                    tst.l  pt_counter
                    bne    pt_return
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    bra    pt_volslidedown2

pt_notecut:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    cmp.l  pt_counter,D0
                    bne    pt_return
                    clr.b  n_volume(A6)
                    rts

pt_notedelay:
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    cmp.l  pt_counter,D0
                    bne    pt_return
                    move.w (A6),D0
                    and.w  #$0FFF,D0
                    beq    pt_return
                    move.l D1,-(SP)
                    bra    pt_doretrg

pt_patterndelay:
                    tst.l  pt_counter
                    bne    pt_return
                    moveq  #0,D0
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    tst.b  pt_pattdelaytime2
                    bne    pt_return
                    addq.b #1,D0
                    move.b D0,pt_pattdelaytime
                    rts

pt_funkit:
                    tst.l  pt_counter
                    bne    pt_return
                    move.b n_cmdlo(A6),D0
                    and.b  #$0F,D0
                    lsl.b  #4,D0
                    andi.b #$0F,n_glissfunk(A6)
                    or.b   D0,n_glissfunk(A6)
                    tst.b  D0
                    beq    pt_return
pt_updatefunk:
                    movem.l D1/A0,-(SP)
                    moveq  #0,D0
                    move.b n_glissfunk(A6),D0
                    lsr.b  #4,D0
                    beq.s  pt_funkend
                    lea    pt_funktable(PC),A0
                    move.b 0(A0,D0.w),D0
                    add.b  D0,n_funkoffset(A6)
                    btst   #7,n_funkoffset(A6)
                    beq.s  pt_funkend
                    clr.b  n_funkoffset(A6)
                    move.l n_loopstart(A6),D0
                    moveq  #0,D1
                    move.w n_replen(A6),D1
                    add.l  D1,D0
                    add.l  D1,D0
                    movea.l n_wavestart(A6),A0
                    addq.l #1,A0
                    cmpa.l D0,A0
                    blo.s  pt_funkok
                    movea.l n_loopstart(A6),A0
pt_funkok:
                    move.l A0,n_wavestart(A6)
                    moveq  #-1,D0
                    sub.b  (A0),D0
                    move.b D0,(A0)
pt_funkend:
                    movem.l (SP)+,D1/A0
                    rts

pt_patternpos_shift:
                   DC.W 0
pt_patternpos_add:
                   DC.L 0
pt_patternpos_len:
                   DC.L 0

pt_funktable:
                   DC.B 0,5,6,7,8,10,11,13,16,19,22,26,32,43,64,128

pt_vibratotable:
                   DC.B 0,24,49,74,97,120,141,161
                   DC.B 180,197,212,224,235,244,250,253
                   DC.B 255,253,250,244,235,224,212,197
                   DC.B 180,161,141,120,97,74,49,24

pt_periodtable:
; -> Tuning 0
                   DC.W 856,808,762,720,678,640,604,570,538,508,480,453
                   DC.W 428,404,381,360,339,320,302,285,269,254,240,226
                   DC.W 214,202,190,180,170,160,151,143,135,127,120,113,0
; -> Tuning 1
                   DC.W 850,802,757,715,674,637,601,567,535,505,477,450
                   DC.W 425,401,379,357,337,318,300,284,268,253,239,225
                   DC.W 213,201,189,179,169,159,150,142,134,126,119,113,0
; -> Tuning 2
                   DC.W 844,796,752,709,670,632,597,563,532,502,474,447
                   DC.W 422,398,376,355,335,316,298,282,266,251,237,224
                   DC.W 211,199,188,177,167,158,149,141,133,125,118,112,0
; -> Tuning 3
                   DC.W 838,791,746,704,665,628,592,559,528,498,470,444
                   DC.W 419,395,373,352,332,314,296,280,264,249,235,222
                   DC.W 209,198,187,176,166,157,148,140,132,125,118,111,0
; -> Tuning 4
                   DC.W 832,785,741,699,660,623,588,555,524,495,467,441
                   DC.W 416,392,370,350,330,312,294,278,262,247,233,220
                   DC.W 208,196,185,175,165,156,147,139,131,124,117,110,0
; -> Tuning 5
                   DC.W 826,779,736,694,655,619,584,551,520,491,463,437
                   DC.W 413,390,368,347,328,309,292,276,260,245,232,219
                   DC.W 206,195,184,174,164,155,146,138,130,123,116,109,0
; -> Tuning 6
                   DC.W 820,774,730,689,651,614,580,547,516,487,460,434
                   DC.W 410,387,365,345,325,307,290,274,258,244,230,217
                   DC.W 205,193,183,172,163,154,145,137,129,122,115,109,0
; -> Tuning 7
                   DC.W 814,768,725,684,646,610,575,543,513,484,457,431
                   DC.W 407,384,363,342,323,305,288,272,256,242,228,216
                   DC.W 204,192,181,171,161,152,144,136,128,121,114,108,0
; -> Tuning -8
                   DC.W 907,856,808,762,720,678,640,604,570,538,508,480
                   DC.W 453,428,404,381,360,339,320,302,285,269,254,240
                   DC.W 226,214,202,190,180,170,160,151,143,135,127,120,0
; -> Tuning -7
                   DC.W 900,850,802,757,715,675,636,601,567,535,505,477
                   DC.W 450,425,401,379,357,337,318,300,284,268,253,238
                   DC.W 225,212,200,189,179,169,159,150,142,134,126,119,0
; -> Tuning -6
                   DC.W 894,844,796,752,709,670,632,597,563,532,502,474
                   DC.W 447,422,398,376,355,335,316,298,282,266,251,237
                   DC.W 223,211,199,188,177,167,158,149,141,133,125,118,0
; -> Tuning -5
                   DC.W 887,838,791,746,704,665,628,592,559,528,498,470
                   DC.W 444,419,395,373,352,332,314,296,280,264,249,235
                   DC.W 222,209,198,187,176,166,157,148,140,132,125,118,0
; -> Tuning -4
                   DC.W 881,832,785,741,699,660,623,588,555,524,494,467
                   DC.W 441,416,392,370,350,330,312,294,278,262,247,233
                   DC.W 220,208,196,185,175,165,156,147,139,131,123,117,0
; -> Tuning -3
                   DC.W 875,826,779,736,694,655,619,584,551,520,491,463
                   DC.W 437,413,390,368,347,328,309,292,276,260,245,232
                   DC.W 219,206,195,184,174,164,155,146,138,130,123,116,0
; -> Tuning -2
                   DC.W 868,820,774,730,689,651,614,580,547,516,487,460
                   DC.W 434,410,387,365,345,325,307,290,274,258,244,230
                   DC.W 217,205,193,183,172,163,154,145,137,129,122,115,0
; -> Tuning -1
                   DC.W 862,814,768,725,684,646,610,575,543,513,484,457
                   DC.W 431,407,384,363,342,323,305,288,272,256,242,228
                   DC.W 216,203,192,181,171,161,152,144,136,128,121,114,0

pt_audchan1temp:   DC.L 0,0,0,0,0,$010000,0,0,0,0,0
pt_audchan2temp:   DC.L 0,0,0,0,0,$020000,0,0,0,0,0
pt_audchan3temp:   DC.L 0,0,0,0,0,$040000,0,0,0,0,0
pt_audchan4temp:   DC.L 0,0,0,0,0,$080000,0,0,0,0,0
pt_audchan1temp2:  DC.L 0,0,0,0,0,$010000,0,0,0,0,0
pt_audchan2temp2:  DC.L 0,0,0,0,0,$020000,0,0,0,0,0
pt_audchan3temp2:  DC.L 0,0,0,0,0,$040000,0,0,0,0,0
pt_audchan4temp2:  DC.L 0,0,0,0,0,$080000,0,0,0,0,0

pt_samplestarts:   DCB.L 31

*pt_timeout     dc.w    330     ;CIA-B timeout-value

pt_counter:        DC.L 0
pt_currspeed:      DC.L 6
pt_pattpos:        DC.W 0
pt_dmacontemp:     DC.W 0
pt_activechannels:
                   DC.W %1111
pt_patternptr:     DC.L 0
pt_patternposition:
                   DC.L 0
pt_songposition:   DC.L 0
pt_songdataptr:    DC.L 0
pt_metrospeed:     DC.B 0
pt_metrochannel:   DC.B 0
pt_speed:          DC.B 6
pt_songpos:        DC.B 0
pt_pbreakposition:
                   DC.B 0
pt_posjumpassert:
                   DC.B 0
pt_pbreakflag:     DC.B 0
pt_lowmask:        DC.B 0
pt_pattdelaytime:
                   DC.B 0
pt_pattdelaytime2:
                   DC.B 0
                   EVEN
                   END
