;################################> HISTORY <###############################
; Project:  Utilities                                     Started: 05/12/94
;--------------------------------------------------------------------------
; Filename: PSEUDOPS.ASM                                  Created: 05/12/94
;--------------------------------------------------------------------------
; Description: Pseudo-Opcodes fr GPU/DSP-Assembler
;--------------------------------------------------------------------------
; 05/09/94 - created, first tests                                       -mf
;--------------------------------------------------------------------------
; Copyrights: BJL-Driver Bastian Schick. EQUates act. based on ATARI-files
;##########################################################################

;=========================================
;                             Code-Pseudos
;=========================================

;========================
;                Stop-GPU
; keine Register

               MACRO STOP_GPU		; Hlt die GPU/den DSP komplett an
                movei	$f02114,r0
                movei	VID_BG,r3
                moveq 	0,r1
.\wait	   	    ;store 	r1,(r0)
	            ;storew	r2,(r3)
	            addq	1,r2
				jr .\wait
				nop
               ENDM

;========================
;                     JSR
; -r30/r31
; -r31 darf bis zum RTS
;  nicht verndert werden!

			   MACRO JSR           		; Jump to SubRoutine
			    movei	\0,r30       	; wohin springen ?
	 			movei  .\backjsr,r31	; Adresse fr Rcksprung merken
	 			jump   (r30)       		; ...und los !
	 			nop
.\backjsr	 
			   ENDM

;========================
; 					  RTS

			   MACRO RTS	; ReTurn from Subroutine
				jump	(r31)
	 			nop
			   ENDM
			   
;=========================================
; 					Assemblierungs-Pseudos
;=========================================

	MACRO DSB
	 IFVAR \1
	  REPT \0
	   DC.B	\1
	  ENDR
		ELSE
		 REPT \0
		  DC.B 0
		 ENDR
		ENDIF
	ENDM
	
	MACRO DSW
	 IFVAR \1
	  REPT \0
	   DC.W	\1
	  ENDR
		ELSE
		 REPT \0
		  DC.W 0
		 ENDR
		ENDIF
	ENDM
	
	MACRO DSL
	 IFVAR \1
	  REPT \0
	   DC.L	\1
	  ENDR
		ELSE
		 REPT \0
		  DC.L 0
		 ENDR
		ENDIF
	ENDM
	
	MACRO EVENP
     IF (8-(*&7))<>8
		 REPT 8-(*&7)
		  DC.B 0
		 ENDR
		ENDIF
	ENDM

	MACRO EVENL
	 IF (4-(*&3))<>4
 	  REPT 4-(*&3)
 	   DC.B 0
 	  ENDR
	 ENDIF
	ENDM
