;################################> HISTORY <###############################
; Project: Sound of Silence ;-)                           Started: 26/07/95
;--------------------------------------------------------------------------
; Filename: REPLAY04.ASM                                  Created: 26/07/95
;--------------------------------------------------------------------------
; Description: Nur'n Test vonwegen Mucke
;--------------------------------<HYSTORY>---------------------------------
;26/07/95 - Erste Tests                                                 -mf
;04/08/95 - Umbau aus Blitter-Version                                   -mf
;         - Samplerepeat eingebaut                                      -mf
;         - Mixer auf 8 Stimmen aufgeblasen                             -mf
;--------------------------------------------------------------------------
; Copyrights: BJL-Driver Bastian Schick. EQUates act. based on ATARI-files
;##########################################################################
;---------------------------<BUGLISTE/TO-DO-LISTE>-------------------------
;11/08/95 - Einbau der zus. 4 Effektstimmen (= insg. 12 Stimmen)
;--------------------------------------------------------------------------

_BLITOFF       EQU 1
_MIXOFF        EQU 0
_DSP_TIME      EQU 0
sample_frq     EQU 46000
timer_init     EQU 830966/sample_frq/2-1
calcblock      EQU 8310/(2*(timer_init+1))

maxvoices::    EQU 4

                path "\mark\sources\includes\"


               INCLUDE "JAGREGEQ.S"
               INCLUDE "BLITEQU.S"
               INCLUDE "DEBUTILS.INC"
               INCLUDE "PSEUDOPS.INC"

SP             REG 31
Flags          REG 27

TimingCounter.a REG 10          ; Register anstatt Speicherstelle (spart Zeit)
TimingFlag.a    REG 11          ; dito
LeftChannel.a   REG 20
RightChannel.a  REG 21
smpl_ptr.a      REG 22
irq_dummy0.a    REG 24
irq_dummy1.a    REG 25
FlagsPtr.a      REG 27
Flags.a         REG 28

**42BS Ein bischen interleaving bei den MAKROS
**     Ausserdem alle Regs benamt
              ;>PART "Makros"
               MACRO START_IRQ    ;das Flags-Register _MUSS_ gesichert werden,
                load (FlagsPtr.a),Flags.a  ;da sonst smtliche CMPs durcheinanderkommen
               ENDM
               MACRO END_IRQ
                load (SP),r30     ;Rcksprung-Adresse
                bclr #3,Flags.a       ;IMASK lschen
                addq #2,r30       ;PC auf nchsten Befehl
                bset  #14,Flags.a     ;REG0 nur fr IRQs
                addq #4,SP
                IF 5=\0
                bset #17,Flags.a
                ELSE
                bset #9+\0,Flags.a    ;Var0 => IRQ-Nummer
                ENDIF
                jump (r30)        ;...und zurck
                store Flags.a,(FlagsPtr.a) ;Flags wieder setzen
               ENDM
;=================================================
;                                    Vektorbereich
;=================================================

               RUN DSP_RAM     ;$f1b000
SOP
                movei init,r30                     ; Startup
                jump (r30)
                nop
;=======================================
;                                   IRQs
;=======================================
**42BS START_IRQ in Dispatcher (spart Zeit)
**     Ausserdem von r29 auf r30 gendert
**     r30 wird _in_ jedem Fall zersrt,drum macht's nix
**     Sample-Daten werden auch schon hier geholt.
              ;>PART "IRQ-Aufrufvektoren"
               ORG DSP_RAM+$10                     ; SSI-IRQ
                movei #ssi_irq,r30
                load   (smpl_ptr.a),r24   ;Sampleworte linke+rechter Kanal holen
                jump (r30)
                START_IRQ
               ORG DSP_RAM+$20                     ; TimerIRQ 1
                movei timer1_irq,r30
                jump (r30)
                START_IRQ
               ORG DSP_RAM+$30                     ; TimerIRQ 2
                movei timer2_irq,r30
                jump (r30)
                START_IRQ

               ORG DSP_RAM+$40
               DC.L voice_var_base ;nur zu Debugzwecken
               EVENL
freqtab::      DC.L 0              ;Adresse der Frequenztabelle im 68k-Teil
dmaadr::       DC.L 0              ;Adresse der Pseudo-DMA-Register
counter::      DC.L 0              ;Testcounter der kHz-Replay-Rate

              ;>PART "DSP-Shutdown"
shuttle::       movei  #shutdown,r29
                jump   (r29)
                nop
shutdown::
               IF _DSP_TIME=1
                movei   #VID_BG,r0
                movei   #$F0ff,r1
                storew  r1,(r0)
               ENDIF
**42BS ---------------------------\
                xor r1,r1             ; alle IRQs aus
                movei  #JPIT1,r0
                store r1,(r0)

                movei  #SMODE,r0
                store  r1,(r0)
                subq   #4,r0
                store  r1,(r0)

                movei #DSP_INT,r0
                movei #%111111<<8,r1
                store r1,(r0)            ; clear pending IRQs

**42BS ---------------------------/
                movei   #DSP_FLAGS,r0
                load    (r0),r1
                bclr   #5,r2             ; SSI off
                bclr   #6,r2             ; Timer 1 off
                bset  #10,r2             ; clear pending SSI
                bset  #11,r2             ; **42BS clear pending Timer 1
                store   r1,(r0)

                movei   #DSP_CTRL,r0
                bclr   #0,r1
                store   r1,(r0)
wait_shuttle    jr      wait_shuttle
                nop
;=================================================
;                                        Hauptteil
;=================================================
                ;PART "INIT"
init::
                movei  #DSP_INT,r0    ; JIRQ-Contrl
;>                moveq  #0,r1        ; alle IRQs aus
;>                storew r1,(r0)      ; (vorsichtshalber, man wei ja nie)
                xor r1,r1             ; alle IRQs aus
                store r1,(r0)         ; (vorsichtshalber, man wei ja nie)

                movei  #JPIT1,r0
                store r1,(r0)
**42 SCLK __vor__ SMODE lschen
                movei  #SCLK,r0
                store  r1,(r0)
                addq   #4,r0
                store  r1,(r0)

                movei  #%100111111000000000,r0
                movei  #DSP_FLAGS,r1
                store  r0,(r1)          ; Flags setzen => REG1 whlen
                nop
                nop                     ; **42BS queue leeren !!

                movei  #stack,SP        ; SP
                movei  #DSP_FLAGS,r30   ; Flags
                moveta SP,SP
                moveta r30,FlagsPtr.a
                move   r30,Flags

                movei  #R_DAC,r0
                moveta r0,RightChannel.a
                store r1,(r0)                   ;**42BS
                movei  #L_DAC,r0
                moveta r0,LeftChannel.a
                store r1,(r0)                   ;**42BS
                movei  #playbuf0,r0             ;Playbuffer
                moveta r0,smpl_ptr.a
                movei #calcblock,r0             ;**42BS
                moveta r0,TimingCounter.a       ;**42BS
                moveta r1,TimingFlag.a          ;**42BS
;========================
;      Tempo-Timer setzen
                movei  #$f10000,r0      ; JT1_Pre
                movei  #$f,r1          ; PreScale = 31+1
                movei  #$f10002,r2      ; JT1_Div
                movei  #$40ec,r3        ; 26,5939Mhz/($40EC+1)/PreScale= ~50Hz
                storew r1,(r0)
                storew r3,(r2)
;========================
;      Samplereplay-Timer
**42BS SMODE __vor__ SCLK setzen

                movei  #SMODE,r2
                movei  #$15,r3
                movei  #SCLK,r0                 ; SSI-IRQ-Timer
                movei  #timer_init,r1            ; 830000(?!?)/2/(8+1) = ~46kHz
                store  r3,(r2)
                store  r1,(r0)

;========================
;           IRQs zulassen
**42BS DSP-IRQ vor der IRQ-Quelle zulassen
                load   (r30),r2         ; DSP-Flags holen
                bset   #5,r2            ; SSI enable
                store  r2,(r30)         ; ...und zurck damit

                movei  #DSP_INT,r0      ; JIRQ-Contrl
                movei  #%100100,r1      ; SSI enable, JPIT1 enable
                storew r1,(r0)
**42BS MUTE-Bit in $f14000.w _nicht_ $f14002.w (Jag.Rom macht's zumindest so !;)
                movei  #JOYSTICK,r0
                movei  #$100,r1         ; MUTE-Bit setzen (???)
                storew r1,(r0)

;>                load   (r30),r2         ; DSP-Flags holen
;>                bset   #5,r2            ; SSI enable
;>                store  r2,(r30)         ; ...und zurck damit

;============================================
;                               Hauptschleife

mixer
                movei  #flag0,r0
                movei  #flag1,r2
                movei  #$3d0dead,r3
                load   (r0),r1
                addq   #1,r1
                cmpq   #2,r1
                jr     ne,noflag0
                nop
                moveq  #0,r1
                store  r3,(r2)
noflag0
                store  r1,(r0)

               IF _DSP_TIME=1
                movei  #VID_BG,r0
                movei  #$f0FF,r1
                storew r1,(r0)
               ENDIF


**42BS Hier von Speicherzelle auf Register gendert

;>waittimer::     movei  #$3d0dead,r4       ;auf den Timer
;>                movei  #timingflag,r2     ;Synchronisieren
;>                load   (r2),r3
;>                nop
;>                cmp    r4,r3
;>                jr     ne,waittimer
;>                nop
;>                moveq  #0,r3
;>                store  r3,(r2)

                  movefa TimingFlag.a,r3
                  xor r2,r2
waittimer::       cmpq #0,r3
                  nop
                  jr eq,waittimer
                  movefa TimingFlag.a,r3
                  nop
                  moveta r2,TimingFlag.a
**42BS *********************************************

               IF _DSP_TIME=1
                movei  #VID_BG,r0
                movei  #$fFFF,r1
                storew r1,(r0)
               ENDIF

               IF 1=0
;=======================================
;               Player-Register auslesen (ERSTMAL GESTORBEN, MACHT DER 68K)
;>                lea     freq,a0         ; Amigafrequenz==>Blitterstep-Tabelle
                movei   #freqtab,r0
                load    (r0),r15

;>                lea     voice_var_base,a1 ; Pointer auf die DSP-Stimmenregister
                movei   #voice_var_base,r14

;>                lea     DFF0A0,a2       ; Amiga-Stimmenregister
                movei   #dmaadr+6,r2
                load    (r2),r2

;>                moveq   #4-1,d7
                moveq   #4-1,r3
                movei   #PlayEmUpL0,r9

PlayEmUpL0:
;>                moveq   #0,d0
;>                move.w  6(a2),d0             ;Amiga-Frequenzvorteiler in

                loadw   (r2),r10            ;AMIGA-Frequenzvorteiler
                store   r10,(r14+v_samfreq)
                shlq    #2,r10
                load    (r15+r10),r10
                store   r10,(r14+v_freqstep)

;>                move.l  d0,v_samfreq(a1)     ;Scalingwerte fr Blitter bzw.
;>                lsl.l   #2,d0                ;ADDs umwandeln und
;>                move.l  (a0,d0.l),d0         ;in DSP eintragen
;>                move.l  d0,v_freqstep(a1)

                addq    #2,r2                ;DMA+8
                loadw   (r2),r10             ;AMIGA-Lautstrke
                store   r10,(r14+v_samvol_l)
                store   r10,(r14+v_samvol_r)

;>                moveq   #0,d0                ;Amiga-Lautstrke auf 16Bit
;>                move.w  8(a2),d0             ;umrechnen
;>                move.l  d0,v_samvol_l(a1)
;>                move.l  d0,v_samvol_r(a1)

                subq    #8,r2                ;DMA+0
                load    (r2),r10             ;aktuelle Sampledaten nur ein-
                movei   #PlayEmUpNo0,r5      ;tragen, wenn <> 0, d.h. wenn ein
                cmpq    #0,r10               ;neuer Anschlag erfolgt ist
                jump    eq,(r5)
                nop

;>                move.l  (a2),d0              ;aktuelle Sampleadresse nur setzen
;>                beq.s   PlayEmUpNo0          ;wenn <> 0, d.h. neuer Anschlag

                addq    #16,r14
                store   r10,(r14)   ;aktuelle Sampleadresse
                subq    #16,r14

;>                move.l  d0,v_samadr(a1)      ;aktuelle Sampleadresse eintragen

                moveq   #0,r10
                store   r10,(r14+v_playoffs)   ;aktuellen Offsetpointer lschen

;>                moveq   #0,d0
;>                move.l  d0,v_playoffs(a1)    ;aktuellen Offsetpointer lschen

                addq    #4,r2
                loadw   (r2),r10
                shlq    #1,r10
                store   r10,(r14+v_samlength)  ;aktuelle Samplelnge

;>                move.w  4(a2),D0
;>                add.l   d0,d0
;>                move.l  d0,v_samlength(a1)   ;aktuelle Samplelnge

                addq    #6,r2
                load    (r2),r10
                store   r10,(r14+v_samrepstart)

;>                move.l  $A(a2),v_samrepstart(a1) ; aktuelle Sampleloopadresse

                addq    #4,r2
                loadw   (r2),r10
                shlq    #1,r10
                store   r10,(r14+v_samreplen)

;>                moveq   #0,d0                ; Repeatlngen eintragen
;>                move.w  $E(a2),D0
;>                add.l   d0,d0
;>                move.l  d0,v_samreplen(a1)
                subq    #$e,r2

PlayEmUpNo0:
                addq    #$10,r2
;>                lea     $10(a2),a2           ; nchste Amiga-Stimme

                movei   #voice_next,r5
                add     r5,r14
;>                lea     voice_next(a1),a1    ; nchste DSP-Stimme

                subq    #1,r3
                jump    nn,(r9)
                nop
;>                dbf     d7,PlayEmUpL0

               ENDIF

;=======================================
;                          Mixer-Routine
**42BS Im Mixer ein bischen Interleaving, bringt aber wohl nix
IF 0
              ;>PART "4-Voice-Mixer"
a_sample_adr    REG 0         ; Pointer auf Anfang des akt. Samples
sample_offs     REG 1         ; aktueller Offset in Sample
sample_len      REG 2         ; Lnge aktuelles Sample
a_sample_buf    REG 3         ; Pointer auf aktuellen Samplebuffer
sample_bytes    REG 4         ; 4 Samplebytes
sample_mask     REG 5         ; Maske fr Samplebytes                 UNBENUTZT
sample_dummy    REG 6         ; Samplebyte Zwischenspeicher
sample_dummy2   REG 7         ; Samplebyte Zwischenspeicher
sample_vol_l    REG 8         ; aktuelle Sample-Lautstrke links
sample_bytes2   REG 9
sample_dummy3   REG 10        ; Samplebyte Zwischenspeicher
sample_dummy4   REG 11        ; Samplebyte Zwischenspeicher
sample_vol_r    REG 12        ; aktuelle Sample-Lautstrke rechts
sample_norm_l   REG 13        ; Normalisierungswert um Sample nach Hhentrans-
                              ; formation wieder mittig zu stellen
a_v_base        REG 14        ; Baseregister auf die Stimmen
sample_adr2     REG 15
sample_norm_r   REG 16        ; Normalisierungswert rechts
l_byte_loop     REG 17        ; JumpPointer auf den Byte-Mixloop
byte_count      REG 18        ; Counter fr den Byte-Mixloop
a_sample_dsp    REG 19        ; Pointer auf Sampleteil im DSP         UNBENUTZT
l_mix_loop      REG 20        ; JumpPointer fr den Stimmenloop
mix_count       REG 21        ; Counter fr den Stimmenloop
sample_end      REG 22        ; Endoffset aktuelles Sample
sample_restart  REG 23        ; Restartoffset des aktuellen Samples
sample_end2     REG 24        ; nchster Restartoffset des akt. Samples
sample_frqstep  REG 28        ; ADD-Stepwert fr die Samplefrequenz
sample_frqcnt   REG 27        ; Pointerregister auf akt. Samplebyte
sample_newfrq   REG 29        ; neue Frequenz bei Loop

                movei  #voice_var_base,a_v_base
              ;*aktuelle Playbufferadresse holen und Buffer vertauschen
                movei  #playbuf_adr,a_sample_buf
                load   (a_sample_buf),sample_dummy
                addq   #4,a_sample_buf
                load   (a_sample_buf),sample_dummy2
                store  sample_dummy,(a_sample_buf)
                subq   #4,a_sample_buf
                store  sample_dummy2,(a_sample_buf)
                move   sample_dummy2,a_sample_buf
                moveta sample_dummy,r22

               IF _MIXOFF=0

                movei  #$FF,sample_mask
mix_em_up
              ;*Sampleadresse holen
                load   (a_v_base),a_sample_adr
              ;*Samplelnge holen
                load   (a_v_base+v_samlength),sample_len
              ;*Sampleoffset holen
                load   (a_v_base+v_playoffs),sample_offs
              ;*Samplefrequenzstep holen
                load   (a_v_base+v_freqstep),sample_frqstep
                shrq   #1,sample_frqstep          ;/2, damit es beim hoch-
                                                  ; addieren der Samplebyte-
                                                  ; offset keinen berlauf ins
                                                  ; Negativbit gibt!
              ;*Samplerepeat vorbereiten
                move   sample_len,sample_restart  ;Erstmal kein Loop, Sample am
                move   sample_restart,sample_end2 ; Ende stoppen
                addq   #10,sample_end2            ;10 Bytes zeit zum stoppen
                moveq  #0,sample_newfrq           ; Frequenz beim stoppen auf 0
                                                  ; dann rauscht auch nix mehr
                move   sample_len,sample_end
                load   (a_v_base+v_samreplen),sample_dummy ;Repeatlnge holen
                movei  #repeatok,sample_dummy4

                cmpq   #3,sample_dummy            ;Repeatstart nur setzen,
                jump   n,(sample_dummy4)          ; wenn ein Repeat da (>2)
                nop
              ;*Restartadresse setzen
                load   (a_v_base+v_samrepstart),sample_restart
                move   sample_frqstep,sample_newfrq  ;Alte Frequenz beibehalten
                move   sample_restart,sample_end     ;Ende des Loopbereiches
                add    sample_dummy,sample_end       ; berechnen
                sub    a_sample_adr,sample_restart   ;Alle Begrenzungen als
                sub    a_sample_adr,sample_end       ; relative Loopoffsets
                move   sample_end,sample_end2        ;Nchster Repeatende
                                                     ; ist gleich diesem
repeatok
                shlq   #15,sample_restart    ;Alle Offsets auf 16Bit Vorkomma,
                shlq   #15,sample_end        ;15Bit Nachkomma anpassen
                shlq   #15,sample_end2

              ;*Samplelautstrke linker Kanal holen
                load   (a_v_base+v_samvol_l),sample_vol_l
                movei  #$8000/maxvoices,sample_norm_l       ;Mitte
              ;*Samplelautstrke rechter Kanal holen
                load   (a_v_base+v_samvol_r),sample_vol_r
                movei  #$8000/maxvoices,sample_norm_r       ;Mitte
                movei  #$80,sample_dummy            ;Jetzt erstmal den An-
                movei  #$80,sample_dummy2           ; passungswert fr die
                mult   sample_vol_l,sample_dummy    ; Lautstrkentransformation
                mult   sample_vol_r,sample_dummy2   ; berechnen
                sub    sample_dummy,sample_norm_l   ;Normalisierungswert L
                sub    sample_dummy2,sample_norm_r  ; und R

                move   a_sample_adr,sample_adr2

;===========
;========= Dieser Mischteil berschreibt den Buffer mit den Samplewerten der
;========= 1. Stimme, er wird somit auch gleich gelscht
;===========

;                movei  #116-1,byte_count          ;116*4 Werte in den Playbuf
 movei #calcblock>>2,byte_count
                movei  #byte_loop2,l_byte_loop
byte_loop2
                move   sample_offs,sample_frqcnt  ;Den Offset auf das akt.
                shrq   #15,sample_frqcnt          ; Samplebyte berechnen
                add    sample_adr2,sample_frqcnt  ; und schlielich die Adresse
;>                loadb  (sample_frqcnt),sample_bytes     ;1.Samplebyte holen
                add    sample_frqstep,sample_offs ;Frequenzadd auf Offset

                cmp    sample_end,sample_offs     ;Ist das Sample hier zuende
            loadb  (sample_frqcnt),sample_bytes     ;1.Samplebyte holen
                jr     n,mix_norepeat10           ; bzw. ist ein Loop dran?
                move   sample_offs,sample_frqcnt  ;Schonmal fr nxtes Byte

                move   sample_restart,sample_offs   ;Restartoffset setzen
                move   sample_newfrq,sample_frqstep ;Neue Frequenz
                move   sample_end2,sample_end       ;Und neuer Loopend
mix_norepeat10

                shrq   #15,sample_frqcnt          ;Dito.
                add    sample_adr2,sample_frqcnt
;>                loadb  (sample_frqcnt),sample_bytes2    ;2.Samplebyte holen
                add    sample_frqstep,sample_offs
                cmp    sample_end,sample_offs
            loadb  (sample_frqcnt),sample_bytes2    ;2.Samplebyte holen
                jr     n,mix_norepeat11
                move   sample_bytes,sample_dummy       ;Byte 1 sichern

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat11

                move   sample_bytes2,sample_dummy3     ;Byte 2 sichern

                move   sample_dummy,sample_dummy2      ;Byte 1+2 fr rechten
                move   sample_dummy3,sample_dummy4     ;Kanal holen

                ;sx*Lautstrke($0..$40)...
                mult   sample_vol_l,sample_dummy       ;Lautstrke einrechnen
                mult   sample_vol_l,sample_dummy3      ;links
                ;...+($8000/4-($80*Lautstrke))
                add    sample_norm_l,sample_dummy      ;Normalisierung
                add    sample_norm_l,sample_dummy3     ;einrechen links
             shlq   #16,sample_dummy                ;Byte links ins Highword
             shlq   #16,sample_dummy3

                mult   sample_vol_r,sample_dummy2      ;Lautstrke einrechnen
                mult   sample_vol_r,sample_dummy4      ;rechts
;>                shlq   #16,sample_dummy                ;Byte links ins Highword
;>                shlq   #16,sample_dummy3
                add    sample_norm_r,sample_dummy2     ;Normalisierung
                add    sample_norm_r,sample_dummy4     ;einrechen rechts

                or     sample_dummy2,sample_dummy      ;als Long zusammenbauen
                or     sample_dummy4,sample_dummy3

                store  sample_dummy,(a_sample_buf)     ;Word 1 L+R ablegen
                addq   #4,a_sample_buf                 ;Nchstes Buffer-Long
                store  sample_dummy3,(a_sample_buf)    ;Word 2 L+R ablegen
                addq   #4,a_sample_buf                 ;Nchstes Long

                move   sample_offs,sample_frqcnt
                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
;>                loadb  (sample_frqcnt),sample_bytes    ;3.Samplebyte holen
                add    sample_frqstep,sample_offs
                cmp    sample_end,sample_offs
            loadb  (sample_frqcnt),sample_bytes    ;3.Samplebyte holen
                jr     n,mix_norepeat12
                move   sample_offs,sample_frqcnt    ;Schonmal fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat12

                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
;>                loadb  (sample_frqcnt),sample_bytes2   ;4.Samplebyte holen
                add    sample_frqstep,sample_offs
                cmp    sample_end,sample_offs
             loadb  (sample_frqcnt),sample_bytes2   ;4.Samplebyte holen
                jr     n,mix_norepeat14
                move   sample_bytes,sample_dummy

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat14

                move   sample_bytes2,sample_dummy3
                move   sample_dummy,sample_dummy2
                move   sample_dummy3,sample_dummy4

                mult   sample_vol_l,sample_dummy       ;Lautstrke einrechnen
                mult   sample_vol_l,sample_dummy3      ;links
                add    sample_norm_l,sample_dummy      ;Normalisierung
                add    sample_norm_l,sample_dummy3     ;einrechen links
            shlq   #16,sample_dummy                ;Byte links ins Highword
            shlq   #16,sample_dummy3
                mult   sample_vol_r,sample_dummy2      ;Lautstrke einrechnen
;>                shlq   #16,sample_dummy                ;Byte links ins Highword
                mult   sample_vol_r,sample_dummy4      ;rechts
;>                shlq   #16,sample_dummy3

                add    sample_norm_r,sample_dummy2     ;Normalisierung
                add    sample_norm_r,sample_dummy4     ;einrechen rechts

                or     sample_dummy2,sample_dummy      ;als Long zusammenbauen
                or     sample_dummy4,sample_dummy3

                store  sample_dummy,(a_sample_buf)     ;Word 3 L+R ablegen
                addq   #4,a_sample_buf
                store  sample_dummy3,(a_sample_buf)    ;Word 4 L+R ablegen

; Hiermit sind 4 Bytes bearbeitet worden...
                subq   #1,byte_count
                jump   nn,(l_byte_loop)
                addq   #4,a_sample_buf                 ;nxtes Long im Buffer

              ;*Sampleoffset wieder ablegen
                store   sample_offs,(a_v_base+v_playoffs)

               IF _DSP_TIME=1
                movei  #VID_BG,sample_dummy
                movei  #$ff80,sample_dummy2
                storew sample_dummy2,(sample_dummy)
               ENDIF

;===========
;========= Ab hier wird auf den Playbuffer nur noch aufaddiert
;===========

                movei  #maxvoices-2,mix_count        ;Die restlichen drei Stimmen
                movei  #mix_loop,l_mix_loop

mix_loop
;>                movei  #voice_next,sample_dummy
;>                add    sample_dummy,a_v_base
;>
;>                movei  #playbuf_adr,a_sample_buf
;>                load   (a_sample_buf),a_sample_buf
**42BS
                movei #voice_next,sample_dummy
                movei #playbuf_adr,a_sample_buf
                add sample_dummy,a_v_base
                load (a_sample_buf),a_sample_buf
**42BS
              ;*Sampleadresse holen
                load   (a_v_base),a_sample_adr
              ;*Samplelnge holen
                load   (a_v_base+v_samlength),sample_len
              ;*Sampleoffset holen
                load   (a_v_base+v_playoffs),sample_offs ;aktuellen Sample
              ;*Samplefrequenzstep holen
                load   (a_v_base+v_freqstep),sample_frqstep
                shrq   #1,sample_frqstep
              ;*Samplerepeat holen
;>                move   sample_len,sample_restart
;>                moveq  #0,sample_newfrq
;>                move   sample_restart,sample_end2
;>                addq   #10,sample_end2
;>                move    sample_len,sample_end
**42BS
                move   sample_len,sample_restart
                move   sample_len,sample_end2
                move   sample_len,sample_end
                addq   #10,sample_end2
                moveq  #0,sample_newfrq
**42BS
                load   (a_v_base+v_samreplen),sample_dummy
                movei  #repeatok2,sample_dummy4

                cmpq   #3,sample_dummy              ;Repeatstart nur setzen,
                jump   n,(sample_dummy4)            ;wenn ein Repeat da
                nop
                load   (a_v_base+v_samrepstart),sample_restart
                move   sample_frqstep,sample_newfrq
                move   sample_restart,sample_end
                add    sample_dummy,sample_end
                sub    a_sample_adr,sample_restart
                sub    a_sample_adr,sample_end
                move   sample_end,sample_end2
repeatok2
;>                addq   #1,sample_end
;>                addq   #1,sample_end2
                shlq   #15,sample_restart
                shlq   #15,sample_end
                shlq   #15,sample_end2

              ;*Samplelautstrke linker Kanal holen
                load   (a_v_base+v_samvol_l),sample_vol_l
                movei  #$8000/maxvoices,sample_norm_l       ; Mitte
              ;*Samplelautstrke rechter Kanal holen
                load   (a_v_base+v_samvol_r),sample_vol_r
                movei  #$8000/maxvoices,sample_norm_r       ; Mitte
                movei  #$80,sample_dummy
                movei  #$80,sample_dummy2
                mult   sample_vol_l,sample_dummy
                mult   sample_vol_r,sample_dummy2
                sub    sample_dummy,sample_norm_l ; Mitte-Normalisierungswert L
                sub    sample_dummy2,sample_norm_r ;und R

                move   a_sample_adr,sample_adr2

;                movei  #116-1,byte_count
 movei #calcblock>>2,byte_count
                movei  #byte_loop,l_byte_loop
byte_loop
                move   sample_offs,sample_frqcnt
                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
;>                loadb  (sample_frqcnt),sample_bytes     ;1.Samplebyte holen
                add    sample_frqstep,sample_offs

                cmp    sample_end,sample_offs
            loadb  (sample_frqcnt),sample_bytes     ;1.Samplebyte holen
                jr     n,mix_norepeat00
                move   sample_offs,sample_frqcnt   ;fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat00
                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
;>                loadb  (sample_frqcnt),sample_bytes2    ;2.Samplebyte holen
                add    sample_frqstep,sample_offs

                cmp    sample_end,sample_offs
            loadb  (sample_frqcnt),sample_bytes2    ;2.Samplebyte holen
                jr     n,mix_norepeat01
                move   sample_bytes,sample_dummy   ;fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat01

                move   sample_bytes2,sample_dummy3

                move   sample_dummy,sample_dummy2
                move   sample_dummy3,sample_dummy4

                mult   sample_vol_l,sample_dummy       ;Lautstrke einrechnen
                mult   sample_vol_l,sample_dummy3      ;links
                add    sample_norm_l,sample_dummy      ;Normalisierung
                add    sample_norm_l,sample_dummy3     ;einrechen links
**42BS
                shlq   #16,sample_dummy                ;Byte links ins Highword
                shlq   #16,sample_dummy3
**42BS
                mult   sample_vol_r,sample_dummy2      ;Lautstrke einrechnen
                mult   sample_vol_r,sample_dummy4      ;rechts
;>                shlq   #16,sample_dummy                ;Byte links ins Highword
;>                shlq   #16,sample_dummy3
                add    sample_norm_r,sample_dummy2     ;Normalisierung
                add    sample_norm_r,sample_dummy4     ;einrechen rechts

                or     sample_dummy2,sample_dummy      ;als Long zusammenbauen
                or     sample_dummy4,sample_dummy3

                load   (a_sample_buf),sample_dummy2    ;Word 1 links+rechts holen
                addq   #4,a_sample_buf
                load   (a_sample_buf),sample_dummy4    ;Word 2 links+rechts holen
           subq   #4,a_sample_buf                      ;**42BS
                add    sample_dummy2,sample_dummy      ;Word aufaddieren
;>                subq   #4,a_sample_buf
                add    sample_dummy4,sample_dummy3     ;Word aufaddieren

                store  sample_dummy,(a_sample_buf)     ;Word 1 L+R ablegen
                addq   #4,a_sample_buf
           move   sample_offs,sample_frqcnt            ;**42BS
                store  sample_dummy3,(a_sample_buf)    ;Word 2 L+R ablegen
           shrq   #15,sample_frqcnt                    ;**42BS
                addq   #4,a_sample_buf

;>                move   sample_offs,sample_frqcnt
;>                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
           add    sample_frqstep,sample_offs           ;**BS42

                loadb  (sample_frqcnt),sample_bytes     ;3.Samplebyte holen
;>                add    sample_frqstep,sample_offs

                cmp    sample_end,sample_offs
                jr     n,mix_norepeat02
                move   sample_offs,sample_frqcnt    ;fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat02

                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
;>                loadb  (sample_frqcnt),sample_bytes2    ;4.Samplebyte holen
                add    sample_frqstep,sample_offs

                cmp    sample_end,sample_offs
            loadb  (sample_frqcnt),sample_bytes2    ;4.Samplebyte holen
                jr     n,mix_norepeat03
                move   sample_bytes,sample_dummy   ;fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat03

                move   sample_bytes2,sample_dummy3
                move   sample_dummy,sample_dummy2
                move   sample_dummy3,sample_dummy4

                mult   sample_vol_l,sample_dummy       ;Lautstrke einrechnen
                mult   sample_vol_l,sample_dummy3      ;links
                add    sample_norm_l,sample_dummy      ;Normalisierung
                add    sample_norm_l,sample_dummy3     ;einrechen links
**42BS
                shlq   #16,sample_dummy                ;Byte links ins Highword
                shlq   #16,sample_dummy3
**42BS

                mult   sample_vol_r,sample_dummy2      ;Lautstrke einrechnen
                mult   sample_vol_r,sample_dummy4      ;rechts
;>                shlq   #16,sample_dummy                ;Byte links ins Highword
;>                shlq   #16,sample_dummy3
                add    sample_norm_r,sample_dummy2     ;Normalisierung
                add    sample_norm_r,sample_dummy4     ;einrechen rechts

                or     sample_dummy2,sample_dummy      ;als Long zusammenbauen
                or     sample_dummy4,sample_dummy3

                load   (a_sample_buf),sample_dummy2    ;Word 1 links+rechts holen
                addq   #4,a_sample_buf
                load   (a_sample_buf),sample_dummy4    ;Word 2 links+rechts holen
                add    sample_dummy2,sample_dummy      ;Words aufaddieren
                subq   #4,a_sample_buf
                add    sample_dummy4,sample_dummy3

                store  sample_dummy,(a_sample_buf)     ;Word 3 L+R ablegen
                addq   #4,a_sample_buf
;>                store  sample_dummy3,(a_sample_buf)    ;Word 4 L+R ablegen

; Hiermit sind 4 Bytes bearbeitet worden...

                subq   #1,byte_count
            store  sample_dummy3,(a_sample_buf)    ;**42BS  ;Word 4 L+R ablegen
                jump   nn,(l_byte_loop)
                addq   #4,a_sample_buf

              ;*Sampleoffset wieder ablegen
                store   sample_offs,(a_v_base+v_playoffs)

              ;*Und weiter im Voice-Loop
                subq   #1,mix_count
                jump   nn,(l_mix_loop)
                nop

               IF _DSP_TIME=1
                movei  #VID_BG,r0
                moveq  #$0,r1
                storew r1,(r0)
               ENDIF

               ENDIF                    ;_MIXOFF

              ;*Und jetzt wieder in den Hauptloop
                movei  #mixer,r30
                jump   (r30)
                nop
ENDIF
              ;>PART "4-Voice-Mixer"
a_sample_adr    REG 0         ; Pointer auf Anfang des akt. Samples
sample_offs     REG 1         ; aktueller Offset in Sample
sample_len      REG 2         ; Lnge aktuelles Sample
a_sample_buf    REG 3         ; Pointer auf aktuellen Samplebuffer
sample_bytes    REG 4         ; 4 Samplebytes
sample_mask     REG 5         ; Maske fr Samplebytes                 UNBENUTZT
sample_dummy    REG 6         ; Samplebyte Zwischenspeicher
sample_dummy2   REG 7         ; Samplebyte Zwischenspeicher
sample_vol_l    REG 8         ; aktuelle Sample-Lautstrke links
sample_bytes2   REG 9
sample_dummy3   REG 10        ; Samplebyte Zwischenspeicher
sample_dummy4   REG 11        ; Samplebyte Zwischenspeicher
sample_vol_r    REG 12        ; aktuelle Sample-Lautstrke rechts
sample_norm_l   REG 13        ; Normalisierungswert um Sample nach Hhentrans-
                              ; formation wieder mittig zu stellen
a_v_base        REG 14        ; Baseregister auf die Stimmen
sample_adr2     REG 15
sample_norm_r   REG 16        ; Normalisierungswert rechts
l_byte_loop     REG 17        ; JumpPointer auf den Byte-Mixloop
byte_count      REG 18        ; Counter fr den Byte-Mixloop
a_sample_dsp    REG 19        ; Pointer auf Sampleteil im DSP         UNBENUTZT
l_mix_loop      REG 20        ; JumpPointer fr den Stimmenloop
mix_count       REG 21        ; Counter fr den Stimmenloop
sample_end      REG 22        ; Endoffset aktuelles Sample
sample_restart  REG 23        ; Restartoffset des aktuellen Samples
sample_end2     REG 24        ; nchster Restartoffset des akt. Samples
sample_frqstep  REG 28        ; ADD-Stepwert fr die Samplefrequenz
sample_frqcnt   REG 27        ; Pointerregister auf akt. Samplebyte
sample_newfrq   REG 29        ; neue Frequenz bei Loop

                movei  #voice_var_base,a_v_base
              ;*aktuelle Playbufferadresse holen und Buffer vertauschen
                movei  #playbuf_adr,a_sample_buf
                load   (a_sample_buf),sample_dummy
                addq   #4,a_sample_buf
                load   (a_sample_buf),sample_dummy2
                store  sample_dummy,(a_sample_buf)
                subq   #4,a_sample_buf
                store  sample_dummy2,(a_sample_buf)
                move   sample_dummy2,a_sample_buf
                moveta sample_dummy,r22

               IF _MIXOFF=0

                movei  #$FF,sample_mask
mix_em_up
              ;*Sampleadresse holen
                load   (a_v_base),a_sample_adr
              ;*Samplelnge holen
                load   (a_v_base+v_samlength),sample_len
              ;*Sampleoffset holen
                load   (a_v_base+v_playoffs),sample_offs
              ;*Samplefrequenzstep holen
                load   (a_v_base+v_freqstep),sample_frqstep
                shrq   #1,sample_frqstep          ;/2, damit es beim hoch-
                                                  ; addieren der Samplebyte-
                                                  ; offset keinen berlauf ins
                                                  ; Negativbit gibt!
              ;*Samplerepeat vorbereiten
                move   sample_len,sample_restart  ;Erstmal kein Loop, Sample am
                move   sample_restart,sample_end2 ; Ende stoppen
                addq   #10,sample_end2            ;10 Bytes zeit zum stoppen
                moveq  #0,sample_newfrq           ; Frequenz beim stoppen auf 0
                                                  ; dann rauscht auch nix mehr
                move   sample_len,sample_end
                load   (a_v_base+v_samreplen),sample_dummy ;Repeatlnge holen
                movei  #repeatok,sample_dummy4

                cmpq   #3,sample_dummy            ;Repeatstart nur setzen,
                jump   n,(sample_dummy4)          ; wenn ein Repeat da (>2)
                nop
              ;*Restartadresse setzen
                load   (a_v_base+v_samrepstart),sample_restart
                move   sample_frqstep,sample_newfrq  ;Alte Frequenz beibehalten
                move   sample_restart,sample_end     ;Ende des Loopbereiches
                add    sample_dummy,sample_end       ; berechnen
                sub    a_sample_adr,sample_restart   ;Alle Begrenzungen als
                sub    a_sample_adr,sample_end       ; relative Loopoffsets
                move   sample_end,sample_end2        ;Nchster Repeatende
                                                     ; ist gleich diesem
repeatok
                shlq   #15,sample_restart    ;Alle Offsets auf 16Bit Vorkomma,
                shlq   #15,sample_end        ;15Bit Nachkomma anpassen
                shlq   #15,sample_end2

              ;*Samplelautstrke linker Kanal holen
                load   (a_v_base+v_samvol_l),sample_vol_l
                movei  #$8000/maxvoices,sample_norm_l       ;Mitte
              ;*Samplelautstrke rechter Kanal holen
                load   (a_v_base+v_samvol_r),sample_vol_r
                movei  #$8000/maxvoices,sample_norm_r       ;Mitte
                movei  #$80,sample_dummy            ;Jetzt erstmal den An-
                movei  #$80,sample_dummy2           ; passungswert fr die
                mult   sample_vol_l,sample_dummy    ; Lautstrkentransformation
                mult   sample_vol_r,sample_dummy2   ; berechnen
                sub    sample_dummy,sample_norm_l   ;Normalisierungswert L
                sub    sample_dummy2,sample_norm_r  ; und R

                move   a_sample_adr,sample_adr2

;===========
;========= Dieser Mischteil berschreibt den Buffer mit den Samplewerten der
;========= 1. Stimme, er wird somit auch gleich gelscht
;===========

                movei  #116-1,byte_count          ;116*4 Werte in den Playbuf
                movei  #byte_loop2,l_byte_loop
byte_loop2
                move   sample_offs,sample_frqcnt  ;Den Offset auf das akt.
                shrq   #15,sample_frqcnt          ; Samplebyte berechnen
                add    sample_adr2,sample_frqcnt  ; und schlielich die Adresse
                loadb  (sample_frqcnt),sample_bytes     ;1.Samplebyte holen
                add    sample_frqstep,sample_offs ;Frequenzadd auf Offset

                cmp    sample_end,sample_offs     ;Ist das Sample hier zuende
                jr     n,mix_norepeat10           ; bzw. ist ein Loop dran?
                move   sample_offs,sample_frqcnt  ;Schonmal fr nxtes Byte

                move   sample_restart,sample_offs   ;Restartoffset setzen
                move   sample_newfrq,sample_frqstep ;Neue Frequenz
                move   sample_end2,sample_end       ;Und neuer Loopend
mix_norepeat10

                shrq   #15,sample_frqcnt          ;Dito.
                add    sample_adr2,sample_frqcnt
                loadb  (sample_frqcnt),sample_bytes2    ;2.Samplebyte holen
                add    sample_frqstep,sample_offs
                cmp    sample_end,sample_offs
                jr     n,mix_norepeat11
                move   sample_bytes,sample_dummy       ;Byte 1 sichern

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat11

                move   sample_bytes2,sample_dummy3     ;Byte 2 sichern

                move   sample_dummy,sample_dummy2      ;Byte 1+2 fr rechten
                move   sample_dummy3,sample_dummy4     ;Kanal holen

                ;sx*Lautstrke($0..$40)...
                mult   sample_vol_l,sample_dummy       ;Lautstrke einrechnen
                mult   sample_vol_l,sample_dummy3      ;links
                ;...+($8000/4-($80*Lautstrke))
                add    sample_norm_l,sample_dummy      ;Normalisierung
                add    sample_norm_l,sample_dummy3     ;einrechen links

                mult   sample_vol_r,sample_dummy2      ;Lautstrke einrechnen
                mult   sample_vol_r,sample_dummy4      ;rechts
                shlq   #16,sample_dummy                ;Byte links ins Highword
                shlq   #16,sample_dummy3
                add    sample_norm_r,sample_dummy2     ;Normalisierung
                add    sample_norm_r,sample_dummy4     ;einrechen rechts

                or     sample_dummy2,sample_dummy      ;als Long zusammenbauen
                or     sample_dummy4,sample_dummy3

                store  sample_dummy,(a_sample_buf)     ;Word 1 L+R ablegen
                addq   #4,a_sample_buf                 ;Nchstes Buffer-Long
                store  sample_dummy3,(a_sample_buf)    ;Word 2 L+R ablegen
                addq   #4,a_sample_buf                 ;Nchstes Long

                move   sample_offs,sample_frqcnt
                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
                loadb  (sample_frqcnt),sample_bytes    ;3.Samplebyte holen
                add    sample_frqstep,sample_offs
                cmp    sample_end,sample_offs
                jr     n,mix_norepeat12
                move   sample_offs,sample_frqcnt    ;Schonmal fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat12

                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
                loadb  (sample_frqcnt),sample_bytes2   ;4.Samplebyte holen
                add    sample_frqstep,sample_offs
                cmp    sample_end,sample_offs
                jr     n,mix_norepeat14
                move   sample_bytes,sample_dummy

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat14

                move   sample_bytes2,sample_dummy3
                move   sample_dummy,sample_dummy2
                move   sample_dummy3,sample_dummy4

                mult   sample_vol_l,sample_dummy       ;Lautstrke einrechnen
                mult   sample_vol_l,sample_dummy3      ;links
                add    sample_norm_l,sample_dummy      ;Normalisierung
                add    sample_norm_l,sample_dummy3     ;einrechen links

                mult   sample_vol_r,sample_dummy2      ;Lautstrke einrechnen
                shlq   #16,sample_dummy                ;Byte links ins Highword
                mult   sample_vol_r,sample_dummy4      ;rechts
                shlq   #16,sample_dummy3
                add    sample_norm_r,sample_dummy2     ;Normalisierung
                add    sample_norm_r,sample_dummy4     ;einrechen rechts

                or     sample_dummy2,sample_dummy      ;als Long zusammenbauen
                or     sample_dummy4,sample_dummy3

                store  sample_dummy,(a_sample_buf)     ;Word 3 L+R ablegen
                addq   #4,a_sample_buf
                store  sample_dummy3,(a_sample_buf)    ;Word 4 L+R ablegen

; Hiermit sind 4 Bytes bearbeitet worden...

                subq   #1,byte_count
                jump   nn,(l_byte_loop)
                addq   #4,a_sample_buf                 ;nxtes Long im Buffer

              ;*Sampleoffset wieder ablegen
                store   sample_offs,(a_v_base+v_playoffs)

               IF _DSP_TIME=1
                movei  #VID_BG,sample_dummy
                movei  #$ff80,sample_dummy2
                storew sample_dummy2,(sample_dummy)
               ENDIF

;===========
;========= Ab hier wird auf den Playbuffer nur noch aufaddiert
;===========

                movei  #maxvoices-2,mix_count        ;Die restlichen drei Stimmen
                movei  #mix_loop,l_mix_loop

mix_loop
                movei  #voice_next,sample_dummy
                add    sample_dummy,a_v_base

                movei  #playbuf_adr,a_sample_buf
                load   (a_sample_buf),a_sample_buf

              ;*Sampleadresse holen
                load   (a_v_base),a_sample_adr
              ;*Samplelnge holen
                load   (a_v_base+v_samlength),sample_len
              ;*Sampleoffset holen
                load   (a_v_base+v_playoffs),sample_offs ;aktuellen Sample
              ;*Samplefrequenzstep holen
                load   (a_v_base+v_freqstep),sample_frqstep
                shrq   #1,sample_frqstep
              ;*Samplerepeat holen
                move   sample_len,sample_restart
                moveq  #0,sample_newfrq
                move   sample_restart,sample_end2
                addq   #10,sample_end2
                move    sample_len,sample_end
                load   (a_v_base+v_samreplen),sample_dummy
                movei  #repeatok2,sample_dummy4

                cmpq   #3,sample_dummy              ;Repeatstart nur setzen,
                jump   n,(sample_dummy4)            ;wenn ein Repeat da
                nop
                load   (a_v_base+v_samrepstart),sample_restart
                move   sample_frqstep,sample_newfrq
                move   sample_restart,sample_end
                add    sample_dummy,sample_end
                sub    a_sample_adr,sample_restart
                sub    a_sample_adr,sample_end
                move   sample_end,sample_end2
repeatok2
;>                addq   #1,sample_end
;>                addq   #1,sample_end2
                shlq   #15,sample_restart
                shlq   #15,sample_end
                shlq   #15,sample_end2

              ;*Samplelautstrke linker Kanal holen
                load   (a_v_base+v_samvol_l),sample_vol_l
                movei  #$8000/maxvoices,sample_norm_l       ; Mitte
              ;*Samplelautstrke rechter Kanal holen
                load   (a_v_base+v_samvol_r),sample_vol_r
                movei  #$8000/maxvoices,sample_norm_r       ; Mitte
                movei  #$80,sample_dummy
                movei  #$80,sample_dummy2
                mult   sample_vol_l,sample_dummy
                mult   sample_vol_r,sample_dummy2
                sub    sample_dummy,sample_norm_l ; Mitte-Normalisierungswert L
                sub    sample_dummy2,sample_norm_r ;und R

                move   a_sample_adr,sample_adr2

                movei  #116-1,byte_count
                movei  #byte_loop,l_byte_loop
byte_loop
                move   sample_offs,sample_frqcnt
                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
                loadb  (sample_frqcnt),sample_bytes     ;1.Samplebyte holen
                add    sample_frqstep,sample_offs

                cmp    sample_end,sample_offs
                jr     n,mix_norepeat00
                move   sample_offs,sample_frqcnt   ;fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat00
                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
                loadb  (sample_frqcnt),sample_bytes2    ;2.Samplebyte holen
                add    sample_frqstep,sample_offs

                cmp    sample_end,sample_offs
                jr     n,mix_norepeat01
                move   sample_bytes,sample_dummy   ;fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat01

                move   sample_bytes2,sample_dummy3

                move   sample_dummy,sample_dummy2
                move   sample_dummy3,sample_dummy4

                mult   sample_vol_l,sample_dummy       ;Lautstrke einrechnen
                mult   sample_vol_l,sample_dummy3      ;links
                add    sample_norm_l,sample_dummy      ;Normalisierung
                add    sample_norm_l,sample_dummy3     ;einrechen links

                mult   sample_vol_r,sample_dummy2      ;Lautstrke einrechnen
                mult   sample_vol_r,sample_dummy4      ;rechts
                shlq   #16,sample_dummy                ;Byte links ins Highword
                shlq   #16,sample_dummy3
                add    sample_norm_r,sample_dummy2     ;Normalisierung
                add    sample_norm_r,sample_dummy4     ;einrechen rechts

                or     sample_dummy2,sample_dummy      ;als Long zusammenbauen
                or     sample_dummy4,sample_dummy3

                load   (a_sample_buf),sample_dummy2    ;Word 1 links+rechts holen
                addq   #4,a_sample_buf
                load   (a_sample_buf),sample_dummy4    ;Word 2 links+rechts holen
                add    sample_dummy2,sample_dummy      ;Word aufaddieren
                subq   #4,a_sample_buf
                add    sample_dummy4,sample_dummy3     ;Word aufaddieren

                store  sample_dummy,(a_sample_buf)     ;Word 1 L+R ablegen
                addq   #4,a_sample_buf

                store  sample_dummy3,(a_sample_buf)    ;Word 2 L+R ablegen
                addq   #4,a_sample_buf

                move   sample_offs,sample_frqcnt
                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
                loadb  (sample_frqcnt),sample_bytes     ;3.Samplebyte holen
                add    sample_frqstep,sample_offs

                cmp    sample_end,sample_offs
                jr     n,mix_norepeat02
                move   sample_offs,sample_frqcnt    ;fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat02

                shrq   #15,sample_frqcnt
                add    sample_adr2,sample_frqcnt
                loadb  (sample_frqcnt),sample_bytes2    ;4.Samplebyte holen
                add    sample_frqstep,sample_offs

                cmp    sample_end,sample_offs
                jr     n,mix_norepeat03
                move   sample_bytes,sample_dummy   ;fr nxtes Byte

                move   sample_restart,sample_offs
                move   sample_newfrq,sample_frqstep
                move   sample_end2,sample_end
mix_norepeat03

                move   sample_bytes2,sample_dummy3
                move   sample_dummy,sample_dummy2
                move   sample_dummy3,sample_dummy4

                mult   sample_vol_l,sample_dummy       ;Lautstrke einrechnen
                mult   sample_vol_l,sample_dummy3      ;links
                add    sample_norm_l,sample_dummy      ;Normalisierung
                add    sample_norm_l,sample_dummy3     ;einrechen links

                mult   sample_vol_r,sample_dummy2      ;Lautstrke einrechnen
                mult   sample_vol_r,sample_dummy4      ;rechts
                shlq   #16,sample_dummy                ;Byte links ins Highword
                shlq   #16,sample_dummy3
                add    sample_norm_r,sample_dummy2     ;Normalisierung
                add    sample_norm_r,sample_dummy4     ;einrechen rechts

                or     sample_dummy2,sample_dummy      ;als Long zusammenbauen
                or     sample_dummy4,sample_dummy3

                load   (a_sample_buf),sample_dummy2    ;Word 1 links+rechts holen
                addq   #4,a_sample_buf
                load   (a_sample_buf),sample_dummy4    ;Word 2 links+rechts holen
                add    sample_dummy2,sample_dummy      ;Words aufaddieren
                subq   #4,a_sample_buf
                add    sample_dummy4,sample_dummy3

                store  sample_dummy,(a_sample_buf)     ;Word 3 L+R ablegen
                addq   #4,a_sample_buf
                store  sample_dummy3,(a_sample_buf)    ;Word 4 L+R ablegen

; Hiermit sind 4 Bytes bearbeitet worden...

                subq   #1,byte_count
                jump   nn,(l_byte_loop)
                addq   #4,a_sample_buf

              ;*Sampleoffset wieder ablegen
                store   sample_offs,(a_v_base+v_playoffs)

              ;*Und weiter im Voice-Loop
                subq   #1,mix_count
                jump   nn,(l_mix_loop)
                nop

               IF _DSP_TIME=1
                movei  #VID_BG,r0
                moveq  #$0,r1
                storew r1,(r0)
               ENDIF

               ENDIF                    ;_MIXOFF

              ;*Und jetzt wieder in den Hauptloop
                movei  #mixer,r30
                jump   (r30)
                nop

;=================================================
;                                    Unterroutinen
;=================================================

                EVENP

;========================
;      Samplereplay-Timer
**42BS Interleaving, und Teile rausgeschmissen.

              ;>PART "SSI-IRQ"
ssi_irq
;>                movei  #VID_BG,r24
;>                movei  #$f0ff,r25
;>                storew r25,(r24)

;> in den dispatcher verlegt
;>                START_IRQ          ;_MUSS_ sein, da in diesem IRQ die Flags
;>                                   ;verndert werden!
;>                load   (smpl_ptr.a),r24   ;Sampleworte linke+rechter Kanal holen

                movei  #$8000,r30  ;Samples werden signed ausgegeben
                addq   #4,smpl_ptr.a

                move   r24,r25
                sub    r30,r24     ;sollte noch in der mix-Routine
                                   ;bercksichtigt werden, hier zieht's Zeit
                shrq   #16,r25
                store  r24,(LeftChannel.a)

                sub    r30,r25
                store  r25,(RightChannel.a)

**42BS Timing-stuff von Speicherzelle auf Register gendert
**
;>                movei  #timer_count,r24 ;Timing-Signal geben
;>                load   (r24),r25        ;das wird hier erledigt, damit
;>                addq   #1,r25           ;garantiert kein Byte zuviel/zuwenig
;>                store  r25,(r24)        ;abgespielt wird... vielleicht bin
;>                movei  #461,r24         ;ich da etwas zu pedantisch ;-)
;>                cmp    r24,r25
;>                jr     n,no_timer
;>                nop
;>                  movei  #$3d0dead,r24
;>                  movei  #timingflag,r30
;>                  store  r24,(r30)
;>                movei  #timer_count,r30
;>                moveq  #0,r24
;>                store r24,(r25)
;>                store  r24,(r30)

                subq #1,TimingCounter.a
                movei #calcblock,r30
                jr nn,no_timer
                nop
                  move r30,TimingCounter.a
                  addq #1,TimingFlag.a
********************************************
no_timer

                movei  #counter,r24     ;die kHz-Rate zu ermitteln (TEST)
                load   (r24),r25
                addq   #1,r25
                store  r25,(r24)

;>                movei  #VID_BG,r24
;>                movei  #$0000,r25
;>                storew r25,(r24)

               END_IRQ 1
;========================
;             Tempo-Timer

              ;>PART "Timer 1"
                EVENL
timer1_irq     ;SETBG #$FFFF
;>                movei  #VID_BG,r0
;>                movei  #$00ff,r1
;>                storew r1,(r0)

;>                movei  #$3d0dead,r28
;>                movei  #timingflag,r30
;>                store  r28,(r30)
;>                movei  #DSP_FLAGS,r0
;>                load   (r0),r1
;>                bset   #11,r1
;>                bclr   #3,r1
;>                store  r1,(r0)

;>                addqmod #4,r14
;>                addqmod #4,r15

;>                movei  #VID_BG,r0
;>                movei  #$0,r1
;>                storew r1,(r0)
               END_IRQ 2
                
timer2_irq
;>                movei  #VID_BG,r0
;>                movei  #$8FFF,r1
;>                storew r1,(r0)

;>                subq   #1,r10

;>                movei  #VID_BG,r0
;>                movei  #$0000,r1
;>                storew r1,(r0)
               END_IRQ 3

;=================================================
;                                     Datenbereich
;=================================================

               DC.B "(c)1994/95 Phobyx creative. Coded by tIn."
               EVENL
timingflag     DC.L   0
flag0          DC.L   0                ;i Vorstufenflag zu Flag1
flag1::        DC.L   0                ;i Timing-Flag fr den 68k-Replay
;>timer_count    DC.L   calcblock        ;i SAmplebyte-Zhler im SSI-IRQ
main_count     DC.L   0                ;i Zhler fr's Timing
main_offset    DC.L   0                ;i aktueller Offset in Samplebuffer
playbuf_adr::  DC.L   playbuf0,playbuf1

;=======================================
;  Sample-Controls der einzelnen Stimmen
;         (e=externer Zugriff, i=intern)

               EVENL
voice_var_base::
d              SET    *

v_samadr::     EQU    *-d
               DC.L   0                ;e +00 Adresse aktuelles Sample

v_samlength::  EQU    *-d ;4
               DC.L   0                ;e +04 Sample-Lnge

v_samfreq::    EQU    *-d ;8
               DC.L   0                ;e +08 Sample-Abspielfrequenz

v_samrepstart:: EQU   *-d ;12
               DC.L   0                ;e +12 Offset zum repeat

v_samreplen::  EQU    *-d ;16
               DC.L   0                ;e +16 Repeat-Lnge

v_samvol_l::   EQU    *-d ;20
               DC.L   0                ;e +20 Sample-Lautstrke links

v_samvol_r::   EQU    *-d ;24
               DC.L   0                ;e +24 Sample-Lautstrke links

v_playoffs::   EQU    *-d ;28
               DC.L   0                ;i +28 Offset zum aktuellen Abspielteil

v_freqstep::   EQU    *-d ;32
               DC.L   0                ;i +32 Frequenzstep fr Blitter
voice_next::   EQU    *-d ;36

               REPT 7                  ;  +36
                DC.L   0,0,0,0,0,0,0,0,0
               ENDR
;=======================================
;                      Sample/Playbuffer
;>               EVENL
;>sambuf_empty:: REPT   116
;>               DC.L   $80808080,$80808080
;>               ENDR
               EVENL
playbuf0::     DSL    520               ; Stereo-PlayBuffer 1
playbuf1::     DSL    520               ; Stereo-PlayBuffer 2

               EVENL
               DSL 10
stack:         DSL 1
;>               EVENP
;>sambuf::       DSB    470          ; Buffer fr aktuellen Sampleteil
EOP
********************************
*              Debug-Align-infos
*
size           set  EOP-SOP
               ECHO "----------------------------"
               ECHO "L:counter:      %Hcounter"
;>               ECHO "P:tabhline:    %Htabhline"
;>               ECHO "L:screenhline: %Hscreenhline"
               ECHO "S:%Dsize"
               IF size>8192
                ECHO " "
                ECHO "/########################################\"
                ECHO "# p ==> WARNUNG!! Programmcode zu lang q ! #"
                FAIL "\########################################/"
               ENDIF
********************************

                END


