/**************************************************************************
.WAV file header:
00-03	'RIFF'
04-07	length
08-11	'WAVE'
12-15	'fmt '
16-19	length of data block
20-21	format tag
22-23	channels (1 mono, 2 stereo)
24-27	samples per second
28-31	average samples per second
32-33	block alignment
34-35	bits per sample
36-39	'data'
40-43	length of sample data

**************************************************************************/
#include <stdio.h>

unsigned char src[50];
long length;					/* length of sample data */
long rate;					/* sample rate */
long temp;
int bits;

int i;

FILE *infile;					/* WAV file pointer	*/
FILE *outfile;					/* new file pointer */
char pathname[100];				/* pathname for opening and closing files */

/**  Main  *****************************************************************/
main(argc, argv)
int argc;
char *argv[];
{
	if (argc < 2)                                   /* if no file name was specified */
	{
		printf ("This program removes the header information from a .WAV file.\n");
		printf ("Usage:  wav filename\n");
		printf ("Do not include the .WAV extension\n");
		exit (0);
	}

	strcpy (pathname, argv[1]);
	strcat (pathname, ".WAV");
	if ((infile = fopen (pathname, "rb")) == NULL)	/* open WAV file */
	{
		printf("Cannot open input file %s\n", pathname);
		exit (-1);
	}

	read_header();						/* get size and other info */
	if((src[0] != 'R') || (src[1] != 'I') || (src[2] != 'F') || (src[3] != 'F'))
	{
		printf("Wrong file format\n");
		exit (-1);
	}

	strcpy (pathname, argv[1]);
	strcat (pathname, ".RAW");
	if ((outfile = fopen (pathname, "wb")) == NULL)	/* open new file */
	{
		printf("Cannot open output file %s\n", pathname);
		exit (-1);
	}

	fseek(infile,44L,0);				/* go to start of sample data */
	if(bits == 8)						/* 8 bit */
	{
		for(temp = 0L; temp < length; temp++)
			fputc((fgetc(infile)-128),outfile);
		temp = length & 1;
		if(temp == 1)
			fputc('0',outfile);			/* round file size to an even number */
	}
	else
	{
		for(temp = 0L; temp < length; temp+=2)
		{
			fputc((fgetc(infile)-128),outfile);
			fputc((fgetc(infile)),outfile);
		}
		temp = length & 1;
		if(temp == 1)
			fputc('0',outfile);
	}

	printf("length = %6ld\n  rate = %6ld\n  bits = %6d\n",length,rate,bits);

	fclose (infile);					/* close WAV file */
	fclose (outfile);					/* close new file */
	exit (0);
}


/* read the first 44 bytes of the .WAV file to get some information */
read_header()
{
	fread (src, 44, 1, infile);
	length = (src[43] << 24L) + (src[42] << 16L) + (src[41] << 8L) + src[40];
	rate = (src[27] << 24L) + (src[26] << 16L) + (src[25] << 8L) + src[24];
	bits = (src[35] << 8) + src[34];
}
