//
// low-level routines for centronix
// written by 42Bastian Schick
//
//
// globals (defined in main)
// gBase : port-address
// gWait : wait-loop counter (no longer used, see below)
//
// functions:
//
// void InitPortNormal();
// void InitPortHyper();
// int SendWord(short w);   /* 1 => timeout */
// int SendWordLE(short w); /* send little-endian word */ 
// int SendLong(long l);    /* 1 => timeout */
// void SendLongHyper(long l);
//
// All functions expect little-endian words/longs !!!

//
// SendLongHyper(ulong l)
//
#define CAT(x,y) x##y
#ifdef __linux__
	.macro FUNC name
	.globl \name
	.type \name,@function
\name:
	.endm
#define EXTERN(name) name
#else
	.macro FUNC name
	.globl _\name
_\name:
	.endm
#define EXTERN(name) CAT(_,name)

#endif
	FUNC	SendLongHyper8
	pushl %ebx
	pushl %ecx

	movl 12(%esp),%ebx
	call SendNibble
	shrl $8,%ebx
	call SendNibble
	shrl $8,%ebx
	call SendNibble
	shrl $8,%ebx
	call SendNibble

//using out is better,AFAIK a port-access is 1us even on a PII-450 !	

//->	movl EXTERN(gWait),%edx
//->	cmpl	$0,%edx
//->	je	2f
//->1:
//->	outb %al,$0x80
//->	decl %edx
//->	jnz 1b
2:
	popl %ecx
	popl %ebx
	ret

	FUNC	SendLongHyper4
	pushl %ebx
	pushl %ecx

	movl 12(%esp),%ebx
	call SendByte
	shrl $8,%ebx
	call SendByte
	shrl $8,%ebx
	call SendByte
	shrl $8,%ebx
	call SendByte

//using out is better,AFAIK a port-access is 1us even on a PII-450 !	
	movl EXTERN(gWait),%edx
	cmpl	$0,%edx
	je	2f
wait0:
	outb %al,$0x80
	decl %edx
	jnz wait0
2:
	popl %ecx
	popl %ebx
	ret

//
// SendByte
// in : bl = data
//
	.align 16
SendByte:
	pushl %ebx
	shlb $4,%bl
	call SendNibble	// else send first lower nibble
	popl %ebx

//
// Send out bl, either only the lower nibble or the whole byte
//
	.align 16
SendNibble:	
	movl EXTERN(gBase),%edx
	incw %dx
L94a:
	inb %dx, %al	// gBase+1
	testb %al,%al
	jns L94a
	
	decw %dx	// gBase
	movb %bl,%al	
	outb %al, %dx

	addw $2,%dx	// gBase+2
	movb $1,%al
	outb %al, %dx

	decw %dx	// gBase+1
L100a:
	inb %dx, %al
	testb %al,%al
	js L100a

	incw %dx	// gBase+2
	xorb %al,%al
	outb %al, %dx

	decw %dx
	movl $100000,%ecx
1:
	decl %ecx
	je 99f
	inb %dx, %al	// gBase+1
	testb %al,%al
	jns 1b
99:	
	ret

//
// initport
//
	.align 16
	FUNC	InitPortHyper
	movl EXTERN(gBase),%edx
	xorb %al,%al
	
	outb %al,%dx
	incw %dx
	outb %al,%dx
	incw %dx
	outb %al,%dx

	ret

//
// InitPortNormal
//
	.align 16
	FUNC	InitPortNormal
	movl EXTERN(gBase),%edx
	xorb %al,%al
	
	outb %al,%dx
	incw %dx
	outb %al,%dx
	incw %dx
	incb %al
	outb %al,%dx

	outb %al,%dx
	ret

//
// SendWordLE(ushort w)
//
	.align 2
	FUNC	SendWordLE
	pushl %ebx
	pushl %esi
	movl 12(%esp),%ebx
	rorw $8,%bx
	jmp cont
//
// SendWord(ushort w)
//
	.align 2
	FUNC	SendWord
	pushl %ebx
	pushl %esi
	movl 12(%esp),%ebx
cont:	
	movl EXTERN(gBase),%edx
	rolw $3,%bx
	movw $8,%cx

	movw $20000,%si
	incw %dx
l00:
	decw %si
	jz l99
	inb %dx,%al
	testb %al,%al
	js l00

l1:
	inb %dx,%al
	testb %al,%al
	js l1
		
	decw %dx
	movb $6,%al
	andb %bl,%al
	outb %al,%dx

	
	incw %dx
	incw %dx
	xorb %al,%al
	outb %al,%dx	 
	
	rolw $2,%bx

	decw %dx
l2:
	inb %dx,%al
	testb %al,%al
	jns l2

	incw %dx
	movb $1,%al
	outb %al,%dx

	outb %al,$0x80

	decw %dx

	decw %cx
	jnz l1

	popl %esi
	popl %ebx
	xorl %eax,%eax
	ret

l99:
	popl %esi
	popl %ebx
	xorl %eax,%eax
	decl %eax
	ret


//
// SendLong(ulong l)
//
	.align 2
	FUNC	SendLong
	pushl %ebx
	pushl %esi
	movl EXTERN(gBase),%edx
	movl 12(%esp),%ebx
	rorl $2,%ebx
	movw $10,%cx		 // 10*3Bit + 2Bit

	movw $20000,%si	// time-out
	incw %dx
l00a:
	decw %si
	jz l99a
	inb %dx,%al
	testb %al,%al
	js l00a


l1a:
	inb %dx,%al
	testb %al,%al
	js l1a
	
	decw %dx
	movb $7,%al
	andb %bl,%al
	outb %al,%dx

	incw %dx
	incw %dx
	xorb %al,%al
	outb %al,%dx	 

	roll $3,%ebx

	decw %dx
l2a:
	inb %dx,%al
	testb %al,%al
	jns l2a

	incw %dx
	movb $1,%al
	outb %al,%dx

	decw %dx

	decw %cx
	jnz l1a

l3a:
	inb %dx,%al
	testb %al,%al
	js l3a
	
	decw %dx
	movb $6,%al
	andb %bl,%al
	orb $0xf0,%al
	outb %al,%dx

	incw %dx
	incw %dx
	xorb %al,%al
	outb %al,%dx	 

	decw %dx
l4a:
	inb %dx,%al
	testb %al,%al
	jns l4a

	incw %dx
	movb $1,%al
	outb %al,%dx

	popl %esi
	popl %ebx
	xorl %eax,%eax
	ret

l99a:
	popl %esi
	popl %ebx
	xorl %eax,%eax
	decl %eax
	ret

