/*
	BJL-uploader for Linux
	Copyright (c) 1997, Joe Britt
	
	Freely distributable and modifiable.
	I only ask that if you use this as the basis of some other work,
	you give me credit for this original version.  Thanks.

	Special thanks to 42Bastian, for being extremely helpful in debugging
	the communication with the BJL-ROM in the Jag.  He's the man!

		JOE       Joe Britt
		42BS      42Bastian Schick <elw5basc(at)gp.fht-esslingen.de>
		JBS       John Sohn (jsohn@ee.net)

	Change History:

	30 Oct 97 JOE     First version.
	31 Oct 97 42BS    added DJGPP support, but don't know if it works...
	 1 Dec 97 JBS     added Win95 console support and enhanced DGJPP functionality
	10 Jan 98 JBS     supports linking with Windows 95 GUI application
	14 Feb 98 42BS    GEMDOS - relocator debuged / trans-routines in bjl.s

         4 Jan 99 42BS    removed win95 stuff, tested under Linux.
                          repl. gWait by port-accesse (out is 1usec, ever)
	 x Jan 03 42BS    Changed to giveio for NT, added progress.
	                  Added Version.
*/

#define VERSION __DATE__
/* gWait was used to adapt PC-speed,

   486DX4-100    200
   PII-450       2000 ????
*/

#include <stdio.h>
#ifdef __MINGW32__
#include <windows.h>
inline void outb(unsigned char data,int port)
{
  asm(" outb %%al,%%dx"::"dx" (port),"al" (data));
}
#else
#include <asm/io.h>
#endif


typedef unsigned char uchar;
typedef unsigned char Boolean;

#ifndef ulong
typedef unsigned long ulong;    // 42BS
typedef unsigned short ushort;  // 42BS
#endif

#define true   1
#define false  0

#define kLPT1Base    0x378
#define kLPT2Base    0x278

/*
from http://www.paranoia.com/~filipg/HTML/LINK/PORTS/F_PARALLEL5.html#PARALLEL_008

STATUS
	7 6 5 4 3 2 1 0
	* . . . . . . .  Busy . . (pin 11), high=0, low=1 (inverted)
	. * . . . . . .  Ack  . . (pin 10), high=1, low=0 (true)
	. . * . . . . .  No paper (pin 12), high=1, low=0 (true)
	. . . * . . . .  Selected (pin 13), high=1, low=0 (true)
	. . . . * . . .  Error. . (pin 15), high=1, low=0 (true)
	. . . . . * * *  Undefined

CONTROL
	7 6 5 4 3 2 1 0
	* * . . . . . .  Unused (undefined on read, ignored on write)
	. . * . . . . .  Bidirectional control, see below
	. . . * . . . .  Interrupt control, 1=enable, 0=disable
	. . . . * . . .  Select . . (pin 17), 1=low, 0=high (inverted)
	. . . . . * . .  Initialize (pin 16), 1=high, 0=low (true)
	. . . . . . * .  Auto Feed  (pin 14), 1=low, 0=high (inverted)
	. . . . . . . *  Strobe . . (pin 1),  1=low, 0=high (inverted)
*/

#define kDataReg     0
#define kStatusReg   1               /* BUSY is bit 7 */
#define kControlReg  2               /* STB is bit 0 */


/* bjl.s */

void InitPortNormal();
int SendWord(ushort w);

void InitPortHyper();
void SendLongHyper( ulong w );
void SendLongHyper8( ulong w );

/* internal prototypes */

ulong relocate(uchar * pdata, ulong * len, ulong *addr,ulong skip);
void SendFile( ulong addr, ulong skip , uchar * buf, ulong len);

ulong ReverseEndian(ulong d);
inline ulong ReverseEndian(ulong d)
{
  asm(" bswap %0":"+r" (d));
  return d;
}
//->ulong ReverseEndian(ulong d)
//->{
//->  return  ((d << 24) |
//->	  ((d & 0x0000ff00) << 8) |
//->	  ((d & 0x00ff0000) >> 8) |
//->	  (d >> 24));
//->}

#define BE_TO_LE(_x)    ReverseEndian(_x)
#define LE_TO_BE(_x)    ReverseEndian(_x)


#define BE_TO_LEW(_x)    ( (ushort)( ((_x)>>8)|((_x)<<8) ) )
#define LE_TO_BEW(_x)    BE_TO_LEW(_x)


Boolean ParseCmds( ulong argc, char *argv[] );
void ArgValue( char *s, ulong *value );
int LoadFile( char *fn, ulong *addr, ulong *skip, uchar **buf);

ulong gBase = kLPT1Base;                        /* default to LPT2 */
ulong gBaseAddr = 0x4000;                       /* default base */
ulong gHeaderSkip = 0;                          /* default header size */ /* was 28,changed 42BS */
ulong gWait = 2;
int   gSwitchCommand = 1;
int   gStartLoader = 0;
int   g4BitMode = 1;
int   gDebugUpload = 0;
char *gImageName = "Joe Britt";
ulong gHash = 0;
int gData = 0;

main( int argc,char *argv[] )
{
  if ( !ParseCmds( argc, argv ) )
  {
    printf("BJL Loader for PC from "__DATE__"\n");
    printf("usage: loader [-s skipbytes][-w wait][-b baseaddr][-p lptbase][-n][-8][-h size][-d] <filename>\n");
    printf("   skipbytes is # bytes in header to skip.      default = %ld\n", gHeaderSkip); 
    printf("   baseaddr is addr to upload to.               default = 0x%08lx\n", gBaseAddr);
    printf("   lptbase specifies base addr of LPT port.     default = 0x%lx\n", gBase); 
    printf("   wait - counter between longs.                default = %ld\n",gWait);
    printf("   -n => don`t send switch-command\n");
    printf("   -8 => use 8Bit transmission (4Bit is default)\n");
    printf("   -h => Print # bytes to go every size bytes.  default = 0 == off\n");
    printf("   -d => Data upload, loader restarts\n");

    return -1;
  }

#ifdef __MINGW32__
  {
    HANDLE h;
    OSVERSIONINFO osvi;
    osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
    GetVersionEx(&osvi);
    if(osvi.dwPlatformId == VER_PLATFORM_WIN32_NT){
      h = CreateFile("\\\\.\\giveio", GENERIC_READ, 0, NULL,
		     OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
      
      if(h == INVALID_HANDLE_VALUE) {
	printf("Couldn't access giveio device\n");
	return -1;
      }
      CloseHandle(h);
    }
  }
#else
  // port 0x80 is for timing

  if ( !(ioperm(gBase, 3, true) == 0) || !(ioperm(0x80,1,true) == 0) ){
    printf("### ioperm() FAILED!\n\n");
    return -1;
  }
#endif
  {
    uchar *buffer;
    long length;

    if ( (length = LoadFile( gImageName,
			     &gBaseAddr,
			     &gHeaderSkip,
			     &buffer )) > 0 ){
      
      printf("len %d\n",length);
      SendFile( gBaseAddr, gHeaderSkip , buffer, (ulong)length);
      
    } 
    
    outb(0x20,gBase+2);
    outb(0,gBase);
//->    for(;;) 
//->      printf("%02x  ",inb(gBase));

  }
#ifndef __MINGW32__
  ioperm(gBase, 3, false);
  ioperm(0x80, 1, false); 
#endif
}

void ArgValue( char *s, ulong *value )
{
  if ( s && isdigit(s[0]) ) 
  {
    if ( s[1] == 'x' )
      sscanf( s, "%x", value );
    else
      sscanf( s, "%d", value );
  }
}


Boolean ParseCmds( unsigned long argc, char *argv[] )
{
   char *s;
   ulong cnt;

   if ( argc == 1 ) 
     return false;

	
  for ( cnt = 1; cnt < argc; cnt++ ) 
  {
    s = argv[cnt];
    if ( s[0] == '-' )
      switch ( s[1] ) 
      {
      case 's':       
	cnt++;
	ArgValue( argv[cnt], &gHeaderSkip );
	break;

      case 'b':       
	cnt++;
	ArgValue( argv[cnt], &gBaseAddr );
	break;

      case 'p':       
	cnt++;
	ArgValue( argv[cnt], &gBase );
	break;

      case 'w':
	cnt++;
	ArgValue(argv[cnt], &gWait);
	break;

      case 'n':
	gSwitchCommand = 0;
	break;
      case 'd':
	gData = 1;
      case '8' :
	g4BitMode = 0;
	break;
      case 'h' :
	cnt++;
	ArgValue( argv[cnt], &gHash);
	gHash = (gHash >>= 2 ) ? gHash : 1;
	break;
/*
      case 'f':       
	cnt++;
	gImageName = argv[cnt];
	break;  
*/      
      default:
	printf("Unknown option !\n");
	exit(1);
      }
    else
    {
      gImageName = s;
    }
  }
  return true;
}

int LoadFile( char *fn, ulong *addr, ulong *skip, uchar **buf)
{
  FILE *fp;
  ulong len;

  if ( (fp = fopen( fn, "rb" )) == (FILE *)NULL ){
    printf("Couldn't open file '%s'!\n", gImageName);
    return -1;
  }

  fseek(fp, 0, SEEK_END);

  len = ftell(fp);
  
  printf("%s is %ld bytes long\n", fn, len);
  
  fseek( fp, 0, SEEK_SET );   /* 42BS */

  *buf = (uchar*)malloc( len );
 
  if ( *buf == (uchar *)NULL ){
    printf("SendFile: couldn't alloc buf!\n");
    return -1;
  }
    
  fread( *buf, sizeof(char), len, fp );                    

  *skip = relocate( *buf, &len , addr, *skip);    // relocate program

  return len;
}

void SendFile( ulong addr, ulong skip, uchar *buf, ulong len)
{
  long *copy;
  long cksum = 0;
  long data;
  uchar * save_buf = buf;   /* 42BS */
			
  printf("start is $%x\n"
	 "transmit-lenght is %ld\n",addr,len);

  buf += skip;                 // skip some bytes

  len = ((len + 3) & ~3);      /* round up */

  if ( gSwitchCommand )
    {
      InitPortNormal();
      
      SendWord(0);               /* syncronize */
      SendWord(0);
      
      if ( g4BitMode ){
	SendWord(0xb8);
      } else {
	SendWord(0xb7);
      }
      //	InitPortHyper();
    }
  
  InitPortHyper();
  if ( g4BitMode ){
    SendLongHyper4( 0 );          /* syncronize */
    // for(;;)
    if ( gData ){
      SendLongHyper4( 0x20102001 ); /* send magic number */
    } else {
      SendLongHyper4( 0x22071970 ); /* send magic number */
    }
    SendLongHyper4( addr );       /* send starting addr */
    SendLongHyper4( len+4 );      /* send length */
    
    len >>= 2;                   /* bytes -> words */ 
    /* lets say :32-bit words :-) */
    
    copy = (ulong*)buf;
    if ( gHash ){
      int t = 0;
      while ( len-- ){
	if ( t <= 0 ){
	  printf("bytes to go: %10d\n",len<<2);
	  t = gHash;
	}
	t -= 4;
	data = BE_TO_LE(*copy++);       
	cksum -= data;
	SendLongHyper4( data );
      } 
    } else {
      while ( len-- ){
	data = BE_TO_LE(*copy++);       
	cksum -= data;
	SendLongHyper4( data );
      } 
    }
    SendLongHyper4( cksum );       /* send checksum */
  } else {
    SendLongHyper8( 0 );          /* syncronize */
    // for(;;)
    if ( gData ){
      SendLongHyper8( 0x20102001 ); /* send magic number */
    } else {
      SendLongHyper8( 0x22071970 ); /* send magic number */
    }
    SendLongHyper8( addr );       /* send starting addr */
    SendLongHyper8( len+4 );      /* send length */
    
    len >>= 2;                   /* bytes -> words */ 

    copy = (ulong*)buf;
    if ( gHash ){
      int t = 0;
      while ( len-- ){
	if ( t <= 0 ){
	  printf("bytes to go: %10d\r",len<<2);
	  t = gHash;
	}
	t -= 4;
	data = BE_TO_LE(*copy++);
	cksum -= data;
	SendLongHyper8( data );
      } 
    } else {
      while ( len-- ){
	data = BE_TO_LE(*copy++);
	cksum -= data;
	SendLongHyper8( data );
      } 
    }
    SendLongHyper8( cksum );       /* send checksum */
  }
  printf("\ncksum = %08lx\n", cksum);
  
  free( save_buf );     /* 42BS */
}

/**********************/
/* GEMDOS - relocator */
/**********************/
/* this function sees if it finds a GEMDOS or JServer - header
	 if so, skip,addr and len are adjusted
*/

ulong relocate( uchar * pdata, ulong *len , ulong *addr, ulong skip)
{

  if ( (pdata[0] == 0x60) && (pdata[1] == 0x1a) ){ // GEMDOS - header 

    if ( *((ulong *)(pdata+28)) == BE_TO_LE(0x4a414752) ){ /* JAGR */
      
      ushort type = BE_TO_LEW(*((ushort *)(pdata+32)));
      ulong new_len;
	
      if ( type != 2 && type != 3 ){
	
	printf("Unsupported JServer-Header !\nLeaving ...\n");
	exit(-1);
      }
		
      *addr = BE_TO_LE( *(ulong *)(pdata+34) );  // dest and start address
      
      if ( (new_len = BE_TO_LE( *(ulong *)(pdata+38) ) )){
	
	*len = new_len;
      }
      
      if ( type == 2)
	return (28+14);
      else
	return (28+18);   // skip GEMDOS and JServer-header
    } else {
//
// BJL - program
// 
      ulong textlen,datalen,bss_len,symblen;   /* header info */
      ulong offset;
      ulong addr2 = *addr;
      uchar * reloptr, * pdata2;
      
//    printf("Relocating BJL ...\n");

      textlen = BE_TO_LE(*(ulong *)(pdata+2));
      datalen = BE_TO_LE(*(ulong *)(pdata+6));
      bss_len = BE_TO_LE(*(ulong *)(pdata+10)); //  no need for this, yet
      symblen = BE_TO_LE(*(ulong *)(pdata+14));
      
//    printf("TEXT(%08x) DATA(%08x) BSS(%08x) SYM(%d)\n",textlen,datalen,bss_len,symblen);

      reloptr = pdata + textlen + datalen + symblen + 28;

      offset = BE_TO_LE(*(ulong *)reloptr);   // first long to relocate

//    printf("Offset :%08x\n",offset);

      reloptr += 4;                 // from now only bytes as offset
		
      pdata2 = pdata + 28 + offset;      // ptr to it

      addr2 = BE_TO_LE(addr2);        // change byte-order 
		
      while ( offset ){              // until offset == 0	
      // compute new address 
//      *(ulong *)pdata2 = LE_TO_BE(BE_TO_LE( *(ulong *)pdata2 ) + addr2);
	*(ulong *)pdata2 += addr2;       // ha, it works ;-)

      // as long as offset is 1 skip 254 byte
	do{
      
	  offset = (ulong) *reloptr;
	  ++reloptr;
	  if (! --offset)
	    pdata2 += 254;
	}while ( !offset );
	pdata2 += ++offset;           // next address
      }

      *len = textlen + datalen;     // send only text and data , no symbols ...
      return ( 28 );                // skip GEMDOS header
    }
  } else if ( (pdata[0] == 0x01) && (pdata[1] == 0x50) ) {

    printf("COFF-Header found ...\n");
    *addr = BE_TO_LE(*(ulong *)(pdata+56));

    skip = BE_TO_LE(*(ulong *)(pdata+68));

    *len -= skip;

    return skip;

  } else {
  
    printf("No Gemdos or COFF header  !\n"); 

    return (skip);                    /* skip user-defined bytes */
  }
}

